/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/network/sockets/SocketOptionsPlatformCapabilities;", "", "()V", "channelSetOption", "Ljava/lang/reflect/Method;", "datagramSetOption", "serverChannelSetOption", "standardSocketOptions", "", "", "Ljava/lang/reflect/Field;", "setReusePort", "", "channel", "Ljava/nio/channels/DatagramChannel;", "Ljava/nio/channels/ServerSocketChannel;", "Ljava/nio/channels/SocketChannel;", "socketOption", "name", "ktor-network"})
public final class SocketOptionsPlatformCapabilities {
    private static final Map<String, Field> standardSocketOptions;
    private static final Method channelSetOption;
    private static final Method serverChannelSetOption;
    private static final Method datagramSetOption;
    public static final SocketOptionsPlatformCapabilities INSTANCE;

    public final void setReusePort(@NotNull SocketChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = channelSetOption;
        if (method == null) {
            Intrinsics.throwNpe();
        }
        method.invoke((Object)channel, option, true);
    }

    public final void setReusePort(@NotNull ServerSocketChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = serverChannelSetOption;
        if (method == null) {
            Intrinsics.throwNpe();
        }
        method.invoke((Object)channel, option, true);
    }

    public final void setReusePort(@NotNull DatagramChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Method method = datagramSetOption;
        if (method == null) {
            Intrinsics.throwNpe();
        }
        method.invoke((Object)channel, option, true);
    }

    private final Object socketOption(String name) {
        Object object = standardSocketOptions.get(name);
        if (object == null || (object = ((Field)object).get(null)) == null) {
            throw (Throwable)new IOException("Socket option " + name + " is not supported");
        }
        return object;
    }

    private SocketOptionsPlatformCapabilities() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        Method method;
        Method element$iv;
        Method[] $receiver$iv;
        Class<?> socketChannelClass;
        Class<?> socketOptionType;
        int modifiers;
        int n;
        int n2;
        Method[] methodArray;
        Object $receiver$iv2;
        SocketOptionsPlatformCapabilities socketOptionsPlatformCapabilities;
        INSTANCE = socketOptionsPlatformCapabilities = new SocketOptionsPlatformCapabilities();
        try {
            Map map;
            Field[] fieldArray = Class.forName("java.net.StandardSocketOptions");
            if (fieldArray != null && (fieldArray = fieldArray.getFields()) != null) {
                void $receiver$iv$iv;
                AccessibleObject element$iv$iv;
                void $receiver$iv$iv2;
                $receiver$iv2 = fieldArray;
                Field[] fieldArray2 = $receiver$iv2;
                Object destination$iv$iv = new ArrayList();
                methodArray = $receiver$iv$iv2;
                int n3 = methodArray.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    Method it = element$iv$iv = methodArray[n2];
                    boolean bl = false;
                    Method method2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"it");
                    modifiers = n = ((Field)((Object)method2)).getModifiers();
                    boolean bl2 = false;
                    boolean bl3 = Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers);
                    if (!bl3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv2 = (List)destination$iv$iv;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10)), (int)16);
                destination$iv$iv = $receiver$iv2;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                for (Object element$iv$iv2 : $receiver$iv$iv) {
                    void it;
                    element$iv$iv = (Field)element$iv$iv2;
                    Map map2 = destination$iv$iv2;
                    boolean bl = false;
                    void v3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                    String string = v3.getName();
                    map2.put(string, element$iv$iv2);
                }
                map = destination$iv$iv2;
            } else {
                map = MapsKt.emptyMap();
            }
            $receiver$iv2 = map;
        }
        catch (Throwable _) {
            $receiver$iv2 = MapsKt.emptyMap();
        }
        standardSocketOptions = $receiver$iv2;
        try {
            Method method3;
            block18: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                if (clazz == null) {
                    Intrinsics.throwNpe();
                }
                socketOptionType = clazz;
                Class<?> clazz2 = socketChannelClass = Class.forName("java.nio.channels.SocketChannel");
                Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"socketChannelClass");
                Method[] methodArray2 = clazz2.getMethods();
                Intrinsics.checkExpressionValueIsNotNull((Object)methodArray2, (String)"socketChannelClass.methods");
                methodArray = $receiver$iv = methodArray2;
                int n4 = methodArray.length;
                for (n2 = 0; n2 < n4; ++n2) {
                    Method method4 = element$iv = methodArray[n2];
                    boolean bl = false;
                    Method method5 = method4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method5, (String)"method");
                    modifiers = n = method5.getModifiers();
                    boolean bl4 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method4.getName(), (Object)"setOption") && method4.getParameterTypes().length == 2 && Intrinsics.areEqual(method4.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method4.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method4.getParameterTypes()[1], Object.class))) continue;
                    method3 = element$iv;
                    break block18;
                }
                method3 = null;
            }
            socketOptionType = method3;
        }
        catch (Throwable _) {
            socketOptionType = null;
        }
        channelSetOption = socketOptionType;
        try {
            Method method6;
            block19: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                if (clazz == null) {
                    Intrinsics.throwNpe();
                }
                socketOptionType = clazz;
                Class<?> clazz3 = socketChannelClass = Class.forName("java.nio.channels.ServerSocketChannel");
                Intrinsics.checkExpressionValueIsNotNull(clazz3, (String)"socketChannelClass");
                Method[] methodArray3 = clazz3.getMethods();
                Intrinsics.checkExpressionValueIsNotNull((Object)methodArray3, (String)"socketChannelClass.methods");
                methodArray = $receiver$iv = methodArray3;
                int n5 = methodArray.length;
                for (n2 = 0; n2 < n5; ++n2) {
                    Method method7 = element$iv = methodArray[n2];
                    boolean bl = false;
                    Method method8 = method7;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method8, (String)"method");
                    modifiers = n = method8.getModifiers();
                    boolean bl5 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method7.getName(), (Object)"setOption") && method7.getParameterTypes().length == 2 && Intrinsics.areEqual(method7.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method7.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method7.getParameterTypes()[1], Object.class))) continue;
                    method6 = element$iv;
                    break block19;
                }
                method6 = null;
            }
            socketOptionType = method6;
        }
        catch (Throwable _) {
            socketOptionType = null;
        }
        serverChannelSetOption = socketOptionType;
        try {
            Method method9;
            block20: {
                Class<?> clazz = Class.forName("java.net.SocketOption");
                if (clazz == null) {
                    Intrinsics.throwNpe();
                }
                socketOptionType = clazz;
                Class<?> clazz4 = socketChannelClass = Class.forName("java.nio.channels.DatagramChannel");
                Intrinsics.checkExpressionValueIsNotNull(clazz4, (String)"socketChannelClass");
                Method[] methodArray4 = clazz4.getMethods();
                Intrinsics.checkExpressionValueIsNotNull((Object)methodArray4, (String)"socketChannelClass.methods");
                methodArray = $receiver$iv = methodArray4;
                int n6 = methodArray.length;
                for (n2 = 0; n2 < n6; ++n2) {
                    Method method10 = element$iv = methodArray[n2];
                    boolean bl = false;
                    Method method11 = method10;
                    Intrinsics.checkExpressionValueIsNotNull((Object)method11, (String)"method");
                    modifiers = n = method11.getModifiers();
                    boolean bl6 = false;
                    if (!(Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method10.getName(), (Object)"setOption") && method10.getParameterTypes().length == 2 && Intrinsics.areEqual(method10.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method10.getParameterTypes()[0], socketOptionType) && Intrinsics.areEqual(method10.getParameterTypes()[1], Object.class))) continue;
                    method9 = element$iv;
                    break block20;
                }
                method9 = null;
            }
            method = method9;
        }
        catch (Throwable _) {
            method = null;
        }
        datagramSetOption = method;
    }
}

