/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.certificates;

import io.ktor.network.tls.OID;
import io.ktor.network.tls.certificates.BuildersKt;
import io.ktor.network.tls.certificates.CertificateBuilder;
import io.ktor.network.tls.certificates.KeyStoreBuilder;
import io.ktor.network.tls.certificates.KeyType;
import io.ktor.network.tls.extensions.HashAlgorithm;
import io.ktor.network.tls.extensions.SignatureAlgorithm;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.SinksKt;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aU\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\u0001\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\r\u001ak\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\n\u001a\u00020\t2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0017H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001am\u0010\f\u001a\u00020\u000b*\u00020\u000b2\n\b\u0002\u0010\u0001\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\u001f\u001a\u00020\u00022\b\b\u0002\u0010 \u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010!\u001a1\u0010%\u001a\u00020\u000b*\u00020\u000b2\n\b\u0002\u0010\u0001\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010#\u001a\u00020\"2\b\b\u0002\u0010$\u001a\u00020\u0002\u00a2\u0006\u0004\b%\u0010&\u001ai\u0010,\u001a\u00020+*\u00020'2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00172\b\b\u0002\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b,\u0010-\u001a,\u00101\u001a\u00020+*\u00020'2\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020+0.\u00a2\u0006\u0002\b/H\u0002\u00a2\u0006\u0004\b1\u00102\u001a\u0013\u00103\u001a\u00020+*\u00020'H\u0002\u00a2\u0006\u0004\b3\u00104\u001a\u0013\u00105\u001a\u00020+*\u00020'H\u0002\u00a2\u0006\u0004\b5\u00104\u001a/\u00106\u001a\u00020+*\u00020'2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0017H\u0002\u00a2\u0006\u0004\b6\u00107\u001a\u0013\u00108\u001a\u00020+*\u00020'H\u0002\u00a2\u0006\u0004\b8\u00104\u001a\u001b\u00109\u001a\u00020+*\u00020'2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b9\u0010:\u001a4\u0010=\u001a\u00020+*\u00020'2\u0006\u0010;\u001a\u00020\u00072\u0017\u0010<\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020+0.\u00a2\u0006\u0002\b/H\u0002\u00a2\u0006\u0004\b=\u0010>\u001a\u001b\u0010@\u001a\u00020+*\u00020'2\u0006\u0010?\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b@\u0010A\u001aq\u0010B\u001a\u00020+*\u00020'2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bB\u0010C\u001a\u001d\u0010E\u001a\u00020+*\u00020'2\b\b\u0002\u0010D\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bE\u0010F\u001a,\u0010H\u001a\u00020+*\u00020'2\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020+0.\u00a2\u0006\u0002\b/H\u0002\u00a2\u0006\u0004\bH\u00102\u001a%\u0010L\u001a\u00020+*\u00020'2\u0006\u0010J\u001a\u00020I2\b\b\u0002\u0010K\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bL\u0010M\u001a\u001b\u0010O\u001a\u00020+*\u00020'2\u0006\u0010N\u001a\u00020(H\u0002\u00a2\u0006\u0004\bO\u0010P\u001a\u001b\u0010Q\u001a\u00020+*\u00020'2\u0006\u0010N\u001a\u00020(H\u0002\u00a2\u0006\u0004\bQ\u0010P\u001a%\u0010T\u001a\u00020+*\u00020'2\u0006\u0010R\u001a\u00020\u00022\b\b\u0002\u0010S\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bT\u0010U\u001a\u0013\u0010V\u001a\u00020+*\u00020'H\u0002\u00a2\u0006\u0004\bV\u00104\u001a,\u0010W\u001a\u00020+*\u00020'2\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020+0.\u00a2\u0006\u0002\b/H\u0002\u00a2\u0006\u0004\bW\u00102\u001a\u001b\u0010Z\u001a\u00020+*\u00020'2\u0006\u0010Y\u001a\u00020XH\u0002\u00a2\u0006\u0004\bZ\u0010[\u001a\u001b\u0010Z\u001a\u00020+*\u00020'2\u0006\u0010Y\u001a\u00020\\H\u0002\u00a2\u0006\u0004\bZ\u0010]\u001a\u001b\u0010`\u001a\u00020+*\u00020'2\u0006\u0010_\u001a\u00020^H\u0002\u00a2\u0006\u0004\b`\u0010a\u001a\u001b\u0010`\u001a\u00020+*\u00020'2\u0006\u0010_\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b`\u0010F\u001a\u001b\u0010c\u001a\u00020+*\u00020'2\u0006\u0010b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bc\u0010F\u001a+\u0010h\u001a\u00020+*\u00020'2\u0006\u0010d\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u00072\u0006\u0010g\u001a\u00020fH\u0002\u00a2\u0006\u0004\bh\u0010i\u001a\u0013\u0010j\u001a\u00020\u0007*\u00020\u0007H\u0002\u00a2\u0006\u0004\bj\u0010k\u001a\u001b\u0010l\u001a\u00020+*\u00020'2\u0006\u0010_\u001a\u00020fH\u0002\u00a2\u0006\u0004\bl\u0010m\u001a\u0013\u0010o\u001a\u00020n*\u00020fH\u0002\u00a2\u0006\u0004\bo\u0010p\u001a\u001b\u0010q\u001a\u00020+*\u00020'2\u0006\u0010_\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bq\u0010F\"\u001a\u0010r\u001a\u00020\u000e8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\br\u0010s\u001a\u0004\bt\u0010u\"\u0014\u0010v\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bv\u0010s\"\u001b\u0010z\u001a\b\u0012\u0004\u0012\u00020w0\u0017*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bx\u0010y\u00a8\u0006{"}, d2={"Ljava/io/File;", "file", "", "algorithm", "keyAlias", "keyPassword", "jksPassword", "", "keySizeInBits", "Lio/ktor/network/tls/certificates/KeyType;", "keyType", "Ljava/security/KeyStore;", "generateCertificate", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILio/ktor/network/tls/certificates/KeyType;)Ljava/security/KeyStore;", "Ljavax/security/auth/x500/X500Principal;", "subject", "issuer", "Ljava/security/PublicKey;", "publicKey", "Ljava/security/KeyPair;", "signerKeyPair", "Lkotlin/time/Duration;", "validityDuration", "", "domains", "Ljava/net/InetAddress;", "ipAddresses", "Ljava/security/cert/X509Certificate;", "generateX509Certificate-Tu6dINM", "(Ljavax/security/auth/x500/X500Principal;Ljavax/security/auth/x500/X500Principal;Ljava/security/PublicKey;Ljava/security/KeyPair;Ljava/lang/String;JLio/ktor/network/tls/certificates/KeyType;Ljava/util/List;Ljava/util/List;)Ljava/security/cert/X509Certificate;", "generateX509Certificate", "caKeyAlias", "caPassword", "(Ljava/security/KeyStore;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Lio/ktor/network/tls/certificates/KeyType;)Ljava/security/KeyStore;", "", "password", "keyStoreType", "trustStore", "(Ljava/security/KeyStore;Ljava/io/File;[CLjava/lang/String;)Ljava/security/KeyStore;", "Lkotlinx/io/Sink;", "Ljava/time/Instant;", "validFrom", "validUntil", "", "writeX509Info", "(Lkotlinx/io/Sink;Ljava/lang/String;Ljavax/security/auth/x500/X500Principal;Ljavax/security/auth/x500/X500Principal;Ljava/security/PublicKey;Ljava/time/Instant;Ljava/time/Instant;Ljava/util/List;Ljava/util/List;Lio/ktor/network/tls/certificates/KeyType;)V", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "content", "extKeyUsage", "(Lkotlinx/io/Sink;Lkotlin/jvm/functions/Function1;)V", "clientAuth", "(Lkotlinx/io/Sink;)V", "serverAuth", "subjectAlternativeNames", "(Lkotlinx/io/Sink;Ljava/util/List;Ljava/util/List;)V", "caExtension", "writeAlgorithmIdentifier", "(Lkotlinx/io/Sink;Ljava/lang/String;)V", "id", "builder", "writeX509Extension", "(Lkotlinx/io/Sink;ILkotlin/jvm/functions/Function1;)V", "dName", "writeX500Principal", "(Lkotlinx/io/Sink;Ljavax/security/auth/x500/X500Principal;)V", "writeCertificate", "(Lkotlinx/io/Sink;Ljavax/security/auth/x500/X500Principal;Ljavax/security/auth/x500/X500Principal;Ljava/security/PublicKey;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Ljava/util/List;Ljava/util/List;Ljava/security/KeyPair;Lio/ktor/network/tls/certificates/KeyType;)V", "v", "writeVersion", "(Lkotlinx/io/Sink;I)V", "block", "writeDerOctetString", "", "array", "unused", "writeDerBitString", "(Lkotlinx/io/Sink;[BI)V", "date", "writeDerUTCTime", "(Lkotlinx/io/Sink;Ljava/time/Instant;)V", "writeDerGeneralizedTime", "s", "type", "writeDerUTF8String", "(Lkotlinx/io/Sink;Ljava/lang/String;I)V", "writeDerNull", "writeDerSequence", "Lio/ktor/network/tls/OID;", "identifier", "writeDerObjectIdentifier", "(Lkotlinx/io/Sink;Lio/ktor/network/tls/OID;)V", "", "(Lkotlinx/io/Sink;[I)V", "Ljava/math/BigInteger;", "value", "writeAsnInt", "(Lkotlinx/io/Sink;Ljava/math/BigInteger;)V", "length", "writeDerLength", "kind", "typeIdentifier", "", "simpleType", "writeDerType", "(Lkotlinx/io/Sink;IIZ)V", "derLength", "(I)I", "writeDerBoolean", "(Lkotlinx/io/Sink;Z)V", "Lkotlin/UByte;", "toUByte", "(Z)B", "writeDerInt", "DEFAULT_PRINCIPAL", "Ljavax/security/auth/x500/X500Principal;", "getDEFAULT_PRINCIPAL", "()Ljavax/security/auth/x500/X500Principal;", "DEFAULT_CA_PRINCIPAL", "Ljavax/net/ssl/TrustManager;", "getTrustManagers", "(Ljava/security/KeyStore;)Ljava/util/List;", "trustManagers", "ktor-network-tls-certificates"})
@SourceDebugExtension(value={"SMAP\nCertificates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Certificates.kt\nio/ktor/network/tls/certificates/CertificatesKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Closeable.kt\nio/ktor/utils/io/core/CloseableKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,571:1\n19#2,3:572\n19#2,3:592\n19#2,3:595\n19#2,3:598\n19#2,3:601\n19#2,3:604\n19#2,3:607\n19#2,3:610\n19#2,3:613\n19#2,3:616\n1863#3,2:575\n12#4,14:577\n1#5:591\n*S KotlinDebug\n*F\n+ 1 Certificates.kt\nio/ktor/network/tls/certificates/CertificatesKt\n*L\n95#1:572,3\n321#1:592,3\n344#1:595,3\n366#1:598,3\n374#1:601,3\n405#1:604,3\n419#1:607,3\n435#1:610,3\n459#1:613,3\n229#1:616,3\n185#1:575,2\n190#1:577,14\n*E\n"})
public final class CertificatesKt {
    @NotNull
    private static final X500Principal DEFAULT_PRINCIPAL = new X500Principal("CN=localhost, OU=Kotlin, O=JetBrains, C=RU");
    @NotNull
    private static final X500Principal DEFAULT_CA_PRINCIPAL = new X500Principal("CN=localhostCA, OU=Kotlin, O=JetBrains, C=RU");

    @NotNull
    public static final X500Principal getDEFAULT_PRINCIPAL() {
        return DEFAULT_PRINCIPAL;
    }

    @NotNull
    public static final KeyStore generateCertificate(@Nullable File file, @NotNull String algorithm, @NotNull String keyAlias, @NotNull String keyPassword, @NotNull String jksPassword, int keySizeInBits, @NotNull KeyType keyType) {
        KeyStore keyStore;
        block0: {
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
            Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
            Intrinsics.checkNotNullParameter((Object)jksPassword, (String)"jksPassword");
            Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
            keyStore = BuildersKt.buildKeyStore((Function1<? super KeyStoreBuilder, Unit>)((Function1)arg_0 -> CertificatesKt.generateCertificate$lambda$1(keyAlias, algorithm, keyPassword, keySizeInBits, keyType, arg_0)));
            keyStore.setCertificateEntry(keyAlias + "Cert", keyStore.getCertificate(keyAlias));
            File file2 = file;
            if (file2 == null) break block0;
            File it = file2;
            boolean bl = false;
            BuildersKt.saveToFile(keyStore, it, jksPassword);
        }
        return keyStore;
    }

    public static /* synthetic */ KeyStore generateCertificate$default(File file, String string, String string2, String string3, String string4, int n, KeyType keyType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file = null;
        }
        if ((n2 & 2) != 0) {
            string = "SHA1withRSA";
        }
        if ((n2 & 4) != 0) {
            string2 = "mykey";
        }
        if ((n2 & 8) != 0) {
            string3 = "changeit";
        }
        if ((n2 & 0x10) != 0) {
            string4 = string3;
        }
        if ((n2 & 0x20) != 0) {
            n = 1024;
        }
        if ((n2 & 0x40) != 0) {
            keyType = KeyType.Server;
        }
        return CertificatesKt.generateCertificate(file, string, string2, string3, string4, n, keyType);
    }

    @NotNull
    public static final X509Certificate generateX509Certificate-Tu6dINM(@NotNull X500Principal subject, @NotNull X500Principal issuer, @NotNull PublicKey publicKey, @NotNull KeyPair signerKeyPair, @NotNull String algorithm, long validityDuration, @NotNull KeyType keyType, @NotNull List<String> domains, @NotNull List<? extends InetAddress> ipAddresses) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)signerKeyPair, (String)"signerKeyPair");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
        Intrinsics.checkNotNullParameter(domains, (String)"domains");
        Intrinsics.checkNotNullParameter(ipAddresses, (String)"ipAddresses");
        Instant now = Instant.now();
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$generateX509Certificate_Tu6dINM_u24lambda_u243 = (Sink)builder$iv;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)now);
        Instant instant = now;
        long l = validityDuration;
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        Instant instant2 = now.plus(duration);
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"plus(...)");
        Instant instant3 = instant2;
        CertificatesKt.writeCertificate($this$generateX509Certificate_Tu6dINM_u24lambda_u243, issuer, subject, publicKey, algorithm, instant, instant3, domains, ipAddresses, signerKeyPair, keyType);
        byte[] certificateBytes = SourcesKt.readByteArray((Source)((Source)builder$iv));
        Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificateBytes));
        cert.verify(signerKeyPair.getPublic());
        Intrinsics.checkNotNull((Object)cert, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        return (X509Certificate)cert;
    }

    public static /* synthetic */ X509Certificate generateX509Certificate-Tu6dINM$default(X500Principal x500Principal, X500Principal x500Principal2, PublicKey publicKey, KeyPair keyPair, String string, long l, KeyType keyType, List list, List list2, int n, Object object) {
        if ((n & 0x20) != 0) {
            l = DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.DAYS);
        }
        if ((n & 0x40) != 0) {
            keyType = KeyType.Server;
        }
        if ((n & 0x80) != 0) {
            Object[] objectArray = new String[]{"127.0.0.1", "localhost"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        if ((n & 0x100) != 0) {
            list2 = CollectionsKt.listOf((Object)Inet4Address.getByName("127.0.0.1"));
        }
        return CertificatesKt.generateX509Certificate-Tu6dINM(x500Principal, x500Principal2, publicKey, keyPair, string, l, keyType, list, list2);
    }

    @NotNull
    public static final KeyStore generateCertificate(@NotNull KeyStore $this$generateCertificate, @Nullable File file, @NotNull String algorithm, @NotNull String keyAlias, @NotNull String keyPassword, @NotNull String jksPassword, int keySizeInBits, @NotNull String caKeyAlias, @NotNull String caPassword, @NotNull KeyType keyType) {
        KeyStore keyStore;
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$generateCertificate, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
            Intrinsics.checkNotNullParameter((Object)keyPassword, (String)"keyPassword");
            Intrinsics.checkNotNullParameter((Object)jksPassword, (String)"jksPassword");
            Intrinsics.checkNotNullParameter((Object)caKeyAlias, (String)"caKeyAlias");
            Intrinsics.checkNotNullParameter((Object)caPassword, (String)"caPassword");
            Intrinsics.checkNotNullParameter((Object)((Object)keyType), (String)"keyType");
            Certificate caCert = $this$generateCertificate.getCertificate(caKeyAlias);
            PublicKey publicKey = caCert.getPublicKey();
            char[] cArray = caPassword.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            Key key = $this$generateCertificate.getKey(caKeyAlias, cArray);
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type java.security.PrivateKey");
            KeyPair caKeys = new KeyPair(publicKey, (PrivateKey)key);
            keyStore = BuildersKt.buildKeyStore((Function1<? super KeyStoreBuilder, Unit>)((Function1)arg_0 -> CertificatesKt.generateCertificate$lambda$5(keyAlias, algorithm, keyPassword, keySizeInBits, keyType, caKeys, caCert, arg_0)));
            File file2 = file;
            if (file2 == null) break block0;
            File it = file2;
            boolean bl = false;
            BuildersKt.saveToFile(keyStore, it, jksPassword);
        }
        return keyStore;
    }

    public static /* synthetic */ KeyStore generateCertificate$default(KeyStore keyStore, File file, String string, String string2, String string3, String string4, int n, String string5, String string6, KeyType keyType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            file = null;
        }
        if ((n2 & 2) != 0) {
            string = "SHA1withRSA";
        }
        if ((n2 & 4) != 0) {
            string2 = "mykey";
        }
        if ((n2 & 8) != 0) {
            string3 = "changeit";
        }
        if ((n2 & 0x10) != 0) {
            string4 = string3;
        }
        if ((n2 & 0x20) != 0) {
            n = 1024;
        }
        if ((n2 & 0x40) != 0) {
            string5 = "mykey";
        }
        if ((n2 & 0x80) != 0) {
            string6 = "changeit";
        }
        if ((n2 & 0x100) != 0) {
            keyType = KeyType.Server;
        }
        return CertificatesKt.generateCertificate(keyStore, file, string, string2, string3, string4, n, string5, string6, keyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final KeyStore trustStore(@NotNull KeyStore $this$trustStore, @Nullable File file, @NotNull char[] password, @NotNull String keyStoreType) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$this$trustStore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)keyStoreType, (String)"keyStoreType");
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        Intrinsics.checkNotNull((Object)keyStore);
        KeyStore trustStore = keyStore;
        trustStore.load(null, null);
        Enumeration<String> enumeration = $this$trustStore.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"aliases(...)");
        ArrayList<String> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Iterable iterable = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Certificate cert;
            String alias = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$trustStore.getCertificate(alias), (String)"getCertificate(...)");
            trustStore.setCertificateEntry(alias, cert);
        }
        File file2 = file;
        if (file2 != null && (file2 = file2.getParentFile()) != null) {
            file2.mkdirs();
        }
        if (file != null) {
            Closeable $this$use$iv = new FileOutputStream(file);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                FileOutputStream it = (FileOutputStream)$this$use$iv;
                boolean bl = false;
                trustStore.store(it, password);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable cause$iv) {
                try {
                    closed$iv = true;
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable closeException$iv) {
                        ExceptionsKt.addSuppressed((Throwable)cause$iv, (Throwable)closeException$iv);
                    }
                    throw cause$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
        }
        return trustStore;
    }

    public static /* synthetic */ KeyStore trustStore$default(KeyStore keyStore, File file, char[] cArray, String string, int n, Object object) {
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            char[] cArray2 = "changeit".toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
            cArray = cArray2;
        }
        if ((n & 4) != 0) {
            string = "JKS";
        }
        return CertificatesKt.trustStore(keyStore, file, cArray, string);
    }

    @NotNull
    public static final List<TrustManager> getTrustManagers(@NotNull KeyStore $this$trustManagers) {
        TrustManagerFactory trustManagerFactory;
        Intrinsics.checkNotNullParameter((Object)$this$trustManagers, (String)"<this>");
        TrustManagerFactory $this$_get_trustManagers__u24lambda_u249 = trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        boolean bl = false;
        $this$_get_trustManagers__u24lambda_u249.init($this$trustManagers);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"getTrustManagers(...)");
        return ArraysKt.toList((Object[])trustManagerArray);
    }

    private static final void writeX509Info(Sink $this$writeX509Info, String algorithm, X500Principal issuer, X500Principal subject, PublicKey publicKey, Instant validFrom, Instant validUntil, List<String> domains, List<? extends InetAddress> ipAddresses, KeyType keyType) {
        BigInteger version = new BigInteger(64, new SecureRandom());
        CertificatesKt.writeDerSequence($this$writeX509Info, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.writeX509Info$lambda$15(version, algorithm, issuer, subject, publicKey, validFrom, validUntil, keyType, domains, ipAddresses, arg_0)));
    }

    static /* synthetic */ void writeX509Info$default(Sink sink, String string, X500Principal x500Principal, X500Principal x500Principal2, PublicKey publicKey, Instant instant, Instant instant2, List list, List list2, KeyType keyType, int n, Object object) {
        if ((n & 0x100) != 0) {
            keyType = KeyType.Server;
        }
        CertificatesKt.writeX509Info(sink, string, x500Principal, x500Principal2, publicKey, instant, instant2, list, list2, keyType);
    }

    private static final void extKeyUsage(Sink $this$extKeyUsage, Function1<? super Sink, Unit> content) {
        CertificatesKt.writeDerSequence($this$extKeyUsage, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.extKeyUsage$lambda$17(content, arg_0)));
    }

    private static final void clientAuth(Sink $this$clientAuth) {
        CertificatesKt.writeDerSequence($this$clientAuth, (Function1<? super Sink, Unit>)((Function1)CertificatesKt::clientAuth$lambda$18));
    }

    private static final void serverAuth(Sink $this$serverAuth) {
        CertificatesKt.writeDerSequence($this$serverAuth, (Function1<? super Sink, Unit>)((Function1)CertificatesKt::serverAuth$lambda$19));
    }

    private static final void subjectAlternativeNames(Sink $this$subjectAlternativeNames, List<String> domains, List<? extends InetAddress> ipAddresses) {
        CertificatesKt.writeDerSequence($this$subjectAlternativeNames, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.subjectAlternativeNames$lambda$24(domains, ipAddresses, arg_0)));
    }

    private static final void caExtension(Sink $this$caExtension) {
        CertificatesKt.writeDerSequence($this$caExtension, (Function1<? super Sink, Unit>)((Function1)CertificatesKt::caExtension$lambda$27));
    }

    private static final void writeAlgorithmIdentifier(Sink $this$writeAlgorithmIdentifier, String algorithm) {
        CertificatesKt.writeDerSequence($this$writeAlgorithmIdentifier, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.writeAlgorithmIdentifier$lambda$28(algorithm, arg_0)));
    }

    private static final void writeX509Extension(Sink $this$writeX509Extension, int id, Function1<? super Sink, Unit> builder) {
        $this$writeX509Extension.writeByte((byte)(0x80 | id));
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeX509Extension_u24lambda_u2429 = (Sink)builder$iv;
        boolean bl = false;
        builder.invoke((Object)$this$writeX509Extension_u24lambda_u2429);
        Source packet = (Source)builder$iv;
        CertificatesKt.writeDerLength($this$writeX509Extension, (int)ByteReadPacketKt.getRemaining((Source)packet));
        BytePacketBuilderKt.writePacket((Sink)$this$writeX509Extension, (Source)packet);
    }

    private static final void writeX500Principal(Sink $this$writeX500Principal, X500Principal dName) {
        byte[] byArray = dName.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeX500Principal, (byte[])byArray, (int)0, (int)0, (int)6, null);
    }

    private static final void writeCertificate(Sink $this$writeCertificate, X500Principal issuer, X500Principal subject, PublicKey publicKey, String algorithm, Instant validFrom, Instant validUntil, List<String> domains, List<? extends InetAddress> ipAddresses, KeyPair signerKeyPair, KeyType keyType) {
        if (!(validFrom.compareTo(validUntil) < 0)) {
            boolean $i$a$-require-CertificatesKt$writeCertificate$22 = false;
            String $i$a$-require-CertificatesKt$writeCertificate$22 = "validFrom must be before validUntil";
            throw new IllegalArgumentException($i$a$-require-CertificatesKt$writeCertificate$22.toString());
        }
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeCertificate_u24lambda_u2431 = (Sink)builder$iv;
        boolean bl = false;
        CertificatesKt.writeX509Info($this$writeCertificate_u24lambda_u2431, algorithm, issuer, subject, publicKey, validFrom, validUntil, domains, ipAddresses, keyType);
        Source certInfo = (Source)builder$iv;
        byte[] certInfoBytes = SourcesKt.readByteArray((Source)certInfo);
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(signerKeyPair.getPrivate());
        signature.update(certInfoBytes);
        byte[] signed = signature.sign();
        CertificatesKt.writeDerSequence($this$writeCertificate, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.writeCertificate$lambda$33(certInfoBytes, signed, algorithm, arg_0)));
    }

    static /* synthetic */ void writeCertificate$default(Sink sink, X500Principal x500Principal, X500Principal x500Principal2, PublicKey publicKey, String string, Instant instant, Instant instant2, List list, List list2, KeyPair keyPair, KeyType keyType, int n, Object object) {
        if ((n & 0x200) != 0) {
            keyType = KeyType.Server;
        }
        CertificatesKt.writeCertificate(sink, x500Principal, x500Principal2, publicKey, string, instant, instant2, list, list2, keyPair, keyType);
    }

    private static final void writeVersion(Sink $this$writeVersion, int v) {
        CertificatesKt.writeDerType($this$writeVersion, 2, 0, false);
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeVersion_u24lambda_u2434 = (Sink)builder$iv;
        boolean bl = false;
        CertificatesKt.writeAsnInt($this$writeVersion_u24lambda_u2434, v);
        Source encoded = (Source)builder$iv;
        CertificatesKt.writeDerLength($this$writeVersion, (int)ByteReadPacketKt.getRemaining((Source)encoded));
        BytePacketBuilderKt.writePacket((Sink)$this$writeVersion, (Source)encoded);
    }

    static /* synthetic */ void writeVersion$default(Sink sink, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        CertificatesKt.writeVersion(sink, n);
    }

    private static final void writeDerOctetString(Sink $this$writeDerOctetString, Function1<? super Sink, Unit> block) {
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeDerOctetString_u24lambda_u2435 = (Sink)builder$iv;
        boolean bl = false;
        block.invoke((Object)$this$writeDerOctetString_u24lambda_u2435);
        Source sub = (Source)builder$iv;
        CertificatesKt.writeDerType($this$writeDerOctetString, 0, 4, true);
        CertificatesKt.writeDerLength($this$writeDerOctetString, (int)ByteReadPacketKt.getRemaining((Source)sub));
        BytePacketBuilderKt.writePacket((Sink)$this$writeDerOctetString, (Source)sub);
    }

    private static final void writeDerBitString(Sink $this$writeDerBitString, byte[] array, int unused) {
        if (!(0 <= unused ? unused < 8 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        CertificatesKt.writeDerType($this$writeDerBitString, 0, 3, true);
        CertificatesKt.writeDerLength($this$writeDerBitString, array.length + 1);
        $this$writeDerBitString.writeByte((byte)unused);
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeDerBitString, (byte[])array, (int)0, (int)0, (int)6, null);
    }

    static /* synthetic */ void writeDerBitString$default(Sink sink, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        CertificatesKt.writeDerBitString(sink, byArray, n);
    }

    private static final void writeDerUTCTime(Sink $this$writeDerUTCTime, Instant date) {
        String string = DateTimeFormatter.ofPattern("yyMMddHHmmss'Z'").format(date.atZone(ZoneOffset.UTC));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        CertificatesKt.writeDerUTF8String($this$writeDerUTCTime, string, 23);
    }

    private static final void writeDerGeneralizedTime(Sink $this$writeDerGeneralizedTime, Instant date) {
        String string = DateTimeFormatter.ofPattern("yyyyMMddHHmmss'Z'").format(date.atZone(ZoneOffset.UTC));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        CertificatesKt.writeDerUTF8String($this$writeDerGeneralizedTime, string, 24);
    }

    private static final void writeDerUTF8String(Sink $this$writeDerUTF8String, String s, int type) {
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeDerUTF8String_u24lambda_u2436 = (Sink)builder$iv;
        boolean bl = false;
        io.ktor.utils.io.core.StringsKt.writeText$default((Sink)$this$writeDerUTF8String_u24lambda_u2436, (CharSequence)s, (int)0, (int)0, null, (int)14, null);
        Source sub = (Source)builder$iv;
        CertificatesKt.writeDerType($this$writeDerUTF8String, 0, type, true);
        CertificatesKt.writeDerLength($this$writeDerUTF8String, (int)ByteReadPacketKt.getRemaining((Source)sub));
        BytePacketBuilderKt.writePacket((Sink)$this$writeDerUTF8String, (Source)sub);
    }

    static /* synthetic */ void writeDerUTF8String$default(Sink sink, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 12;
        }
        CertificatesKt.writeDerUTF8String(sink, string, n);
    }

    private static final void writeDerNull(Sink $this$writeDerNull) {
        $this$writeDerNull.writeShort((short)1280);
    }

    private static final void writeDerSequence(Sink $this$writeDerSequence, Function1<? super Sink, Unit> block) {
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeDerSequence_u24lambda_u2437 = (Sink)builder$iv;
        boolean bl = false;
        block.invoke((Object)$this$writeDerSequence_u24lambda_u2437);
        Source sub = (Source)builder$iv;
        CertificatesKt.writeDerType($this$writeDerSequence, 0, 16, false);
        CertificatesKt.writeDerLength($this$writeDerSequence, (int)ByteReadPacketKt.getRemaining((Source)sub));
        BytePacketBuilderKt.writePacket((Sink)$this$writeDerSequence, (Source)sub);
    }

    private static final void writeDerObjectIdentifier(Sink $this$writeDerObjectIdentifier, OID identifier) {
        CertificatesKt.writeDerObjectIdentifier($this$writeDerObjectIdentifier, identifier.getAsArray());
    }

    /*
     * Unable to fully structure code
     */
    private static final void writeDerObjectIdentifier(Sink $this$writeDerObjectIdentifier, int[] identifier) {
        if (!(identifier.length >= 2)) {
            var3_2 = "Failed requirement.";
            throw new IllegalArgumentException(var3_2.toString());
        }
        var2_6 = identifier[0];
        if (!(0 <= var2_6 ? var2_6 < 3 : false)) {
            var3_3 = "Failed requirement.";
            throw new IllegalArgumentException(var3_3.toString());
        }
        if (identifier[0] == 2) ** GOTO lbl-1000
        var2_6 = identifier[1];
        v0 = 0 <= var2_6 ? var2_6 < 40 : false;
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        if (!v1) {
            var3_4 = "Failed requirement.";
            throw new IllegalArgumentException(var3_4.toString());
        }
        $i$f$buildPacket = false;
        builder$iv = new Buffer();
        $this$writeDerObjectIdentifier_u24lambda_u2438 = (Sink)builder$iv;
        $i$a$-buildPacket-CertificatesKt$writeDerObjectIdentifier$sub$1 = false;
        CertificatesKt.writeDerInt($this$writeDerObjectIdentifier_u24lambda_u2438, identifier[0] * 40 + identifier[1]);
        i = 2;
        var8_12 = ArraysKt.getLastIndex((int[])identifier);
        if (i <= var8_12) {
            while (true) {
                CertificatesKt.writeDerInt($this$writeDerObjectIdentifier_u24lambda_u2438, identifier[i]);
                if (i == var8_12) break;
                ++i;
            }
        }
        sub = (Source)builder$iv;
        CertificatesKt.writeDerType($this$writeDerObjectIdentifier, 0, 6, true);
        CertificatesKt.writeDerLength($this$writeDerObjectIdentifier, (int)ByteReadPacketKt.getRemaining((Source)sub));
        BytePacketBuilderKt.writePacket((Sink)$this$writeDerObjectIdentifier, (Source)sub);
    }

    private static final void writeAsnInt(Sink $this$writeAsnInt, BigInteger value) {
        CertificatesKt.writeDerType($this$writeAsnInt, 0, 2, true);
        byte[] encoded = value.toByteArray();
        CertificatesKt.writeDerLength($this$writeAsnInt, encoded.length);
        Intrinsics.checkNotNull((Object)encoded);
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeAsnInt, (byte[])encoded, (int)0, (int)0, (int)6, null);
    }

    private static final void writeAsnInt(Sink $this$writeAsnInt, int value) {
        CertificatesKt.writeDerType($this$writeAsnInt, 0, 2, true);
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeAsnInt_u24lambda_u2439 = (Sink)builder$iv;
        boolean bl = false;
        boolean skip = true;
        for (int idx = 0; idx < 4; ++idx) {
            int part = value >>> (4 - idx - 1) * 8 & 0xFF;
            if (part == 0 && skip) continue;
            skip = false;
            $this$writeAsnInt_u24lambda_u2439.writeByte((byte)part);
        }
        Source encoded = (Source)builder$iv;
        CertificatesKt.writeDerLength($this$writeAsnInt, (int)ByteReadPacketKt.getRemaining((Source)encoded));
        BytePacketBuilderKt.writePacket((Sink)$this$writeAsnInt, (Source)encoded);
    }

    private static final void writeDerLength(Sink $this$writeDerLength, int length) {
        if (!(length >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (length <= 127) {
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 255) {
            $this$writeDerLength.writeByte((byte)-127);
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 65535) {
            $this$writeDerLength.writeByte((byte)-126);
            $this$writeDerLength.writeByte((byte)(length >>> 8));
            $this$writeDerLength.writeByte((byte)length);
        } else if (length <= 0xFFFFFF) {
            $this$writeDerLength.writeByte((byte)-125);
            $this$writeDerLength.writeByte((byte)(length >>> 16));
            $this$writeDerLength.writeByte((byte)(length >>> 8 & 0xFF));
            $this$writeDerLength.writeByte((byte)length);
        } else {
            $this$writeDerLength.writeByte((byte)-124);
            $this$writeDerLength.writeByte((byte)(length >>> 24));
            $this$writeDerLength.writeByte((byte)(length >>> 16 & 0xFF));
            $this$writeDerLength.writeByte((byte)(length >>> 8 & 0xFF));
            $this$writeDerLength.writeByte((byte)length);
        }
    }

    private static final void writeDerType(Sink $this$writeDerType, int kind, int typeIdentifier, boolean simpleType) {
        if (!(0 <= kind ? kind < 4 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(typeIdentifier >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean bl = 0 <= typeIdentifier ? typeIdentifier < 31 : false;
        if (bl) {
            int singleByte = kind << 6 | typeIdentifier | (simpleType ? 0 : 32);
            byte byteValue = (byte)singleByte;
            $this$writeDerType.writeByte(byteValue);
        } else {
            int firstByte = kind << 6 | 0x1F | (simpleType ? 0 : 32);
            $this$writeDerType.writeByte((byte)firstByte);
            CertificatesKt.writeDerInt($this$writeDerType, typeIdentifier);
        }
    }

    private static final int derLength(int $this$derLength) {
        if (!($this$derLength >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if ($this$derLength == 0) {
            return 0;
        }
        int mask = 127;
        int byteCount = 1;
        while (($this$derLength & mask) != $this$derLength) {
            mask |= mask << 7;
            ++byteCount;
        }
        return byteCount;
    }

    private static final void writeDerBoolean(Sink $this$writeDerBoolean, boolean value) {
        CertificatesKt.writeDerType($this$writeDerBoolean, 0, 1, true);
        CertificatesKt.writeDerLength($this$writeDerBoolean, 1);
        SinksKt.writeUByte-EK-6454((Sink)$this$writeDerBoolean, (byte)CertificatesKt.toUByte(value));
    }

    private static final byte toUByte(boolean $this$toUByte) {
        return $this$toUByte ? UByte.constructor-impl((byte)((byte)255)) : UByte.constructor-impl((byte)((byte)0));
    }

    private static final void writeDerInt(Sink $this$writeDerInt, int value) {
        if (!(value >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int byteCount = CertificatesKt.derLength(value);
        for (int i = 0; i < byteCount; ++i) {
            int idx = i;
            boolean bl = false;
            int part = value >> (byteCount - idx - 1) * 7 & 0x7F;
            if (idx == byteCount - 1) {
                $this$writeDerInt.writeByte((byte)part);
                continue;
            }
            $this$writeDerInt.writeByte((byte)(part | 0x80));
        }
    }

    private static final Unit generateCertificate$lambda$1$lambda$0(String $algorithm, String $keyPassword, int $keySizeInBits, KeyType $keyType, CertificateBuilder $this$certificate) {
        Intrinsics.checkNotNullParameter((Object)$this$certificate, (String)"$this$certificate");
        String[] stringArray = new String[]{"with"};
        List list = StringsKt.split$default((CharSequence)$algorithm, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String hashName = (String)list.get(0);
        String signName = (String)list.get(1);
        $this$certificate.setHash(HashAlgorithm.valueOf((String)hashName));
        $this$certificate.setSign(SignatureAlgorithm.valueOf((String)signName));
        $this$certificate.setPassword($keyPassword);
        $this$certificate.setKeySizeInBits($keySizeInBits);
        $this$certificate.setKeyType($keyType);
        $this$certificate.setSubject($keyType == KeyType.CA ? DEFAULT_CA_PRINCIPAL : DEFAULT_PRINCIPAL);
        Object[] objectArray = new String[]{"127.0.0.1", "localhost"};
        $this$certificate.setDomains(CollectionsKt.listOf((Object[])objectArray));
        return Unit.INSTANCE;
    }

    private static final Unit generateCertificate$lambda$1(String $keyAlias, String $algorithm, String $keyPassword, int $keySizeInBits, KeyType $keyType, KeyStoreBuilder $this$buildKeyStore) {
        Intrinsics.checkNotNullParameter((Object)$this$buildKeyStore, (String)"$this$buildKeyStore");
        $this$buildKeyStore.certificate($keyAlias, (Function1<? super CertificateBuilder, Unit>)((Function1)arg_0 -> CertificatesKt.generateCertificate$lambda$1$lambda$0($algorithm, $keyPassword, $keySizeInBits, $keyType, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit generateCertificate$lambda$5$lambda$4(String $algorithm, String $keyPassword, int $keySizeInBits, KeyType $keyType, KeyPair $caKeys, Certificate $caCert, CertificateBuilder $this$certificate) {
        Intrinsics.checkNotNullParameter((Object)$this$certificate, (String)"$this$certificate");
        String[] stringArray = new String[]{"with"};
        List list = StringsKt.split$default((CharSequence)$algorithm, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String hashName = (String)list.get(0);
        String signName = (String)list.get(1);
        $this$certificate.setHash(HashAlgorithm.valueOf((String)hashName));
        $this$certificate.setSign(SignatureAlgorithm.valueOf((String)signName));
        $this$certificate.setPassword($keyPassword);
        $this$certificate.setKeySizeInBits($keySizeInBits);
        $this$certificate.setKeyType($keyType);
        $this$certificate.setSubject(DEFAULT_PRINCIPAL);
        Object[] objectArray = new String[]{"127.0.0.1", "localhost"};
        $this$certificate.setDomains(CollectionsKt.listOf((Object[])objectArray));
        Intrinsics.checkNotNull((Object)$caCert);
        $this$certificate.signWith($caKeys, $caCert, DEFAULT_CA_PRINCIPAL);
        return Unit.INSTANCE;
    }

    private static final Unit generateCertificate$lambda$5(String $keyAlias, String $algorithm, String $keyPassword, int $keySizeInBits, KeyType $keyType, KeyPair $caKeys, Certificate $caCert, KeyStoreBuilder $this$buildKeyStore) {
        Intrinsics.checkNotNullParameter((Object)$this$buildKeyStore, (String)"$this$buildKeyStore");
        $this$buildKeyStore.certificate($keyAlias, (Function1<? super CertificateBuilder, Unit>)((Function1)arg_0 -> CertificatesKt.generateCertificate$lambda$5$lambda$4($algorithm, $keyPassword, $keySizeInBits, $keyType, $caKeys, $caCert, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit writeX509Info$lambda$15$lambda$10(Instant $validFrom, Instant $validUntil, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeDerUTCTime($this$writeDerSequence, $validFrom);
        CertificatesKt.writeDerGeneralizedTime($this$writeDerSequence, $validUntil);
        return Unit.INSTANCE;
    }

    private static final Unit writeX509Info$lambda$15$lambda$14$lambda$13$lambda$11(Sink $this$extKeyUsage) {
        Intrinsics.checkNotNullParameter((Object)$this$extKeyUsage, (String)"$this$extKeyUsage");
        CertificatesKt.serverAuth($this$extKeyUsage);
        return Unit.INSTANCE;
    }

    private static final Unit writeX509Info$lambda$15$lambda$14$lambda$13$lambda$12(Sink $this$extKeyUsage) {
        Intrinsics.checkNotNullParameter((Object)$this$extKeyUsage, (String)"$this$extKeyUsage");
        CertificatesKt.clientAuth($this$extKeyUsage);
        return Unit.INSTANCE;
    }

    private static final Unit writeX509Info$lambda$15$lambda$14$lambda$13(KeyType $keyType, List $domains, List $ipAddresses, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        switch (WhenMappings.$EnumSwitchMapping$0[$keyType.ordinal()]) {
            case 1: {
                CertificatesKt.caExtension($this$writeDerSequence);
                break;
            }
            case 2: {
                CertificatesKt.extKeyUsage($this$writeDerSequence, (Function1<? super Sink, Unit>)((Function1)CertificatesKt::writeX509Info$lambda$15$lambda$14$lambda$13$lambda$11));
                CertificatesKt.subjectAlternativeNames($this$writeDerSequence, $domains, $ipAddresses);
                break;
            }
            case 3: {
                CertificatesKt.extKeyUsage($this$writeDerSequence, (Function1<? super Sink, Unit>)((Function1)CertificatesKt::writeX509Info$lambda$15$lambda$14$lambda$13$lambda$12));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeX509Info$lambda$15(BigInteger $version, String $algorithm, X500Principal $issuer, X500Principal $subject, PublicKey $publicKey, Instant $validFrom, Instant $validUntil, KeyType $keyType, List $domains, List $ipAddresses, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeVersion($this$writeDerSequence, 2);
        CertificatesKt.writeAsnInt($this$writeDerSequence, $version);
        CertificatesKt.writeAlgorithmIdentifier($this$writeDerSequence, $algorithm);
        CertificatesKt.writeX500Principal($this$writeDerSequence, $issuer);
        CertificatesKt.writeDerSequence($this$writeDerSequence, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.writeX509Info$lambda$15$lambda$10($validFrom, $validUntil, arg_0)));
        CertificatesKt.writeX500Principal($this$writeDerSequence, $subject);
        byte[] byArray = $publicKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeDerSequence, (byte[])byArray, (int)0, (int)0, (int)6, null);
        $this$writeDerSequence.writeByte((byte)-93);
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeX509Info_u24lambda_u2415_u24lambda_u2414 = (Sink)builder$iv;
        boolean bl = false;
        CertificatesKt.writeDerSequence($this$writeX509Info_u24lambda_u2415_u24lambda_u2414, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.writeX509Info$lambda$15$lambda$14$lambda$13($keyType, $domains, $ipAddresses, arg_0)));
        Source extensions = (Source)builder$iv;
        CertificatesKt.writeDerLength($this$writeDerSequence, (int)ByteReadPacketKt.getRemaining((Source)extensions));
        BytePacketBuilderKt.writePacket((Sink)$this$writeDerSequence, (Source)extensions);
        return Unit.INSTANCE;
    }

    private static final Unit extKeyUsage$lambda$17$lambda$16(Function1 $content, Sink $this$writeDerOctetString) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerOctetString, (String)"$this$writeDerOctetString");
        $content.invoke((Object)$this$writeDerOctetString);
        return Unit.INSTANCE;
    }

    private static final Unit extKeyUsage$lambda$17(Function1 $content, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getExtKeyUsage());
        CertificatesKt.writeDerOctetString($this$writeDerSequence, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.extKeyUsage$lambda$17$lambda$16($content, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit clientAuth$lambda$18(Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getClientAuth());
        return Unit.INSTANCE;
    }

    private static final Unit serverAuth$lambda$19(Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getServerAuth());
        return Unit.INSTANCE;
    }

    private static final Unit subjectAlternativeNames$lambda$24$lambda$23$lambda$22$lambda$20(String $domain, Sink $this$writeX509Extension) {
        Intrinsics.checkNotNullParameter((Object)$this$writeX509Extension, (String)"$this$writeX509Extension");
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeX509Extension, (byte[])io.ktor.utils.io.core.StringsKt.toByteArray$default((String)$domain, null, (int)1, null), (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit subjectAlternativeNames$lambda$24$lambda$23$lambda$22$lambda$21(InetAddress $ip, Sink $this$writeX509Extension) {
        Intrinsics.checkNotNullParameter((Object)$this$writeX509Extension, (String)"$this$writeX509Extension");
        byte[] byArray = $ip.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getAddress(...)");
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeX509Extension, (byte[])byArray, (int)0, (int)0, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit subjectAlternativeNames$lambda$24$lambda$23$lambda$22(List $domains, List $ipAddresses, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        for (String domain : $domains) {
            CertificatesKt.writeX509Extension($this$writeDerSequence, 2, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.subjectAlternativeNames$lambda$24$lambda$23$lambda$22$lambda$20(domain, arg_0)));
        }
        for (InetAddress ip : $ipAddresses) {
            CertificatesKt.writeX509Extension($this$writeDerSequence, 7, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.subjectAlternativeNames$lambda$24$lambda$23$lambda$22$lambda$21(ip, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit subjectAlternativeNames$lambda$24$lambda$23(List $domains, List $ipAddresses, Sink $this$writeDerOctetString) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerOctetString, (String)"$this$writeDerOctetString");
        CertificatesKt.writeDerSequence($this$writeDerOctetString, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.subjectAlternativeNames$lambda$24$lambda$23$lambda$22($domains, $ipAddresses, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit subjectAlternativeNames$lambda$24(List $domains, List $ipAddresses, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getSubjectAltName());
        CertificatesKt.writeDerOctetString($this$writeDerSequence, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.subjectAlternativeNames$lambda$24$lambda$23($domains, $ipAddresses, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit caExtension$lambda$27$lambda$26$lambda$25(Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeDerBoolean($this$writeDerSequence, true);
        return Unit.INSTANCE;
    }

    private static final Unit caExtension$lambda$27$lambda$26(Sink $this$writeDerOctetString) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerOctetString, (String)"$this$writeDerOctetString");
        CertificatesKt.writeDerSequence($this$writeDerOctetString, (Function1<? super Sink, Unit>)((Function1)CertificatesKt::caExtension$lambda$27$lambda$26$lambda$25));
        return Unit.INSTANCE;
    }

    private static final Unit caExtension$lambda$27(Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.getBasicConstraints());
        CertificatesKt.writeDerBoolean($this$writeDerSequence, true);
        CertificatesKt.writeDerOctetString($this$writeDerSequence, (Function1<? super Sink, Unit>)((Function1)CertificatesKt::caExtension$lambda$27$lambda$26));
        return Unit.INSTANCE;
    }

    private static final Unit writeAlgorithmIdentifier$lambda$28(String $algorithm, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        OID oid = OID.Companion.fromAlgorithm($algorithm);
        CertificatesKt.writeDerObjectIdentifier($this$writeDerSequence, oid);
        CertificatesKt.writeDerNull($this$writeDerSequence);
        return Unit.INSTANCE;
    }

    private static final Unit writeCertificate$lambda$33$lambda$32(String $algorithm, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        CertificatesKt.writeDerObjectIdentifier($this$writeDerSequence, OID.Companion.fromAlgorithm($algorithm));
        CertificatesKt.writeDerNull($this$writeDerSequence);
        return Unit.INSTANCE;
    }

    private static final Unit writeCertificate$lambda$33(byte[] $certInfoBytes, byte[] $signed, String $algorithm, Sink $this$writeDerSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$writeDerSequence, (String)"$this$writeDerSequence");
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeDerSequence, (byte[])$certInfoBytes, (int)0, (int)0, (int)6, null);
        CertificatesKt.writeDerSequence($this$writeDerSequence, (Function1<? super Sink, Unit>)((Function1)arg_0 -> CertificatesKt.writeCertificate$lambda$33$lambda$32($algorithm, arg_0)));
        Intrinsics.checkNotNull((Object)$signed);
        CertificatesKt.writeDerBitString$default($this$writeDerSequence, $signed, 0, 2, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KeyType.values().length];
            try {
                nArray[KeyType.CA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.Server.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KeyType.Client.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

