/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectableBase;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.CIOReaderKt;
import io.ktor.network.sockets.CIOWriterKt;
import io.ktor.network.sockets.ReadWriteSocket;
import io.ktor.network.sockets.SocketOptions;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteChannelUtilsKt;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelKt;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import io.ktor.utils.io.ChannelJob;
import io.ktor.utils.io.ReaderJob;
import io.ktor.utils.io.WriterJob;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b \u0018\u0000*\u000e\b\u0000\u0010\u0003 \u0001*\u00020\u0001*\u00020\u00022\u00020\u00042\u00020\u00052\u00020\u0006B3\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJG\u0010$\u001a\u00028\u0001\"\b\b\u0001\u0010\u001d*\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u00112\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\"H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0011\u0010'\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b)\u0010\u001aJ%\u0010,\u001a\u0004\u0018\u00010&2\b\u0010*\u001a\u0004\u0018\u00010&2\b\u0010+\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0004\b,\u0010-R\u001a\u0010\u0007\u001a\u00028\u00008\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010.\u001a\u0004\b/\u00100R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00101\u001a\u0004\b2\u00103R\u001f\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8\u0006\u00a2\u0006\f\n\u0004\b\f\u00104\u001a\u0004\b5\u00106R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00107R\u0014\u00109\u001a\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u001c\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u001c\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010<R\u001a\u0010?\u001a\u00020>8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010BR\u0014\u0010F\u001a\u00020C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\"\u0010J\u001a\u00020G*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR$\u0010M\u001a\u0004\u0018\u00010&*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006N"}, d2={"Lio/ktor/network/sockets/NIOSocketImpl;", "Ljava/nio/channels/ByteChannel;", "Ljava/nio/channels/SelectableChannel;", "S", "Lio/ktor/network/sockets/ReadWriteSocket;", "Lio/ktor/network/selector/SelectableBase;", "Lkotlinx/coroutines/CoroutineScope;", "channel", "Lio/ktor/network/selector/SelectorManager;", "selector", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "pool", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "socketOptions", "<init>", "(Ljava/nio/channels/SelectableChannel;Lio/ktor/network/selector/SelectorManager;Lio/ktor/utils/io/pool/ObjectPool;Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;)V", "Lio/ktor/utils/io/ByteChannel;", "Lio/ktor/utils/io/WriterJob;", "attachForReading", "(Lio/ktor/utils/io/ByteChannel;)Lio/ktor/utils/io/WriterJob;", "Lio/ktor/utils/io/ReaderJob;", "attachForWriting", "(Lio/ktor/utils/io/ByteChannel;)Lio/ktor/utils/io/ReaderJob;", "", "dispose", "()V", "close", "Lio/ktor/utils/io/ChannelJob;", "J", "", "name", "Ljava/util/concurrent/atomic/AtomicReference;", "ref", "Lkotlin/Function0;", "producer", "attachFor", "(Ljava/lang/String;Lio/ktor/utils/io/ByteChannel;Ljava/util/concurrent/atomic/AtomicReference;Lkotlin/jvm/functions/Function0;)Lio/ktor/utils/io/ChannelJob;", "", "actualClose", "()Ljava/lang/Throwable;", "checkChannels", "e1", "e2", "combine", "(Ljava/lang/Throwable;Ljava/lang/Throwable;)Ljava/lang/Throwable;", "Ljava/nio/channels/SelectableChannel;", "getChannel", "()Ljava/nio/channels/SelectableChannel;", "Lio/ktor/network/selector/SelectorManager;", "getSelector", "()Lio/ktor/network/selector/SelectorManager;", "Lio/ktor/utils/io/pool/ObjectPool;", "getPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closeFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "readerJob", "Ljava/util/concurrent/atomic/AtomicReference;", "writerJob", "Lkotlinx/coroutines/CompletableJob;", "socketContext", "Lkotlinx/coroutines/CompletableJob;", "getSocketContext", "()Lkotlinx/coroutines/CompletableJob;", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "", "getCompletedOrNotStarted", "(Ljava/util/concurrent/atomic/AtomicReference;)Z", "completedOrNotStarted", "getException", "(Ljava/util/concurrent/atomic/AtomicReference;)Ljava/lang/Throwable;", "exception", "ktor-network"})
@SourceDebugExtension(value={"SMAP\nNIOSocketImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NIOSocketImpl.kt\nio/ktor/network/sockets/NIOSocketImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public abstract class NIOSocketImpl<S extends SelectableChannel>
extends SelectableBase
implements ReadWriteSocket,
CoroutineScope {
    @NotNull
    private final S channel;
    @NotNull
    private final SelectorManager selector;
    @Nullable
    private final ObjectPool<ByteBuffer> pool;
    @Nullable
    private final SocketOptions.TCPClientSocketOptions socketOptions;
    @NotNull
    private final AtomicBoolean closeFlag;
    @NotNull
    private final AtomicReference<ReaderJob> readerJob;
    @NotNull
    private final AtomicReference<WriterJob> writerJob;
    @NotNull
    private final CompletableJob socketContext;

    public NIOSocketImpl(@NotNull S channel, @NotNull SelectorManager selector, @Nullable ObjectPool<ByteBuffer> pool, @Nullable SocketOptions.TCPClientSocketOptions socketOptions) {
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        super((SelectableChannel)channel);
        this.channel = channel;
        this.selector = selector;
        this.pool = pool;
        this.socketOptions = socketOptions;
        this.closeFlag = new AtomicBoolean();
        this.readerJob = new AtomicReference();
        this.writerJob = new AtomicReference();
        this.socketContext = JobKt.Job$default(null, (int)1, null);
    }

    public /* synthetic */ NIOSocketImpl(SelectableChannel selectableChannel, SelectorManager selectorManager, ObjectPool objectPool, SocketOptions.TCPClientSocketOptions tCPClientSocketOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tCPClientSocketOptions = null;
        }
        this(selectableChannel, selectorManager, (ObjectPool<ByteBuffer>)objectPool, tCPClientSocketOptions);
    }

    @NotNull
    public S getChannel() {
        return this.channel;
    }

    @NotNull
    public final SelectorManager getSelector() {
        return this.selector;
    }

    @Nullable
    public final ObjectPool<ByteBuffer> getPool() {
        return this.pool;
    }

    @NotNull
    public CompletableJob getSocketContext() {
        return this.socketContext;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.getSocketContext();
    }

    @Override
    @NotNull
    public final WriterJob attachForReading(@NotNull ByteChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return this.attachFor("reading", channel, this.writerJob, () -> NIOSocketImpl.attachForReading$lambda$0(this, channel));
    }

    @Override
    @NotNull
    public final ReaderJob attachForWriting(@NotNull ByteChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return this.attachFor("writing", channel, this.readerJob, () -> NIOSocketImpl.attachForWriting$lambda$1(this, channel));
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        if (!this.closeFlag.compareAndSet(false, true)) {
            return;
        }
        ReaderJob readerJob = this.readerJob.get();
        if (readerJob != null && (readerJob = readerJob.getChannel()) != null) {
            ByteWriteChannelKt.close((ByteWriteChannel)readerJob);
        }
        WriterJob writerJob = this.writerJob.get();
        if (writerJob != null) {
            ByteWriteChannelOperationsKt.cancel((ChannelJob)((ChannelJob)writerJob));
        }
        this.checkChannels();
    }

    private final <J extends ChannelJob> J attachFor(String name, ByteChannel channel, AtomicReference<J> ref, Function0<? extends J> producer) {
        if (this.closeFlag.get()) {
            ClosedChannelException e = new ClosedChannelException();
            ByteWriteChannelOperationsKt.close((ByteWriteChannel)((ByteWriteChannel)channel), (Throwable)e);
            throw e;
        }
        ChannelJob j = (ChannelJob)producer.invoke();
        if (!ref.compareAndSet(null, j)) {
            IllegalStateException e = new IllegalStateException(name + " channel has already been set");
            ByteWriteChannelOperationsKt.cancel((ChannelJob)j);
            throw e;
        }
        if (this.closeFlag.get()) {
            ClosedChannelException e = new ClosedChannelException();
            ByteWriteChannelOperationsKt.cancel((ChannelJob)j);
            ByteWriteChannelOperationsKt.close((ByteWriteChannel)((ByteWriteChannel)channel), (Throwable)e);
            throw e;
        }
        ByteChannelUtilsKt.attachJob((ByteChannel)channel, (ChannelJob)j);
        ByteWriteChannelOperationsKt.invokeOnCompletion((ChannelJob)j, () -> NIOSocketImpl.attachFor$lambda$2(this));
        return (J)j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Throwable actualClose() {
        Throwable throwable;
        try {
            ((Channel)this.getChannel()).close();
            super.close();
            throwable = null;
        }
        catch (Throwable cause) {
            throwable = cause;
        }
        finally {
            this.selector.notifyClosed(this);
        }
        return throwable;
    }

    private final void checkChannels() {
        if (this.closeFlag.get() && this.getCompletedOrNotStarted(this.readerJob) && this.getCompletedOrNotStarted(this.writerJob)) {
            Throwable e1 = this.getException(this.readerJob);
            Throwable e2 = this.getException(this.writerJob);
            Throwable e3 = this.actualClose();
            Throwable combined = this.combine(this.combine(e1, e2), e3);
            boolean bl = combined == null ? this.getSocketContext().complete() : this.getSocketContext().completeExceptionally(combined);
        }
    }

    private final Throwable combine(Throwable e1, Throwable e2) {
        Throwable throwable;
        if (e1 == null) {
            throwable = e2;
        } else if (e2 == null) {
            throwable = e1;
        } else if (e1 == e2) {
            throwable = e1;
        } else {
            ExceptionsKt.addSuppressed((Throwable)e1, (Throwable)e2);
            throwable = e1;
        }
        return throwable;
    }

    private final boolean getCompletedOrNotStarted(AtomicReference<? extends ChannelJob> $this$completedOrNotStarted) {
        ChannelJob it = $this$completedOrNotStarted.get();
        boolean bl = false;
        return it == null || ByteWriteChannelOperationsKt.isCompleted((ChannelJob)it);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Throwable getException(AtomicReference<? extends ChannelJob> $this$exception) {
        ChannelJob channelJob = $this$exception.get();
        if (channelJob == null) return null;
        Object object = channelJob;
        ChannelJob it = object;
        boolean bl = false;
        if (!ByteWriteChannelOperationsKt.isCancelled((ChannelJob)it)) return null;
        ChannelJob channelJob2 = object;
        ChannelJob channelJob3 = channelJob2;
        if (channelJob3 == null) return null;
        object = ByteWriteChannelOperationsKt.getCancellationException((ChannelJob)channelJob3);
        if (object == null) return null;
        Throwable throwable = ((Throwable)object).getCause();
        return throwable;
    }

    private static final WriterJob attachForReading$lambda$0(NIOSocketImpl this$0, ByteChannel $channel) {
        return this$0.pool != null ? CIOReaderKt.attachForReadingImpl(this$0, $channel, (ReadableByteChannel)this$0.getChannel(), this$0, this$0.selector, this$0.pool, this$0.socketOptions) : CIOReaderKt.attachForReadingDirectImpl(this$0, $channel, (ReadableByteChannel)this$0.getChannel(), this$0, this$0.selector, this$0.socketOptions);
    }

    private static final ReaderJob attachForWriting$lambda$1(NIOSocketImpl this$0, ByteChannel $channel) {
        return CIOWriterKt.attachForWritingDirectImpl(this$0, $channel, (WritableByteChannel)this$0.getChannel(), this$0, this$0.selector, this$0.socketOptions);
    }

    private static final Unit attachFor$lambda$2(NIOSocketImpl this$0) {
        this$0.checkChannels();
        return Unit.INSTANCE;
    }
}

