/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectInterest;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.JavaSocketAddressUtilsKt;
import io.ktor.network.sockets.NIOSocketImpl;
import io.ktor.network.sockets.Socket;
import io.ktor.network.sockets.SocketAddress;
import io.ktor.network.sockets.SocketImpl;
import io.ktor.network.sockets.SocketOptions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B!\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001aH\u0002R\u0016\u0010\u0005\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/ktor/network/sockets/SocketImpl;", "S", "Ljava/nio/channels/SocketChannel;", "Lio/ktor/network/sockets/NIOSocketImpl;", "Lio/ktor/network/sockets/Socket;", "channel", "selector", "Lio/ktor/network/selector/SelectorManager;", "socketOptions", "Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;", "(Ljava/nio/channels/SocketChannel;Lio/ktor/network/selector/SelectorManager;Lio/ktor/network/sockets/SocketOptions$TCPClientSocketOptions;)V", "getChannel", "()Ljava/nio/channels/SocketChannel;", "Ljava/nio/channels/SocketChannel;", "localAddress", "Lio/ktor/network/sockets/SocketAddress;", "getLocalAddress", "()Lio/ktor/network/sockets/SocketAddress;", "remoteAddress", "getRemoteAddress", "connect", "target", "Ljava/net/SocketAddress;", "connect$ktor_network", "(Ljava/net/SocketAddress;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selfConnect", "", "wantConnect", "", "state", "ktor-network"})
public final class SocketImpl<S extends SocketChannel>
extends NIOSocketImpl<S>
implements Socket {
    @NotNull
    private final S channel;

    public SocketImpl(@NotNull S channel, @NotNull SelectorManager selector, @Nullable SocketOptions.TCPClientSocketOptions socketOptions) {
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        super((SelectableChannel)channel, selector, null, socketOptions);
        this.channel = channel;
        if (!(!((AbstractSelectableChannel)this.getChannel()).isBlocking())) {
            boolean bl = false;
            String string = "Channel need to be configured as non-blocking.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SocketImpl(SocketChannel socketChannel, SelectorManager selectorManager, SocketOptions.TCPClientSocketOptions tCPClientSocketOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            tCPClientSocketOptions = null;
        }
        this(socketChannel, selectorManager, tCPClientSocketOptions);
    }

    @Override
    @NotNull
    public S getChannel() {
        return this.channel;
    }

    @Override
    @NotNull
    public SocketAddress getLocalAddress() {
        SocketAddress socketAddress;
        java.net.SocketAddress socketAddress2 = ((SocketChannel)this.getChannel()).getLocalAddress();
        SocketAddress socketAddress3 = socketAddress = socketAddress2 == null ? null : JavaSocketAddressUtilsKt.toSocketAddress(socketAddress2);
        if (socketAddress == null) {
            throw new IllegalStateException("Channel is not yet bound");
        }
        return socketAddress;
    }

    @Override
    @NotNull
    public SocketAddress getRemoteAddress() {
        SocketAddress socketAddress;
        java.net.SocketAddress socketAddress2 = ((SocketChannel)this.getChannel()).getRemoteAddress();
        SocketAddress socketAddress3 = socketAddress = socketAddress2 == null ? null : JavaSocketAddressUtilsKt.toSocketAddress(socketAddress2);
        if (socketAddress == null) {
            throw new IllegalStateException("Channel is not yet connected");
        }
        return socketAddress;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object connect$ktor_network(@NotNull java.net.SocketAddress var1_1, @NotNull Continuation<? super Socket> var2_2) {
        if (!(var2_2 instanceof connect.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ SocketImpl<S> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.connect$ktor_network(null, (Continuation<Socket>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getChannel().connect((java.net.SocketAddress)target)) {
                    return this;
                }
                this.wantConnect(true);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.getSelector().select(this, SelectInterest.CONNECT, (Continuation<? super Unit>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                this = (SocketImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 3 sources

                while (true) {
                    if (this.getChannel().finishConnect()) {
                        if (!this.selfConnect()) break block0;
                        this.getChannel().close();
                        continue;
                    }
                    this.wantConnect(true);
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = this.getSelector().select(this, SelectInterest.CONNECT, (Continuation<? super Unit>)$continuation);
                    if (v1 != var5_5) continue;
                    return var5_5;
                }
            }
            case 2: {
                this = (SocketImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** continue;
            }
        }
        this.wantConnect(false);
        return this;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void wantConnect(boolean state) {
        this.interestOp(SelectInterest.CONNECT, state);
    }

    static /* synthetic */ void wantConnect$default(SocketImpl socketImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        socketImpl.wantConnect(bl);
    }

    private final boolean selfConnect() {
        boolean bl;
        String string;
        String string2;
        java.net.SocketAddress localAddress = ((SocketChannel)this.getChannel()).getLocalAddress();
        java.net.SocketAddress remoteAddress = ((SocketChannel)this.getChannel()).getRemoteAddress();
        if (localAddress == null || remoteAddress == null) {
            throw new IllegalStateException("localAddress and remoteAddress should not be null.");
        }
        InetSocketAddress localInetSocketAddress = localAddress instanceof InetSocketAddress ? (InetSocketAddress)localAddress : null;
        InetSocketAddress remoteInetSocketAddress = remoteAddress instanceof InetSocketAddress ? (InetSocketAddress)remoteAddress : null;
        InetSocketAddress inetSocketAddress = localInetSocketAddress;
        if (inetSocketAddress == null) {
            string2 = "";
        } else {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress == null) {
                string2 = "";
            } else {
                string2 = inetAddress.getHostAddress();
                if (string2 == null) {
                    string2 = "";
                }
            }
        }
        String localHostAddress = string2;
        InetSocketAddress inetSocketAddress2 = remoteInetSocketAddress;
        if (inetSocketAddress2 == null) {
            string = "";
        } else {
            InetAddress inetAddress = inetSocketAddress2.getAddress();
            if (inetAddress == null) {
                string = "";
            } else {
                string = inetAddress.getHostAddress();
                if (string == null) {
                    string = "";
                }
            }
        }
        String remoteHostAddress = string;
        InetSocketAddress inetSocketAddress3 = remoteInetSocketAddress;
        if (inetSocketAddress3 == null) {
            bl = false;
        } else {
            boolean bl2;
            InetAddress inetAddress = inetSocketAddress3.getAddress();
            bl = inetAddress == null ? false : (bl2 = inetAddress.isAnyLocalAddress());
        }
        boolean isRemoteAnyLocalAddress = bl;
        InetSocketAddress inetSocketAddress4 = localInetSocketAddress;
        Integer localPort = inetSocketAddress4 == null ? null : Integer.valueOf(inetSocketAddress4.getPort());
        InetSocketAddress inetSocketAddress5 = remoteInetSocketAddress;
        Integer remotePort = inetSocketAddress5 == null ? null : Integer.valueOf(inetSocketAddress5.getPort());
        return Intrinsics.areEqual((Object)localPort, (Object)remotePort) && (isRemoteAnyLocalAddress || Intrinsics.areEqual((Object)localHostAddress, (Object)remoteHostAddress));
    }
}

