/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/network/sockets/SocketOptionsPlatformCapabilities;", "", "()V", "channelSetOption", "Ljava/lang/reflect/Method;", "datagramSetOption", "serverChannelSetOption", "standardSocketOptions", "", "", "Ljava/lang/reflect/Field;", "setReusePort", "", "channel", "Ljava/nio/channels/DatagramChannel;", "Ljava/nio/channels/ServerSocketChannel;", "Ljava/nio/channels/SocketChannel;", "socketOption", "name", "ktor-network"})
public final class SocketOptionsPlatformCapabilities {
    @NotNull
    public static final SocketOptionsPlatformCapabilities INSTANCE;
    @NotNull
    private static final Map<String, Field> standardSocketOptions;
    @Nullable
    private static final Method channelSetOption;
    @Nullable
    private static final Method serverChannelSetOption;
    @Nullable
    private static final Method datagramSetOption;

    private SocketOptionsPlatformCapabilities() {
    }

    public final void setReusePort(@NotNull SocketChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Object[] objectArray = channelSetOption;
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{option, true};
        objectArray2.invoke((Object)channel, objectArray);
    }

    public final void setReusePort(@NotNull ServerSocketChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Object[] objectArray = serverChannelSetOption;
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{option, true};
        objectArray2.invoke((Object)channel, objectArray);
    }

    public final void setReusePort(@NotNull DatagramChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Object option = this.socketOption("SO_REUSEPORT");
        Object[] objectArray = datagramSetOption;
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{option, true};
        objectArray2.invoke((Object)channel, objectArray);
    }

    private final Object socketOption(String name) {
        Object object;
        Field field = standardSocketOptions.get(name);
        Object object2 = object = field == null ? null : field.get(null);
        if (object == null) {
            throw new IOException("Socket option " + name + " is not supported");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    static {
        int n;
        Object[] $this$firstOrNull$iv;
        Class<?> socketChannelClass;
        GenericDeclaration socketOptionType;
        Class<?> _2;
        Object object;
        Object object2;
        INSTANCE = new SocketOptionsPlatformCapabilities();
        try {
            Map map;
            Field[] fieldArray;
            object2 = Class.forName("java.net.StandardSocketOptions");
            Field[] fieldArray2 = fieldArray = object2 == null ? null : object2.getFields();
            if (fieldArray == null) {
                map = null;
            } else {
                void $this$associateByTo$iv$iv;
                void $this$filterTo$iv$iv;
                Field[] $this$filter$iv = fieldArray;
                boolean $i$f$filter = false;
                Field[] fieldArray3 = $this$filter$iv;
                Iterable<void> destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Field element$iv$iv2 : $this$filterTo$iv$iv) {
                    void it = element$iv$iv2;
                    boolean bl6 = false;
                    int n2 = it.getModifiers();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int modifiers = n2;
                    boolean bl4 = false;
                    boolean bl5 = Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers);
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                object2 = (List)destination$iv$iv;
                Iterable $this$associateBy$iv = (Iterable)object2;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    Field element$iv$iv2;
                    element$iv$iv2 = (Field)element$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl = false;
                    String bl6 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)bl6, (String)"it.name");
                    String string = bl6;
                    map2.put(string, element$iv$iv);
                }
                map = destination$iv$iv2;
            }
            object = map;
            object = object == null ? MapsKt.emptyMap() : object;
        }
        catch (Throwable _2) {
            object = MapsKt.emptyMap();
        }
        standardSocketOptions = object;
        try {
            Object object3;
            block15: {
                _2 = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(_2);
                socketOptionType = _2;
                socketChannelClass = Class.forName("java.nio.channels.SocketChannel");
                object2 = socketChannelClass.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"socketChannelClass.methods");
                $this$firstOrNull$iv = object2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Method method = (Method)element$iv;
                    boolean bl = false;
                    n = method.getModifiers();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    int modifiers = n;
                    boolean bl9 = false;
                    boolean bl10 = Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method.getName(), (Object)"setOption") && method.getParameterTypes().length == 2 && Intrinsics.areEqual(method.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method.getParameterTypes()[0], (Object)socketOptionType) && Intrinsics.areEqual(method.getParameterTypes()[1], Object.class);
                    if (!bl10) continue;
                    object3 = element$iv;
                    break block15;
                }
                object3 = null;
            }
            socketOptionType = (Method)object3;
        }
        catch (Throwable _3) {
            socketOptionType = null;
        }
        channelSetOption = socketOptionType;
        try {
            Object object4;
            block16: {
                _2 = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(_2);
                socketOptionType = _2;
                socketChannelClass = Class.forName("java.nio.channels.ServerSocketChannel");
                $this$firstOrNull$iv = socketChannelClass.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)$this$firstOrNull$iv, (String)"socketChannelClass.methods");
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Method method = (Method)element$iv;
                    boolean bl = false;
                    n = method.getModifiers();
                    boolean bl11 = false;
                    boolean bl12 = false;
                    int modifiers = n;
                    boolean bl13 = false;
                    boolean bl14 = Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method.getName(), (Object)"setOption") && method.getParameterTypes().length == 2 && Intrinsics.areEqual(method.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method.getParameterTypes()[0], (Object)socketOptionType) && Intrinsics.areEqual(method.getParameterTypes()[1], Object.class);
                    if (!bl14) continue;
                    object4 = element$iv;
                    break block16;
                }
                object4 = null;
            }
            socketOptionType = (Method)object4;
        }
        catch (Throwable _4) {
            socketOptionType = null;
        }
        serverChannelSetOption = socketOptionType;
        try {
            Object object5;
            block17: {
                _2 = Class.forName("java.net.SocketOption");
                Intrinsics.checkNotNull(_2);
                socketOptionType = _2;
                socketChannelClass = Class.forName("java.nio.channels.DatagramChannel");
                $this$firstOrNull$iv = socketChannelClass.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)$this$firstOrNull$iv, (String)"socketChannelClass.methods");
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Method method = (Method)element$iv;
                    boolean bl = false;
                    n = method.getModifiers();
                    boolean bl15 = false;
                    boolean bl16 = false;
                    int modifiers = n;
                    boolean bl17 = false;
                    boolean bl18 = Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && Intrinsics.areEqual((Object)method.getName(), (Object)"setOption") && method.getParameterTypes().length == 2 && Intrinsics.areEqual(method.getReturnType(), socketChannelClass) && Intrinsics.areEqual(method.getParameterTypes()[0], (Object)socketOptionType) && Intrinsics.areEqual(method.getParameterTypes()[1], Object.class);
                    if (!bl18) continue;
                    object5 = element$iv;
                    break block17;
                }
                object5 = null;
            }
            object = (Method)object5;
        }
        catch (Throwable _5) {
            object = null;
        }
        datagramSetOption = object;
    }
}

