/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.streams;

import io.ktor.utils.io.bits.MemoryJvmKt;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.pool.ObjectPool;
import io.ktor.utils.io.streams.ByteArraysKt;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J$\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/ktor/utils/io/streams/InputStreamAsInput;", "Lio/ktor/utils/io/core/Input;", "stream", "Ljava/io/InputStream;", "pool", "Lio/ktor/utils/io/pool/ObjectPool;", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "(Ljava/io/InputStream;Lio/ktor/utils/io/pool/ObjectPool;)V", "closeSource", "", "fill", "", "destination", "Ljava/nio/ByteBuffer;", "Lio/ktor/utils/io/bits/Memory;", "offset", "length", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Input.kt\nio/ktor/utils/io/streams/InputStreamAsInput\n+ 2 PrimiteArrays.kt\nio/ktor/utils/io/bits/PrimiteArraysKt\n+ 3 MemoryFactoryJvm.kt\nio/ktor/utils/io/bits/MemoryFactoryJvmKt\n*L\n1#1,40:1\n282#2:41\n283#2,3:46\n17#3,4:42\n*S KotlinDebug\n*F\n+ 1 Input.kt\nio/ktor/utils/io/streams/InputStreamAsInput\n*L\n26#1:41\n26#1:46,3\n26#1:42,4\n*E\n"})
public final class InputStreamAsInput
extends Input {
    @NotNull
    private final InputStream stream;

    public InputStreamAsInput(@NotNull InputStream stream, @NotNull ObjectPool<ChunkBuffer> pool) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        super(null, 0L, pool, 3, null);
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected int fill(@NotNull ByteBuffer destination, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (destination.hasArray() && !destination.isReadOnly()) {
            return RangesKt.coerceAtLeast((int)this.stream.read(destination.array(), destination.arrayOffset() + offset, length), (int)0);
        }
        byte[] buffer = ByteArraysKt.getByteArrayPool().borrow();
        try {
            void $this$storeByteArray$iv;
            int rc = this.stream.read(buffer, 0, Math.min(buffer.length, length));
            if (rc == -1) {
                int n = 0;
                return n;
            }
            ByteBuffer byteBuffer = destination;
            int sourceOffset$iv = 0;
            boolean $i$f$storeByteArray = false;
            byte[] $this$useMemory$iv$iv = buffer;
            boolean $i$f$useMemory = false;
            ByteBuffer byteBuffer2 = ByteBuffer.wrap($this$useMemory$iv$iv, sourceOffset$iv, rc).slice().order(ByteOrder.BIG_ENDIAN);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"order(...)");
            ByteBuffer sourceMemory$iv = MemoryJvmKt.Memory(byteBuffer2);
            boolean bl = false;
            MemoryJvmKt.copyTo(sourceMemory$iv, (ByteBuffer)$this$storeByteArray$iv, 0, rc, offset);
            int n = rc;
            return n;
        }
        finally {
            ByteArraysKt.getByteArrayPool().recycle(buffer);
        }
    }

    @Override
    protected void closeSource() {
        this.stream.close();
    }
}

