/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core.internal;

import io.ktor.utils.io.bits.DefaultAllocator;
import io.ktor.utils.io.bits.Memory;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.BufferFactoryKt;
import io.ktor.utils.io.pool.NoPoolImpl;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B*\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0000H\u0002J\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000J\b\u0010 \u001a\u00020\u0000H\u0016J\r\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0016\u0010!\u001a\u00020\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006H\u0016J\u0006\u0010%\u001a\u00020\u001bJ\r\u0010&\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b)R(\u0010\t\u001a\u0004\u0018\u00010\u00002\b\u0010\b\u001a\u0004\u0018\u00010\u00008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u001c\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006+"}, d2={"Lio/ktor/utils/io/core/internal/ChunkBuffer;", "Lio/ktor/utils/io/core/Buffer;", "memory", "Lio/ktor/utils/io/bits/Memory;", "origin", "parentPool", "Lio/ktor/utils/io/pool/ObjectPool;", "(Ljava/nio/ByteBuffer;Lio/ktor/utils/io/core/internal/ChunkBuffer;Lio/ktor/utils/io/pool/ObjectPool;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "newValue", "next", "getNext", "()Lio/ktor/utils/io/core/internal/ChunkBuffer;", "setNext", "(Lio/ktor/utils/io/core/internal/ChunkBuffer;)V", "nextRef", "Lkotlinx/atomicfu/AtomicRef;", "<set-?>", "getOrigin", "getParentPool$ktor_io", "()Lio/ktor/utils/io/pool/ObjectPool;", "refCount", "Lkotlinx/atomicfu/AtomicInt;", "referenceCount", "", "getReferenceCount", "()I", "acquire", "", "acquire$ktor_io", "appendNext", "chunk", "cleanNext", "duplicate", "release", "", "release$ktor_io", "pool", "reset", "unlink", "unlink$ktor_io", "unpark", "unpark$ktor_io", "Companion", "ktor-io"})
public class ChunkBuffer
extends Buffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ObjectPool<ChunkBuffer> parentPool;
    @NotNull
    private final AtomicRef<ChunkBuffer> nextRef;
    @NotNull
    private final AtomicInt refCount;
    @Nullable
    private ChunkBuffer origin;
    @NotNull
    private static final ObjectPool<ChunkBuffer> Pool = new ObjectPool<ChunkBuffer>(){

        public int getCapacity() {
            return BufferFactoryKt.getDefaultChunkedBufferPool().getCapacity();
        }

        @NotNull
        public ChunkBuffer borrow() {
            return BufferFactoryKt.getDefaultChunkedBufferPool().borrow();
        }

        public void recycle(@NotNull ChunkBuffer instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            BufferFactoryKt.getDefaultChunkedBufferPool().recycle(instance);
        }

        public void dispose() {
            BufferFactoryKt.getDefaultChunkedBufferPool().dispose();
        }

        public void close() {
            ObjectPool.DefaultImpls.close(this);
        }
    };
    @NotNull
    private static final ObjectPool<ChunkBuffer> EmptyPool = new ObjectPool<ChunkBuffer>(){

        public int getCapacity() {
            return 1;
        }

        @NotNull
        public ChunkBuffer borrow() {
            return ChunkBuffer.Companion.getEmpty();
        }

        public void recycle(@NotNull ChunkBuffer instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            if (!(instance == ChunkBuffer.Companion.getEmpty())) {
                boolean bl = false;
                String string = "Only ChunkBuffer.Empty instance could be recycled.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public void dispose() {
        }

        public void close() {
            ObjectPool.DefaultImpls.close(this);
        }
    };
    @NotNull
    private static final ChunkBuffer Empty = new ChunkBuffer(Memory.Companion.getEmpty-SK3TCg8(), null, EmptyPool, null);
    @NotNull
    private static final ObjectPool<ChunkBuffer> NoPool = new NoPoolImpl<ChunkBuffer>(){

        @NotNull
        public ChunkBuffer borrow() {
            return new ChunkBuffer(DefaultAllocator.INSTANCE.alloc-gFv-Zug(4096), null, this, null);
        }

        public void recycle(@NotNull ChunkBuffer instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            DefaultAllocator.INSTANCE.free-3GNKZMM(instance.getMemory-SK3TCg8());
        }
    };
    @NotNull
    private static final ObjectPool<ChunkBuffer> NoPoolManuallyManaged = new NoPoolImpl<ChunkBuffer>(){

        @NotNull
        public ChunkBuffer borrow() {
            throw new UnsupportedOperationException("This pool doesn't support borrow");
        }

        public void recycle(@NotNull ChunkBuffer instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        }
    };

    private ChunkBuffer(ByteBuffer memory, ChunkBuffer origin, ObjectPool<ChunkBuffer> parentPool) {
        super(memory, null);
        this.parentPool = parentPool;
        if (!(origin != this)) {
            boolean bl = false;
            String string = "A chunk couldn't be a view of itself.";
            throw new IllegalArgumentException(string.toString());
        }
        this.nextRef = AtomicFU.atomic(null);
        this.refCount = AtomicFU.atomic((int)1);
        this.origin = origin;
    }

    @Nullable
    public final ObjectPool<ChunkBuffer> getParentPool$ktor_io() {
        return this.parentPool;
    }

    @Nullable
    public final ChunkBuffer getOrigin() {
        return this.origin;
    }

    @Nullable
    public final ChunkBuffer getNext() {
        return (ChunkBuffer)this.nextRef.getValue();
    }

    public final void setNext(@Nullable ChunkBuffer newValue) {
        if (newValue == null) {
            this.cleanNext();
        } else {
            this.appendNext(newValue);
        }
    }

    public final int getReferenceCount() {
        return this.refCount.getValue();
    }

    private final void appendNext(ChunkBuffer chunk) {
        if (!this.nextRef.compareAndSet(null, (Object)chunk)) {
            throw new IllegalStateException("This chunk has already a next chunk.");
        }
    }

    @Nullable
    public final ChunkBuffer cleanNext() {
        return (ChunkBuffer)this.nextRef.getAndSet(null);
    }

    @Override
    @NotNull
    public ChunkBuffer duplicate() {
        ChunkBuffer chunkBuffer;
        ChunkBuffer chunkBuffer2 = this.origin;
        if (chunkBuffer2 == null) {
            chunkBuffer2 = this;
        }
        ChunkBuffer newOrigin = chunkBuffer2;
        boolean bl = false;
        newOrigin.acquire$ktor_io();
        ChunkBuffer copy2 = chunkBuffer = new ChunkBuffer(this.getMemory-SK3TCg8(), newOrigin, this.parentPool, null);
        boolean bl2 = false;
        this.duplicateTo(copy2);
        return chunkBuffer;
    }

    public void release(@NotNull ObjectPool<ChunkBuffer> pool) {
        Intrinsics.checkNotNullParameter(pool, (String)"pool");
        if (this.release$ktor_io()) {
            ChunkBuffer origin = this.origin;
            if (origin != null) {
                this.unlink$ktor_io();
                origin.release(pool);
            } else {
                ObjectPool<ChunkBuffer> objectPool = this.parentPool;
                if (objectPool == null) {
                    objectPool = pool;
                }
                ObjectPool<ChunkBuffer> poolToUse = objectPool;
                poolToUse.recycle(this);
            }
        }
    }

    public final void unlink$ktor_io() {
        if (!this.refCount.compareAndSet(0, -1)) {
            throw new IllegalStateException("Unable to unlink: buffer is in use.");
        }
        this.cleanNext();
        this.origin = null;
    }

    public final void acquire$ktor_io() {
        int old;
        int upd$iv;
        int cur$iv;
        AtomicInt $this$update$iv = this.refCount;
        boolean $i$f$update = false;
        do {
            old = cur$iv = $this$update$iv.getValue();
            boolean bl = false;
            if (old > 0) continue;
            throw new IllegalStateException("Unable to acquire chunk: it is already released.");
        } while (!$this$update$iv.compareAndSet(cur$iv, upd$iv = old + 1));
    }

    public final void unpark$ktor_io() {
        int upd$iv;
        int cur$iv;
        AtomicInt $this$update$iv = this.refCount;
        boolean $i$f$update = false;
        do {
            int old = cur$iv = $this$update$iv.getValue();
            boolean bl = false;
            if (old < 0) {
                throw new IllegalStateException("This instance is already disposed and couldn't be borrowed.");
            }
            if (old <= 0) continue;
            throw new IllegalStateException("This instance is already in use but somehow appeared in the pool.");
        } while (!$this$update$iv.compareAndSet(cur$iv, upd$iv = 1));
    }

    public final boolean release$ktor_io() {
        int old;
        int upd$iv;
        int cur$iv;
        AtomicInt $this$updateAndGet$iv = this.refCount;
        boolean $i$f$updateAndGet = false;
        do {
            old = cur$iv = $this$updateAndGet$iv.getValue();
            boolean bl = false;
            if (old > 0) continue;
            throw new IllegalStateException("Unable to release: it is already released.");
        } while (!$this$updateAndGet$iv.compareAndSet(cur$iv, upd$iv = old - 1));
        return upd$iv == 0;
    }

    @Override
    public final void reset() {
        if (!(this.origin == null)) {
            boolean bl = false;
            String string = "Unable to reset buffer with origin";
            throw new IllegalArgumentException(string.toString());
        }
        super.reset();
        this.nextRef.setValue(null);
    }

    public /* synthetic */ ChunkBuffer(ByteBuffer memory, ChunkBuffer origin, ObjectPool parentPool, DefaultConstructorMarker $constructor_marker) {
        this(memory, origin, parentPool);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Lio/ktor/utils/io/core/internal/ChunkBuffer$Companion;", "", "()V", "Empty", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "getEmpty", "()Lio/ktor/utils/io/core/internal/ChunkBuffer;", "EmptyPool", "Lio/ktor/utils/io/pool/ObjectPool;", "getEmptyPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "NoPool", "getNoPool$ktor_io", "NoPoolManuallyManaged", "getNoPoolManuallyManaged$ktor_io", "Pool", "getPool", "ktor-io"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getPool() {
            return Pool;
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getEmptyPool() {
            return EmptyPool;
        }

        @NotNull
        public final ChunkBuffer getEmpty() {
            return Empty;
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getNoPool$ktor_io() {
            return NoPool;
        }

        @NotNull
        public final ObjectPool<ChunkBuffer> getNoPoolManuallyManaged$ktor_io() {
            return NoPoolManuallyManaged;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

