/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.internal;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0006H\u0000\u001a\u001e\u0010\n\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\r\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u000f\u001a\u00020\t*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0001H\u0000\u00a8\u0006\u0012"}, d2={"getIOIntProperty", "", "name", "", "default", "indexOfPartial", "Ljava/nio/ByteBuffer;", "sub", "isEmpty", "", "putAtMost", "src", "n", "putLimited", "limit", "startsWith", "prefix", "prefixSkip", "ktor-io"})
public final class UtilsKt {
    public static final boolean isEmpty(@NotNull ByteBuffer $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"$this$isEmpty");
        return !$this$isEmpty.hasRemaining();
    }

    public static final int getIOIntProperty(@NotNull String name, int n) {
        Integer n2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            object = System.getProperty("io.ktor.utils.io." + name);
        }
        catch (SecurityException e) {
            object = null;
        }
        return (n2 = object) != null && (n2 = StringsKt.toIntOrNull(n2)) != null ? n2 : n;
    }

    /*
     * WARNING - void declaration
     */
    public static final int indexOfPartial(@NotNull ByteBuffer $this$indexOfPartial, @NotNull ByteBuffer sub) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOfPartial, (String)"$this$indexOfPartial");
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        int subPosition = sub.position();
        int subSize = sub.remaining();
        byte first = sub.get(subPosition);
        int limit = $this$indexOfPartial.limit();
        int n = $this$indexOfPartial.position();
        int n2 = limit;
        while (n < n2) {
            void idx;
            block4: {
                if ($this$indexOfPartial.get((int)idx) == first) {
                    void j;
                    int n3 = 1;
                    int n4 = subSize;
                    while (n3 < n4 && idx + j != limit) {
                        if ($this$indexOfPartial.get((int)(idx + j)) == sub.get(subPosition + j)) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return (int)(idx - $this$indexOfPartial.position());
                }
            }
            ++idx;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean startsWith(@NotNull ByteBuffer $this$startsWith, @NotNull ByteBuffer prefix, int prefixSkip) {
        Intrinsics.checkNotNullParameter((Object)$this$startsWith, (String)"$this$startsWith");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        int n = $this$startsWith.remaining();
        int n2 = prefix.remaining() - prefixSkip;
        int n3 = 0;
        int size = Math.min(n, n2);
        if (size <= 0) {
            return false;
        }
        int position = $this$startsWith.position();
        int prefixPosition = prefix.position() + prefixSkip;
        n3 = 0;
        int n4 = size;
        while (n3 < n4) {
            void i;
            if ($this$startsWith.get(position + i) != prefix.get(prefixPosition + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static /* synthetic */ boolean startsWith$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return UtilsKt.startsWith(byteBuffer, byteBuffer2, n);
    }

    /*
     * WARNING - void declaration
     */
    public static final int putAtMost(@NotNull ByteBuffer $this$putAtMost, @NotNull ByteBuffer src, int n) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$putAtMost, (String)"$this$putAtMost");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int rem = $this$putAtMost.remaining();
        int srcRem = src.remaining();
        if (srcRem <= rem && srcRem <= n) {
            $this$putAtMost.put(src);
            n2 = srcRem;
        } else {
            int n3 = 0;
            int n4 = 0;
            n4 = Math.min(srcRem, n);
            boolean bl = false;
            n3 = 1;
            int size = Math.min(rem, n4);
            if (n3 <= (n4 = size)) {
                while (true) {
                    void idx;
                    $this$putAtMost.put(src.get());
                    if (idx == n4) break;
                    ++idx;
                }
            }
            n2 = size;
        }
        return n2;
    }

    public static /* synthetic */ int putAtMost$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = byteBuffer2.remaining();
        }
        return UtilsKt.putAtMost(byteBuffer, byteBuffer2, n);
    }

    public static final int putLimited(@NotNull ByteBuffer $this$putLimited, @NotNull ByteBuffer src, int limit) {
        Intrinsics.checkNotNullParameter((Object)$this$putLimited, (String)"$this$putLimited");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return UtilsKt.putAtMost($this$putLimited, src, limit - src.position());
    }

    public static /* synthetic */ int putLimited$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = byteBuffer.limit();
        }
        return UtilsKt.putLimited(byteBuffer, byteBuffer2, n);
    }
}

