/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateBuilder;
import io.ktor.http.CookieDateParser;
import io.ktor.http.CookieUtilsKt;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.http.StringLexer;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u0001H\u0005H\u0002\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lio/ktor/http/CookieDateParser;", "", "()V", "checkFieldNotNull", "", "T", "source", "", "name", "field", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "checkRequirement", "requirement", "", "msg", "Lkotlin/Function0;", "parse", "Lio/ktor/util/date/GMTDate;", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nCookieUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CookieUtils.kt\nio/ktor/http/CookieDateParser\n+ 2 CookieUtils.kt\nio/ktor/http/StringLexer\n*L\n1#1,349:1\n56#2,3:350\n*S KotlinDebug\n*F\n+ 1 CookieUtils.kt\nio/ktor/http/CookieDateParser\n*L\n294#1:350,3\n*E\n"})
public final class CookieDateParser {
    private final <T> void checkFieldNotNull(String source, String name, T field) {
        if (field == null) {
            throw new InvalidCookieDateException(source, "Could not find " + name);
        }
    }

    private final void checkRequirement(String source, boolean requirement, Function0<String> msg) {
        if (!requirement) {
            throw new InvalidCookieDateException(source, (String)msg.invoke());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        StringLexer lexer = new StringLexer(source);
        CookieDateBuilder builder = new CookieDateBuilder();
        lexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)parse.1.INSTANCE));
        while (lexer.getHasRemaining()) {
            String token2;
            if (!lexer.test((Function1<? super Character, Boolean>)((Function1)parse.2.INSTANCE))) continue;
            StringLexer this_$iv = lexer;
            boolean $i$f$capture = false;
            int start$iv = this_$iv.getIndex();
            StringLexer $this$parse_u24lambda_u240 = this_$iv;
            boolean bl = false;
            $this$parse_u24lambda_u240.acceptWhile((Function1<? super Character, Boolean>)((Function1)parse.token.1.1.INSTANCE));
            Intrinsics.checkNotNullExpressionValue((Object)this_$iv.getSource().substring(start$iv, this_$iv.getIndex()), (String)"substring(...)");
            CookieUtilsKt.handleToken(builder, token2);
            lexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)parse.3.INSTANCE));
        }
        Integer n = builder.getYear();
        Object object = new IntRange(70, 99);
        if (n != null && object.contains(n.intValue())) {
            Integer n2 = builder.getYear();
            Intrinsics.checkNotNull((Object)n2);
            builder.setYear(n2 + 1900);
        } else {
            object = new IntRange(0, 69);
            if (n != null && object.contains(n.intValue())) {
                Integer n3 = builder.getYear();
                Intrinsics.checkNotNull((Object)n3);
                builder.setYear(n3 + 2000);
            }
        }
        this.checkFieldNotNull(source, "day-of-month", builder.getDayOfMonth());
        this.checkFieldNotNull(source, "month", builder.getMonth());
        this.checkFieldNotNull(source, "year", builder.getYear());
        this.checkFieldNotNull(source, "time", builder.getHours());
        this.checkFieldNotNull(source, "time", builder.getMinutes());
        this.checkFieldNotNull(source, "time", builder.getSeconds());
        n = new IntRange(1, 31);
        object = builder.getDayOfMonth();
        this.checkRequirement(source, object != null && n.contains((Integer)object), (Function0<String>)((Function0)parse.4.INSTANCE));
        Integer n4 = builder.getYear();
        Intrinsics.checkNotNull((Object)n4);
        this.checkRequirement(source, n4 >= 1601, (Function0<String>)((Function0)parse.5.INSTANCE));
        Integer n5 = builder.getHours();
        Intrinsics.checkNotNull((Object)n5);
        this.checkRequirement(source, n5 <= 23, (Function0<String>)((Function0)parse.6.INSTANCE));
        Integer n6 = builder.getMinutes();
        Intrinsics.checkNotNull((Object)n6);
        this.checkRequirement(source, n6 <= 59, (Function0<String>)((Function0)parse.7.INSTANCE));
        Integer n7 = builder.getSeconds();
        Intrinsics.checkNotNull((Object)n7);
        this.checkRequirement(source, n7 <= 59, (Function0<String>)((Function0)parse.8.INSTANCE));
        return builder.build();
    }
}

