/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a$\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\f\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0007H\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0011"}, d2={"count", "", "urlString", "", "startIndex", "endIndex", "char", "", "findScheme", "fillHost", "", "Lio/ktor/http/URLBuilder;", "indexOfColonInHostPort", "isLetter", "", "takeFrom", "takeFromUnsafe", "ktor-http"})
public final class URLParserKt {
    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkParameterIsNotNull((Object)$this$takeFrom, (String)"$this$takeFrom");
        Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
        try {
            uRLBuilder = URLParserKt.takeFromUnsafe($this$takeFrom, urlString);
        }
        catch (Throwable cause) {
            throw (Throwable)new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final URLBuilder takeFromUnsafe(@NotNull URLBuilder $this$takeFromUnsafe, @NotNull String urlString) {
        String string;
        String string2;
        URLBuilder uRLBuilder;
        int it;
        int n;
        int n22;
        char it22;
        int startIndex;
        int it32;
        block21: {
            int n3;
            int n4;
            block20: {
                Intrinsics.checkParameterIsNotNull((Object)$this$takeFromUnsafe, (String)"$this$takeFromUnsafe");
                Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
                CharSequence $this$indexOfFirst$iv = urlString;
                boolean $i$f$indexOfFirst = false;
                int n5 = 0;
                n4 = $this$indexOfFirst$iv.length();
                while (n5 < n4) {
                    void index$iv;
                    it32 = $this$indexOfFirst$iv.charAt((int)index$iv);
                    boolean bl = false;
                    if (!CharsKt.isWhitespace((char)it32)) {
                        n3 = index$iv;
                        break block20;
                    }
                    ++index$iv;
                }
                n3 = -1;
            }
            startIndex = n3;
            CharSequence $this$indexOfLast$iv = urlString;
            boolean $i$f$indexOfLast = false;
            n4 = $this$indexOfLast$iv.length();
            --n4;
            it32 = 0;
            while (n4 >= 0) {
                void index$iv;
                it22 = $this$indexOfLast$iv.charAt((int)index$iv);
                n22 = 0;
                if (!CharsKt.isWhitespace((char)it22)) {
                    n = index$iv;
                    break block21;
                }
                --index$iv;
            }
            n = -1;
        }
        int endIndex = n + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String index$iv = urlString;
            it32 = startIndex + schemeLength;
            it22 = '\u0000';
            String string3 = index$iv.substring(startIndex, it32);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String scheme = string3;
            $this$takeFromUnsafe.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                String it22;
                Integer it32 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"@/\\?#"), (int)startIndex, (boolean)false, (int)4, null);
                it22 = '\u0000';
                n22 = 0;
                it = ((Number)it32).intValue();
                boolean bl = false;
                Integer n6 = it > 0 ? it32 : null;
                int n7 = delimiter = n6 != null ? n6 : endIndex;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    it22 = urlString;
                    uRLBuilder = $this$takeFromUnsafe;
                    n22 = 0;
                    String string4 = it22.substring(startIndex, passwordIndex);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string4;
                    uRLBuilder.setUser(string2);
                    it22 = urlString;
                    n22 = passwordIndex + 1;
                    uRLBuilder = $this$takeFromUnsafe;
                    it = 0;
                    String string5 = it22.substring(n22, delimiter);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string5;
                    uRLBuilder.setPassword(string2);
                } else {
                    it22 = urlString;
                    uRLBuilder = $this$takeFromUnsafe;
                    n22 = 0;
                    Intrinsics.checkExpressionValueIsNotNull((Object)it22.substring(startIndex, delimiter), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    uRLBuilder.setUser(string2);
                }
                startIndex = delimiter + 1;
            }
            URLParserKt.fillHost($this$takeFromUnsafe, urlString, startIndex, delimiter);
            startIndex = delimiter;
        }
        if (startIndex >= endIndex) {
            $this$takeFromUnsafe.setEncodedPath(urlString.charAt(endIndex - 1) == '/' ? "/" : "");
            return $this$takeFromUnsafe;
        }
        URLBuilder uRLBuilder2 = $this$takeFromUnsafe;
        if (slashCount == 0) {
            int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)$this$takeFromUnsafe.getEncodedPath(), (char)'/', (int)0, (boolean)false, (int)6, null);
            if (lastSlashIndex != $this$takeFromUnsafe.getEncodedPath().length() - 1) {
                if (lastSlashIndex != -1) {
                    String passwordIndex = $this$takeFromUnsafe.getEncodedPath();
                    it22 = '\u0000';
                    n22 = lastSlashIndex + 1;
                    uRLBuilder = uRLBuilder2;
                    it = 0;
                    String string6 = passwordIndex;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(it22, n22);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = string7;
                    uRLBuilder2 = uRLBuilder;
                    string = string2;
                } else {
                    string = "/";
                }
            } else {
                string = $this$takeFromUnsafe.getEncodedPath();
            }
        } else {
            string = "";
        }
        uRLBuilder2.setEncodedPath(string);
        Integer passwordIndex = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"?#"), (int)startIndex, (boolean)false, (int)4, null);
        it22 = '\u0000';
        n22 = 0;
        it = ((Number)passwordIndex).intValue();
        boolean bl = false;
        Integer n8 = it > 0 ? passwordIndex : null;
        int pathEnd = n8 != null ? n8 : endIndex;
        String it22 = urlString;
        n22 = 0;
        String string8 = it22.substring(startIndex, pathEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String rawPath = string8;
        URLBuilder uRLBuilder3 = $this$takeFromUnsafe;
        uRLBuilder3.setEncodedPath(uRLBuilder3.getEncodedPath() + CodecsKt.encodeURLPath(rawPath));
        startIndex = pathEnd;
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            if (startIndex + 1 == endIndex) {
                $this$takeFromUnsafe.setTrailingQuery(true);
                return $this$takeFromUnsafe;
            }
            Integer n22 = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
            boolean bl2 = false;
            int n9 = 0;
            int it4 = ((Number)n22).intValue();
            boolean bl3 = false;
            Integer n10 = it4 > 0 ? n22 : null;
            int fragmentStart = n10 != null ? n10 : endIndex;
            String string9 = urlString;
            n9 = startIndex + 1;
            boolean bl4 = false;
            String string10 = string9.substring(n9, fragmentStart);
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Parameters rawParameters = QueryKt.parseQueryString$default(string10, 0, 0, 6, null);
            rawParameters.forEach((Function2)new Function2<String, List<? extends String>, Unit>($this$takeFromUnsafe){
                final /* synthetic */ URLBuilder $this_takeFromUnsafe;

                public final void invoke(@NotNull String key, @NotNull List<String> values) {
                    Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                    Intrinsics.checkParameterIsNotNull(values, (String)"values");
                    this.$this_takeFromUnsafe.getParameters().appendAll(key, values);
                }
                {
                    this.$this_takeFromUnsafe = uRLBuilder;
                    super(2);
                }
            });
            startIndex = fragmentStart;
        }
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string11 = urlString;
            int n11 = startIndex + 1;
            uRLBuilder = $this$takeFromUnsafe;
            boolean bl5 = false;
            String string12 = string11.substring(n11, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string12;
            uRLBuilder.setFragment(string2);
        }
        return $this$takeFromUnsafe;
    }

    private static final void fillHost(@NotNull URLBuilder $this$fillHost, String urlString, int startIndex, int endIndex) {
        Object object = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int n = 0;
        boolean bl = false;
        int it = ((Number)object).intValue();
        boolean bl2 = false;
        Object object2 = it > 0 ? object : null;
        int colonIndex = object2 != null ? (Integer)object2 : endIndex;
        object = urlString;
        URLBuilder uRLBuilder = $this$fillHost;
        n = 0;
        Object object3 = object;
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object3).substring(startIndex, colonIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string2 = string;
        uRLBuilder.setHost(string2);
        if (colonIndex + 1 < endIndex) {
            object = urlString;
            n = colonIndex + 1;
            uRLBuilder = $this$fillHost;
            bl = false;
            Object object4 = object;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object4).substring(n, endIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string3;
            object = string2;
            n = 0;
            int n2 = Integer.parseInt((String)object);
            uRLBuilder.setPort(n2);
        } else {
            $this$fillHost.setPort(0);
        }
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        for (int current = startIndex; current < endIndex; ++current) {
            char c = urlString.charAt(current);
            if (c == ':') {
                return current;
            }
            if (URLParserKt.isLetter(c)) continue;
            return -1;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result = 0;
        while (startIndex + result < endIndex && urlString.charAt(startIndex + result) == c) {
            ++result;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final int indexOfColonInHostPort(@NotNull String $this$indexOfColonInHostPort, int startIndex, int endIndex) {
        boolean skip = false;
        int n = startIndex;
        int n2 = endIndex;
        while (n < n2) {
            void index;
            switch ($this$indexOfColonInHostPort.charAt((int)index)) {
                case '[': {
                    skip = true;
                    break;
                }
                case ']': {
                    skip = false;
                    break;
                }
                case ':': {
                    if (skip) break;
                    return (int)index;
                }
            }
            ++index;
        }
        return -1;
    }

    private static final boolean isLetter(char $this$isLetter) {
        char c = $this$isLetter;
        char c2 = 'a';
        char c3 = 'z';
        boolean bl = false;
        char c4 = Character.toLowerCase(c);
        char c5 = c4;
        return c2 <= c5 && c3 >= c5;
    }
}

