/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateBuilder;
import io.ktor.http.CookieDateParser;
import io.ktor.http.CookieUtilsKt;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.http.StringLexer;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u0001H\u0005H\u0002\u00a2\u0006\u0002\u0010\nJ&\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lio/ktor/http/CookieDateParser;", "", "()V", "checkFieldNotNull", "", "T", "source", "", "name", "field", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "checkRequirement", "requirement", "", "msg", "Lkotlin/Function0;", "parse", "Lio/ktor/util/date/GMTDate;", "ktor-http"})
public final class CookieDateParser {
    private final <T> void checkFieldNotNull(String source, String name, T field) {
        if (field == null) {
            throw (Throwable)new InvalidCookieDateException(source, "Could not find " + name);
        }
    }

    private final void checkRequirement(String source, boolean requirement, Function0<String> msg) {
        if (!requirement) {
            throw (Throwable)new InvalidCookieDateException(source, (String)msg.invoke());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        StringLexer lexer = new StringLexer(source);
        CookieDateBuilder builder = new CookieDateBuilder();
        lexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)parse.1.INSTANCE));
        while (lexer.getHasRemaining()) {
            String token2;
            if (!lexer.test((Function1<? super Character, Boolean>)((Function1)parse.2.INSTANCE))) continue;
            StringLexer this_$iv = lexer;
            boolean $i$f$capture = false;
            int start$iv = this_$iv.getIndex();
            StringLexer $this$capture = this_$iv;
            boolean bl = false;
            $this$capture.acceptWhile((Function1<? super Character, Boolean>)((Function1)parse.token.1.1.INSTANCE));
            String string = this_$iv.getSource();
            int n = this_$iv.getIndex();
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(start$iv, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            CookieUtilsKt.handleToken(builder, token2);
            lexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)parse.3.INSTANCE));
        }
        Integer n = builder.getYear();
        int n2 = 70;
        Object object = new IntRange(n2, 99);
        boolean bl = false;
        if (n != null && object.contains(n.intValue())) {
            Integer n3 = builder.getYear();
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            builder.setYear(n3 + 1900);
        } else {
            int n4 = 0;
            object = new IntRange(n4, 69);
            bl = false;
            if (n != null && object.contains(n.intValue())) {
                Integer n5 = builder.getYear();
                if (n5 == null) {
                    Intrinsics.throwNpe();
                }
                builder.setYear(n5 + 2000);
            }
        }
        this.checkFieldNotNull(source, "day-of-month", builder.getDayOfMonth());
        this.checkFieldNotNull(source, "month", builder.getMonth());
        this.checkFieldNotNull(source, "year", builder.getYear());
        this.checkFieldNotNull(source, "time", builder.getHours());
        this.checkFieldNotNull(source, "time", builder.getMinutes());
        this.checkFieldNotNull(source, "time", builder.getSeconds());
        int n6 = 1;
        IntRange intRange = new IntRange(n6, 31);
        object = builder.getDayOfMonth();
        String string = source;
        CookieDateParser cookieDateParser = this;
        bl = false;
        boolean bl3 = object != null && intRange.contains(((Integer)object).intValue());
        cookieDateParser.checkRequirement(string, bl3, (Function0<String>)((Function0)parse.4.INSTANCE));
        Integer n7 = builder.getYear();
        if (n7 == null) {
            Intrinsics.throwNpe();
        }
        this.checkRequirement(source, n7 >= 1601, (Function0<String>)((Function0)parse.5.INSTANCE));
        Integer n8 = builder.getHours();
        if (n8 == null) {
            Intrinsics.throwNpe();
        }
        this.checkRequirement(source, n8 <= 23, (Function0<String>)((Function0)parse.6.INSTANCE));
        Integer n9 = builder.getMinutes();
        if (n9 == null) {
            Intrinsics.throwNpe();
        }
        this.checkRequirement(source, n9 <= 59, (Function0<String>)((Function0)parse.7.INSTANCE));
        Integer n10 = builder.getSeconds();
        if (n10 == null) {
            Intrinsics.throwNpe();
        }
        this.checkRequirement(source, n10 <= 59, (Function0<String>)((Function0)parse.8.INSTANCE));
        return builder.build();
    }
}

