/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.FileContentTypeKt;
import io.ktor.http.MimesKt;
import io.ktor.util.CharsetKt;
import io.ktor.util.CollectionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0006\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002\u001a\u0012\u0010\t\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002\u001a\u0010\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003*\u00020\u0004\u001a\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00072\u0006\u0010\r\u001a\u00020\u0002\u001a\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003*\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002\u001a<\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00030\u0001\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u00130\u0012H\u0000\u001a\u0012\u0010\u0014\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0002H\u0000\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"contentTypesByExtensions", "", "", "", "Lio/ktor/http/ContentType;", "extensionsByContentType", "defaultForFileExtension", "Lio/ktor/http/ContentType$Companion;", "extension", "defaultForFilePath", "path", "fileExtensions", "fromFileExtension", "ext", "fromFilePath", "groupByPairs", "A", "B", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "selectDefault", "toContentType", "ktor-http"})
public final class FileContentTypeKt {
    private static final Map<String, List<ContentType>> contentTypesByExtensions;
    private static final Map<ContentType, List<String>> extensionsByContentType;

    @NotNull
    public static final ContentType defaultForFileExtension(@NotNull ContentType.Companion $receiver, @NotNull String extension) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFileExtension(ContentType.Companion, extension));
    }

    @NotNull
    public static final ContentType defaultForFilePath(@NotNull ContentType.Companion $receiver, @NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        return FileContentTypeKt.selectDefault(FileContentTypeKt.fromFilePath(ContentType.Companion, path2));
    }

    @NotNull
    public static final List<ContentType> fromFilePath(@NotNull ContentType.Companion $receiver, @NotNull String path2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        int slashIndex = StringsKt.lastIndexOfAny$default((CharSequence)path2, (char[])CharsetKt.toCharArray((String)"/\\"), (int)0, (boolean)false, (int)6, null);
        int index = StringsKt.indexOf$default((CharSequence)path2, (char)'.', (int)(slashIndex + 1), (boolean)false, (int)4, null);
        if (index == -1) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        String string = path2;
        int n = index + 1;
        ContentType.Companion companion = $receiver;
        String string2 = string.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String string3 = string2;
        return FileContentTypeKt.fromFileExtension(companion, string3);
    }

    @NotNull
    public static final List<ContentType> fromFileExtension(@NotNull ContentType.Companion $receiver, @NotNull String ext) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
        String current = StringsKt.removePrefix((String)ext, (CharSequence)".");
        while ((charSequence = (CharSequence)current).length() > 0) {
            List<ContentType> type = contentTypesByExtensions.get(current);
            if (type != null) {
                return type;
            }
            current = StringsKt.substringAfter((String)current, (String)".", (String)"");
        }
        return kotlin.collections.CollectionsKt.emptyList();
    }

    @NotNull
    public static final List<String> fileExtensions(@NotNull ContentType $receiver) {
        List<String> list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List<String> list2 = extensionsByContentType.get($receiver);
        if (list2 == null) {
            list2 = list = extensionsByContentType.get($receiver.withoutParameters());
        }
        if (list2 == null) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public static final ContentType selectDefault(@NotNull List<ContentType> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        ContentType contentType2 = (ContentType)kotlin.collections.CollectionsKt.firstOrNull($receiver);
        if (contentType2 == null) {
            contentType2 = ContentType.Application.INSTANCE.getOctetStream();
        }
        ContentType contentType3 = contentType2;
        return Intrinsics.areEqual((Object)contentType3.getContentType(), (Object)"text") && ContentTypesKt.charset(contentType3) == null ? ContentTypesKt.withCharset(contentType3, Charsets.UTF_8) : contentType3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <A, B> Map<A, List<B>> groupByPairs(@NotNull Sequence<? extends Pair<? extends A, ? extends B>> $receiver) {
        Object value$iv$iv$iv;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Object $receiver$iv = $receiver;
        Sequence<? extends Pair<? extends A, ? extends B>> sequence = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object key$iv$iv = it.getFirst();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $receiver$iv$iv2;
            void e;
            Iterable $receiver$iv2;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            boolean bl2 = false;
            Iterable $i$f$getOrPut = $receiver$iv2 = (Iterable)e.getValue();
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Object object = it.getSecond();
                collection.add(object);
            }
            List list = (List)destination$iv$iv2;
            map2.put(k2, list);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final ContentType toContentType(@NotNull String $receiver) {
        ContentType contentType2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        try {
            contentType2 = ContentType.Companion.parse($receiver);
        }
        catch (Throwable e) {
            throw (Throwable)new IllegalArgumentException("Failed to parse " + $receiver, e);
        }
        return contentType2;
    }

    static {
        Map map;
        Map $receiver = map = CollectionsKt.caseInsensitiveMap();
        boolean bl = false;
        $receiver.putAll(FileContentTypeKt.groupByPairs(kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes())));
        contentTypesByExtensions = map;
        extensionsByContentType = FileContentTypeKt.groupByPairs(SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)MimesKt.getMimes()), (Function1)extensionsByContentType.1.INSTANCE));
    }
}

