/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.util.DatesJvmKt;
import io.ktor.util.KtorExperimentalAPI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0007\u001a\n\u0010\t\u001a\u00020\b*\u00020\n\u001a\f\u0010\t\u001a\u00020\b*\u00020\u000bH\u0007\"\u001c\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f"}, d2={"httpDateFormat", "Ljava/time/format/DateTimeFormatter;", "httpDateFormat$annotations", "()V", "getHttpDateFormat", "()Ljava/time/format/DateTimeFormatter;", "fromHttpDateString", "Ljava/time/ZonedDateTime;", "", "toHttpDateString", "Ljava/time/temporal/Temporal;", "", "ktor-http-jvm"})
public final class HttpDateKt {
    @NotNull
    private static final DateTimeFormatter httpDateFormat;

    @KtorExperimentalAPI
    @NotNull
    public static final String toHttpDateString(long $receiver) {
        Instant instant = Instant.ofEpochMilli($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(this)");
        return HttpDateKt.toHttpDateString(instant);
    }

    @NotNull
    public static final String toHttpDateString(@NotNull Temporal $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = httpDateFormat.format($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"httpDateFormat.format(this)");
        return string;
    }

    @KtorExperimentalAPI
    @NotNull
    public static final ZonedDateTime fromHttpDateString(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse($receiver, httpDateFormat);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.parse(this, httpDateFormat)");
        return zonedDateTime;
    }

    @KtorExperimentalAPI
    public static /* synthetic */ void httpDateFormat$annotations() {
    }

    @NotNull
    public static final DateTimeFormatter getHttpDateFormat() {
        return httpDateFormat;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z").withLocale(Locale.US).withZone(DatesJvmKt.getGreenwichMeanTime());
        if (dateTimeFormatter == null) {
            Intrinsics.throwNpe();
        }
        httpDateFormat = dateTimeFormatter;
    }
}

