/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaderValueParserKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\b\u001b\u001c\u001d\u001e\u001f !\"B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006#"}, d2={"Lio/ktor/http/ContentType;", "Lio/ktor/http/HeaderValueWithParameters;", "contentType", "", "contentSubtype", "parameters", "", "Lio/ktor/http/HeaderValueParam;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "existingContent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getContentSubtype", "()Ljava/lang/String;", "getContentType", "equals", "", "other", "", "hasParameter", "name", "value", "hashCode", "", "match", "pattern", "withParameter", "withoutParameters", "Application", "Audio", "Companion", "Image", "Message", "MultiPart", "Text", "Video", "ktor-http-jvm"})
public final class ContentType
extends HeaderValueWithParameters {
    @NotNull
    private final String contentType;
    @NotNull
    private final String contentSubtype;
    @NotNull
    private static final ContentType Any;
    public static final Companion Companion;

    @NotNull
    public final ContentType withParameter(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.hasParameter(name, value)) {
            return this;
        }
        return new ContentType(this.contentType, this.contentSubtype, this.getContent(), CollectionsKt.plus((Collection)this.getParameters(), (Object)new HeaderValueParam(name, value)));
    }

    private final boolean hasParameter(String name, String value) {
        boolean bl;
        block0 : switch (this.getParameters().size()) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                HeaderValueParam headerValueParam;
                HeaderValueParam it = headerValueParam = this.getParameters().get(0);
                if (StringsKt.equals((String)it.getName(), (String)name, (boolean)true) && StringsKt.equals((String)it.getValue(), (String)value, (boolean)true)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                Iterable $receiver$iv = this.getParameters();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $receiver$iv) {
                    HeaderValueParam it = (HeaderValueParam)element$iv;
                    if (!(StringsKt.equals((String)it.getName(), (String)name, (boolean)true) && StringsKt.equals((String)it.getValue(), (String)value, (boolean)true))) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final ContentType withoutParameters() {
        return new ContentType(this.contentType, this.contentSubtype, null, 4, null);
    }

    public final boolean match(@NotNull ContentType pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        if (Intrinsics.areEqual((Object)pattern.contentType, (Object)"*") ^ true && !StringsKt.equals((String)pattern.contentType, (String)this.contentType, (boolean)true)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)pattern.contentSubtype, (Object)"*") ^ true && !StringsKt.equals((String)pattern.contentSubtype, (String)this.contentSubtype, (boolean)true)) {
            return false;
        }
        for (HeaderValueParam headerValueParam : pattern.getParameters()) {
            boolean matches;
            boolean bl;
            String patternName = headerValueParam.component1();
            String patternValue = headerValueParam.component2();
            String string = patternName;
            block0 : switch (string.hashCode()) {
                case 42: {
                    if (string.equals("*")) {
                        String string2 = patternValue;
                        switch (string2.hashCode()) {
                            case 42: {
                                if (!string2.equals("*")) break;
                                bl = true;
                                break block0;
                            }
                        }
                        Iterable $receiver$iv = this.getParameters();
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                            break;
                        }
                        for (Object element$iv : $receiver$iv) {
                            HeaderValueParam p = (HeaderValueParam)element$iv;
                            if (!StringsKt.equals((String)p.getValue(), (String)patternValue, (boolean)true)) continue;
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break;
                    }
                }
                default: {
                    String value = this.parameter(patternName);
                    String string3 = patternValue;
                    switch (string3.hashCode()) {
                        case 42: {
                            if (!string3.equals("*")) break;
                            if (value != null) {
                                bl = true;
                                break block0;
                            }
                            bl = false;
                            break block0;
                        }
                    }
                    bl = StringsKt.equals((String)value, (String)patternValue, (boolean)true);
                }
            }
            if (matches = bl) continue;
            return false;
        }
        return true;
    }

    public final boolean match(@NotNull String pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        return this.match(Companion.parse(pattern));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ContentType && StringsKt.equals((String)this.contentType, (String)((ContentType)other).contentType, (boolean)true) && StringsKt.equals((String)this.contentSubtype, (String)((ContentType)other).contentSubtype, (boolean)true) && Intrinsics.areEqual(this.getParameters(), ((ContentType)other).getParameters());
    }

    public int hashCode() {
        String string;
        String string2 = string = this.contentType;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        int result = string3.hashCode();
        string = this.contentSubtype;
        int n = 31 * result;
        int n2 = result;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        String string6 = string5;
        result = n2 + (n + string6.hashCode());
        return result += 31 * ((Object)this.getParameters()).hashCode();
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final String getContentSubtype() {
        return this.contentSubtype;
    }

    private ContentType(String contentType2, String contentSubtype, String existingContent, List<HeaderValueParam> parameters2) {
        super(existingContent, parameters2);
        this.contentType = contentType2;
        this.contentSubtype = contentSubtype;
    }

    /* synthetic */ ContentType(String string, String string2, String string3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list);
    }

    public ContentType(@NotNull String contentType2, @NotNull String contentSubtype, @NotNull List<HeaderValueParam> parameters2) {
        Intrinsics.checkParameterIsNotNull((Object)contentType2, (String)"contentType");
        Intrinsics.checkParameterIsNotNull((Object)contentSubtype, (String)"contentSubtype");
        Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
        this(contentType2, contentSubtype, contentType2 + '/' + contentSubtype, parameters2);
    }

    public /* synthetic */ ContentType(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, list);
    }

    static {
        Companion = new Companion(null);
        Any = new ContentType("*", "*", null, 4, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lio/ktor/http/ContentType$Application;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Atom", "getAtom", "FontWoff", "getFontWoff", "FormUrlEncoded", "getFormUrlEncoded", "GZip", "getGZip", "JavaScript", "getJavaScript", "Json", "getJson", "OctetStream", "getOctetStream", "Rss", "getRss", "Xml", "getXml", "Xml_Dtd", "getXml_Dtd", "Zip", "getZip", "ktor-http-jvm"})
    public static final class Application {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType Atom;
        @NotNull
        private static final ContentType Json;
        @NotNull
        private static final ContentType JavaScript;
        @NotNull
        private static final ContentType OctetStream;
        @NotNull
        private static final ContentType FontWoff;
        @NotNull
        private static final ContentType Rss;
        @NotNull
        private static final ContentType Xml;
        @NotNull
        private static final ContentType Xml_Dtd;
        @NotNull
        private static final ContentType Zip;
        @NotNull
        private static final ContentType GZip;
        @NotNull
        private static final ContentType FormUrlEncoded;
        public static final Application INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getAtom() {
            return Atom;
        }

        @NotNull
        public final ContentType getJson() {
            return Json;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getOctetStream() {
            return OctetStream;
        }

        @NotNull
        public final ContentType getFontWoff() {
            return FontWoff;
        }

        @NotNull
        public final ContentType getRss() {
            return Rss;
        }

        @NotNull
        public final ContentType getXml() {
            return Xml;
        }

        @NotNull
        public final ContentType getXml_Dtd() {
            return Xml_Dtd;
        }

        @NotNull
        public final ContentType getZip() {
            return Zip;
        }

        @NotNull
        public final ContentType getGZip() {
            return GZip;
        }

        @NotNull
        public final ContentType getFormUrlEncoded() {
            return FormUrlEncoded;
        }

        private Application() {
        }

        static {
            Application application;
            INSTANCE = application = new Application();
            Any = new ContentType("application", "*", null, 4, null);
            Atom = new ContentType("application", "atom+xml", null, 4, null);
            Json = new ContentType("application", "json", null, 4, null);
            JavaScript = new ContentType("application", "javascript", null, 4, null);
            OctetStream = new ContentType("application", "octet-stream", null, 4, null);
            FontWoff = new ContentType("application", "font-woff", null, 4, null);
            Rss = new ContentType("application", "rss+xml", null, 4, null);
            Xml = new ContentType("application", "xml", null, 4, null);
            Xml_Dtd = new ContentType("application", "xml-dtd", null, 4, null);
            Zip = new ContentType("application", "zip", null, 4, null);
            GZip = new ContentType("application", "gzip", null, 4, null);
            FormUrlEncoded = new ContentType("application", "x-www-form-urlencoded", null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/ktor/http/ContentType$Audio;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "MP4", "getMP4", "MPEG", "getMPEG", "OGG", "getOGG", "ktor-http-jvm"})
    public static final class Audio {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType MP4;
        @NotNull
        private static final ContentType MPEG;
        @NotNull
        private static final ContentType OGG;
        public static final Audio INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }

        private Audio() {
        }

        static {
            Audio audio;
            INSTANCE = audio = new Audio();
            Any = new ContentType("audio", "*", null, 4, null);
            MP4 = new ContentType("audio", "mp4", null, 4, null);
            MPEG = new ContentType("audio", "mpeg", null, 4, null);
            OGG = new ContentType("audio", "ogg", null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/ContentType$Image;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "GIF", "getGIF", "JPEG", "getJPEG", "PNG", "getPNG", "SVG", "getSVG", "XIcon", "getXIcon", "ktor-http-jvm"})
    public static final class Image {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType GIF;
        @NotNull
        private static final ContentType JPEG;
        @NotNull
        private static final ContentType PNG;
        @NotNull
        private static final ContentType SVG;
        @NotNull
        private static final ContentType XIcon;
        public static final Image INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getGIF() {
            return GIF;
        }

        @NotNull
        public final ContentType getJPEG() {
            return JPEG;
        }

        @NotNull
        public final ContentType getPNG() {
            return PNG;
        }

        @NotNull
        public final ContentType getSVG() {
            return SVG;
        }

        @NotNull
        public final ContentType getXIcon() {
            return XIcon;
        }

        private Image() {
        }

        static {
            Image image;
            INSTANCE = image = new Image();
            Any = new ContentType("image", "*", null, 4, null);
            GIF = new ContentType("image", "gif", null, 4, null);
            JPEG = new ContentType("image", "jpeg", null, 4, null);
            PNG = new ContentType("image", "png", null, 4, null);
            SVG = new ContentType("image", "svg+xml", null, 4, null);
            XIcon = new ContentType("image", "x-icon", null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/ktor/http/ContentType$Message;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Http", "getHttp", "ktor-http-jvm"})
    public static final class Message {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType Http;
        public static final Message INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getHttp() {
            return Http;
        }

        private Message() {
        }

        static {
            Message message;
            INSTANCE = message = new Message();
            Any = new ContentType("message", "*", null, 4, null);
            Http = new ContentType("message", "http", null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/ContentType$MultiPart;", "", "()V", "Alternative", "Lio/ktor/http/ContentType;", "getAlternative", "()Lio/ktor/http/ContentType;", "Any", "getAny", "ByteRanges", "getByteRanges", "Encrypted", "getEncrypted", "FormData", "getFormData", "Mixed", "getMixed", "Related", "getRelated", "Signed", "getSigned", "ktor-http-jvm"})
    public static final class MultiPart {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType Mixed;
        @NotNull
        private static final ContentType Alternative;
        @NotNull
        private static final ContentType Related;
        @NotNull
        private static final ContentType FormData;
        @NotNull
        private static final ContentType Signed;
        @NotNull
        private static final ContentType Encrypted;
        @NotNull
        private static final ContentType ByteRanges;
        public static final MultiPart INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMixed() {
            return Mixed;
        }

        @NotNull
        public final ContentType getAlternative() {
            return Alternative;
        }

        @NotNull
        public final ContentType getRelated() {
            return Related;
        }

        @NotNull
        public final ContentType getFormData() {
            return FormData;
        }

        @NotNull
        public final ContentType getSigned() {
            return Signed;
        }

        @NotNull
        public final ContentType getEncrypted() {
            return Encrypted;
        }

        @NotNull
        public final ContentType getByteRanges() {
            return ByteRanges;
        }

        private MultiPart() {
        }

        static {
            MultiPart multiPart;
            INSTANCE = multiPart = new MultiPart();
            Any = new ContentType("multipart", "*", null, 4, null);
            Mixed = new ContentType("multipart", "mixed", null, 4, null);
            Alternative = new ContentType("multipart", "alternative", null, 4, null);
            Related = new ContentType("multipart", "related", null, 4, null);
            FormData = new ContentType("multipart", "form-data", null, 4, null);
            Signed = new ContentType("multipart", "signed", null, 4, null);
            Encrypted = new ContentType("multipart", "encrypted", null, 4, null);
            ByteRanges = new ContentType("multipart", "byteranges", null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/ContentType$Text;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "CSS", "getCSS", "CSV", "getCSV", "Html", "getHtml", "JavaScript", "getJavaScript", "Plain", "getPlain", "VCard", "getVCard", "Xml", "getXml", "ktor-http-jvm"})
    public static final class Text {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType Plain;
        @NotNull
        private static final ContentType CSS;
        @NotNull
        private static final ContentType CSV;
        @NotNull
        private static final ContentType Html;
        @NotNull
        private static final ContentType JavaScript;
        @NotNull
        private static final ContentType VCard;
        @NotNull
        private static final ContentType Xml;
        public static final Text INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getPlain() {
            return Plain;
        }

        @NotNull
        public final ContentType getCSS() {
            return CSS;
        }

        @NotNull
        public final ContentType getCSV() {
            return CSV;
        }

        @NotNull
        public final ContentType getHtml() {
            return Html;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getVCard() {
            return VCard;
        }

        @NotNull
        public final ContentType getXml() {
            return Xml;
        }

        private Text() {
        }

        static {
            Text text;
            INSTANCE = text = new Text();
            Any = new ContentType("text", "*", null, 4, null);
            Plain = new ContentType("text", "plain", null, 4, null);
            CSS = new ContentType("text", "css", null, 4, null);
            CSV = new ContentType("text", "csv", null, 4, null);
            Html = new ContentType("text", "html", null, 4, null);
            JavaScript = new ContentType("text", "javascript", null, 4, null);
            VCard = new ContentType("text", "vcard", null, 4, null);
            Xml = new ContentType("text", "xml", null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/ktor/http/ContentType$Video;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "MP4", "getMP4", "MPEG", "getMPEG", "OGG", "getOGG", "QuickTime", "getQuickTime", "ktor-http-jvm"})
    public static final class Video {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType MPEG;
        @NotNull
        private static final ContentType MP4;
        @NotNull
        private static final ContentType OGG;
        @NotNull
        private static final ContentType QuickTime;
        public static final Video INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }

        @NotNull
        public final ContentType getQuickTime() {
            return QuickTime;
        }

        private Video() {
        }

        static {
            Video video;
            INSTANCE = video = new Video();
            Any = new ContentType("video", "*", null, 4, null);
            MPEG = new ContentType("video", "mpeg", null, 4, null);
            MP4 = new ContentType("video", "mp4", null, 4, null);
            OGG = new ContentType("video", "ogg", null, 4, null);
            QuickTime = new ContentType("video", "quicktime", null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/ktor/http/ContentType$Companion;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "parse", "value", "", "ktor-http-jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ContentType parse(@NotNull String value) {
            void parameters2;
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            HeaderValueWithParameters.Companion this_$iv = HeaderValueWithParameters.Companion;
            HeaderValue headerValue$iv = (HeaderValue)CollectionsKt.single(HttpHeaderValueParserKt.parseHeaderValue(value));
            List<HeaderValueParam> list = headerValue$iv.getParams();
            String parts = headerValue$iv.getValue();
            int slash = StringsKt.indexOf$default((CharSequence)parts, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (slash == -1) {
                String string;
                String string2 = string = parts;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string2)).toString(), (Object)"*")) {
                    return Companion.getAny();
                }
                throw (Throwable)new BadContentTypeFormatException(value);
            }
            CharSequence charSequence = parts;
            int n = 0;
            String string = charSequence;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string.substring(n, slash);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            charSequence = string3;
            String string4 = charSequence;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String type = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            charSequence = type;
            if (charSequence.length() == 0) {
                throw (Throwable)new BadContentTypeFormatException(value);
            }
            CharSequence charSequence2 = parts;
            int n2 = slash + 1;
            String string5 = charSequence2;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            charSequence2 = string6;
            String string7 = charSequence2;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String subtype = ((Object)StringsKt.trim((CharSequence)string7)).toString();
            charSequence2 = subtype;
            if (charSequence2.length() == 0 || StringsKt.contains$default((CharSequence)subtype, (char)'/', (boolean)false, (int)2, null)) {
                throw (Throwable)new BadContentTypeFormatException(value);
            }
            return new ContentType(type, subtype, (List<HeaderValueParam>)parameters2);
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

