/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ApplicationResponsePropertiesJvmKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpDateKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import io.ktor.util.DatesJvmKt;
import java.nio.file.attribute.FileTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\u0013\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lio/ktor/http/content/LastModifiedVersion;", "Lio/ktor/http/content/Version;", "lastModified", "Ljava/nio/file/attribute/FileTime;", "(Ljava/nio/file/attribute/FileTime;)V", "Ljava/util/Date;", "(Ljava/util/Date;)V", "Ljava/time/ZonedDateTime;", "(Ljava/time/ZonedDateTime;)V", "getLastModified", "()Ljava/time/ZonedDateTime;", "appendHeadersTo", "", "builder", "Lio/ktor/http/HeadersBuilder;", "check", "Lio/ktor/http/content/VersionCheckResult;", "requestHeaders", "Lio/ktor/http/Headers;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ktor-http-jvm"})
public final class LastModifiedVersion
implements Version {
    @NotNull
    private final ZonedDateTime lastModified;

    @Override
    @NotNull
    public VersionCheckResult check(@NotNull Headers requestHeaders) {
        ZonedDateTime ifUnmodifiedSince;
        Intrinsics.checkParameterIsNotNull((Object)requestHeaders, (String)"requestHeaders");
        ZonedDateTime normalized = this.lastModified.withNano(0);
        String string = requestHeaders.get(HttpHeaders.INSTANCE.getIfModifiedSince());
        ZonedDateTime ifModifiedSince = string != null ? HttpDateKt.fromHttpDateString(string) : null;
        String string2 = requestHeaders.get(HttpHeaders.INSTANCE.getIfUnmodifiedSince());
        ZonedDateTime zonedDateTime = ifUnmodifiedSince = string2 != null ? HttpDateKt.fromHttpDateString(string2) : null;
        if (ifModifiedSince != null && normalized.compareTo(ifModifiedSince) <= 0) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        if (ifUnmodifiedSince != null && normalized.compareTo(ifUnmodifiedSince) > 0) {
            return VersionCheckResult.PRECONDITION_FAILED;
        }
        return VersionCheckResult.OK;
    }

    @Override
    public void appendHeadersTo(@NotNull HeadersBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)builder), (String)"builder");
        ZonedDateTime zonedDateTime = this.lastModified.withZoneSameInstant(DatesJvmKt.getGreenwichMeanTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"lastModified.withZoneSam\u2026nstant(GreenwichMeanTime)");
        ApplicationResponsePropertiesJvmKt.lastModified(builder, zonedDateTime);
    }

    @NotNull
    public final ZonedDateTime getLastModified() {
        return this.lastModified;
    }

    public LastModifiedVersion(@NotNull ZonedDateTime lastModified) {
        Intrinsics.checkParameterIsNotNull((Object)lastModified, (String)"lastModified");
        this.lastModified = lastModified;
    }

    public LastModifiedVersion(@NotNull FileTime lastModified) {
        Intrinsics.checkParameterIsNotNull((Object)lastModified, (String)"lastModified");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(lastModified.toInstant(), ZoneId.systemDefault());
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.ofInstant(\u2026, ZoneId.systemDefault())");
        this(zonedDateTime);
    }

    public LastModifiedVersion(@NotNull Date lastModified) {
        Intrinsics.checkParameterIsNotNull((Object)lastModified, (String)"lastModified");
        this(DatesJvmKt.toZonedDateTime((Date)lastModified));
    }

    @NotNull
    public final ZonedDateTime component1() {
        return this.lastModified;
    }

    @NotNull
    public final LastModifiedVersion copy(@NotNull ZonedDateTime lastModified) {
        Intrinsics.checkParameterIsNotNull((Object)lastModified, (String)"lastModified");
        return new LastModifiedVersion(lastModified);
    }

    @NotNull
    public static /* synthetic */ LastModifiedVersion copy$default(LastModifiedVersion lastModifiedVersion, ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            zonedDateTime = lastModifiedVersion.lastModified;
        }
        return lastModifiedVersion.copy(zonedDateTime);
    }

    @NotNull
    public String toString() {
        return "LastModifiedVersion(lastModified=" + this.lastModified + ")";
    }

    public int hashCode() {
        ZonedDateTime zonedDateTime = this.lastModified;
        return zonedDateTime != null ? ((Object)zonedDateTime).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LastModifiedVersion)) break block3;
                LastModifiedVersion lastModifiedVersion = (LastModifiedVersion)object;
                if (!Intrinsics.areEqual((Object)this.lastModified, (Object)lastModifiedVersion.lastModified)) break block3;
            }
            return true;
        }
        return false;
    }
}

