/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\n\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\n\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0007*\u00020\u000b\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"HTTP_DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "getHTTP_DATE_FORMAT", "()Ljava/text/SimpleDateFormat;", "formatHttpDate", "", "date", "Ljava/util/Date;", "parseHttpDate", "expires", "Lio/ktor/http/HttpMessage;", "Lio/ktor/http/HttpMessageBuilder;", "ifModifiedSince", "", "lastModified", "ktor-http-jvm"})
public final class HttpMessagePropertiesJvmKt {
    private static final SimpleDateFormat getHTTP_DATE_FORMAT() {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat $receiver = simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        $receiver.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    private static final Date parseHttpDate(String date) {
        Date date2 = HttpMessagePropertiesJvmKt.getHTTP_DATE_FORMAT().parse(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"HTTP_DATE_FORMAT.parse(date)");
        return date2;
    }

    private static final String formatHttpDate(Date date) {
        String string = HttpMessagePropertiesJvmKt.getHTTP_DATE_FORMAT().format(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HTTP_DATE_FORMAT.format(date)");
        return string;
    }

    public static final void ifModifiedSince(@NotNull HttpMessageBuilder $receiver, @NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getIfModifiedSince(), HttpMessagePropertiesJvmKt.formatHttpDate(date));
    }

    @Nullable
    public static final Date lastModified(@NotNull HttpMessageBuilder $receiver) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
        if (string != null) {
            String string2;
            String it = string2 = string;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date expires(@NotNull HttpMessageBuilder $receiver) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getExpires());
        if (string != null) {
            String string2;
            String it = string2 = string;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date lastModified(@NotNull HttpMessage $receiver) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
        if (string != null) {
            String string2;
            String it = string2 = string;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date expires(@NotNull HttpMessage $receiver) {
        Date date;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getExpires());
        if (string != null) {
            String string2;
            String it = string2 = string;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }
}

