/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.okhttp;

import io.ktor.client.plugins.sse.ClientSSESession;
import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.sse.SSEException;
import io.ktor.sse.ServerSentEvent;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0016J,\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020\"H\u0016J$\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010(\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0015H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/ktor/client/engine/okhttp/OkHttpSSESession;", "Lio/ktor/client/plugins/sse/ClientSSESession;", "Lokhttp3/sse/EventSourceListener;", "engine", "Lokhttp3/OkHttpClient;", "engineRequest", "Lokhttp3/Request;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Lkotlin/coroutines/CoroutineContext;)V", "_incoming", "Lkotlinx/coroutines/channels/Channel;", "Lio/ktor/sse/ServerSentEvent;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "incoming", "Lkotlinx/coroutines/flow/Flow;", "getIncoming", "()Lkotlinx/coroutines/flow/Flow;", "originResponse", "Lkotlinx/coroutines/CompletableDeferred;", "Lokhttp3/Response;", "getOriginResponse$ktor_client_okhttp", "()Lkotlinx/coroutines/CompletableDeferred;", "serverSentEventsSource", "Lokhttp3/sse/EventSource;", "mapException", "Lio/ktor/sse/SSEException;", "response", "onClosed", "", "eventSource", "onEvent", "id", "", "type", "data", "onFailure", "t", "", "onOpen", "ktor-client-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHttpSSESession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpSSESession.kt\nio/ktor/client/engine/okhttp/OkHttpSSESession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class OkHttpSSESession
extends EventSourceListener
implements ClientSSESession {
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final EventSource serverSentEventsSource;
    @NotNull
    private final CompletableDeferred<Response> originResponse;
    @NotNull
    private final Channel<ServerSentEvent> _incoming;

    public OkHttpSSESession(@NotNull OkHttpClient engine, @NotNull Request engineRequest, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        Intrinsics.checkNotNullParameter((Object)engineRequest, (String)"engineRequest");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.coroutineContext = coroutineContext;
        this.serverSentEventsSource = EventSources.createFactory((OkHttpClient)engine).newEventSource(engineRequest, (EventSourceListener)this);
        this.originResponse = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this._incoming = ChannelKt.Channel$default((int)8, null, null, (int)6, null);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final CompletableDeferred<Response> getOriginResponse$ktor_client_okhttp() {
        return this.originResponse;
    }

    @NotNull
    public Flow<ServerSentEvent> getIncoming() {
        return FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this._incoming));
    }

    public void onOpen(@NotNull EventSource eventSource, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.originResponse.complete((Object)response);
    }

    public void onEvent(@NotNull EventSource eventSource, @Nullable String id, @Nullable String type, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ChannelsKt.trySendBlocking((SendChannel)((SendChannel)this._incoming), (Object)new ServerSentEvent(data, type, id, null, null, 24, null));
    }

    /*
     * Unable to fully structure code
     */
    public void onFailure(@NotNull EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        v0 = response;
        v1 = statusCode = v0 != null ? Integer.valueOf(v0.code()) : null;
        if (response == null) ** GOTO lbl-1000
        v2 = statusCode;
        var5_5 = HttpStatusCode.Companion.getOK().getValue();
        if (v2 == null || v2 != var5_5) {
            this.originResponse.complete((Object)response);
        } else lbl-1000:
        // 2 sources

        {
            v3 = t;
            if (v3 != null) {
                it = v3;
                $i$a$-let-OkHttpSSESession$onFailure$error$1 = false;
                v4 = new SSEException(it);
            } else {
                v4 = this.mapException(response);
            }
            error = v4;
            this.originResponse.completeExceptionally((Throwable)error);
        }
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this._incoming), null, (int)1, null);
        this.serverSentEventsSource.cancel();
    }

    public void onClosed(@NotNull EventSource eventSource) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this._incoming), null, (int)1, null);
        this.serverSentEventsSource.cancel();
    }

    private final SSEException mapException(Response response) {
        return response != null && response.code() != HttpStatusCode.Companion.getOK().getValue() ? new SSEException("Expected status code " + HttpStatusCode.Companion.getOK().getValue() + " but was: " + response.code()) : (response != null && !Intrinsics.areEqual((Object)response.headers().get(HttpHeaders.INSTANCE.getContentType()), (Object)ContentType.Text.INSTANCE.getEventStream().toString()) ? new SSEException("Content type must be " + ContentType.Text.INSTANCE.getEventStream() + " but was: " + response.headers().get(HttpHeaders.INSTANCE.getContentType())) : new SSEException("Unexpected error occurred"));
    }
}

