/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.cio;

import io.ktor.client.call.HttpClientCall;
import io.ktor.client.request.HttpRequest;
import io.ktor.client.response.HttpResponse;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.cio.CIOHeaders;
import io.ktor.http.cio.Response;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.io.ByteReadChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lio/ktor/client/engine/cio/CIOHttpResponse;", "Lio/ktor/client/response/HttpResponse;", "request", "Lio/ktor/client/request/HttpRequest;", "requestTime", "Lio/ktor/util/date/GMTDate;", "content", "Lkotlinx/coroutines/io/ByteReadChannel;", "response", "Lio/ktor/http/cio/Response;", "pipelined", "", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/ktor/client/request/HttpRequest;Lio/ktor/util/date/GMTDate;Lkotlinx/coroutines/io/ByteReadChannel;Lio/ktor/http/cio/Response;ZLkotlin/coroutines/CoroutineContext;)V", "call", "Lio/ktor/client/call/HttpClientCall;", "getCall", "()Lio/ktor/client/call/HttpClientCall;", "getContent", "()Lkotlinx/coroutines/io/ByteReadChannel;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "getRequestTime", "()Lio/ktor/util/date/GMTDate;", "responseTime", "getResponseTime", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "version", "Lio/ktor/http/HttpProtocolVersion;", "getVersion", "()Lio/ktor/http/HttpProtocolVersion;", "close", "", "ktor-client-cio"})
public final class CIOHttpResponse
implements HttpResponse {
    @NotNull
    private final HttpClientCall call;
    @NotNull
    private final HttpStatusCode status;
    @NotNull
    private final HttpProtocolVersion version;
    @NotNull
    private final Headers headers;
    @NotNull
    private final GMTDate responseTime;
    @NotNull
    private final GMTDate requestTime;
    @NotNull
    private final ByteReadChannel content;
    private final Response response;
    private final boolean pipelined;
    @NotNull
    private final CoroutineContext coroutineContext;

    @NotNull
    public HttpClientCall getCall() {
        return this.call;
    }

    @NotNull
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @NotNull
    public HttpProtocolVersion getVersion() {
        return this.version;
    }

    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public GMTDate getResponseTime() {
        return this.responseTime;
    }

    public void close() {
        HttpResponse.DefaultImpls.close((HttpResponse)this);
        if (this.pipelined) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(this, null){
                private CoroutineScope p$;
                long J$0;
                int label;
                final /* synthetic */ CIOHttpResponse this$0;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            long length;
                            Object object2 = result;
                            if (object2 instanceof Result.Failure) {
                                throw ((Result.Failure)object2).exception;
                            }
                            CoroutineScope coroutineScope = this.p$;
                            String string = this.this$0.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            String string2 = string;
                            this.J$0 = length = Long.parseLong(string2);
                            this.label = 1;
                            Object object3 = this.this$0.getContent().discard(length - this.this$0.getContent().getTotalBytesRead(), (Continuation)this);
                            if (object3 != object) return object3;
                            return object;
                        }
                        case 1: {
                            long length = this.J$0;
                            Object object4 = result;
                            if (object4 instanceof Result.Failure) {
                                throw ((Result.Failure)object4).exception;
                            }
                            Object object3 = result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = cIOHttpResponse;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Long>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        this.response.release();
    }

    @NotNull
    public GMTDate getRequestTime() {
        return this.requestTime;
    }

    @NotNull
    public ByteReadChannel getContent() {
        return this.content;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public CIOHttpResponse(@NotNull HttpRequest request, @NotNull GMTDate requestTime, @NotNull ByteReadChannel content, @NotNull Response response, boolean pipelined, @NotNull CoroutineContext coroutineContext) {
        Headers headers;
        HeadersBuilder headersBuilder;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)requestTime, (String)"requestTime");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)coroutineContext, (String)"coroutineContext");
        this.requestTime = requestTime;
        this.content = content;
        this.response = response;
        this.pipelined = pipelined;
        this.coroutineContext = coroutineContext;
        this.call = request.getCall();
        this.status = new HttpStatusCode(this.response.getStatus(), ((Object)this.response.getStatusText()).toString());
        this.version = HttpProtocolVersion.Companion.getHTTP_1_1();
        Headers.Companion companion = Headers.Companion;
        CIOHttpResponse cIOHttpResponse = this;
        HeadersBuilder $receiver = headersBuilder = new HeadersBuilder(0, 1, null);
        CIOHeaders origin = new CIOHeaders(this.response.getHeaders());
        Iterable $receiver$iv = origin.names();
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            $receiver.appendAll(it, (Iterable)origin.getAll(it));
        }
        cIOHttpResponse.headers = headers = headersBuilder.build();
        this.responseTime = DateJvmKt.GMTDate$default(null, (int)1, null);
    }

    @NotNull
    public Job getExecutionContext() {
        return HttpResponse.DefaultImpls.getExecutionContext((HttpResponse)this);
    }
}

