/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.apache;

import io.ktor.client.engine.apache.InterestControllerHolder;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\tj\u0002`\nH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/client/engine/apache/ReactorLoopDispatcher;", "Lkotlinx/coroutines/CoroutineDispatcher;", "interestController", "Lio/ktor/client/engine/apache/InterestControllerHolder;", "queueSize", "", "(Lio/ktor/client/engine/apache/InterestControllerHolder;I)V", "queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "dispatch", "", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "hasTasks", "", "processLoop", "ktor-client-apache"})
public final class ReactorLoopDispatcher
extends CoroutineDispatcher {
    private final ArrayBlockingQueue<Runnable> queue;
    private final InterestControllerHolder interestController;
    private final int queueSize;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Job job = (Job)context.get((CoroutineContext.Key)Job.Key);
        if (job != null) {
            if (job.isCancelled()) {
                block.run();
                return;
            }
        }
        boolean bl = this.queue.add(block);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Dispatcher queue of size " + this.queueSize + " is full: " + this.queue;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.interestController.resumeInputIfPossible();
    }

    public final void processLoop() {
        while (true) {
            Runnable runnable = this.queue.poll();
            if (runnable == null) break;
            runnable.run();
        }
    }

    public final boolean hasTasks() {
        Collection collection = this.queue;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public ReactorLoopDispatcher(@NotNull InterestControllerHolder interestController, int queueSize) {
        Intrinsics.checkNotNullParameter((Object)interestController, (String)"interestController");
        this.interestController = interestController;
        this.queueSize = queueSize;
        this.queue = new ArrayBlockingQueue(this.queueSize);
    }
}

