/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.auth;

import io.ktor.auth.SimpleAuthKt;
import io.ktor.auth.UserIdPrincipal;
import io.ktor.auth.UserPasswordCredential;
import io.ktor.config.ApplicationConfig;
import io.ktor.util.CryptoKt;
import java.security.MessageDigest;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0017\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB-\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lio/ktor/auth/UserHashedTableAuth;", "", "table", "", "", "", "(Ljava/util/Map;)V", "config", "Lio/ktor/config/ApplicationConfig;", "(Lio/ktor/config/ApplicationConfig;)V", "digester", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Ljava/util/Map;)V", "getDigester", "()Lkotlin/jvm/functions/Function1;", "getTable", "()Ljava/util/Map;", "authenticate", "Lio/ktor/auth/UserIdPrincipal;", "credential", "Lio/ktor/auth/UserPasswordCredential;", "ktor-auth"})
public final class UserHashedTableAuth {
    @NotNull
    private final Function1<String, byte[]> digester;
    @NotNull
    private final Map<String, byte[]> table;

    public UserHashedTableAuth(@NotNull Function1<? super String, byte[]> digester, @NotNull Map<String, byte[]> table) {
        Intrinsics.checkNotNullParameter(digester, (String)"digester");
        Intrinsics.checkNotNullParameter(table, (String)"table");
        this.digester = digester;
        this.table = table;
        if (this.table.isEmpty()) {
            // empty if block
        }
    }

    @NotNull
    public final Function1<String, byte[]> getDigester() {
        return this.digester;
    }

    @NotNull
    public final Map<String, byte[]> getTable() {
        return this.table;
    }

    @Deprecated(message="Configure digest function explicitly.", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ UserHashedTableAuth(Map table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this((Function1<? super String, byte[]>)CryptoKt.getDigestFunction((String)"SHA-256", (Function1)1.INSTANCE), table);
    }

    @Deprecated(message="Configuring from an application config is no longer supported.", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ UserHashedTableAuth(ApplicationConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this((Function1<? super String, byte[]>)CryptoKt.getDigestFunction((String)config.property("hashAlgorithm").getString(), (String)config.property("salt").getString()), SimpleAuthKt.parseUsers$default(config, null, 1, null));
    }

    @Nullable
    public final UserIdPrincipal authenticate(@NotNull UserPasswordCredential credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        byte[] userPasswordHash = this.table.get(credential.getName());
        if (userPasswordHash != null && MessageDigest.isEqual((byte[])this.digester.invoke((Object)credential.getPassword()), userPasswordHash)) {
            return new UserIdPrincipal(credential.getName());
        }
        return null;
    }
}

