/*
 * Decompiled with CFR 0.152.
 */
package io.kstuff.text;

import io.jstuff.util.IntOutput;
import io.kstuff.text.CharMapResult;
import io.kstuff.text.MapResult;
import io.kstuff.text.StringMapper;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0007J\n\u0010\f\u001a\u00020\u0007*\u00020\u0007J\n\u0010\r\u001a\u00020\u000e*\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0014\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003\u00a8\u0006\u0010"}, d2={"Lio/kstuff/text/URIStringMapper;", "", "<init>", "()V", "spaceResult", "Lio/kstuff/text/CharMapResult;", "illegalMessage", "", "getIllegalMessage$annotations", "incompleteMessage", "getIncompleteMessage$annotations", "encodeURI", "decodeURI", "isUnreservedForURI", "", "", "string-mapper"})
public final class URIStringMapper {
    @NotNull
    public static final URIStringMapper INSTANCE = new URIStringMapper();
    @NotNull
    private static final CharMapResult spaceResult = new CharMapResult(1, ' ');
    @NotNull
    private static final String illegalMessage = "Illegal URI escape sequence";
    @NotNull
    private static final String incompleteMessage = "Incomplete URI escape sequence";

    private URIStringMapper() {
    }

    private static /* synthetic */ void getIllegalMessage$annotations() {
    }

    private static /* synthetic */ void getIncompleteMessage$annotations() {
    }

    @NotNull
    public final String encodeURI(@NotNull String $this$encodeURI) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeURI, (String)"<this>");
        return StringMapper.INSTANCE.mapCharacters($this$encodeURI, (Function1<? super Character, ? extends CharSequence>)((Function1)URIStringMapper::encodeURI$lambda$1));
    }

    @NotNull
    public final String decodeURI(@NotNull String $this$decodeURI) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeURI, (String)"<this>");
        return StringMapper.INSTANCE.mapSubstrings($this$decodeURI, (Function1<? super Integer, ? extends MapResult>)((Function1)arg_0 -> URIStringMapper.decodeURI$lambda$3($this$decodeURI, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isUnreservedForURI(char $this$isUnreservedForURI) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if ('A' <= $this$isUnreservedForURI) {
            if ($this$isUnreservedForURI < '[') {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        if ('a' <= $this$isUnreservedForURI) {
            if ($this$isUnreservedForURI < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('0' <= $this$isUnreservedForURI) {
            if ($this$isUnreservedForURI < ':') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ($this$isUnreservedForURI == '-') return true;
        if ($this$isUnreservedForURI == '.') return true;
        if ($this$isUnreservedForURI == '_') return true;
        if ($this$isUnreservedForURI != '~') return false;
        return true;
    }

    private static final CharSequence encodeURI$lambda$1(char it) {
        CharSequence charSequence;
        if (INSTANCE.isUnreservedForURI(it) || it == '$') {
            charSequence = null;
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$encodeURI_u24lambda_u241_u24lambda_u240 = stringBuilder = new StringBuilder(3);
            boolean bl = false;
            $this$encodeURI_u24lambda_u241_u24lambda_u240.append('%');
            IntOutput.append2Hex((Appendable)$this$encodeURI_u24lambda_u241_u24lambda_u240, (int)it);
            charSequence = stringBuilder;
        }
        return charSequence;
    }

    private static final int decodeURI$lambda$3$lambda$2(String $this_decodeURI, int $it) {
        int n;
        try {
            n = StringMapper.INSTANCE.fromHexDigit($this_decodeURI.charAt($it + 1)) << 4 | StringMapper.INSTANCE.fromHexDigit($this_decodeURI.charAt($it + 2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(illegalMessage);
        }
        return n;
    }

    private static final MapResult decodeURI$lambda$3(String $this_decodeURI, int it) {
        MapResult mapResult;
        switch ($this_decodeURI.charAt(it)) {
            case '%': {
                mapResult = StringMapper.INSTANCE.buildResult($this_decodeURI, it, 3, incompleteMessage, (Function0<Integer>)((Function0)() -> URIStringMapper.decodeURI$lambda$3$lambda$2($this_decodeURI, it)));
                break;
            }
            case '+': {
                mapResult = spaceResult;
                break;
            }
            default: {
                mapResult = null;
            }
        }
        return mapResult;
    }
}

