/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.signers;

import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Signature;
import io.ethers.core.types.transaction.ChainId;
import io.ethers.core.types.transaction.TransactionSigned;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.core.types.transaction.TxType;
import io.ethers.crypto.Hashing;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\u001aJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\tH&J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00a6\u0002J\b\u0010\u0018\u001a\u00020\u0019H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lio/ethers/signers/Signer;", "", "address", "Lio/ethers/core/types/Address;", "getAddress", "()Lio/ethers/core/types/Address;", "signMessage", "Lio/ethers/core/types/Signature;", "message", "", "signTransaction", "Lio/ethers/core/types/transaction/TransactionSigned;", "tx", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "signHash", "hash", "trySignMessage", "Lio/ethers/core/Result;", "Lio/ethers/signers/Signer$SigningError;", "trySignTransaction", "trySignHash", "equals", "", "other", "hashCode", "", "SigningError", "ethers-signers"})
public interface Signer {
    @NotNull
    public Address getAddress();

    @NotNull
    default public Signature signMessage(@NotNull byte[] message) {
        Signature sig = this.signHash(Hashing.hashMessage((byte[])message));
        sig.updateV(sig.recoveryId() + 27L);
        return sig;
    }

    @NotNull
    default public TransactionSigned signTransaction(@NotNull TransactionUnsigned tx) {
        Signature sig = this.signHash(tx.signatureHash());
        if (Intrinsics.areEqual((Object)tx.getType(), (Object)TxType.Legacy.INSTANCE)) {
            if (ChainId.isValid((long)tx.getChainId())) {
                sig.updateV(tx.getChainId() * (long)2 + 35L + sig.recoveryId());
            } else {
                sig.updateV(sig.recoveryId() + 27L);
            }
        }
        return new TransactionSigned(tx, sig, null, this.getAddress(), 4, null);
    }

    @NotNull
    public Signature signHash(@NotNull byte[] var1);

    @NotNull
    default public Result<Signature, SigningError> trySignMessage(@NotNull byte[] message) {
        Result result;
        try {
            result = ResultKt.success((Object)this.signMessage(message));
        }
        catch (Exception e) {
            result = ResultKt.failure((Result.Error)new SigningError("Error signing message: " + new String(message, Charsets.UTF_8), e));
        }
        return result;
    }

    @NotNull
    default public Result<TransactionSigned, SigningError> trySignTransaction(@NotNull TransactionUnsigned tx) {
        Result result;
        try {
            result = ResultKt.success((Object)this.signTransaction(tx));
        }
        catch (Exception e) {
            result = ResultKt.failure((Result.Error)new SigningError("Error signing transaction: " + tx, e));
        }
        return result;
    }

    @NotNull
    default public Result<Signature, SigningError> trySignHash(@NotNull byte[] hash) {
        Result result;
        try {
            result = ResultKt.success((Object)this.signHash(hash));
        }
        catch (Exception e) {
            result = ResultKt.failure((Result.Error)new SigningError("Error signing hash: " + new Hash(hash), e));
        }
        return result;
    }

    public boolean equals(@Nullable Object var1);

    public int hashCode();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u0010\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006H\u00c6\u0003J%\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lio/ethers/signers/Signer$SigningError;", "Lio/ethers/core/Result$Error;", "msg", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Ljava/lang/String;Ljava/lang/Exception;)V", "getMsg", "()Ljava/lang/String;", "getCause", "()Ljava/lang/Exception;", "doThrow", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "ethers-signers"})
    public static final class SigningError
    implements Result.Error {
        @NotNull
        private final String msg;
        @Nullable
        private final Exception cause;

        public SigningError(@NotNull String msg, @Nullable Exception cause) {
            this.msg = msg;
            this.cause = cause;
        }

        public /* synthetic */ SigningError(String string, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                exception = null;
            }
            this(string, exception);
        }

        @NotNull
        public final String getMsg() {
            return this.msg;
        }

        @Nullable
        public final Exception getCause() {
            return this.cause;
        }

        @NotNull
        public Void doThrow() {
            throw new RuntimeException(this.msg, this.cause);
        }

        @NotNull
        public final String component1() {
            return this.msg;
        }

        @Nullable
        public final Exception component2() {
            return this.cause;
        }

        @NotNull
        public final SigningError copy(@NotNull String msg, @Nullable Exception cause) {
            return new SigningError(msg, cause);
        }

        public static /* synthetic */ SigningError copy$default(SigningError signingError, String string, Exception exception, int n, Object object) {
            if ((n & 1) != 0) {
                string = signingError.msg;
            }
            if ((n & 2) != 0) {
                exception = signingError.cause;
            }
            return signingError.copy(string, exception);
        }

        @NotNull
        public String toString() {
            return "SigningError(msg=" + this.msg + ", cause=" + this.cause + ")";
        }

        public int hashCode() {
            int result = this.msg.hashCode();
            result = result * 31 + (this.cause == null ? 0 : this.cause.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SigningError)) {
                return false;
            }
            SigningError signingError = (SigningError)other;
            if (!Intrinsics.areEqual((Object)this.msg, (Object)signingError.msg)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cause, (Object)signingError.cause);
        }
    }
}

