/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.signers;

import io.ethers.crypto.bip32.ExtendedSigningKey;
import io.ethers.crypto.bip32.HDPath;
import io.ethers.crypto.bip39.MnemonicCode;
import io.ethers.signers.PrivateKeySigner;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nB+\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/ethers/signers/MnemonicKeySource;", "", "mnemonic", "Lio/ethers/crypto/bip39/MnemonicCode;", "passphrase", "", "path", "Lio/ethers/crypto/bip32/HDPath;", "<init>", "(Lio/ethers/crypto/bip39/MnemonicCode;Ljava/lang/String;Lio/ethers/crypto/bip32/HDPath;)V", "(Ljava/lang/String;Ljava/lang/String;Lio/ethers/crypto/bip32/HDPath;)V", "", "(Ljava/util/List;Ljava/lang/String;Lio/ethers/crypto/bip32/HDPath;)V", "getPath", "()Lio/ethers/crypto/bip32/HDPath;", "parentKey", "Lio/ethers/crypto/bip32/ExtendedSigningKey;", "getAccount", "Lio/ethers/signers/PrivateKeySigner;", "index", "", "equals", "", "other", "hashCode", "ethers-signers"})
public final class MnemonicKeySource {
    @NotNull
    private final HDPath path;
    @NotNull
    private final ExtendedSigningKey parentKey;

    @JvmOverloads
    public MnemonicKeySource(@NotNull MnemonicCode mnemonic, @NotNull String passphrase, @NotNull HDPath path) {
        this.path = path;
        this.parentKey = ExtendedSigningKey.Companion.fromSeed(mnemonic.getSeed(passphrase)).derivePath(this.path);
    }

    public /* synthetic */ MnemonicKeySource(MnemonicCode mnemonicCode, String string, HDPath hDPath, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            hDPath = HDPath.Companion.getETHEREUM();
        }
        this(mnemonicCode, string, hDPath);
    }

    @NotNull
    public final HDPath getPath() {
        return this.path;
    }

    @JvmOverloads
    public MnemonicKeySource(@NotNull String mnemonic, @NotNull String passphrase, @NotNull HDPath path) {
        this(new MnemonicCode(mnemonic, null, 2, null), passphrase, path);
    }

    public /* synthetic */ MnemonicKeySource(String string, String string2, HDPath hDPath, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            hDPath = HDPath.Companion.getETHEREUM();
        }
        this(string, string2, hDPath);
    }

    @JvmOverloads
    public MnemonicKeySource(@NotNull List<String> mnemonic, @NotNull String passphrase, @NotNull HDPath path) {
        this(new MnemonicCode(mnemonic, null, 2, null), passphrase, path);
    }

    public /* synthetic */ MnemonicKeySource(List list, String string, HDPath hDPath, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            hDPath = HDPath.Companion.getETHEREUM();
        }
        this(list, string, hDPath);
    }

    @NotNull
    public final PrivateKeySigner getAccount(int index) {
        return new PrivateKeySigner(this.parentKey.deriveChild(index).getSigningKey());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.signers.MnemonicKeySource");
        MnemonicKeySource cfr_ignored_0 = (MnemonicKeySource)other;
        return Intrinsics.areEqual((Object)this.parentKey, (Object)((MnemonicKeySource)other).parentKey);
    }

    public int hashCode() {
        return this.parentKey.hashCode();
    }

    @JvmOverloads
    public MnemonicKeySource(@NotNull MnemonicCode mnemonic, @NotNull String passphrase) {
        this(mnemonic, passphrase, null, 4, null);
    }

    @JvmOverloads
    public MnemonicKeySource(@NotNull MnemonicCode mnemonic) {
        this(mnemonic, null, null, 6, null);
    }

    @JvmOverloads
    public MnemonicKeySource(@NotNull String mnemonic, @NotNull String passphrase) {
        this(mnemonic, passphrase, null, 4, null);
    }

    @JvmOverloads
    public MnemonicKeySource(@NotNull String mnemonic) {
        this(mnemonic, null, null, 6, null);
    }

    @JvmOverloads
    public MnemonicKeySource(@NotNull List<String> mnemonic, @NotNull String passphrase) {
        this(mnemonic, passphrase, null, 4, null);
    }

    @JvmOverloads
    public MnemonicKeySource(@NotNull List<String> mnemonic) {
        this(mnemonic, null, null, 6, null);
    }
}

