/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.rlp;

import io.ethers.rlp.RlpEncodable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0001)B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0017\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u0000\"\b\b\u0000\u0010\u0013*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016J\u001a\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J,\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0017\u001a\u00020\t2\u0017\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0002\b\u001cH\u0086\bJ\u0012\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\tH\u0007J\u001a\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\tH\u0007J\u001f\u0010 \u001a\u00020\u0000\"\b\b\u0000\u0010\u0013*\u00020\u00142\b\u0010!\u001a\u0004\u0018\u0001H\u0013\u00a2\u0006\u0002\u0010\"J\u0010\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010#J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020$J\u0010\u0010 \u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u0003J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010'\u001a\u00020\f*\u00020\f2\u0006\u0010(\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/ethers/rlp/RlpEncoder;", "", "array", "", "isExactSize", "", "<init>", "([BZ)V", "size", "", "(IZ)V", "buffer", "Ljava/nio/ByteBuffer;", "startedListCount", "toByteArray", "appendRaw", "byte", "", "encodeList", "T", "Lio/ethers/rlp/RlpEncodable;", "list", "", "bodySize", "action", "Ljava/lang/Runnable;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "startList", "finishList", "bufferStartPosition", "encode", "value", "(Lio/ethers/rlp/RlpEncodable;)Lio/ethers/rlp/RlpEncoder;", "Ljava/math/BigInteger;", "", "encodeSize", "lengthOfSize", "ensureCapacity", "sizeIncrement", "Companion", "ethers-rlp"})
@SourceDebugExtension(value={"SMAP\nRlpEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,437:1\n71#1,5:438\n71#1,5:443\n1694#2,6:448\n*S KotlinDebug\n*F\n+ 1 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n*L\n50#1:438,5\n62#1:443,5\n157#1:448,6\n*E\n"})
public final class RlpEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isExactSize;
    @NotNull
    private ByteBuffer buffer;
    private int startedListCount;
    private static final double BUFFER_GROWTH_FACTOR = 1.5;
    private static final BigInteger RLP_STRING_SHORT_BIGINT = BigInteger.valueOf(128L);

    @JvmOverloads
    public RlpEncoder(@NotNull byte[] array, boolean isExactSize) {
        this.isExactSize = isExactSize;
        this.buffer = ByteBuffer.wrap(array);
    }

    public /* synthetic */ RlpEncoder(byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(byArray, bl);
    }

    @JvmOverloads
    public RlpEncoder(int size, boolean isExactSize) {
        this(new byte[size], isExactSize);
    }

    public /* synthetic */ RlpEncoder(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 512;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    @NotNull
    public final byte[] toByteArray() {
        if (this.startedListCount != 0) {
            throw new IllegalStateException("Not all list encodings were finished. Need to close " + this.startedListCount + " more.");
        }
        if (this.isExactSize || this.buffer.position() == this.buffer.capacity()) {
            if (this.buffer.position() != this.buffer.capacity()) {
                throw new IllegalStateException("Incorrectly sized RLP Encoder: got size " + this.buffer.position() + ", expected " + this.buffer.capacity());
            }
            return this.buffer.array();
        }
        return ArraysKt.copyOfRange((byte[])this.buffer.array(), (int)0, (int)this.buffer.position());
    }

    @NotNull
    public final RlpEncoder appendRaw(byte by) {
        this.ensureCapacity(this.buffer, 1).put(by);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends RlpEncodable> RlpEncoder encodeList(@NotNull List<? extends T> list) {
        void this_$iv;
        RlpEncoder rlpEncoder = this;
        int bodySize$iv = Companion.sizeOfListBody(list);
        boolean $i$f$encodeList = false;
        int bufferStartPosition$iv = this_$iv.startList(bodySize$iv);
        RlpEncoder $this$encodeList_u24lambda_u240 = (RlpEncoder)this_$iv;
        boolean bl = false;
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            ((RlpEncodable)list.get(i)).rlpEncode($this$encodeList_u24lambda_u240);
        }
        this_$iv.finishList(bufferStartPosition$iv, bodySize$iv);
        return rlpEncoder;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final RlpEncoder encodeList(int bodySize, @NotNull Runnable action) {
        void var3_3;
        RlpEncoder this_$iv = this;
        boolean $i$f$encodeList = false;
        int bufferStartPosition$iv = this_$iv.startList(bodySize);
        RlpEncoder $this$encodeList_u24lambda_u241 = this_$iv;
        boolean bl = false;
        action.run();
        this_$iv.finishList(bufferStartPosition$iv, bodySize);
        return var3_3;
    }

    public static /* synthetic */ RlpEncoder encodeList$default(RlpEncoder rlpEncoder, int n, Runnable runnable, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return rlpEncoder.encodeList(n, runnable);
    }

    @NotNull
    public final RlpEncoder encodeList(int bodySize, @NotNull Function1<? super RlpEncoder, Unit> action) {
        boolean $i$f$encodeList = false;
        int bufferStartPosition = this.startList(bodySize);
        action.invoke((Object)this);
        this.finishList(bufferStartPosition, bodySize);
        return this;
    }

    public static /* synthetic */ RlpEncoder encodeList$default(RlpEncoder $this, int bodySize, Function1 action, int n, Object object) {
        if ((n & 1) != 0) {
            bodySize = -1;
        }
        boolean $i$f$encodeList = false;
        int bufferStartPosition = $this.startList(bodySize);
        action.invoke((Object)$this);
        $this.finishList(bufferStartPosition, bodySize);
        return $this;
    }

    @JvmOverloads
    public final int startList(int bodySize) {
        int bufferStartPosition = this.buffer.position();
        if (bodySize > 55) {
            int lengthOfSize = Companion.lengthOfSizeInBytes(bodySize);
            this.ensureCapacity(this.buffer, 1 + lengthOfSize + bodySize);
            this.buffer.put((byte)(247 + lengthOfSize));
            this.encodeSize(lengthOfSize, bodySize);
        } else {
            this.ensureCapacity(this.buffer, 1).put((byte)-64);
        }
        int n = this.startedListCount;
        this.startedListCount = n + 1;
        return bufferStartPosition;
    }

    public static /* synthetic */ int startList$default(RlpEncoder rlpEncoder, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        return rlpEncoder.startList(n);
    }

    @JvmOverloads
    public final void finishList(int bufferStartPosition, int bodySize) {
        int bufferEndPosition = this.buffer.position();
        int size = bufferEndPosition - bufferStartPosition - 1;
        if (size != 0) {
            if (size <= 55) {
                this.buffer.put(bufferStartPosition, (byte)(192 + size));
            } else if (bodySize <= 0) {
                int lengthOfSize = Companion.lengthOfSizeInBytes(size);
                this.buffer.put(bufferStartPosition, (byte)(247 + lengthOfSize));
                int startIndex = bufferStartPosition + 1;
                this.ensureCapacity(this.buffer, lengthOfSize);
                ArraysKt.copyInto((byte[])this.buffer.array(), (byte[])this.buffer.array(), (int)(startIndex + lengthOfSize), (int)startIndex, (int)bufferEndPosition);
                this.buffer.position(startIndex);
                this.encodeSize(lengthOfSize, size);
                this.buffer.position(bufferEndPosition + lengthOfSize);
            }
        }
        int n = this.startedListCount;
        this.startedListCount = n + -1;
    }

    public static /* synthetic */ void finishList$default(RlpEncoder rlpEncoder, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        rlpEncoder.finishList(n, n2);
    }

    @NotNull
    public final <T extends RlpEncodable> RlpEncoder encode(@Nullable T value) {
        if (value == null) {
            this.appendRaw((byte)-128);
        } else {
            value.rlpEncode(this);
        }
        return this;
    }

    @NotNull
    public final RlpEncoder encode(@Nullable BigInteger value) {
        ByteBuffer byteBuffer;
        int n;
        int n2;
        byte[] bytes;
        block7: {
            if (value == null) {
                this.ensureCapacity(this.buffer, 1).put((byte)-128);
                return this;
            }
            if (value.compareTo(BigInteger.ZERO) < 0) {
                throw new IllegalArgumentException("Negative values are not supported: " + value);
            }
            if (Intrinsics.areEqual((Object)value, (Object)BigInteger.ZERO)) {
                this.ensureCapacity(this.buffer, 1).put((byte)-128);
                return this;
            }
            bytes = value.toByteArray();
            n2 = 0;
            byte[] $this$indexOfFirst$iv = bytes;
            boolean $i$f$indexOfFirst = false;
            int n3 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n3; ++index$iv) {
                byte it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it != 0)) continue;
                n = index$iv;
                break block7;
            }
            n = -1;
        }
        int n4 = n;
        int offset = Math.max(n2, n4);
        int nonZeroLength = bytes.length - offset;
        if (nonZeroLength > 32) {
            throw new IllegalArgumentException("Value too big, max 32 bytes are supported: " + value);
        }
        if (nonZeroLength == 1 && (UByte.constructor-impl((byte)bytes[offset]) & 0xFF) < 128) {
            byteBuffer = this.ensureCapacity(this.buffer, 1).put(bytes[offset]);
        } else {
            this.ensureCapacity(this.buffer, 1 + nonZeroLength);
            this.buffer.put((byte)(128 + nonZeroLength));
            byteBuffer = this.buffer.put(bytes, offset, nonZeroLength);
        }
        return this;
    }

    @NotNull
    public final RlpEncoder encode(long value) {
        int bitShift;
        if (value < 0L) {
            throw new IllegalArgumentException("Negative values are not supported: " + value);
        }
        if (value == 0L) {
            this.ensureCapacity(this.buffer, 1).put((byte)-128);
            return this;
        }
        for (bitShift = 56; bitShift >= 0 && value >> bitShift == 0L; bitShift -= 8) {
        }
        int nonZeroLength = bitShift / 8 + 1;
        if (nonZeroLength == 1 && value < 128L) {
            this.ensureCapacity(this.buffer, 1).put((byte)value);
        } else {
            this.ensureCapacity(this.buffer, 1 + nonZeroLength);
            this.buffer.put((byte)(128 + nonZeroLength));
            while (bitShift >= 0) {
                this.buffer.put((byte)(value >> bitShift & 0xFFL));
                bitShift -= 8;
            }
        }
        return this;
    }

    @NotNull
    public final RlpEncoder encode(@Nullable byte[] value) {
        ByteBuffer byteBuffer;
        if (value == null || value.length == 0) {
            this.ensureCapacity(this.buffer, 1).put((byte)-128);
            return this;
        }
        if (value.length == 1 && (UByte.constructor-impl((byte)value[0]) & 0xFF) < 128) {
            byteBuffer = this.ensureCapacity(this.buffer, 1).put(value[0]);
        } else if (value.length <= 55) {
            this.ensureCapacity(this.buffer, 1 + value.length);
            this.buffer.put((byte)(128 + value.length));
            byteBuffer = this.buffer.put(value);
        } else {
            int lengthOfSize = Companion.lengthOfSizeInBytes(value.length);
            this.ensureCapacity(this.buffer, 1 + lengthOfSize + value.length);
            this.buffer.put((byte)(183 + lengthOfSize));
            this.encodeSize(lengthOfSize, value.length);
            byteBuffer = this.buffer.put(value);
        }
        return this;
    }

    private final void encodeSize(int lengthOfSize, int size) {
        switch (lengthOfSize) {
            case 1: {
                this.buffer.put((byte)(size & 0xFF));
                break;
            }
            case 2: {
                this.buffer.put((byte)(size >> 8 & 0xFF));
                this.buffer.put((byte)(size & 0xFF));
                break;
            }
            case 3: {
                this.buffer.put((byte)(size >> 16 & 0xFF));
                this.buffer.put((byte)(size >> 8 & 0xFF));
                this.buffer.put((byte)(size & 0xFF));
                break;
            }
            case 4: {
                this.buffer.put((byte)(size >> 24 & 0xFF));
                this.buffer.put((byte)(size >> 16 & 0xFF));
                this.buffer.put((byte)(size >> 8 & 0xFF));
                this.buffer.put((byte)(size & 0xFF));
            }
        }
    }

    private final ByteBuffer ensureCapacity(ByteBuffer $this$ensureCapacity, int sizeIncrement) {
        if (this.isExactSize || $this$ensureCapacity.remaining() >= sizeIncrement) {
            return $this$ensureCapacity;
        }
        int newCapacity = Math.max($this$ensureCapacity.capacity() + sizeIncrement, (int)((double)$this$ensureCapacity.capacity() * 1.5));
        byte[] byArray = Arrays.copyOf(this.buffer.array(), newCapacity);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
        byte[] newBuffer = byArray;
        int originalPosition = $this$ensureCapacity.position();
        this.buffer = ByteBuffer.wrap(newBuffer);
        this.buffer.position(originalPosition);
        return this.buffer;
    }

    @JvmOverloads
    public RlpEncoder(@NotNull byte[] array) {
        this(array, false, 2, null);
    }

    @JvmOverloads
    public RlpEncoder(int size) {
        this(size, false, 2, null);
    }

    @JvmOverloads
    public RlpEncoder() {
        this(0, false, 3, null);
    }

    @JvmOverloads
    @NotNull
    public final RlpEncoder encodeList(@NotNull Runnable action) {
        return RlpEncoder.encodeList$default(this, 0, action, 1, null);
    }

    @JvmOverloads
    public final int startList() {
        return RlpEncoder.startList$default(this, 0, 1, null);
    }

    @JvmOverloads
    public final void finishList(int bufferStartPosition) {
        RlpEncoder.finishList$default(this, bufferStartPosition, 0, 2, null);
    }

    @JvmStatic
    public static final int sizeOf(@Nullable RlpEncodable value) {
        return Companion.sizeOf(value);
    }

    @JvmStatic
    public static final int sizeOf(@Nullable BigInteger value) {
        return Companion.sizeOf(value);
    }

    @JvmStatic
    public static final int sizeOf(long value) {
        return Companion.sizeOf(value);
    }

    @JvmStatic
    public static final int sizeOf(@Nullable byte[] value) {
        return Companion.sizeOf(value);
    }

    @JvmStatic
    public static final <T extends RlpEncodable> int sizeOfList(@NotNull List<? extends T> list) {
        return Companion.sizeOfList(list);
    }

    @JvmStatic
    public static final int sizeOfList(int listBodySize) {
        return Companion.sizeOfList(listBodySize);
    }

    @JvmStatic
    public static final int sizeOfListBody(@NotNull List<? extends RlpEncodable> list) {
        return Companion.sizeOfListBody(list);
    }

    @JvmStatic
    public static final int lengthOfSizeInBytes(int size) {
        return Companion.lengthOfSizeInBytes(size);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\rH\u0007J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0007J \u0010\u000f\u001a\u00020\n\"\b\b\u0000\u0010\u0010*\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0007J\u0016\u0010\u0014\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0007J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/ethers/rlp/RlpEncoder$Companion;", "", "<init>", "()V", "BUFFER_GROWTH_FACTOR", "", "RLP_STRING_SHORT_BIGINT", "Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "sizeOf", "", "value", "Lio/ethers/rlp/RlpEncodable;", "", "", "sizeOfList", "T", "list", "", "listBodySize", "sizeOfListBody", "lengthOfSizeInBytes", "size", "ethers-rlp"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int sizeOf(@Nullable RlpEncodable value) {
            RlpEncodable rlpEncodable = value;
            return rlpEncodable != null ? rlpEncodable.rlpSize() : 1;
        }

        @JvmStatic
        public final int sizeOf(@Nullable BigInteger value) {
            if (value == null) {
                return 1;
            }
            if (value.compareTo(BigInteger.ZERO) < 0) {
                throw new IllegalArgumentException("Negative values are not supported: " + value);
            }
            if (Intrinsics.areEqual((Object)value, (Object)BigInteger.ZERO)) {
                return 1;
            }
            int nonZeroLength = (value.bitLength() + 7) / 8;
            if (nonZeroLength > 32) {
                throw new IllegalArgumentException("Value too big, max 32 bytes are supported: " + value);
            }
            return nonZeroLength == 1 && value.compareTo(RLP_STRING_SHORT_BIGINT) < 0 ? 1 : 1 + nonZeroLength;
        }

        @JvmStatic
        public final int sizeOf(long value) {
            int bitShift;
            if (value < 0L) {
                throw new IllegalArgumentException("Negative values are not supported: " + value);
            }
            if (value == 0L) {
                return 1;
            }
            for (bitShift = 56; bitShift >= 0 && value >> bitShift == 0L; bitShift -= 8) {
            }
            int nonZeroLength = bitShift / 8 + 1;
            return nonZeroLength == 1 && value < 128L ? 1 : 1 + nonZeroLength;
        }

        @JvmStatic
        public final int sizeOf(@Nullable byte[] value) {
            if (value == null || value.length == 0) {
                return 1;
            }
            if (value.length == 1 && (UByte.constructor-impl((byte)value[0]) & 0xFF) < 128) {
                return 1;
            }
            if (value.length <= 55) {
                return 1 + value.length;
            }
            int lengthOfSize = this.lengthOfSizeInBytes(value.length);
            return 1 + lengthOfSize + value.length;
        }

        @JvmStatic
        public final <T extends RlpEncodable> int sizeOfList(@NotNull List<? extends T> list) {
            return this.sizeOfList(this.sizeOfListBody(list));
        }

        @JvmStatic
        public final int sizeOfList(int listBodySize) {
            return listBodySize + (listBodySize == 0 ? 1 : (listBodySize <= 55 ? 1 : 1 + this.lengthOfSizeInBytes(listBodySize)));
        }

        @JvmStatic
        public final int sizeOfListBody(@NotNull List<? extends RlpEncodable> list) {
            int size = 0;
            int n = ((Collection)list).size();
            for (int i = 0; i < n; ++i) {
                size += this.sizeOf(list.get(i));
            }
            return size;
        }

        @JvmStatic
        public final int lengthOfSizeInBytes(int size) {
            return size <= 255 ? 1 : (size <= 65535 ? 2 : (size <= 0xFFFFFF ? 3 : 4));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

