/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.types;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0007\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/ethers/providers/types/ConditionalCompletableFuture;", "T", "Ljava/util/concurrent/CompletableFuture;", "canAwait", "Ljava/util/concurrent/atomic/AtomicBoolean;", "<init>", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getNow", "valueIfAbsent", "(Ljava/lang/Object;)Ljava/lang/Object;", "join", "verifyCanAwait", "", "ethers-providers"})
public final class ConditionalCompletableFuture<T>
extends CompletableFuture<T> {
    @NotNull
    private final AtomicBoolean canAwait;

    public ConditionalCompletableFuture(@NotNull AtomicBoolean canAwait) {
        this.canAwait = canAwait;
    }

    @Override
    public T get() {
        this.verifyCanAwait();
        return super.get();
    }

    @Override
    public T get(long timeout, @NotNull TimeUnit unit) {
        this.verifyCanAwait();
        return super.get(timeout, unit);
    }

    @Override
    public T getNow(T valueIfAbsent) {
        this.verifyCanAwait();
        return super.getNow(valueIfAbsent);
    }

    @Override
    public T join() {
        this.verifyCanAwait();
        return super.join();
    }

    private final void verifyCanAwait() {
        if (!this.canAwait.get()) {
            throw new IllegalStateException("Request has not been sent yet. Awaiting would block indefinitely.");
        }
    }
}

