/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import io.ethers.core.FastHex;
import io.ethers.core.Jackson;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.Block;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.BlockWithHashes;
import io.ethers.core.types.BlockWithTransactions;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.CreateAccessList;
import io.ethers.core.types.FeeHistory;
import io.ethers.core.types.Hash;
import io.ethers.core.types.IntoCallRequest;
import io.ethers.core.types.Log;
import io.ethers.core.types.LogFilter;
import io.ethers.core.types.RPCTransaction;
import io.ethers.core.types.StateOverride;
import io.ethers.core.types.SyncStatus;
import io.ethers.core.types.TransactionReceipt;
import io.ethers.core.types.TxpoolContent;
import io.ethers.core.types.TxpoolContentFromAddress;
import io.ethers.core.types.TxpoolInspectResult;
import io.ethers.core.types.TxpoolStatus;
import io.ethers.core.types.tracers.TracerConfig;
import io.ethers.core.types.tracers.TxTraceResult;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.providers.HttpClient;
import io.ethers.providers.JsonRpcClient;
import io.ethers.providers.RpcClientConfig;
import io.ethers.providers.RpcError;
import io.ethers.providers.WsClient;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.CallFailedError;
import io.ethers.providers.types.CallManyBundle;
import io.ethers.providers.types.CallManyContext;
import io.ethers.providers.types.FilterPoller;
import io.ethers.providers.types.PendingTransaction;
import io.ethers.providers.types.RpcCall;
import io.ethers.providers.types.RpcRequest;
import io.ethers.providers.types.RpcSubscribe;
import io.ethers.providers.types.RpcSubscribeCall;
import io.ethers.providers.types.SuppliedRpcRequest;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u008f\u00012\u00020\u0001:\b\u008c\u0001\u008d\u0001\u008e\u0001\u008f\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 \u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010\"\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 \u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010#\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0 \u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016JN\u0010%\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H&0 \u0012\u0004\u0012\u00020\u00110\u000f\"\u0004\b\u0000\u0010'\"\u000e\b\u0001\u0010&*\b\u0012\u0004\u0012\u0002H'0(2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H&0+H\u0002J*\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 \u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0005H\u0016J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J,\u00101\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00103\u001a\u0002022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J8\u00104\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001e2\b\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u000109H\u0016JX\u0010:\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020=0<0;\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002050;2\u0006\u0010?\u001a\u00020@2\b\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u000109H\u0016J$\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010B\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0014\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0014\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0014\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J2\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001a0;H\u0016J2\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010H\u001a\u00020\u00052\u0006\u0010L\u001a\u00020M2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001a0;H\u0016J\u0014\u0010N\u001a\u000e\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u001c\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0005H\u0016J$\u0010S\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u0005H\u0016J$\u0010T\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010U\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020R0 \u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010V\u001a\u000202H\u0016J\"\u0010W\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0 \u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010V\u001a\u000202H\u0016J(\u0010Y\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0;0 \u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\\\u001a\u00020]H\u0016J\u001c\u0010^\u001a\u000e\u0012\u0004\u0012\u00020_\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u00104\u001a\u000205H\u0016J\u001c\u0010`\u001a\u000e\u0012\u0004\u0012\u00020_\u0012\u0004\u0012\u00020\u00110<2\u0006\u0010a\u001a\u00020bH\u0002J\"\u0010c\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020d0;\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010e\u001a\u00020fH\u0016J\"\u0010g\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020d0h\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010e\u001a\u00020fH\u0016J\u001a\u0010i\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002020h\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u001a\u0010j\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002020h\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u001a\u0010k\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020R0h\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0014\u0010l\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u00110mH\u0016J\u0014\u0010n\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020\u00110mH\u0016J\u0014\u0010o\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00110mH\u0016J\u001c\u0010p\u001a\u000e\u0012\u0004\u0012\u00020d\u0012\u0004\u0012\u00020\u00110m2\u0006\u0010e\u001a\u00020fH\u0016J\u001c\u0010q\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010r\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010s\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002000;\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002000 \u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010V\u001a\u000202H\u0016J\u001c\u0010u\u001a\u000e\u0012\u0004\u0012\u00020v\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010w\u001a\u00020\u0005H\u0016J8\u0010x\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020\u00110\u000f\"\u0004\b\u0000\u0010'2\u0006\u00104\u001a\u0002052\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002H'0zH\u0016JL\u0010{\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0;\u0012\u0004\u0012\u00020\u00110\u000f\"\u0004\b\u0000\u0010'2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002050;2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002H'0z2\u0006\u0010?\u001a\u00020@H\u0016J0\u0010|\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020\u00110\u000f\"\u0004\b\u0000\u0010'2\u0006\u0010}\u001a\u0002022\f\u0010y\u001a\b\u0012\u0004\u0012\u0002H'0zH\u0016J<\u0010~\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0\u007f0;\u0012\u0004\u0012\u00020\u00110\u000f\"\u0004\b\u0000\u0010'2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010y\u001a\b\u0012\u0004\u0012\u0002H'0zH\u0016J\u0015\u0010\u0080\u0001\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0015\u0010\u0081\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0015\u0010\u0082\u0001\u001a\u000e\u0012\u0004\u0012\u00020v\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0016\u0010\u0083\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u0084\u0001\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u001e\u0010\u0085\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u0086\u0001\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u0087\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u0088\u0001\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0016\u0010\u0089\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J\u0015\u0010\u008b\u0001\u001a\u000e\u0012\u0004\u0012\u00020v\u0012\u0004\u0012\u00020\u00110\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0090\u0001"}, d2={"Lio/ethers/providers/Provider;", "Lio/ethers/providers/middleware/Middleware;", "client", "Lio/ethers/providers/JsonRpcClient;", "chainId", "", "<init>", "(Lio/ethers/providers/JsonRpcClient;J)V", "getClient", "()Lio/ethers/providers/JsonRpcClient;", "getChainId", "()J", "supportsFillTransaction", "", "fillTransactionFeeHistory", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/core/types/FeeHistory;", "Lio/ethers/providers/RpcError;", "inner", "getInner", "()Lio/ethers/providers/middleware/Middleware;", "provider", "getProvider", "()Lio/ethers/providers/Provider;", "getBlockNumber", "getBalance", "Ljava/math/BigInteger;", "address", "Lio/ethers/core/types/Address;", "blockId", "Lio/ethers/core/types/BlockId;", "getBlockHeader", "Ljava/util/Optional;", "Lio/ethers/core/types/BlockWithHashes;", "getBlockWithHashes", "getBlockWithTransactions", "Lio/ethers/core/types/BlockWithTransactions;", "getBlock", "B", "T", "Lio/ethers/core/types/Block;", "fullTransactions", "responseType", "Ljava/lang/Class;", "getUncleBlockHeader", "index", "getUncleBlocksCount", "getCode", "Lio/ethers/core/types/Bytes;", "getStorage", "Lio/ethers/core/types/Hash;", "key", "call", "Lio/ethers/core/types/IntoCallRequest;", "stateOverride", "Lio/ethers/core/types/StateOverride;", "blockOverride", "Lio/ethers/core/types/BlockOverride;", "callMany", "", "Lio/ethers/core/Result;", "Lio/ethers/providers/types/CallFailedError;", "calls", "transactionIndex", "", "estimateGas", "createAccessList", "Lio/ethers/core/types/CreateAccessList;", "getGasPrice", "getBlobBaseFee", "getMaxPriorityFeePerGas", "getFeeHistory", "blockCount", "lastBlockName", "Lio/ethers/core/types/BlockId$Name;", "rewardPercentiles", "lastBlockNumber", "Lio/ethers/core/types/BlockId$Number;", "isNodeSyncing", "Lio/ethers/core/types/SyncStatus;", "getBlockTransactionCount", "getTransactionByBlockAndIndex", "Lio/ethers/core/types/RPCTransaction;", "getRawTransactionByBlockAndIndex", "getTransactionCount", "getTransactionByHash", "hash", "getTransactionReceipt", "Lio/ethers/core/types/TransactionReceipt;", "getBlockReceipts", "sendRawTransaction", "Lio/ethers/providers/types/PendingTransaction;", "signedTransaction", "", "fillTransaction", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "manuallyFillTransaction", "original", "Lio/ethers/core/types/CallRequest;", "getLogs", "Lio/ethers/core/types/Log;", "filter", "Lio/ethers/core/types/LogFilter;", "watchLogs", "Lio/ethers/providers/types/FilterPoller;", "watchNewBlockHashes", "watchNewPendingTransactionHashes", "watchNewPendingTransactions", "subscribeNewPendingTransactionHashes", "Lio/ethers/providers/types/RpcSubscribe;", "subscribeNewPendingTransactions", "subscribeNewHeads", "subscribeLogs", "getRawBlockHeader", "getRawBlockWithTransactions", "getRawReceipts", "getRawTransaction", "printBlock", "", "number", "traceCall", "config", "Lio/ethers/core/types/tracers/TracerConfig;", "traceCallMany", "traceTransaction", "txHash", "traceBlock", "Lio/ethers/core/types/tracers/TxTraceResult;", "isListening", "getPeerCount", "getVersion", "txpoolContent", "Lio/ethers/core/types/TxpoolContent;", "txpoolContentFrom", "Lio/ethers/core/types/TxpoolContentFromAddress;", "txpoolStatus", "Lio/ethers/core/types/TxpoolStatus;", "txpoolInspect", "Lio/ethers/core/types/TxpoolInspectResult;", "getClientVersion", "Error", "UnsupportedUrlProtocol", "UnableToGetChainId", "Companion", "ethers-providers"})
@SourceDebugExtension(value={"SMAP\nProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Provider.kt\nio/ethers/providers/Provider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n1#1,699:1\n1617#2,9:700\n1869#2:709\n1870#2:711\n1626#2:712\n1#3:710\n194#4,11:713\n33#4,6:724\n205#4,3:730\n194#4,14:733\n194#4,11:747\n33#4,6:758\n205#4,3:764\n*S KotlinDebug\n*F\n+ 1 Provider.kt\nio/ethers/providers/Provider\n*L\n405#1:700,9\n405#1:709\n405#1:711\n405#1:712\n405#1:710\n171#1:713,11\n174#1:724,6\n171#1:730,3\n565#1:733,14\n584#1:747,11\n589#1:758,6\n584#1:764,3\n*E\n"})
public final class Provider
implements Middleware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonRpcClient client;
    private final long chainId;
    private boolean supportsFillTransaction;
    @NotNull
    private final RpcRequest<FeeHistory, RpcError> fillTransactionFeeHistory;
    @NotNull
    private static final Object[] EMPTY_ARRAY = new Object[0];
    @NotNull
    private static final Regex PROTO_HTTPS = new Regex("^(https?)://.+$");
    @NotNull
    private static final Regex PROTO_WSS = new Regex("^(wss?)://.+$");

    public Provider(@NotNull JsonRpcClient client, long chainId) {
        this.client = client;
        this.chainId = chainId;
        this.supportsFillTransaction = true;
        this.fillTransactionFeeHistory = this.getFeeHistory(10L, BlockId.LATEST, (List<? extends BigInteger>)CollectionsKt.listOf((Object)new BigInteger("20")));
    }

    @Override
    @NotNull
    public JsonRpcClient getClient() {
        return this.client;
    }

    @Override
    public long getChainId() {
        return this.chainId;
    }

    @Override
    @Nullable
    public Middleware getInner() {
        return null;
    }

    @Override
    @NotNull
    public Provider getProvider() {
        return this;
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getBlockNumber() {
        return new RpcCall<Long>(this.getClient(), "eth_blockNumber", EMPTY_ARRAY, Provider::getBlockNumber$lambda$0);
    }

    @Override
    @NotNull
    public RpcRequest<BigInteger, RpcError> getBalance(@NotNull Address address, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{address, blockId.getId()};
        return new RpcCall<BigInteger>(this.getClient(), "eth_getBalance", objectArray, Provider::getBalance$lambda$1);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<BlockWithHashes>, RpcError> getBlockHeader(@NotNull BlockId blockId) {
        String string;
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getHeaderByHash";
        } else if (blockId2 instanceof BlockId.Number || blockId2 instanceof BlockId.Name) {
            string = "eth_getHeaderByNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Optional>(this.getClient(), method, params, Provider::getBlockHeader$lambda$2);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<BlockWithHashes>, RpcError> getBlockWithHashes(@NotNull BlockId blockId) {
        return this.getBlock(blockId, false, BlockWithHashes.class);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<BlockWithTransactions>, RpcError> getBlockWithTransactions(@NotNull BlockId blockId) {
        return this.getBlock(blockId, true, BlockWithTransactions.class);
    }

    private final <T, B extends Block<T>> RpcRequest<Optional<B>, RpcError> getBlock(BlockId blockId, boolean fullTransactions, Class<B> responseType) {
        String string;
        Object[] objectArray = new Object[]{blockId.getId(), fullTransactions};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getBlockByHash";
        } else if (blockId2 instanceof BlockId.Number || blockId2 instanceof BlockId.Name) {
            string = "eth_getBlockByNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Optional>(this.getClient(), method, params, arg_0 -> Provider.getBlock$lambda$3(responseType, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<Optional<BlockWithHashes>, RpcError> getUncleBlockHeader(@NotNull BlockId blockId, long index) {
        String string;
        Object[] objectArray = new String[]{blockId.getId(), FastHex.encodeWithPrefix((long)index)};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getUncleByBlockHashAndIndex";
        } else if (blockId2 instanceof BlockId.Number || blockId2 instanceof BlockId.Name) {
            string = "eth_getUncleByBlockNumberAndIndex";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Optional>(this.getClient(), method, params, Provider::getUncleBlockHeader$lambda$4);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getUncleBlocksCount(@NotNull BlockId blockId) {
        String string;
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getUncleCountByBlockHash";
        } else if (blockId2 instanceof BlockId.Number || blockId2 instanceof BlockId.Name) {
            string = "eth_getUncleCountByBlockNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Long>(this.getClient(), method, params, Provider::getUncleBlocksCount$lambda$5);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> getCode(@NotNull Address address, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{address, blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Bytes>(this.getClient(), "eth_getCode", params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<Hash, RpcError> getStorage(@NotNull Address address, @NotNull Hash key, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{address, key, blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Hash>(this.getClient(), "eth_getStorageAt", params, Hash.class);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> call(@NotNull IntoCallRequest call, @NotNull BlockId blockId, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        Object[] objectArray;
        Object[] objectArray2;
        if (blockOverride != null) {
            objectArray2 = new Object[]{call.toCallRequest(), blockId.getId(), stateOverride, blockOverride};
            objectArray = objectArray2;
        } else if (stateOverride != null) {
            objectArray2 = new Object[]{call.toCallRequest(), blockId.getId(), stateOverride};
            objectArray = objectArray2;
        } else {
            objectArray2 = new Object[]{call.toCallRequest(), blockId.getId()};
            objectArray = objectArray2;
        }
        Object[] params = objectArray;
        return new RpcCall<Bytes>(this.getClient(), "eth_call", params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<List<Result<Bytes, CallFailedError>>, RpcError> callMany(@NotNull BlockId blockId, @NotNull List<? extends IntoCallRequest> calls, int transactionIndex, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        CallManyBundle bundle = new CallManyBundle(calls, blockOverride);
        CallManyContext ctx = new CallManyContext(blockId, transactionIndex);
        Object[] objectArray = new Object[]{bundle, ctx, stateOverride};
        return new RpcCall<List>(this.getClient(), "eth_callMany", objectArray, Provider::callMany$lambda$8);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> estimateGas(@NotNull IntoCallRequest call, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{call.toCallRequest(), blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Long>(this.getClient(), "eth_estimateGas", params, Provider::estimateGas$lambda$9);
    }

    @Override
    @NotNull
    public RpcRequest<CreateAccessList, RpcError> createAccessList(@NotNull IntoCallRequest call, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{call.toCallRequest(), blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<CreateAccessList>(this.getClient(), "eth_createAccessList", params, CreateAccessList.class);
    }

    @Override
    @NotNull
    public RpcRequest<BigInteger, RpcError> getGasPrice() {
        return new RpcCall<BigInteger>(this.getClient(), "eth_gasPrice", EMPTY_ARRAY, Provider::getGasPrice$lambda$10);
    }

    @Override
    @NotNull
    public RpcRequest<BigInteger, RpcError> getBlobBaseFee() {
        return new RpcCall<BigInteger>(this.getClient(), "eth_blobBaseFee", EMPTY_ARRAY, Provider::getBlobBaseFee$lambda$11);
    }

    @Override
    @NotNull
    public RpcRequest<BigInteger, RpcError> getMaxPriorityFeePerGas() {
        return new RpcCall<BigInteger>(this.getClient(), "eth_maxPriorityFeePerGas", EMPTY_ARRAY, Provider::getMaxPriorityFeePerGas$lambda$12);
    }

    @Override
    @NotNull
    public RpcRequest<FeeHistory, RpcError> getFeeHistory(long blockCount, @NotNull BlockId.Name lastBlockName, @NotNull List<? extends BigInteger> rewardPercentiles) {
        Object[] objectArray = new Object[]{FastHex.encodeWithPrefix((long)blockCount), lastBlockName.getId(), rewardPercentiles};
        Object[] params = objectArray;
        return new RpcCall<FeeHistory>(this.getClient(), "eth_feeHistory", params, FeeHistory.class);
    }

    @Override
    @NotNull
    public RpcRequest<FeeHistory, RpcError> getFeeHistory(long blockCount, @NotNull BlockId.Number lastBlockNumber, @NotNull List<? extends BigInteger> rewardPercentiles) {
        Object[] objectArray = new Object[]{FastHex.encodeWithPrefix((long)blockCount), lastBlockNumber.getId(), rewardPercentiles};
        Object[] params = objectArray;
        return new RpcCall<FeeHistory>(this.getClient(), "eth_feeHistory", params, FeeHistory.class);
    }

    @Override
    @NotNull
    public RpcRequest<SyncStatus, RpcError> isNodeSyncing() {
        return new RpcCall<SyncStatus>(this.getClient(), "eth_syncing", EMPTY_ARRAY, Provider::isNodeSyncing$lambda$13);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getBlockTransactionCount(@NotNull BlockId blockId) {
        String string;
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getBlockTransactionCountByHash";
        } else if (blockId2 instanceof BlockId.Number || blockId2 instanceof BlockId.Name) {
            string = "eth_getBlockTransactionCountByNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Long>(this.getClient(), method, params, Provider::getBlockTransactionCount$lambda$14);
    }

    @Override
    @NotNull
    public RpcRequest<RPCTransaction, RpcError> getTransactionByBlockAndIndex(@NotNull BlockId blockId, long index) {
        String string;
        Object[] objectArray = new String[]{blockId.getId(), FastHex.encodeWithPrefix((long)index)};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getTransactionByBlockHashAndIndex";
        } else if (blockId2 instanceof BlockId.Number || blockId2 instanceof BlockId.Name) {
            string = "eth_getTransactionByBlockNumberAndIndex";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<RPCTransaction>(this.getClient(), method, params, RPCTransaction.class);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> getRawTransactionByBlockAndIndex(@NotNull BlockId blockId, long index) {
        String string;
        Object[] objectArray = new String[]{blockId.getId(), FastHex.encodeWithPrefix((long)index)};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getRawTransactionByBlockHashAndIndex";
        } else if (blockId2 instanceof BlockId.Number || blockId2 instanceof BlockId.Name) {
            string = "eth_getRawTransactionByBlockNumberAndIndex";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Bytes>(this.getClient(), method, params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getTransactionCount(@NotNull Address address, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{address, blockId.getId()};
        return new RpcCall<Long>(this.getClient(), "eth_getTransactionCount", objectArray, Provider::getTransactionCount$lambda$15);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<RPCTransaction>, RpcError> getTransactionByHash(@NotNull Hash hash) {
        Object[] objectArray = new Hash[]{hash};
        return new RpcCall<Optional>(this.getClient(), "eth_getTransactionByHash", objectArray, Provider::getTransactionByHash$lambda$16);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<TransactionReceipt>, RpcError> getTransactionReceipt(@NotNull Hash hash) {
        Object[] objectArray = new Hash[]{hash};
        return new RpcCall<Optional>(this.getClient(), "eth_getTransactionReceipt", objectArray, Provider::getTransactionReceipt$lambda$17);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<List<TransactionReceipt>>, RpcError> getBlockReceipts(@NotNull BlockId blockId) {
        Object[] objectArray = new String[]{blockId.getId()};
        return new RpcCall<Optional>(this.getClient(), "eth_getBlockReceipts", objectArray, Provider::getBlockReceipts$lambda$19);
    }

    @Override
    @NotNull
    public RpcRequest<PendingTransaction, RpcError> sendRawTransaction(@NotNull byte[] signedTransaction) {
        byte[][] byArrayArray = new byte[][]{signedTransaction};
        return new RpcCall<PendingTransaction>(this.getClient(), "eth_sendRawTransaction", (Object[])byArrayArray, arg_0 -> Provider.sendRawTransaction$lambda$20(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<TransactionUnsigned, RpcError> fillTransaction(@NotNull IntoCallRequest call) {
        CallRequest callRequest = call.toCallRequest();
        if (!this.supportsFillTransaction) {
            return new SuppliedRpcRequest(() -> Provider.fillTransaction$lambda$21(this, callRequest));
        }
        Object[] objectArray = new CallRequest[]{callRequest};
        return new RpcCall<TransactionUnsigned>(this.getClient(), "eth_fillTransaction", objectArray, arg_0 -> Provider.fillTransaction$lambda$22(this, arg_0)).orElse(arg_0 -> Provider.fillTransaction$lambda$23(this, callRequest, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final Result<TransactionUnsigned, RpcError> manuallyFillTransaction(CallRequest original) {
        Result<FeeHistory, RpcError> feeHistoryResult;
        CompletableFuture<Result<Long, RpcError>> completableFuture;
        TransactionUnsigned unsigned;
        CallRequest call = new CallRequest(original);
        if (call.getChainId() == -1L) {
            call.setChainId(this.getProvider().getChainId());
        }
        if ((unsigned = call.toUnsignedTransactionOrNull()) != null) {
            return ResultKt.success((Object)unsigned);
        }
        if (call.getBlobVersionedHashes() != null && call.getTo() == null) {
            return ResultKt.failure((Result.Error)new RpcError(5003, "Cannot fill blob transaction, missing 'to' field", null, null, 12, null));
        }
        Address sender = call.getFrom();
        if (call.getNonce() >= 0L) {
            completableFuture = null;
        } else {
            if (sender == null) {
                return ResultKt.failure((Result.Error)new RpcError(5003, "Cannot estimate nonce, 'from' field is not set", null, null, 12, null));
            }
            completableFuture = this.getProvider().getTransactionCount(sender, (BlockId)BlockId.LATEST).sendAsync();
        }
        CompletableFuture<Result<Long, RpcError>> nonceFut = completableFuture;
        CompletableFuture<Result<Long, RpcError>> gasLimitFut = call.getGas() >= 21000L ? null : this.getProvider().estimateGas((IntoCallRequest)call, (BlockId)BlockId.LATEST).sendAsync();
        boolean txFeesSet = call.getGasPrice() != null || call.getGasTipCap() != null && call.getGasFeeCap() != null;
        boolean blobFeesSet = call.getBlobVersionedHashes() == null || call.getBlobFeeCap() != null;
        CompletableFuture<Result<FeeHistory, RpcError>> feeHistoryFut = txFeesSet && blobFeesSet ? null : this.fillTransactionFeeHistory.sendAsync();
        CompletableFuture<Result<Long, RpcError>> completableFuture2 = nonceFut;
        Result<Long, RpcError> nonceResult = completableFuture2 != null ? completableFuture2.get() : null;
        CompletableFuture<Result<Long, RpcError>> completableFuture3 = gasLimitFut;
        Result<Long, RpcError> gasLimitResult = completableFuture3 != null ? completableFuture3.get() : null;
        CompletableFuture<Result<FeeHistory, RpcError>> completableFuture4 = feeHistoryFut;
        Object object = feeHistoryResult = completableFuture4 != null ? completableFuture4.get() : null;
        if (nonceResult != null) {
            if (ResultKt.isFailure(nonceResult)) {
                return nonceResult;
            }
            call.nonce(((Number)((Result.Success)nonceResult).unwrap()).longValue());
        }
        if (gasLimitResult != null) {
            if (ResultKt.isFailure(gasLimitResult)) {
                return gasLimitResult;
            }
            call.gas(((Number)((Result.Success)gasLimitResult).unwrap()).longValue());
        }
        if (feeHistoryResult != null) {
            if (ResultKt.isFailure(feeHistoryResult)) {
                return feeHistoryResult;
            }
            FeeHistory feeHistory = (FeeHistory)((Result.Success)feeHistoryResult).unwrap();
            if (!txFeesSet) {
                CallRequest callRequest;
                BigInteger bigInteger;
                void $this$mapNotNullTo$iv$iv;
                List list = feeHistory.getRewards();
                Intrinsics.checkNotNull((Object)list);
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    BigInteger it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    List it = (List)element$iv$iv;
                    boolean bl2 = false;
                    BigInteger r = (BigInteger)CollectionsKt.firstOrNull((List)it);
                    if ((r == null || r.compareTo(BigInteger.ZERO) <= 0 ? null : r) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List rewards = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                if (rewards.isEmpty()) {
                    bigInteger = BigInteger.ONE;
                } else if (rewards.size() % 2 == 0) {
                    BigInteger bigInteger2 = ((BigInteger)rewards.get(rewards.size() / 2 - 1)).add((BigInteger)rewards.get(rewards.size() / 2));
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"add(...)");
                    BigInteger bigInteger3 = bigInteger2.divide(BigInteger.TWO);
                    bigInteger = bigInteger3;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"divide(...)");
                } else {
                    bigInteger = (BigInteger)rewards.get(rewards.size() / 2);
                }
                BigInteger medianReward = bigInteger.max(BigInteger.ONE);
                if (feeHistory.getNextBaseFeePerGas().compareTo(BigInteger.ZERO) > 0) {
                    BigInteger bigInteger4 = feeHistory.getNextBaseFeePerGas().add(medianReward);
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"add(...)");
                    call.gasFeeCap(bigInteger4);
                    callRequest = call.gasTipCap(medianReward);
                } else {
                    callRequest = call.gasPrice(medianReward);
                }
            }
            if (!blobFeesSet) {
                call.blobFeeCap(feeHistory.getNextBaseFeePerBlobGas());
            }
        }
        if ((unsigned = call.toUnsignedTransactionOrNull()) != null) {
            return ResultKt.success((Object)unsigned);
        }
        JsonNode data = Jackson.MAPPER.valueToTree((Object)call);
        return ResultKt.failure((Result.Error)new RpcError(5003, "Failed to manually fill transaction", data, null, 8, null));
    }

    @Override
    @NotNull
    public RpcRequest<List<Log>, RpcError> getLogs(@NotNull LogFilter filter) {
        Object[] objectArray = new LogFilter[]{filter};
        return new RpcCall<List>(this.getClient(), "eth_getLogs", objectArray, Provider::getLogs$lambda$25);
    }

    @Override
    @NotNull
    public RpcRequest<FilterPoller<Log>, RpcError> watchLogs(@NotNull LogFilter filter) {
        Object[] objectArray = new LogFilter[]{filter};
        return new RpcCall<FilterPoller>(this.getClient(), "eth_newFilter", objectArray, arg_0 -> Provider.watchLogs$lambda$27(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<FilterPoller<Hash>, RpcError> watchNewBlockHashes() {
        return new RpcCall<FilterPoller>(this.getClient(), "eth_newBlockFilter", EMPTY_ARRAY, arg_0 -> Provider.watchNewBlockHashes$lambda$29(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<FilterPoller<Hash>, RpcError> watchNewPendingTransactionHashes() {
        return new RpcCall<FilterPoller>(this.getClient(), "eth_newPendingTransactionFilter", EMPTY_ARRAY, arg_0 -> Provider.watchNewPendingTransactionHashes$lambda$31(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<FilterPoller<RPCTransaction>, RpcError> watchNewPendingTransactions() {
        Object[] objectArray = new Boolean[]{true};
        return new RpcCall<FilterPoller>(this.getClient(), "eth_newPendingTransactionFilter", objectArray, arg_0 -> Provider.watchNewPendingTransactions$lambda$33(this, arg_0));
    }

    @Override
    @NotNull
    public RpcSubscribe<Hash, RpcError> subscribeNewPendingTransactionHashes() {
        Object[] objectArray = new String[]{"newPendingTransactions"};
        return new RpcSubscribeCall<Hash>(this.getClient(), objectArray, Provider::subscribeNewPendingTransactionHashes$lambda$34);
    }

    @Override
    @NotNull
    public RpcSubscribe<RPCTransaction, RpcError> subscribeNewPendingTransactions() {
        Object[] objectArray = new Object[]{"newPendingTransactions", true};
        return new RpcSubscribeCall<RPCTransaction>(this.getClient(), objectArray, Provider::subscribeNewPendingTransactions$lambda$35);
    }

    @Override
    @NotNull
    public RpcSubscribe<BlockWithHashes, RpcError> subscribeNewHeads() {
        Object[] objectArray = new String[]{"newHeads"};
        return new RpcSubscribeCall<BlockWithHashes>(this.getClient(), objectArray, Provider::subscribeNewHeads$lambda$36);
    }

    @Override
    @NotNull
    public RpcSubscribe<Log, RpcError> subscribeLogs(@NotNull LogFilter filter) {
        Object[] objectArray = new Object[]{"logs", filter};
        return new RpcSubscribeCall<Log>(this.getClient(), objectArray, Provider::subscribeLogs$lambda$37);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> getRawBlockHeader(@NotNull BlockId blockId) {
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Bytes>(this.getClient(), "debug_getRawHeader", params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> getRawBlockWithTransactions(@NotNull BlockId blockId) {
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Bytes>(this.getClient(), "debug_getRawBlock", params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<List<Bytes>, RpcError> getRawReceipts(@NotNull BlockId blockId) {
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<List>(this.getClient(), "debug_getRawReceipts", params, Provider::getRawReceipts$lambda$38);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<Bytes>, RpcError> getRawTransaction(@NotNull Hash hash) {
        Object[] objectArray = new Hash[]{hash};
        return new RpcCall<Optional>(this.getClient(), "debug_getRawTransaction", objectArray, Provider::getRawTransaction$lambda$39);
    }

    @Override
    @NotNull
    public RpcRequest<String, RpcError> printBlock(long number) {
        Object[] objectArray = new Long[]{number};
        Object[] params = objectArray;
        return new RpcCall<String>(this.getClient(), "debug_printBlock", params, String.class);
    }

    @Override
    @NotNull
    public <T> RpcRequest<T, RpcError> traceCall(@NotNull IntoCallRequest call, @NotNull BlockId blockId, @NotNull TracerConfig<T> config) {
        Object[] objectArray = new Object[]{call.toCallRequest(), blockId.getId(), config};
        Object[] params = objectArray;
        return new RpcCall<Object>(this.getClient(), "debug_traceCall", params, arg_0 -> Provider.traceCall$lambda$40(config, arg_0));
    }

    @Override
    @NotNull
    public <T> RpcRequest<List<T>, RpcError> traceCallMany(@NotNull BlockId blockId, @NotNull List<? extends IntoCallRequest> calls, @NotNull TracerConfig<T> config, int transactionIndex) {
        CallManyBundle bundle = new CallManyBundle(calls, config.getBlockOverrides());
        CallManyContext ctx = new CallManyContext(blockId, transactionIndex);
        Object[] objectArray = new Object[3];
        CallManyBundle[] callManyBundleArray = new CallManyBundle[]{bundle};
        objectArray[0] = callManyBundleArray;
        objectArray[1] = ctx;
        objectArray[2] = config;
        return new RpcCall<List>(this.getClient(), "debug_traceCallMany", objectArray, arg_0 -> Provider.traceCallMany$lambda$43(config, arg_0));
    }

    @Override
    @NotNull
    public <T> RpcRequest<T, RpcError> traceTransaction(@NotNull Hash txHash, @NotNull TracerConfig<T> config) {
        Object[] objectArray = new Object[]{txHash, config};
        Object[] params = objectArray;
        return new RpcCall<Object>(this.getClient(), "debug_traceTransaction", params, arg_0 -> Provider.traceTransaction$lambda$44(config, arg_0));
    }

    @Override
    @NotNull
    public <T> RpcRequest<List<TxTraceResult<T>>, RpcError> traceBlock(@NotNull BlockId blockId, @NotNull TracerConfig<T> config) {
        String string;
        Object[] objectArray = new Object[]{blockId.getId(), config};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "debug_traceBlockByHash";
        } else if (blockId2 instanceof BlockId.Number || blockId2 instanceof BlockId.Name) {
            string = "debug_traceBlockByNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<List>(this.getClient(), method, params, arg_0 -> Provider.traceBlock$lambda$47(config, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<Boolean, RpcError> isListening() {
        return new RpcCall<Boolean>(this.getClient(), "net_listening", EMPTY_ARRAY, Provider::isListening$lambda$48);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getPeerCount() {
        return new RpcCall<Long>(this.getClient(), "net_peerCount", EMPTY_ARRAY, Provider::getPeerCount$lambda$49);
    }

    @Override
    @NotNull
    public RpcRequest<String, RpcError> getVersion() {
        return new RpcCall<String>(this.getClient(), "net_version", EMPTY_ARRAY, String.class);
    }

    @Override
    @NotNull
    public RpcRequest<TxpoolContent, RpcError> txpoolContent() {
        return new RpcCall<TxpoolContent>(this.getClient(), "txpool_content", EMPTY_ARRAY, TxpoolContent.class);
    }

    @Override
    @NotNull
    public RpcRequest<TxpoolContentFromAddress, RpcError> txpoolContentFrom(@NotNull Address address) {
        Object[] objectArray = new Address[]{address};
        Object[] params = objectArray;
        return new RpcCall<TxpoolContentFromAddress>(this.getClient(), "txpool_contentFrom", params, TxpoolContentFromAddress.class);
    }

    @Override
    @NotNull
    public RpcRequest<TxpoolStatus, RpcError> txpoolStatus() {
        return new RpcCall<TxpoolStatus>(this.getClient(), "txpool_status", EMPTY_ARRAY, TxpoolStatus.class);
    }

    @Override
    @NotNull
    public RpcRequest<TxpoolInspectResult, RpcError> txpoolInspect() {
        return new RpcCall<TxpoolInspectResult>(this.getClient(), "txpool_inspect", EMPTY_ARRAY, TxpoolInspectResult.class);
    }

    @Override
    @NotNull
    public RpcRequest<String, RpcError> getClientVersion() {
        return new RpcCall<String>(this.getClient(), "web3_clientVersion", EMPTY_ARRAY, String.class);
    }

    private static final Long getBlockNumber$lambda$0(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final BigInteger getBalance$lambda$1(JsonParser it) {
        return JsonParserExtensionsKt.readHexBigInteger((JsonParser)it);
    }

    private static final Optional getBlockHeader$lambda$2(JsonParser it) {
        return JsonParserExtensionsKt.readOptionalValue((JsonParser)it, BlockWithHashes.class);
    }

    private static final Optional getBlock$lambda$3(Class $responseType, JsonParser it) {
        return JsonParserExtensionsKt.readOptionalValue((JsonParser)it, (Class)$responseType);
    }

    private static final Optional getUncleBlockHeader$lambda$4(JsonParser it) {
        return JsonParserExtensionsKt.readOptionalValue((JsonParser)it, BlockWithHashes.class);
    }

    private static final Long getUncleBlocksCount$lambda$5(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    /*
     * Unable to fully structure code
     */
    private static final List callMany$lambda$8(JsonParser it) {
        block12: {
            block13: {
                block11: {
                    $this$readListOf$iv = it;
                    $i$f$readListOf = false;
                    if ($this$readListOf$iv.getCurrentToken() != JsonToken.VALUE_NULL) break block11;
                    v0 = CollectionsKt.emptyList();
                    break block12;
                }
                if ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY) break block13;
                v0 = CollectionsKt.emptyList();
                break block12;
            }
            ret$iv = new ArrayList<Result>();
            do {
                var4_4 = $this$readListOf$iv;
                var13_13 = ret$iv;
                $i$a$-readListOf-Provider$callMany$1$1 = false;
                result = null;
                $this$forEachObjectField$iv = it;
                $i$f$forEachObjectField = false;
                block7: while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                    field$iv = $this$forEachObjectField$iv.currentName();
                    $this$forEachObjectField$iv.nextToken();
                    field = field$iv;
                    $i$a$-forEachObjectField-Provider$callMany$1$1$1 = false;
                    var12_12 = field;
                    switch (var12_12.hashCode()) {
                        case -1005512447: {
                            if (!var12_12.equals("output")) {
                                ** break;
                            }
                            ** GOTO lbl40
                        }
                        case -934426595: {
                            if (!var12_12.equals("result")) {
                                ** break;
                            }
                            ** GOTO lbl40
                        }
                        case 96784904: {
                            if (var12_12.equals("error")) break;
                            ** break;
                        }
                        case 111972721: {
                            if (!var12_12.equals("value")) ** break;
lbl40:
                            // 3 sources

                            result = ResultKt.success((Object)JsonParserExtensionsKt.readBytes((JsonParser)it));
                            continue block7;
                        }
                    }
                    result = ResultKt.failure((Result.Error)new CallFailedError(it.getValueAsString()));
                    continue;
lbl44:
                    // 5 sources

                    it.skipChildren();
                }
                v1 = result;
                if (v1 == null) {
                    throw new IllegalStateException("No result or error found in response");
                }
                var13_13.add(v1);
            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
            v0 = ret$iv;
        }
        return v0;
    }

    private static final Long estimateGas$lambda$9(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final BigInteger getGasPrice$lambda$10(JsonParser it) {
        return JsonParserExtensionsKt.readHexBigInteger((JsonParser)it);
    }

    private static final BigInteger getBlobBaseFee$lambda$11(JsonParser it) {
        return JsonParserExtensionsKt.readHexBigInteger((JsonParser)it);
    }

    private static final BigInteger getMaxPriorityFeePerGas$lambda$12(JsonParser it) {
        return JsonParserExtensionsKt.readHexBigInteger((JsonParser)it);
    }

    private static final SyncStatus isNodeSyncing$lambda$13(JsonParser it) {
        return (SyncStatus)it.readValueAs(SyncStatus.class);
    }

    private static final Long getBlockTransactionCount$lambda$14(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final Long getTransactionCount$lambda$15(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final Optional getTransactionByHash$lambda$16(JsonParser it) {
        return JsonParserExtensionsKt.readOptionalValue((JsonParser)it, RPCTransaction.class);
    }

    private static final Optional getTransactionReceipt$lambda$17(JsonParser it) {
        return JsonParserExtensionsKt.readOptionalValue((JsonParser)it, TransactionReceipt.class);
    }

    private static final List getBlockReceipts$lambda$19$lambda$18(JsonParser $it, JsonParser $this$readOptionalValue) {
        return JsonParserExtensionsKt.readListOf((JsonParser)$it, TransactionReceipt.class);
    }

    private static final Optional getBlockReceipts$lambda$19(JsonParser it) {
        return JsonParserExtensionsKt.readOptionalValue((JsonParser)it, arg_0 -> Provider.getBlockReceipts$lambda$19$lambda$18(it, arg_0));
    }

    private static final PendingTransaction sendRawTransaction$lambda$20(Provider this$0, JsonParser it) {
        return new PendingTransaction(JsonParserExtensionsKt.readHash((JsonParser)it), this$0);
    }

    private static final Result fillTransaction$lambda$21(Provider this$0, CallRequest $callRequest) {
        return this$0.manuallyFillTransaction($callRequest);
    }

    private static final TransactionUnsigned fillTransaction$lambda$22(Provider this$0, JsonParser it) {
        TransactionUnsigned ret = null;
        while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)it)) {
            if (!JsonParserExtensionsKt.isField((JsonParser)it, (String)"raw")) continue;
            ret = TransactionUnsigned.Companion.rlpDecode(JsonParserExtensionsKt.readHexByteArray((JsonParser)it), this$0.getChainId());
        }
        TransactionUnsigned transactionUnsigned = ret;
        if (transactionUnsigned == null) {
            throw new IllegalStateException("Invalid response");
        }
        return transactionUnsigned;
    }

    private static final Result fillTransaction$lambda$23(Provider this$0, CallRequest $callRequest, RpcError err) {
        Result result;
        if (err.isMethodNotFound() || StringsKt.contains$default((CharSequence)err.getMessage(), (CharSequence)"did not match any variant", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)err.getMessage(), (CharSequence)"not supported", (boolean)false, (int)2, null)) {
            this$0.supportsFillTransaction = false;
            result = this$0.manuallyFillTransaction($callRequest);
        } else {
            result = ResultKt.failure((Result.Error)err);
        }
        return result;
    }

    private static final List getLogs$lambda$25(JsonParser it) {
        return JsonParserExtensionsKt.readListOf((JsonParser)it, Log.class);
    }

    private static final List watchLogs$lambda$27$lambda$26(JsonParser it) {
        return JsonParserExtensionsKt.readListOf((JsonParser)it, Log.class);
    }

    private static final FilterPoller watchLogs$lambda$27(Provider this$0, JsonParser p) {
        return new FilterPoller(p.getText(), this$0, Provider::watchLogs$lambda$27$lambda$26);
    }

    private static final List watchNewBlockHashes$lambda$29$lambda$28(JsonParser it) {
        return JsonParserExtensionsKt.readListOfHashes((JsonParser)it);
    }

    private static final FilterPoller watchNewBlockHashes$lambda$29(Provider this$0, JsonParser p) {
        return new FilterPoller(p.getText(), this$0, Provider::watchNewBlockHashes$lambda$29$lambda$28);
    }

    private static final List watchNewPendingTransactionHashes$lambda$31$lambda$30(JsonParser it) {
        return JsonParserExtensionsKt.readListOfHashes((JsonParser)it);
    }

    private static final FilterPoller watchNewPendingTransactionHashes$lambda$31(Provider this$0, JsonParser p) {
        return new FilterPoller(p.getText(), this$0, Provider::watchNewPendingTransactionHashes$lambda$31$lambda$30);
    }

    private static final List watchNewPendingTransactions$lambda$33$lambda$32(JsonParser it) {
        return JsonParserExtensionsKt.readListOf((JsonParser)it, RPCTransaction.class);
    }

    private static final FilterPoller watchNewPendingTransactions$lambda$33(Provider this$0, JsonParser p) {
        return new FilterPoller(p.getText(), this$0, Provider::watchNewPendingTransactions$lambda$33$lambda$32);
    }

    private static final Hash subscribeNewPendingTransactionHashes$lambda$34(JsonParser it) {
        return JsonParserExtensionsKt.readHash((JsonParser)it);
    }

    private static final RPCTransaction subscribeNewPendingTransactions$lambda$35(JsonParser it) {
        return (RPCTransaction)it.readValueAs(RPCTransaction.class);
    }

    private static final BlockWithHashes subscribeNewHeads$lambda$36(JsonParser it) {
        return (BlockWithHashes)it.readValueAs(BlockWithHashes.class);
    }

    private static final Log subscribeLogs$lambda$37(JsonParser it) {
        return (Log)it.readValueAs(Log.class);
    }

    private static final List getRawReceipts$lambda$38(JsonParser it) {
        return JsonParserExtensionsKt.readListOf((JsonParser)it, Bytes.class);
    }

    private static final Optional getRawTransaction$lambda$39(JsonParser it) {
        if (it.currentToken() == null) {
            return Optional.empty();
        }
        Bytes bytes = JsonParserExtensionsKt.readBytesEmptyAsNull((JsonParser)it);
        if (bytes == null) {
            return Optional.empty();
        }
        Bytes rlp = bytes;
        return Optional.of(rlp);
    }

    private static final Object traceCall$lambda$40(TracerConfig $config, JsonParser it) {
        return $config.getTracer().decodeResult(it);
    }

    private static final List traceCallMany$lambda$43(TracerConfig $config, JsonParser it) {
        List list;
        List list2;
        JsonParser $this$readListOf$iv = it;
        boolean $i$f$readListOf = false;
        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
            list2 = CollectionsKt.emptyList();
        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
            list2 = CollectionsKt.emptyList();
        } else {
            ArrayList<List> ret$iv = new ArrayList<List>();
            do {
                List list3;
                JsonParser jsonParser = $this$readListOf$iv;
                ArrayList<List> arrayList = ret$iv;
                boolean bl = false;
                JsonParser $this$readListOf$iv2 = it;
                boolean $i$f$readListOf2 = false;
                if ($this$readListOf$iv2.getCurrentToken() == JsonToken.VALUE_NULL) {
                    list3 = CollectionsKt.emptyList();
                } else if ($this$readListOf$iv2.nextToken() == JsonToken.END_ARRAY) {
                    list3 = CollectionsKt.emptyList();
                } else {
                    ArrayList<Object> ret$iv2 = new ArrayList<Object>();
                    do {
                        JsonParser jsonParser2 = $this$readListOf$iv2;
                        ArrayList<Object> arrayList2 = ret$iv2;
                        boolean bl2 = false;
                        arrayList2.add($config.getTracer().decodeResult(it));
                    } while ($this$readListOf$iv2.nextToken() != JsonToken.END_ARRAY);
                    list3 = ret$iv2;
                }
                arrayList.add(list3);
            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
            list2 = ret$iv;
        }
        if ((list = (List)CollectionsKt.firstOrNull((List)list2)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final Object traceTransaction$lambda$44(TracerConfig $config, JsonParser it) {
        return $config.getTracer().decodeResult(it);
    }

    /*
     * Unable to fully structure code
     */
    private static final List traceBlock$lambda$47(TracerConfig $config, JsonParser it) {
        block9: {
            block10: {
                block8: {
                    $this$readListOf$iv = it;
                    $i$f$readListOf = false;
                    if ($this$readListOf$iv.getCurrentToken() != JsonToken.VALUE_NULL) break block8;
                    v0 = CollectionsKt.emptyList();
                    break block9;
                }
                if ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY) break block10;
                v0 = CollectionsKt.emptyList();
                break block9;
            }
            ret$iv = new ArrayList<TxTraceResult>();
            do {
                var5_5 = $this$readListOf$iv;
                var16_16 = ret$iv;
                $i$a$-readListOf-Provider$traceBlock$1$1 = false;
                txHash = null;
                result = null;
                error = null;
                $this$forEachObjectField$iv = it;
                $i$f$forEachObjectField = false;
                while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                    block11: {
                        field$iv = $this$forEachObjectField$iv.currentName();
                        $this$forEachObjectField$iv.nextToken();
                        field = field$iv;
                        $i$a$-forEachObjectField-Provider$traceBlock$1$1$1 = false;
                        var15_15 = field;
                        switch (var15_15.hashCode()) {
                            case -934426595: {
                                if (var15_15.equals("result")) break;
                                ** break;
                            }
                            case 96784904: {
                                if (!var15_15.equals("error")) {
                                    ** break;
                                }
                                break block11;
                            }
                            case -860921422: {
                                if (!var15_15.equals("txHash")) ** break;
                                txHash = JsonParserExtensionsKt.readHash((JsonParser)it);
                                ** break;
                            }
                        }
                        result = $config.getTracer().decodeResult(it);
                        ** break;
                    }
                    error = it.getValueAsString();
lbl44:
                    // 7 sources

                }
                var16_16.add(new TxTraceResult(txHash, result, error));
            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
            v0 = ret$iv;
        }
        return v0;
    }

    private static final Boolean isListening$lambda$48(JsonParser it) {
        return (Boolean)it.readValueAs(Boolean.TYPE);
    }

    private static final Long getPeerCount$lambda$49(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Result<Provider, Error> fromUrl(@NotNull String url, @NotNull RpcClientConfig config, long chainId) {
        return Companion.fromUrl(url, config, chainId);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Result<Provider, Error> fromUrl(@NotNull String url, @NotNull RpcClientConfig config) {
        return Companion.fromUrl(url, config);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Result<Provider, Error> fromUrl(@NotNull String url) {
        return Companion.fromUrl(url);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/ethers/providers/Provider$Companion;", "", "<init>", "()V", "EMPTY_ARRAY", "", "[Ljava/lang/Object;", "PROTO_HTTPS", "Lkotlin/text/Regex;", "PROTO_WSS", "fromUrl", "Lio/ethers/core/Result;", "Lio/ethers/providers/Provider;", "Lio/ethers/providers/Provider$Error;", "url", "", "config", "Lio/ethers/providers/RpcClientConfig;", "chainId", "", "getChainId", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/providers/RpcError;", "client", "Lio/ethers/providers/JsonRpcClient;", "ethers-providers"})
    @SourceDebugExtension(value={"SMAP\nProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Provider.kt\nio/ethers/providers/Provider$Companion\n+ 2 Result.kt\nio/ethers/core/ResultKt\n*L\n1#1,699:1\n303#2,4:700\n*S KotlinDebug\n*F\n+ 1 Provider.kt\nio/ethers/providers/Provider$Companion\n*L\n688#1:700,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Result<Provider, Error> fromUrl(@NotNull String url, @NotNull RpcClientConfig config, long chainId) {
            JsonRpcClient jsonRpcClient;
            CharSequence charSequence = url;
            if (PROTO_HTTPS.matches(charSequence)) {
                jsonRpcClient = new HttpClient(url, config);
            } else {
                charSequence = url;
                if (PROTO_WSS.matches(charSequence)) {
                    jsonRpcClient = new WsClient(url, config);
                } else {
                    return ResultKt.failure((Result.Error)new UnsupportedUrlProtocol(url));
                }
            }
            JsonRpcClient client = jsonRpcClient;
            long chainId2 = chainId;
            if (chainId2 == -1L) {
                Result<Long, RpcError> $this$unwrapOrReturn$iv = this.getChainId(client).sendAwait();
                boolean $i$f$unwrapOrReturn = false;
                if (!ResultKt.isSuccess($this$unwrapOrReturn$iv)) {
                    RpcError it = (RpcError)((Result.Failure)$this$unwrapOrReturn$iv).unwrapError();
                    boolean bl = false;
                    return ResultKt.failure((Result.Error)new UnableToGetChainId(url, it));
                }
                chainId2 = ((Number)((Result.Success)$this$unwrapOrReturn$iv).getValue()).longValue();
            }
            return ResultKt.success((Object)new Provider(client, chainId2));
        }

        public static /* synthetic */ Result fromUrl$default(Companion companion, String string, RpcClientConfig rpcClientConfig, long l, int n, Object object) {
            if ((n & 2) != 0) {
                rpcClientConfig = new RpcClientConfig();
            }
            if ((n & 4) != 0) {
                l = -1L;
            }
            return companion.fromUrl(string, rpcClientConfig, l);
        }

        private final RpcRequest<Long, RpcError> getChainId(JsonRpcClient client) {
            return new RpcCall<Long>(client, "eth_chainId", EMPTY_ARRAY, Companion::getChainId$lambda$1);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Result<Provider, Error> fromUrl(@NotNull String url, @NotNull RpcClientConfig config) {
            return io.ethers.providers.Provider$Companion.fromUrl$default(this, url, config, 0L, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Result<Provider, Error> fromUrl(@NotNull String url) {
            return io.ethers.providers.Provider$Companion.fromUrl$default(this, url, null, 0L, 6, null);
        }

        private static final Long getChainId$lambda$1(JsonParser it) {
            return JsonParserExtensionsKt.readHexLong((JsonParser)it);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0002\u0002\u0003\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lio/ethers/providers/Provider$Error;", "Lio/ethers/core/Result$Error;", "Lio/ethers/providers/Provider$UnableToGetChainId;", "Lio/ethers/providers/Provider$UnsupportedUrlProtocol;", "ethers-providers"})
    public static interface Error
    extends Result.Error {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/ethers/providers/Provider$UnableToGetChainId;", "Lio/ethers/providers/Provider$Error;", "url", "", "error", "Lio/ethers/providers/RpcError;", "<init>", "(Ljava/lang/String;Lio/ethers/providers/RpcError;)V", "getUrl", "()Ljava/lang/String;", "getError", "()Lio/ethers/providers/RpcError;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "ethers-providers"})
    public static final class UnableToGetChainId
    implements Error {
        @NotNull
        private final String url;
        @NotNull
        private final RpcError error;

        public UnableToGetChainId(@NotNull String url, @NotNull RpcError error) {
            this.url = url;
            this.error = error;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final RpcError getError() {
            return this.error;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final RpcError component2() {
            return this.error;
        }

        @NotNull
        public final UnableToGetChainId copy(@NotNull String url, @NotNull RpcError error) {
            return new UnableToGetChainId(url, error);
        }

        public static /* synthetic */ UnableToGetChainId copy$default(UnableToGetChainId unableToGetChainId, String string, RpcError rpcError, int n, Object object) {
            if ((n & 1) != 0) {
                string = unableToGetChainId.url;
            }
            if ((n & 2) != 0) {
                rpcError = unableToGetChainId.error;
            }
            return unableToGetChainId.copy(string, rpcError);
        }

        @NotNull
        public String toString() {
            return "UnableToGetChainId(url=" + this.url + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + this.error.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnableToGetChainId)) {
                return false;
            }
            UnableToGetChainId unableToGetChainId = (UnableToGetChainId)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)unableToGetChainId.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)unableToGetChainId.error);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/ethers/providers/Provider$UnsupportedUrlProtocol;", "Lio/ethers/providers/Provider$Error;", "url", "", "<init>", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "ethers-providers"})
    public static final class UnsupportedUrlProtocol
    implements Error {
        @NotNull
        private final String url;

        public UnsupportedUrlProtocol(@NotNull String url) {
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final UnsupportedUrlProtocol copy(@NotNull String url) {
            return new UnsupportedUrlProtocol(url);
        }

        public static /* synthetic */ UnsupportedUrlProtocol copy$default(UnsupportedUrlProtocol unsupportedUrlProtocol, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = unsupportedUrlProtocol.url;
            }
            return unsupportedUrlProtocol.copy(string);
        }

        @NotNull
        public String toString() {
            return "UnsupportedUrlProtocol(url=" + this.url + ")";
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnsupportedUrlProtocol)) {
                return false;
            }
            UnsupportedUrlProtocol unsupportedUrlProtocol = (UnsupportedUrlProtocol)other;
            return Intrinsics.areEqual((Object)this.url, (Object)unsupportedUrlProtocol.url);
        }
    }
}

