/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto.bip39;

import io.ethers.crypto.Hashing;
import io.ethers.crypto.bip39.MnemonicWordList;
import io.ethers.crypto.bip39.MnemonicWordListEnglish;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B!\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u001b\b\u0017\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0004H\u0007J\u0006\u0010\u0012\u001a\u00020\u0010J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lio/ethers/crypto/bip39/MnemonicCode;", "", "words", "", "", "wordList", "Lio/ethers/crypto/bip39/MnemonicWordList;", "<init>", "(Ljava/util/List;Lio/ethers/crypto/bip39/MnemonicWordList;)V", "wordString", "(Ljava/lang/String;Lio/ethers/crypto/bip39/MnemonicWordList;)V", "getWords", "()Ljava/util/List;", "getWordList", "()Lio/ethers/crypto/bip39/MnemonicWordList;", "getSeed", "", "passphrase", "getEntropy", "equals", "", "other", "hashCode", "", "Companion", "ethers-crypto"})
public final class MnemonicCode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> words;
    @NotNull
    private final MnemonicWordList wordList;
    private static final int SEED_KEY_SIZE = 512;
    private static final int SEED_ITERATIONS = 2048;

    @JvmOverloads
    public MnemonicCode(@NotNull List<String> words, @NotNull MnemonicWordList wordList) {
        this.words = words;
        this.wordList = wordList;
        if (this.words.isEmpty()) {
            throw new IllegalArgumentException("Word list is empty.");
        }
        if (this.words.size() % 3 > 0) {
            throw new IllegalArgumentException("Word list size must be multiple of three words.");
        }
        this.getEntropy();
    }

    public /* synthetic */ MnemonicCode(List list, MnemonicWordList mnemonicWordList, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mnemonicWordList = MnemonicWordListEnglish.INSTANCE;
        }
        this(list, mnemonicWordList);
    }

    @NotNull
    public final List<String> getWords() {
        return this.words;
    }

    @NotNull
    public final MnemonicWordList getWordList() {
        return this.wordList;
    }

    @JvmOverloads
    public MnemonicCode(@NotNull String wordString, @NotNull MnemonicWordList wordList) {
        char[] cArray = new char[]{wordList.getSeparator()};
        this(StringsKt.split$default((CharSequence)wordString, (char[])cArray, (boolean)false, (int)0, (int)6, null), wordList);
    }

    public /* synthetic */ MnemonicCode(String string, MnemonicWordList mnemonicWordList, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mnemonicWordList = MnemonicWordListEnglish.INSTANCE;
        }
        this(string, mnemonicWordList);
    }

    @JvmOverloads
    @NotNull
    public final byte[] getSeed(@NotNull String passphrase) {
        String string = "mnemonic%s";
        Object[] objectArray = new Object[]{passphrase};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String salt = string2;
        PKCS5S2ParametersGenerator $this$getSeed_u24lambda_u240 = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
        boolean bl = false;
        byte[] byArray = CollectionsKt.joinToString$default((Iterable)this.words, (CharSequence)String.valueOf(this.wordList.getSeparator()), null, null, (int)0, null, null, (int)62, null).getBytes(StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = salt.getBytes(StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        $this$getSeed_u24lambda_u240.init(byArray, byArray2, 2048);
        CipherParameters cipherParameters = $this$getSeed_u24lambda_u240.generateDerivedParameters(512);
        Intrinsics.checkNotNull((Object)cipherParameters, (String)"null cannot be cast to non-null type org.bouncycastle.crypto.params.KeyParameter");
        return ((KeyParameter)cipherParameters).getKey();
    }

    public static /* synthetic */ byte[] getSeed$default(MnemonicCode mnemonicCode, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return mnemonicCode.getSeed(string);
    }

    @NotNull
    public final byte[] getEntropy() {
        int ndx;
        int concatLenBits = this.words.size() * 11;
        boolean[] concatBits = new boolean[concatLenBits];
        Iterator iterator = ((Iterable)this.words).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int wordIndex = n++;
            String word = (String)iterator.next();
            ndx = CollectionsKt.binarySearch$default(this.wordList.getWords(), (Comparable)((Comparable)((Object)word)), (int)0, (int)0, (int)6, null);
            if (ndx < 0) {
                throw new RuntimeException("Invalid mnemonic word '" + word + "' for provided word list '" + this.wordList + "'");
            }
            for (int ii = 0; ii < 11; ++ii) {
                concatBits[wordIndex * 11 + ii] = (ndx & 1 << 10 - ii) != 0;
            }
        }
        int checksumLengthBits = concatLenBits / 33;
        int entropyLengthBits = concatLenBits - checksumLengthBits;
        byte[] entropy = new byte[entropyLengthBits / 8];
        ndx = entropy.length;
        for (int ii = 0; ii < ndx; ++ii) {
            for (int jj = 0; jj < 8; ++jj) {
                if (!concatBits[ii * 8 + jj]) continue;
                entropy[ii] = (byte)(entropy[ii] | 1 << 7 - jj);
            }
        }
        byte[] hash = new SHA256.Digest().digest(entropy);
        boolean[] hashBits = MnemonicCode.Companion.bytesToBits(hash);
        for (int i = 0; i < checksumLengthBits; ++i) {
            if (concatBits[entropyLengthBits + i] == hashBits[i]) continue;
            throw new RuntimeException("Checksum mismatch, invalid mnemonic");
        }
        return entropy;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.crypto.bip39.MnemonicCode");
        MnemonicCode cfr_ignored_0 = (MnemonicCode)other;
        return Intrinsics.areEqual(this.words, ((MnemonicCode)other).words);
    }

    public int hashCode() {
        return ((Object)this.words).hashCode();
    }

    @JvmOverloads
    public MnemonicCode(@NotNull List<String> words) {
        this(words, null, 2, null);
    }

    @JvmOverloads
    public MnemonicCode(@NotNull String wordString) {
        this(wordString, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final byte[] getSeed() {
        return MnemonicCode.getSeed$default(this, null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MnemonicCode fromRandomEntropy(int bitsOfEntropy, @NotNull MnemonicWordList wordList) {
        return Companion.fromRandomEntropy(bitsOfEntropy, wordList);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MnemonicCode fromEntropy(@NotNull byte[] entropy, @NotNull MnemonicWordList wordList) {
        return Companion.fromEntropy(entropy, wordList);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MnemonicCode fromRandomEntropy(int bitsOfEntropy) {
        return Companion.fromRandomEntropy(bitsOfEntropy);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MnemonicCode fromRandomEntropy() {
        return Companion.fromRandomEntropy();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final MnemonicCode fromEntropy(@NotNull byte[] entropy) {
        return Companion.fromEntropy(entropy);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/ethers/crypto/bip39/MnemonicCode$Companion;", "", "<init>", "()V", "SEED_KEY_SIZE", "", "SEED_ITERATIONS", "fromRandomEntropy", "Lio/ethers/crypto/bip39/MnemonicCode;", "bitsOfEntropy", "wordList", "Lio/ethers/crypto/bip39/MnemonicWordList;", "fromEntropy", "entropy", "", "bytesToBits", "", "data", "ethers-crypto"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MnemonicCode fromRandomEntropy(int bitsOfEntropy, @NotNull MnemonicWordList wordList) {
            byte[] entropy = new byte[bitsOfEntropy / 8];
            Hashing.secureRandom().nextBytes(entropy);
            return this.fromEntropy(entropy, wordList);
        }

        public static /* synthetic */ MnemonicCode fromRandomEntropy$default(Companion companion, int n, MnemonicWordList mnemonicWordList, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 256;
            }
            if ((n2 & 2) != 0) {
                mnemonicWordList = MnemonicWordListEnglish.INSTANCE;
            }
            return companion.fromRandomEntropy(n, mnemonicWordList);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MnemonicCode fromEntropy(@NotNull byte[] entropy, @NotNull MnemonicWordList wordList) {
            if (entropy.length == 0) {
                throw new IllegalArgumentException("Entropy is empty.");
            }
            if (entropy.length % 4 > 0) {
                throw new IllegalArgumentException("Entropy length not multiple of 32 bits.");
            }
            if (entropy.length < 16) {
                throw new IllegalArgumentException("Entropy length too short, must be at least 128 bits.");
            }
            if (entropy.length > 32) {
                throw new IllegalArgumentException("Entropy length too long, must be at most 256 bits.");
            }
            byte[] hash = new SHA256.Digest().digest(entropy);
            boolean[] hashBits = this.bytesToBits(hash);
            boolean[] entropyBits = this.bytesToBits(entropy);
            int checksumLengthBits = entropyBits.length / 32;
            boolean[] concatBits = new boolean[entropyBits.length + checksumLengthBits];
            System.arraycopy(entropyBits, 0, concatBits, 0, entropyBits.length);
            System.arraycopy(hashBits, 0, concatBits, entropyBits.length, checksumLengthBits);
            ArrayList<String> words = new ArrayList<String>();
            int nwords = concatBits.length / 11;
            for (int i = 0; i < nwords; ++i) {
                int index = 0;
                for (int j = 0; j < 11; ++j) {
                    index <<= 1;
                    if (!concatBits[i * 11 + j]) continue;
                    index |= 1;
                }
                words.add(wordList.get(index));
            }
            return new MnemonicCode(words, null, 2, null);
        }

        public static /* synthetic */ MnemonicCode fromEntropy$default(Companion companion, byte[] byArray, MnemonicWordList mnemonicWordList, int n, Object object) {
            if ((n & 2) != 0) {
                mnemonicWordList = MnemonicWordListEnglish.INSTANCE;
            }
            return companion.fromEntropy(byArray, mnemonicWordList);
        }

        private final boolean[] bytesToBits(byte[] data) {
            boolean[] bits = new boolean[data.length * 8];
            int n = data.length;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < 8; ++j) {
                    bits[i * 8 + j] = (data[i] & 1 << 7 - j) != 0;
                }
            }
            return bits;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MnemonicCode fromRandomEntropy(int bitsOfEntropy) {
            return io.ethers.crypto.bip39.MnemonicCode$Companion.fromRandomEntropy$default(this, bitsOfEntropy, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MnemonicCode fromRandomEntropy() {
            return io.ethers.crypto.bip39.MnemonicCode$Companion.fromRandomEntropy$default(this, 0, null, 3, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final MnemonicCode fromEntropy(@NotNull byte[] entropy) {
            return io.ethers.crypto.bip39.MnemonicCode$Companion.fromEntropy$default(this, entropy, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

