/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto.bip32;

import io.ethers.crypto.Hashing;
import io.ethers.crypto.Secp256k1;
import io.ethers.crypto.bip32.HDPath;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0013J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00030\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\bR\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lio/ethers/crypto/bip32/ExtendedSigningKey;", "", "privateKey", "", "chainCode", "<init>", "([B[B)V", "getChainCode", "()[B", "signingKey", "Lio/ethers/crypto/Secp256k1$SigningKey;", "getSigningKey", "()Lio/ethers/crypto/Secp256k1$SigningKey;", "pubCompressed", "kotlin.jvm.PlatformType", "getPubCompressed", "pubCompressed$delegate", "Lkotlin/Lazy;", "fingerprint", "", "getFingerprint", "()I", "fingerprint$delegate", "derivePath", "path", "Lio/ethers/crypto/bip32/HDPath;", "deriveChild", "index", "equals", "", "other", "hashCode", "Companion", "ethers-crypto"})
public final class ExtendedSigningKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] chainCode;
    @NotNull
    private final Secp256k1.SigningKey signingKey;
    @NotNull
    private final Lazy pubCompressed$delegate;
    @NotNull
    private final Lazy fingerprint$delegate;
    @NotNull
    private static final byte[] PREFIX_KEY_BYTES;

    public ExtendedSigningKey(@NotNull byte[] privateKey, @NotNull byte[] chainCode) {
        this.chainCode = chainCode;
        this.signingKey = new Secp256k1.SigningKey(privateKey);
        if (privateKey.length != 32) {
            throw new IllegalArgumentException("Invalid private key length. Should be exactly 32 bytes, got " + privateKey.length);
        }
        if (this.chainCode.length != 32) {
            throw new IllegalArgumentException("Invalid chain code length. Should be exactly 32 bytes, got " + this.chainCode.length);
        }
        this.pubCompressed$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ExtendedSigningKey.pubCompressed_delegate$lambda$0(this));
        this.fingerprint$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ExtendedSigningKey.fingerprint_delegate$lambda$1(this));
    }

    @NotNull
    public final byte[] getChainCode() {
        return this.chainCode;
    }

    @NotNull
    public final Secp256k1.SigningKey getSigningKey() {
        return this.signingKey;
    }

    private final byte[] getPubCompressed() {
        Lazy lazy = this.pubCompressed$delegate;
        return (byte[])lazy.getValue();
    }

    public final int getFingerprint() {
        Lazy lazy = this.fingerprint$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final ExtendedSigningKey derivePath(@NotNull HDPath path) {
        ExtendedSigningKey key = this;
        int n = path.getDepth();
        for (int depth = 0; depth < n; ++depth) {
            key = key.deriveChild(path.indexAtDepth(depth));
        }
        return key;
    }

    @NotNull
    public final ExtendedSigningKey deriveChild(int index) {
        ByteBuffer byteBuffer;
        ByteBuffer buff = ByteBuffer.allocate(37);
        if (HDPath.Companion.isHardened(index)) {
            buff.position(1);
            byteBuffer = buff.put(this.signingKey.getPrivateKey());
        } else {
            byteBuffer = buff.put(this.getPubCompressed());
        }
        buff.putInt(index);
        byte[] hmac = Hashing.hmacSha512(this.chainCode, buff.array());
        byte[] privateKeyNew = Secp256k1.INSTANCE.privateKeyAdd(this.signingKey.getPrivateKey(), ArraysKt.copyOfRange((byte[])hmac, (int)0, (int)32));
        byte[] chainCodeNew = ArraysKt.copyOfRange((byte[])hmac, (int)32, (int)64);
        return new ExtendedSigningKey(privateKeyNew, chainCodeNew);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.crypto.bip32.ExtendedSigningKey");
        ExtendedSigningKey cfr_ignored_0 = (ExtendedSigningKey)other;
        if (!Arrays.equals(this.chainCode, ((ExtendedSigningKey)other).chainCode)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signingKey, (Object)((ExtendedSigningKey)other).signingKey);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.chainCode);
        result = 31 * result + this.signingKey.hashCode();
        return result;
    }

    private static final byte[] pubCompressed_delegate$lambda$0(ExtendedSigningKey this$0) {
        return this$0.signingKey.getPublicPoint().getEncoded(true);
    }

    private static final int fingerprint_delegate$lambda$1(ExtendedSigningKey this$0) {
        byte[] id = Hashing.INSTANCE.sha256ripe160(this$0.getPubCompressed());
        return id[3] & 0xFF | (id[2] & 0xFF) << 8 | (id[1] & 0xFF) << 16 | (id[0] & 0xFF) << 24;
    }

    @JvmStatic
    @NotNull
    public static final ExtendedSigningKey fromSeed(@NotNull byte[] seed) {
        return Companion.fromSeed(seed);
    }

    static {
        byte[] byArray = "Bitcoin seed".getBytes(StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        PREFIX_KEY_BYTES = byArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/ethers/crypto/bip32/ExtendedSigningKey$Companion;", "", "<init>", "()V", "PREFIX_KEY_BYTES", "", "fromSeed", "Lio/ethers/crypto/bip32/ExtendedSigningKey;", "seed", "ethers-crypto"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExtendedSigningKey fromSeed(@NotNull byte[] seed) {
            byte[] hmac = Hashing.hmacSha512(PREFIX_KEY_BYTES, seed);
            return new ExtendedSigningKey(ArraysKt.copyOfRange((byte[])hmac, (int)0, (int)32), ArraysKt.copyOfRange((byte[])hmac, (int)32, (int)64));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

