/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto;

import java.security.SecureRandom;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0007J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/ethers/crypto/Hashing;", "", "<init>", "()V", "MESSAGE_PREFIX", "", "VERSIONED_HASH_VERSION_KZG", "", "secureRandom", "Ljava/security/SecureRandom;", "getSecureRandom", "()Ljava/security/SecureRandom;", "secureRandom$delegate", "Lkotlin/Lazy;", "hashMessage", "message", "keccak256", "data", "hmacSha512", "key", "input", "sha256ripe160", "blobVersionedHash", "commitment", "ethers-crypto"})
public final class Hashing {
    @NotNull
    public static final Hashing INSTANCE = new Hashing();
    @NotNull
    private static final byte[] MESSAGE_PREFIX;
    private static final byte VERSIONED_HASH_VERSION_KZG = 1;
    @NotNull
    private static final Lazy secureRandom$delegate;

    private Hashing() {
    }

    private final SecureRandom getSecureRandom() {
        Lazy lazy = secureRandom$delegate;
        return (SecureRandom)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final SecureRandom secureRandom() {
        return INSTANCE.getSecureRandom();
    }

    @JvmStatic
    @NotNull
    public static final byte[] hashMessage(@NotNull byte[] message) {
        String string = String.valueOf(message.length);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] messageSizeString = byArray;
        byte[] input = new byte[MESSAGE_PREFIX.length + messageSizeString.length + message.length];
        System.arraycopy(MESSAGE_PREFIX, 0, input, 0, MESSAGE_PREFIX.length);
        System.arraycopy(messageSizeString, 0, input, MESSAGE_PREFIX.length, messageSizeString.length);
        System.arraycopy(message, 0, input, MESSAGE_PREFIX.length + messageSizeString.length, message.length);
        return new Keccak.Digest256().digest(input);
    }

    @JvmStatic
    @NotNull
    public static final byte[] keccak256(@NotNull byte[] data) {
        return new Keccak.Digest256().digest(data);
    }

    @JvmStatic
    @NotNull
    public static final byte[] hmacSha512(@NotNull byte[] key, @NotNull byte[] input) {
        byte[] out = new byte[64];
        HMac $this$hmacSha512_u24lambda_u241 = new HMac((Digest)new SHA512Digest());
        boolean bl = false;
        $this$hmacSha512_u24lambda_u241.init((CipherParameters)new KeyParameter(key));
        $this$hmacSha512_u24lambda_u241.update(input, 0, input.length);
        $this$hmacSha512_u24lambda_u241.doFinal(out, 0);
        return out;
    }

    @NotNull
    public final byte[] sha256ripe160(@NotNull byte[] input) {
        byte[] out = new byte[20];
        RIPEMD160Digest $this$sha256ripe160_u24lambda_u242 = new RIPEMD160Digest();
        boolean bl = false;
        byte[] sha256 = new SHA256.Digest().digest(input);
        $this$sha256ripe160_u24lambda_u242.update(sha256, 0, sha256.length);
        $this$sha256ripe160_u24lambda_u242.doFinal(out, 0);
        return out;
    }

    @JvmStatic
    @NotNull
    public static final byte[] blobVersionedHash(@NotNull byte[] commitment) {
        byte[] hash = new SHA256.Digest().digest(commitment);
        hash[0] = 1;
        return hash;
    }

    private static final SecureRandom secureRandom_delegate$lambda$0() {
        return new SecureRandom();
    }

    static {
        String string = "\u0019Ethereum Signed Message:\n";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        MESSAGE_PREFIX = byArray;
        secureRandom$delegate = LazyKt.lazy(Hashing::secureRandom_delegate$lambda$0);
    }
}

