/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.utils;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007J \u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Lio/ethers/core/utils/GasUtils;", "", "<init>", "()V", "getEffectiveGasTip", "Ljava/math/BigInteger;", "baseFee", "gasTipCap", "gasFeeCap", "getEffectiveGasPrice", "ethers-core"})
public final class GasUtils {
    @NotNull
    public static final GasUtils INSTANCE = new GasUtils();

    private GasUtils() {
    }

    @JvmStatic
    @NotNull
    public static final BigInteger getEffectiveGasTip(@NotNull BigInteger baseFee, @NotNull BigInteger gasTipCap, @NotNull BigInteger gasFeeCap) {
        BigInteger bigInteger = gasFeeCap.subtract(baseFee);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"subtract(...)");
        BigInteger possibleTip = bigInteger;
        BigInteger maxTip = gasTipCap;
        return maxTip.min(possibleTip);
    }

    @JvmStatic
    @NotNull
    public static final BigInteger getEffectiveGasPrice(@NotNull BigInteger baseFee, @NotNull BigInteger gasTipCap, @NotNull BigInteger gasFeeCap) {
        BigInteger bigInteger = baseFee.add(GasUtils.getEffectiveGasTip(baseFee, gasTipCap, gasFeeCap));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"add(...)");
        return bigInteger;
    }
}

