/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0000J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lio/ethers/core/utils/EthUnit;", "", "decimals", "", "<init>", "(I)V", "getDecimals", "()I", "toWei", "Ljava/math/BigDecimal;", "amount", "", "", "", "Ljava/math/BigInteger;", "toGwei", "toEther", "fromWei", "fromGwei", "fromEther", "convert", "toUnit", "component1", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "ethers-core"})
public final class EthUnit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int decimals;
    @JvmField
    @NotNull
    public static final EthUnit WEI = new EthUnit(0);
    @JvmField
    @NotNull
    public static final EthUnit KWEI = new EthUnit(3);
    @JvmField
    @NotNull
    public static final EthUnit MWEI = new EthUnit(6);
    @JvmField
    @NotNull
    public static final EthUnit GWEI = new EthUnit(9);
    @JvmField
    @NotNull
    public static final EthUnit SZABO = new EthUnit(12);
    @JvmField
    @NotNull
    public static final EthUnit FINNEY = new EthUnit(15);
    @JvmField
    @NotNull
    public static final EthUnit ETHER = new EthUnit(18);
    @JvmField
    @NotNull
    public static final EthUnit KETHER = new EthUnit(21);
    @JvmField
    @NotNull
    public static final EthUnit METHER = new EthUnit(24);
    @JvmField
    @NotNull
    public static final EthUnit GETHER = new EthUnit(27);

    public EthUnit(int decimals) {
        this.decimals = decimals;
    }

    public final int getDecimals() {
        return this.decimals;
    }

    @NotNull
    public final BigDecimal toWei(int amount) {
        return this.convert(amount, WEI);
    }

    @NotNull
    public final BigDecimal toWei(long amount) {
        return this.convert(amount, WEI);
    }

    @NotNull
    public final BigDecimal toWei(double amount) {
        return this.convert(amount, WEI);
    }

    @NotNull
    public final BigDecimal toWei(@NotNull String amount) {
        return this.convert(amount, WEI);
    }

    @NotNull
    public final BigDecimal toWei(@NotNull BigInteger amount) {
        return this.convert(amount, WEI);
    }

    @NotNull
    public final BigDecimal toWei(@NotNull BigDecimal amount) {
        return this.convert(amount, WEI);
    }

    @NotNull
    public final BigDecimal toGwei(int amount) {
        return this.convert(amount, GWEI);
    }

    @NotNull
    public final BigDecimal toGwei(long amount) {
        return this.convert(amount, GWEI);
    }

    @NotNull
    public final BigDecimal toGwei(double amount) {
        return this.convert(amount, GWEI);
    }

    @NotNull
    public final BigDecimal toGwei(@NotNull String amount) {
        return this.convert(amount, GWEI);
    }

    @NotNull
    public final BigDecimal toGwei(@NotNull BigInteger amount) {
        return this.convert(amount, GWEI);
    }

    @NotNull
    public final BigDecimal toGwei(@NotNull BigDecimal amount) {
        return this.convert(amount, GWEI);
    }

    @NotNull
    public final BigDecimal toEther(int amount) {
        return this.convert(amount, ETHER);
    }

    @NotNull
    public final BigDecimal toEther(long amount) {
        return this.convert(amount, ETHER);
    }

    @NotNull
    public final BigDecimal toEther(double amount) {
        return this.convert(amount, ETHER);
    }

    @NotNull
    public final BigDecimal toEther(@NotNull String amount) {
        return this.convert(amount, ETHER);
    }

    @NotNull
    public final BigDecimal toEther(@NotNull BigInteger amount) {
        return this.convert(amount, ETHER);
    }

    @NotNull
    public final BigDecimal toEther(@NotNull BigDecimal amount) {
        return this.convert(amount, ETHER);
    }

    @NotNull
    public final BigDecimal fromWei(int amount) {
        return WEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromWei(long amount) {
        return WEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromWei(double amount) {
        return WEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromWei(@NotNull String amount) {
        return WEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromWei(@NotNull BigInteger amount) {
        return WEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromWei(@NotNull BigDecimal amount) {
        return WEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromGwei(int amount) {
        return GWEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromGwei(long amount) {
        return GWEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromGwei(double amount) {
        return GWEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromGwei(@NotNull String amount) {
        return GWEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromGwei(@NotNull BigInteger amount) {
        return GWEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromGwei(@NotNull BigDecimal amount) {
        return GWEI.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromEther(int amount) {
        return ETHER.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromEther(long amount) {
        return ETHER.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromEther(double amount) {
        return ETHER.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromEther(@NotNull String amount) {
        return ETHER.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromEther(@NotNull BigInteger amount) {
        return ETHER.convert(amount, this);
    }

    @NotNull
    public final BigDecimal fromEther(@NotNull BigDecimal amount) {
        return ETHER.convert(amount, this);
    }

    @NotNull
    public final BigDecimal convert(int amount, @NotNull EthUnit toUnit) {
        BigDecimal bigDecimal = BigDecimal.valueOf(amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.convert(bigDecimal, toUnit);
    }

    @NotNull
    public final BigDecimal convert(long amount, @NotNull EthUnit toUnit) {
        BigDecimal bigDecimal = BigDecimal.valueOf(amount);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return this.convert(bigDecimal, toUnit);
    }

    @NotNull
    public final BigDecimal convert(double amount, @NotNull EthUnit toUnit) {
        return this.convert(new BigDecimal(String.valueOf(amount)), toUnit);
    }

    @NotNull
    public final BigDecimal convert(@NotNull String amount, @NotNull EthUnit toUnit) {
        return this.convert(new BigDecimal(amount), toUnit);
    }

    @NotNull
    public final BigDecimal convert(@NotNull BigInteger amount, @NotNull EthUnit toUnit) {
        BigInteger bigInteger = amount;
        int n = toUnit.decimals - this.decimals;
        MathContext mathContext = MathContext.UNLIMITED;
        return new BigDecimal(bigInteger, n, mathContext);
    }

    @NotNull
    public final BigDecimal convert(@NotNull BigDecimal amount, @NotNull EthUnit toUnit) {
        return amount.movePointRight(this.decimals - toUnit.decimals).setScale(toUnit.decimals, RoundingMode.DOWN);
    }

    public final int component1() {
        return this.decimals;
    }

    @NotNull
    public final EthUnit copy(int decimals) {
        return new EthUnit(decimals);
    }

    public static /* synthetic */ EthUnit copy$default(EthUnit ethUnit, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = ethUnit.decimals;
        }
        return ethUnit.copy(n);
    }

    @NotNull
    public String toString() {
        return "EthUnit(decimals=" + this.decimals + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.decimals);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EthUnit)) {
            return false;
        }
        EthUnit ethUnit = (EthUnit)other;
        return this.decimals == ethUnit.decimals;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/ethers/core/utils/EthUnit$Companion;", "", "<init>", "()V", "WEI", "Lio/ethers/core/utils/EthUnit;", "KWEI", "MWEI", "GWEI", "SZABO", "FINNEY", "ETHER", "KETHER", "METHER", "GETHER", "ethers-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

