/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.transaction;

import io.ethers.core.types.AccessList;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Signature;
import io.ethers.core.types.transaction.ChainId;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.core.types.transaction.TxType;
import io.ethers.crypto.Hashing;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 Q2\u00020\u0001:\u0002PQBy\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017Bi\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0018J\"\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u001a\u0010:\u001a\u00020;2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000208H\u0016J\u0012\u0010<\u001a\u00020;2\b\u00105\u001a\u0004\u0018\u000106H\u0002J\t\u0010=\u001a\u00020\u0003H\u00c6\u0003J\t\u0010>\u001a\u00020\u0005H\u00c6\u0003J\t\u0010?\u001a\u00020\u0007H\u00c6\u0003J\t\u0010@\u001a\u00020\u0007H\u00c6\u0003J\t\u0010A\u001a\u00020\u0005H\u00c6\u0003J\t\u0010B\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010C\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\t\u0010D\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\t\u0010F\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u0015H\u00c6\u0003J\u0091\u0001\u0010I\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\r\u001a\u00020\u00072\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00052\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00c6\u0001J\u0013\u0010J\u001a\u0002082\b\u0010K\u001a\u0004\u0018\u00010LH\u00d6\u0003J\t\u0010M\u001a\u00020;H\u00d6\u0001J\t\u0010N\u001a\u00020OH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001eR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0011\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001cR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001cR\u0014\u0010-\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006R"}, d2={"Lio/ethers/core/types/transaction/TxBlob;", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "to", "Lio/ethers/core/types/Address;", "value", "Ljava/math/BigInteger;", "nonce", "", "gas", "gasFeeCap", "gasTipCap", "data", "Lio/ethers/core/types/Bytes;", "chainId", "accessList", "", "Lio/ethers/core/types/AccessList$Item;", "blobFeeCap", "blobVersionedHashes", "Lio/ethers/core/types/Hash;", "sidecar", "Lio/ethers/core/types/transaction/TxBlob$Sidecar;", "<init>", "(Lio/ethers/core/types/Address;Ljava/math/BigInteger;JJLjava/math/BigInteger;Ljava/math/BigInteger;Lio/ethers/core/types/Bytes;JLjava/util/List;Ljava/math/BigInteger;Ljava/util/List;Lio/ethers/core/types/transaction/TxBlob$Sidecar;)V", "(Lio/ethers/core/types/Address;Ljava/math/BigInteger;JJLjava/math/BigInteger;Ljava/math/BigInteger;Lio/ethers/core/types/Bytes;JLjava/util/List;Ljava/math/BigInteger;Lio/ethers/core/types/transaction/TxBlob$Sidecar;)V", "getTo", "()Lio/ethers/core/types/Address;", "getValue", "()Ljava/math/BigInteger;", "getNonce", "()J", "getGas", "getGasFeeCap", "getGasTipCap", "getData", "()Lio/ethers/core/types/Bytes;", "getChainId", "getAccessList", "()Ljava/util/List;", "getBlobFeeCap", "getBlobVersionedHashes", "getSidecar", "()Lio/ethers/core/types/transaction/TxBlob$Sidecar;", "gasPrice", "getGasPrice", "type", "Lio/ethers/core/types/transaction/TxType;", "getType", "()Lio/ethers/core/types/transaction/TxType;", "rlpEncodeEnveloped", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "signature", "Lio/ethers/core/types/Signature;", "hashEncoding", "", "rlpEncodeFields", "rlpEnvelopedSize", "", "rlpFieldsWithSignatureSize", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "copy", "equals", "other", "", "hashCode", "toString", "", "Sidecar", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nTxBlob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TxBlob.kt\nio/ethers/core/types/transaction/TxBlob\n+ 2 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n*L\n1#1,233:1\n71#2,5:234\n71#2,2:239\n71#2,5:241\n73#2,3:246\n*S KotlinDebug\n*F\n+ 1 TxBlob.kt\nio/ethers/core/types/transaction/TxBlob\n*L\n90#1:234,5\n97#1:239,2\n98#1:241,5\n97#1:246,3\n*E\n"})
public final class TxBlob
implements TransactionUnsigned {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Address to;
    @NotNull
    private final BigInteger value;
    private final long nonce;
    private final long gas;
    @NotNull
    private final BigInteger gasFeeCap;
    @NotNull
    private final BigInteger gasTipCap;
    @Nullable
    private final Bytes data;
    private final long chainId;
    @NotNull
    private final List<AccessList.Item> accessList;
    @NotNull
    private final BigInteger blobFeeCap;
    @NotNull
    private final List<Hash> blobVersionedHashes;
    @Nullable
    private final Sidecar sidecar;
    public static final long GAS_PER_BLOB = 131072L;

    public TxBlob(@NotNull Address to, @NotNull BigInteger value, long nonce, long gas, @NotNull BigInteger gasFeeCap, @NotNull BigInteger gasTipCap, @Nullable Bytes data, long chainId, @NotNull List<AccessList.Item> accessList, @NotNull BigInteger blobFeeCap, @NotNull List<Hash> blobVersionedHashes, @Nullable Sidecar sidecar) {
        this.to = to;
        this.value = value;
        this.nonce = nonce;
        this.gas = gas;
        this.gasFeeCap = gasFeeCap;
        this.gasTipCap = gasTipCap;
        this.data = data;
        this.chainId = chainId;
        this.accessList = accessList;
        this.blobFeeCap = blobFeeCap;
        this.blobVersionedHashes = blobVersionedHashes;
        this.sidecar = sidecar;
        if (!ChainId.isValid(this.getChainId())) {
            throw new IllegalArgumentException("TxBlob transactions must have a chainId");
        }
    }

    public /* synthetic */ TxBlob(Address address, BigInteger bigInteger, long l, long l2, BigInteger bigInteger2, BigInteger bigInteger3, Bytes bytes, long l3, List list, BigInteger bigInteger4, List list2, Sidecar sidecar, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x800) != 0) {
            sidecar = null;
        }
        this(address, bigInteger, l, l2, bigInteger2, bigInteger3, bytes, l3, list, bigInteger4, list2, sidecar);
    }

    @Override
    @NotNull
    public Address getTo() {
        return this.to;
    }

    @Override
    @NotNull
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public long getGas() {
        return this.gas;
    }

    @Override
    @NotNull
    public BigInteger getGasFeeCap() {
        return this.gasFeeCap;
    }

    @Override
    @NotNull
    public BigInteger getGasTipCap() {
        return this.gasTipCap;
    }

    @Override
    @Nullable
    public Bytes getData() {
        return this.data;
    }

    @Override
    public long getChainId() {
        return this.chainId;
    }

    @Override
    @NotNull
    public List<AccessList.Item> getAccessList() {
        return this.accessList;
    }

    @Override
    @NotNull
    public BigInteger getBlobFeeCap() {
        return this.blobFeeCap;
    }

    @Override
    @NotNull
    public List<Hash> getBlobVersionedHashes() {
        return this.blobVersionedHashes;
    }

    @Nullable
    public final Sidecar getSidecar() {
        return this.sidecar;
    }

    public TxBlob(@NotNull Address to, @NotNull BigInteger value, long nonce, long gas, @NotNull BigInteger gasFeeCap, @NotNull BigInteger gasTipCap, @Nullable Bytes data, long chainId, @NotNull List<AccessList.Item> accessList, @NotNull BigInteger blobFeeCap, @NotNull Sidecar sidecar) {
        this(to, value, nonce, gas, gasFeeCap, gasTipCap, data, chainId, accessList, blobFeeCap, sidecar.getVersionedHashes(), sidecar);
    }

    @Override
    @NotNull
    public BigInteger getGasPrice() {
        return this.getGasFeeCap();
    }

    @Override
    @NotNull
    public TxType getType() {
        return TxType.Blob.INSTANCE;
    }

    @Override
    public void rlpEncodeEnveloped(@NotNull RlpEncoder rlp, @Nullable Signature signature, boolean hashEncoding) {
        RlpEncoder.Companion $this$rlpEncodeEnveloped_u24lambda_u243 = RlpEncoder.Companion;
        boolean bl = false;
        rlp.appendRaw((byte)this.getType().getType());
        int fieldsWithSignatureSize = this.rlpFieldsWithSignatureSize(signature);
        if (hashEncoding || this.sidecar == null) {
            RlpEncoder this_$iv = rlp;
            boolean $i$f$encodeList = false;
            int bufferStartPosition$iv = this_$iv.startList(fieldsWithSignatureSize);
            RlpEncoder $this$rlpEncodeEnveloped_u24lambda_u243_u24lambda_u240 = this_$iv;
            boolean bl2 = false;
            this.rlpEncodeFields($this$rlpEncodeEnveloped_u24lambda_u243_u24lambda_u240);
            Signature signature2 = signature;
            if (signature2 != null) {
                signature2.rlpEncode($this$rlpEncodeEnveloped_u24lambda_u243_u24lambda_u240);
            }
            this_$iv.finishList(bufferStartPosition$iv, fieldsWithSignatureSize);
        } else {
            RlpEncoder this_$iv = rlp;
            int bodySize$iv = $this$rlpEncodeEnveloped_u24lambda_u243.sizeOfList(fieldsWithSignatureSize) + this.sidecar.rlpSize();
            boolean $i$f$encodeList = false;
            int bufferStartPosition$iv = this_$iv.startList(bodySize$iv);
            RlpEncoder $this$rlpEncodeEnveloped_u24lambda_u243_u24lambda_u242 = this_$iv;
            boolean bl3 = false;
            RlpEncoder this_$iv2 = rlp;
            boolean $i$f$encodeList2 = false;
            int bufferStartPosition$iv2 = this_$iv2.startList(fieldsWithSignatureSize);
            RlpEncoder $this$rlpEncodeEnveloped_u24lambda_u243_u24lambda_u242_u24lambda_u241 = this_$iv2;
            boolean bl4 = false;
            this.rlpEncodeFields($this$rlpEncodeEnveloped_u24lambda_u243_u24lambda_u242_u24lambda_u241);
            Signature signature3 = signature;
            if (signature3 != null) {
                signature3.rlpEncode($this$rlpEncodeEnveloped_u24lambda_u243_u24lambda_u242_u24lambda_u241);
            }
            this_$iv2.finishList(bufferStartPosition$iv2, fieldsWithSignatureSize);
            this.sidecar.rlpEncode(rlp);
            this_$iv.finishList(bufferStartPosition$iv, bodySize$iv);
        }
    }

    private final void rlpEncodeFields(RlpEncoder rlp) {
        rlp.encode(this.getChainId());
        rlp.encode(this.getNonce());
        rlp.encode(this.getGasTipCap());
        rlp.encode(this.getGasFeeCap());
        rlp.encode(this.getGas());
        rlp.encode((RlpEncodable)this.getTo());
        rlp.encode(this.getValue());
        rlp.encode((RlpEncodable)this.getData());
        rlp.encodeList(this.getAccessList());
        rlp.encode(this.getBlobFeeCap());
        rlp.encodeList(this.getBlobVersionedHashes());
    }

    @Override
    public int rlpEnvelopedSize(@Nullable Signature signature, boolean hashEncoding) {
        RlpEncoder.Companion $this$rlpEnvelopedSize_u24lambda_u244 = RlpEncoder.Companion;
        boolean bl = false;
        int size = 1;
        if (hashEncoding || this.sidecar == null) {
            size += $this$rlpEnvelopedSize_u24lambda_u244.sizeOfList(this.rlpFieldsWithSignatureSize(signature));
        } else {
            int fieldsListSize = $this$rlpEnvelopedSize_u24lambda_u244.sizeOfList(this.rlpFieldsWithSignatureSize(signature));
            size += $this$rlpEnvelopedSize_u24lambda_u244.sizeOfList(fieldsListSize + this.sidecar.rlpSize());
        }
        return size;
    }

    private final int rlpFieldsWithSignatureSize(Signature signature) {
        RlpEncoder.Companion $this$rlpFieldsWithSignatureSize_u24lambda_u245 = RlpEncoder.Companion;
        boolean bl = false;
        int size = $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf(this.getChainId()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf(this.getNonce()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf(this.getGasTipCap()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf(this.getGasFeeCap()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf(this.getGas()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf((RlpEncodable)this.getTo()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf(this.getValue()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf((RlpEncodable)this.getData()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOfList(this.getAccessList()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOf(this.getBlobFeeCap()) + $this$rlpFieldsWithSignatureSize_u24lambda_u245.sizeOfList(this.getBlobVersionedHashes());
        if (signature != null) {
            return size + signature.rlpSize();
        }
        return size;
    }

    @NotNull
    public final Address component1() {
        return this.to;
    }

    @NotNull
    public final BigInteger component2() {
        return this.value;
    }

    public final long component3() {
        return this.nonce;
    }

    public final long component4() {
        return this.gas;
    }

    @NotNull
    public final BigInteger component5() {
        return this.gasFeeCap;
    }

    @NotNull
    public final BigInteger component6() {
        return this.gasTipCap;
    }

    @Nullable
    public final Bytes component7() {
        return this.data;
    }

    public final long component8() {
        return this.chainId;
    }

    @NotNull
    public final List<AccessList.Item> component9() {
        return this.accessList;
    }

    @NotNull
    public final BigInteger component10() {
        return this.blobFeeCap;
    }

    @NotNull
    public final List<Hash> component11() {
        return this.blobVersionedHashes;
    }

    @Nullable
    public final Sidecar component12() {
        return this.sidecar;
    }

    @NotNull
    public final TxBlob copy(@NotNull Address to, @NotNull BigInteger value, long nonce, long gas, @NotNull BigInteger gasFeeCap, @NotNull BigInteger gasTipCap, @Nullable Bytes data, long chainId, @NotNull List<AccessList.Item> accessList, @NotNull BigInteger blobFeeCap, @NotNull List<Hash> blobVersionedHashes, @Nullable Sidecar sidecar) {
        return new TxBlob(to, value, nonce, gas, gasFeeCap, gasTipCap, data, chainId, accessList, blobFeeCap, blobVersionedHashes, sidecar);
    }

    public static /* synthetic */ TxBlob copy$default(TxBlob txBlob, Address address, BigInteger bigInteger, long l, long l2, BigInteger bigInteger2, BigInteger bigInteger3, Bytes bytes, long l3, List list, BigInteger bigInteger4, List list2, Sidecar sidecar, int n, Object object) {
        if ((n & 1) != 0) {
            address = txBlob.to;
        }
        if ((n & 2) != 0) {
            bigInteger = txBlob.value;
        }
        if ((n & 4) != 0) {
            l = txBlob.nonce;
        }
        if ((n & 8) != 0) {
            l2 = txBlob.gas;
        }
        if ((n & 0x10) != 0) {
            bigInteger2 = txBlob.gasFeeCap;
        }
        if ((n & 0x20) != 0) {
            bigInteger3 = txBlob.gasTipCap;
        }
        if ((n & 0x40) != 0) {
            bytes = txBlob.data;
        }
        if ((n & 0x80) != 0) {
            l3 = txBlob.chainId;
        }
        if ((n & 0x100) != 0) {
            list = txBlob.accessList;
        }
        if ((n & 0x200) != 0) {
            bigInteger4 = txBlob.blobFeeCap;
        }
        if ((n & 0x400) != 0) {
            list2 = txBlob.blobVersionedHashes;
        }
        if ((n & 0x800) != 0) {
            sidecar = txBlob.sidecar;
        }
        return txBlob.copy(address, bigInteger, l, l2, bigInteger2, bigInteger3, bytes, l3, list, bigInteger4, list2, sidecar);
    }

    @NotNull
    public String toString() {
        return "TxBlob(to=" + this.to + ", value=" + this.value + ", nonce=" + this.nonce + ", gas=" + this.gas + ", gasFeeCap=" + this.gasFeeCap + ", gasTipCap=" + this.gasTipCap + ", data=" + this.data + ", chainId=" + this.chainId + ", accessList=" + this.accessList + ", blobFeeCap=" + this.blobFeeCap + ", blobVersionedHashes=" + this.blobVersionedHashes + ", sidecar=" + this.sidecar + ")";
    }

    public int hashCode() {
        int result = this.to.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + Long.hashCode(this.nonce);
        result = result * 31 + Long.hashCode(this.gas);
        result = result * 31 + this.gasFeeCap.hashCode();
        result = result * 31 + this.gasTipCap.hashCode();
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + Long.hashCode(this.chainId);
        result = result * 31 + ((Object)this.accessList).hashCode();
        result = result * 31 + this.blobFeeCap.hashCode();
        result = result * 31 + ((Object)this.blobVersionedHashes).hashCode();
        result = result * 31 + (this.sidecar == null ? 0 : this.sidecar.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TxBlob)) {
            return false;
        }
        TxBlob txBlob = (TxBlob)other;
        if (!Intrinsics.areEqual((Object)this.to, (Object)txBlob.to)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)txBlob.value)) {
            return false;
        }
        if (this.nonce != txBlob.nonce) {
            return false;
        }
        if (this.gas != txBlob.gas) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gasFeeCap, (Object)txBlob.gasFeeCap)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gasTipCap, (Object)txBlob.gasTipCap)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.data, (Object)txBlob.data)) {
            return false;
        }
        if (this.chainId != txBlob.chainId) {
            return false;
        }
        if (!Intrinsics.areEqual(this.accessList, txBlob.accessList)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.blobFeeCap, (Object)txBlob.blobFeeCap)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.blobVersionedHashes, txBlob.blobVersionedHashes)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sidecar, (Object)txBlob.sidecar);
    }

    @JvmStatic
    @Nullable
    public static TxBlob rlpDecode(@NotNull RlpDecoder rlp) {
        return Companion.rlpDecode(rlp);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/transaction/TxBlob$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/transaction/TxBlob;", "<init>", "()V", "GAS_PER_BLOB", "", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "ethers-core"})
    public static final class Companion
    implements RlpDecodable<TxBlob> {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public TxBlob rlpDecode(@NotNull RlpDecoder rlp) {
            long l = rlp.decodeLong();
            long l2 = rlp.decodeLong();
            BigInteger bigInteger = rlp.decodeBigIntegerElse(BigInteger.ZERO);
            BigInteger bigInteger2 = rlp.decodeBigIntegerElse(BigInteger.ZERO);
            long l3 = rlp.decodeLong();
            Address address = (Address)rlp.decode((RlpDecodable)Address.Companion);
            if (address == null) {
                return null;
            }
            Address address2 = address;
            BigInteger bigInteger3 = rlp.decodeBigIntegerElse(BigInteger.ZERO);
            Bytes bytes = (Bytes)rlp.decode((RlpDecodable)Bytes.Companion);
            List list = rlp.decodeAsList((RlpDecodable)AccessList.Item.Companion);
            BigInteger bigInteger4 = rlp.decodeBigIntegerElse(BigInteger.ZERO);
            List list2 = rlp.decodeAsList((RlpDecodable)Hash.Companion);
            return new TxBlob(address2, bigInteger3, l2, l3, bigInteger2, bigInteger, bytes, l, list, bigInteger4, list2, null, 2048, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u001b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u0017H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\n\u00a8\u0006$"}, d2={"Lio/ethers/core/types/transaction/TxBlob$Sidecar;", "Lio/ethers/rlp/RlpEncodable;", "blobs", "", "Lio/ethers/core/types/Bytes;", "commitments", "proofs", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getBlobs", "()Ljava/util/List;", "getCommitments", "getProofs", "versionedHashes", "Lio/ethers/core/types/Hash;", "getVersionedHashes", "versionedHashes$delegate", "Lkotlin/Lazy;", "rlpEncode", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "rlpSize", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nTxBlob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TxBlob.kt\nio/ethers/core/types/transaction/TxBlob$Sidecar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1761#2,3:234\n1761#2,3:237\n1761#2,3:240\n1563#2:244\n1634#2,3:245\n1#3:243\n*S KotlinDebug\n*F\n+ 1 TxBlob.kt\nio/ethers/core/types/transaction/TxBlob$Sidecar\n*L\n169#1:234,3\n172#1:237,3\n175#1:240,3\n184#1:244\n184#1:245,3\n*E\n"})
    public static final class Sidecar
    implements RlpEncodable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Bytes> blobs;
        @NotNull
        private final List<Bytes> commitments;
        @NotNull
        private final List<Bytes> proofs;
        @NotNull
        private final Lazy versionedHashes$delegate;
        public static final int BLOB_LENGTH = 131072;
        public static final int COMMITMENT_LENGTH = 48;
        public static final int PROOF_LENGTH = 48;

        public Sidecar(@NotNull List<Bytes> blobs, @NotNull List<Bytes> commitments, @NotNull List<Bytes> proofs) {
            boolean bl;
            block15: {
                boolean bl2;
                Bytes it;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block14: {
                    boolean bl3;
                    block13: {
                        this.blobs = blobs;
                        this.commitments = commitments;
                        this.proofs = proofs;
                        if (this.blobs.size() != this.commitments.size() || this.blobs.size() != this.proofs.size()) {
                            throw new IllegalArgumentException("blobs, commitments, and proofs must be the same size");
                        }
                        $this$any$iv = this.blobs;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (Bytes)element$iv;
                                boolean bl4 = false;
                                if (!(it.getSize() != 131072)) continue;
                                bl3 = true;
                                break block13;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        throw new IllegalArgumentException("blobs must be 131072 bytes long");
                    }
                    $this$any$iv = this.commitments;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Bytes)element$iv;
                            boolean bl5 = false;
                            if (!(it.getSize() != 48)) continue;
                            bl2 = true;
                            break block14;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    throw new IllegalArgumentException("commitments must be 48 bytes long");
                }
                $this$any$iv = this.proofs;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (Bytes)element$iv;
                        boolean bl6 = false;
                        if (!(it.getSize() != 48)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalArgumentException("proofs must be 48 bytes long");
            }
            this.versionedHashes$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Sidecar.versionedHashes_delegate$lambda$4(this));
        }

        @NotNull
        public final List<Bytes> getBlobs() {
            return this.blobs;
        }

        @NotNull
        public final List<Bytes> getCommitments() {
            return this.commitments;
        }

        @NotNull
        public final List<Bytes> getProofs() {
            return this.proofs;
        }

        @NotNull
        public final List<Hash> getVersionedHashes() {
            Lazy lazy = this.versionedHashes$delegate;
            return (List)lazy.getValue();
        }

        public void rlpEncode(@NotNull RlpEncoder rlp) {
            rlp.encodeList(this.blobs);
            rlp.encodeList(this.commitments);
            rlp.encodeList(this.proofs);
        }

        public int rlpSize() {
            RlpEncoder.Companion $this$rlpSize_u24lambda_u245 = RlpEncoder.Companion;
            boolean bl = false;
            return $this$rlpSize_u24lambda_u245.sizeOfList(this.blobs) + $this$rlpSize_u24lambda_u245.sizeOfList(this.commitments) + $this$rlpSize_u24lambda_u245.sizeOfList(this.proofs);
        }

        @NotNull
        public final List<Bytes> component1() {
            return this.blobs;
        }

        @NotNull
        public final List<Bytes> component2() {
            return this.commitments;
        }

        @NotNull
        public final List<Bytes> component3() {
            return this.proofs;
        }

        @NotNull
        public final Sidecar copy(@NotNull List<Bytes> blobs, @NotNull List<Bytes> commitments, @NotNull List<Bytes> proofs) {
            return new Sidecar(blobs, commitments, proofs);
        }

        public static /* synthetic */ Sidecar copy$default(Sidecar sidecar, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list = sidecar.blobs;
            }
            if ((n & 2) != 0) {
                list2 = sidecar.commitments;
            }
            if ((n & 4) != 0) {
                list3 = sidecar.proofs;
            }
            return sidecar.copy(list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "Sidecar(blobs=" + this.blobs + ", commitments=" + this.commitments + ", proofs=" + this.proofs + ")";
        }

        public int hashCode() {
            int result = ((Object)this.blobs).hashCode();
            result = result * 31 + ((Object)this.commitments).hashCode();
            result = result * 31 + ((Object)this.proofs).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Sidecar)) {
                return false;
            }
            Sidecar sidecar = (Sidecar)other;
            if (!Intrinsics.areEqual(this.blobs, sidecar.blobs)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.commitments, sidecar.commitments)) {
                return false;
            }
            return Intrinsics.areEqual(this.proofs, sidecar.proofs);
        }

        /*
         * WARNING - void declaration
         */
        private static final List versionedHashes_delegate$lambda$4(Sidecar this$0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this$0.commitments;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Bytes bytes = (Bytes)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Hash(Hashing.blobVersionedHash((byte[])it.asByteArray())));
            }
            return (List)destination$iv$iv;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ethers/core/types/transaction/TxBlob$Sidecar$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/transaction/TxBlob$Sidecar;", "<init>", "()V", "BLOB_LENGTH", "", "COMMITMENT_LENGTH", "PROOF_LENGTH", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "ethers-core"})
        public static final class Companion
        implements RlpDecodable<Sidecar> {
            private Companion() {
            }

            @NotNull
            public Sidecar rlpDecode(@NotNull RlpDecoder rlp) {
                return new Sidecar(rlp.decodeAsList((RlpDecodable)Bytes.Companion), rlp.decodeAsList((RlpDecodable)Bytes.Companion), rlp.decodeAsList((RlpDecodable)Bytes.Companion));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

