/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.transaction;

import io.ethers.core.types.AccessList;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Signature;
import io.ethers.core.types.transaction.ChainId;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.core.types.transaction.TxType;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 F2\u00020\u0001:\u0001FBQ\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\"\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203H\u0016J\u001a\u00104\u001a\u0002052\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203H\u0016J\u0012\u00106\u001a\u0002052\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u000b\u00107\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0005H\u00c6\u0003J\t\u00109\u001a\u00020\u0007H\u00c6\u0003J\t\u0010:\u001a\u00020\u0007H\u00c6\u0003J\t\u0010;\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010=\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0003Jc\u0010?\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00072\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0001J\u0013\u0010@\u001a\u0002032\b\u0010A\u001a\u0004\u0018\u00010BH\u00d6\u0003J\t\u0010C\u001a\u000205H\u00d6\u0001J\t\u0010D\u001a\u00020EH\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\t\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0014\u0010!\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0015R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0015R\u001c\u0010)\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u001e\u00a8\u0006G"}, d2={"Lio/ethers/core/types/transaction/TxAccessList;", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "to", "Lio/ethers/core/types/Address;", "value", "Ljava/math/BigInteger;", "nonce", "", "gas", "gasPrice", "data", "Lio/ethers/core/types/Bytes;", "chainId", "accessList", "", "Lio/ethers/core/types/AccessList$Item;", "<init>", "(Lio/ethers/core/types/Address;Ljava/math/BigInteger;JJLjava/math/BigInteger;Lio/ethers/core/types/Bytes;JLjava/util/List;)V", "getTo", "()Lio/ethers/core/types/Address;", "getValue", "()Ljava/math/BigInteger;", "getNonce", "()J", "getGas", "getGasPrice", "getData", "()Lio/ethers/core/types/Bytes;", "getChainId", "getAccessList", "()Ljava/util/List;", "gasTipCap", "getGasTipCap", "gasFeeCap", "getGasFeeCap", "type", "Lio/ethers/core/types/transaction/TxType;", "getType", "()Lio/ethers/core/types/transaction/TxType;", "blobFeeCap", "getBlobFeeCap", "blobVersionedHashes", "Lio/ethers/core/types/Hash;", "getBlobVersionedHashes", "rlpEncodeEnveloped", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "signature", "Lio/ethers/core/types/Signature;", "hashEncoding", "", "rlpEnvelopedSize", "", "rlpFieldsWithSignatureSize", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "", "hashCode", "toString", "", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nTxAccessList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TxAccessList.kt\nio/ethers/core/types/transaction/TxAccessList\n+ 2 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n*L\n1#1,98:1\n71#2,5:99\n*S KotlinDebug\n*F\n+ 1 TxAccessList.kt\nio/ethers/core/types/transaction/TxAccessList\n*L\n52#1:99,5\n*E\n"})
public final class TxAccessList
implements TransactionUnsigned {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Address to;
    @NotNull
    private final BigInteger value;
    private final long nonce;
    private final long gas;
    @NotNull
    private final BigInteger gasPrice;
    @Nullable
    private final Bytes data;
    private final long chainId;
    @NotNull
    private final List<AccessList.Item> accessList;

    public TxAccessList(@Nullable Address to, @NotNull BigInteger value, long nonce, long gas, @NotNull BigInteger gasPrice, @Nullable Bytes data, long chainId, @NotNull List<AccessList.Item> accessList) {
        this.to = to;
        this.value = value;
        this.nonce = nonce;
        this.gas = gas;
        this.gasPrice = gasPrice;
        this.data = data;
        this.chainId = chainId;
        this.accessList = accessList;
        if (!ChainId.isValid(this.getChainId())) {
            throw new IllegalArgumentException("AccessList transactions must have a chainId");
        }
    }

    @Override
    @Nullable
    public Address getTo() {
        return this.to;
    }

    @Override
    @NotNull
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public long getGas() {
        return this.gas;
    }

    @Override
    @NotNull
    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    @Override
    @Nullable
    public Bytes getData() {
        return this.data;
    }

    @Override
    public long getChainId() {
        return this.chainId;
    }

    @Override
    @NotNull
    public List<AccessList.Item> getAccessList() {
        return this.accessList;
    }

    @Override
    @NotNull
    public BigInteger getGasTipCap() {
        return this.getGasPrice();
    }

    @Override
    @NotNull
    public BigInteger getGasFeeCap() {
        return this.getGasPrice();
    }

    @Override
    @NotNull
    public TxType getType() {
        return TxType.AccessList.INSTANCE;
    }

    @Override
    @Nullable
    public BigInteger getBlobFeeCap() {
        return null;
    }

    @Override
    @Nullable
    public List<Hash> getBlobVersionedHashes() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void rlpEncodeEnveloped(@NotNull RlpEncoder rlp, @Nullable Signature signature, boolean hashEncoding) {
        void this_$iv;
        rlp.appendRaw((byte)this.getType().getType());
        RlpEncoder rlpEncoder = rlp;
        int bodySize$iv = this.rlpFieldsWithSignatureSize(signature);
        boolean $i$f$encodeList = false;
        int bufferStartPosition$iv = this_$iv.startList(bodySize$iv);
        void $this$rlpEncodeEnveloped_u24lambda_u240 = this_$iv;
        boolean bl = false;
        rlp.encode(this.getChainId());
        rlp.encode(this.getNonce());
        rlp.encode(this.getGasPrice());
        rlp.encode(this.getGas());
        rlp.encode((RlpEncodable)this.getTo());
        rlp.encode(this.getValue());
        rlp.encode((RlpEncodable)this.getData());
        rlp.encodeList(this.getAccessList());
        Signature signature2 = signature;
        if (signature2 != null) {
            signature2.rlpEncode((RlpEncoder)$this$rlpEncodeEnveloped_u24lambda_u240);
        }
        this_$iv.finishList(bufferStartPosition$iv, bodySize$iv);
    }

    @Override
    public int rlpEnvelopedSize(@Nullable Signature signature, boolean hashEncoding) {
        RlpEncoder.Companion $this$rlpEnvelopedSize_u24lambda_u241 = RlpEncoder.Companion;
        boolean bl = false;
        return 1 + $this$rlpEnvelopedSize_u24lambda_u241.sizeOfList(this.rlpFieldsWithSignatureSize(signature));
    }

    private final int rlpFieldsWithSignatureSize(Signature signature) {
        RlpEncoder.Companion $this$rlpFieldsWithSignatureSize_u24lambda_u242 = RlpEncoder.Companion;
        boolean bl = false;
        Signature signature2 = signature;
        return $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getChainId()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getNonce()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getGasPrice()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getGas()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf((RlpEncodable)this.getTo()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf(this.getValue()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOf((RlpEncodable)this.getData()) + $this$rlpFieldsWithSignatureSize_u24lambda_u242.sizeOfList(this.getAccessList()) + (signature2 != null ? signature2.rlpSize() : 0);
    }

    @Nullable
    public final Address component1() {
        return this.to;
    }

    @NotNull
    public final BigInteger component2() {
        return this.value;
    }

    public final long component3() {
        return this.nonce;
    }

    public final long component4() {
        return this.gas;
    }

    @NotNull
    public final BigInteger component5() {
        return this.gasPrice;
    }

    @Nullable
    public final Bytes component6() {
        return this.data;
    }

    public final long component7() {
        return this.chainId;
    }

    @NotNull
    public final List<AccessList.Item> component8() {
        return this.accessList;
    }

    @NotNull
    public final TxAccessList copy(@Nullable Address to, @NotNull BigInteger value, long nonce, long gas, @NotNull BigInteger gasPrice, @Nullable Bytes data, long chainId, @NotNull List<AccessList.Item> accessList) {
        return new TxAccessList(to, value, nonce, gas, gasPrice, data, chainId, accessList);
    }

    public static /* synthetic */ TxAccessList copy$default(TxAccessList txAccessList, Address address, BigInteger bigInteger, long l, long l2, BigInteger bigInteger2, Bytes bytes, long l3, List list, int n, Object object) {
        if ((n & 1) != 0) {
            address = txAccessList.to;
        }
        if ((n & 2) != 0) {
            bigInteger = txAccessList.value;
        }
        if ((n & 4) != 0) {
            l = txAccessList.nonce;
        }
        if ((n & 8) != 0) {
            l2 = txAccessList.gas;
        }
        if ((n & 0x10) != 0) {
            bigInteger2 = txAccessList.gasPrice;
        }
        if ((n & 0x20) != 0) {
            bytes = txAccessList.data;
        }
        if ((n & 0x40) != 0) {
            l3 = txAccessList.chainId;
        }
        if ((n & 0x80) != 0) {
            list = txAccessList.accessList;
        }
        return txAccessList.copy(address, bigInteger, l, l2, bigInteger2, bytes, l3, list);
    }

    @NotNull
    public String toString() {
        return "TxAccessList(to=" + this.to + ", value=" + this.value + ", nonce=" + this.nonce + ", gas=" + this.gas + ", gasPrice=" + this.gasPrice + ", data=" + this.data + ", chainId=" + this.chainId + ", accessList=" + this.accessList + ")";
    }

    public int hashCode() {
        int result = this.to == null ? 0 : this.to.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + Long.hashCode(this.nonce);
        result = result * 31 + Long.hashCode(this.gas);
        result = result * 31 + this.gasPrice.hashCode();
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + Long.hashCode(this.chainId);
        result = result * 31 + ((Object)this.accessList).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TxAccessList)) {
            return false;
        }
        TxAccessList txAccessList = (TxAccessList)other;
        if (!Intrinsics.areEqual((Object)this.to, (Object)txAccessList.to)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)txAccessList.value)) {
            return false;
        }
        if (this.nonce != txAccessList.nonce) {
            return false;
        }
        if (this.gas != txAccessList.gas) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gasPrice, (Object)txAccessList.gasPrice)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.data, (Object)txAccessList.data)) {
            return false;
        }
        if (this.chainId != txAccessList.chainId) {
            return false;
        }
        return Intrinsics.areEqual(this.accessList, txAccessList.accessList);
    }

    @JvmStatic
    @NotNull
    public static TxAccessList rlpDecode(@NotNull RlpDecoder rlp) {
        return Companion.rlpDecode(rlp);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\b"}, d2={"Lio/ethers/core/types/transaction/TxAccessList$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/transaction/TxAccessList;", "<init>", "()V", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "ethers-core"})
    public static final class Companion
    implements RlpDecodable<TxAccessList> {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public TxAccessList rlpDecode(@NotNull RlpDecoder rlp) {
            long l = rlp.decodeLong();
            long l2 = rlp.decodeLong();
            BigInteger bigInteger = rlp.decodeBigIntegerElse(BigInteger.ZERO);
            long l3 = rlp.decodeLong();
            Address address = (Address)rlp.decode((RlpDecodable)Address.Companion);
            BigInteger bigInteger2 = rlp.decodeBigIntegerElse(BigInteger.ZERO);
            Bytes bytes = (Bytes)rlp.decode((RlpDecodable)Bytes.Companion);
            List list = rlp.decodeAsList((RlpDecodable)AccessList.Item.Companion);
            return new TxAccessList(address, bigInteger2, l2, l3, bigInteger, bytes, l, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

