/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.transaction;

import io.ethers.core.types.Signature;
import io.ethers.core.types.transaction.Transaction;
import io.ethers.core.types.transaction.TxAccessList;
import io.ethers.core.types.transaction.TxBlob;
import io.ethers.core.types.transaction.TxDynamicFee;
import io.ethers.core.types.transaction.TxLegacy;
import io.ethers.core.types.transaction.TxType;
import io.ethers.crypto.Hashing;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH&J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH&J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016\u0082\u0001\u0004\u0012\u0013\u0014\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lio/ethers/core/types/transaction/TransactionUnsigned;", "Lio/ethers/core/types/transaction/Transaction;", "Lio/ethers/rlp/RlpEncodable;", "rlpEncodeEnveloped", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "signature", "Lio/ethers/core/types/Signature;", "hashEncoding", "", "rlpEnvelopedSize", "", "signatureHash", "", "rlpEncode", "rlpSize", "Companion", "Lio/ethers/core/types/transaction/TxAccessList;", "Lio/ethers/core/types/transaction/TxBlob;", "Lio/ethers/core/types/transaction/TxDynamicFee;", "Lio/ethers/core/types/transaction/TxLegacy;", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nTransactionUnsigned.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionUnsigned.kt\nio/ethers/core/types/transaction/TransactionUnsigned\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public interface TransactionUnsigned
extends Transaction,
RlpEncodable {
    @NotNull
    public static final Companion Companion = io.ethers.core.types.transaction.TransactionUnsigned$Companion.$$INSTANCE;

    public void rlpEncodeEnveloped(@NotNull RlpEncoder var1, @Nullable Signature var2, boolean var3);

    public int rlpEnvelopedSize(@Nullable Signature var1, boolean var2);

    @NotNull
    default public byte[] signatureHash() {
        RlpEncoder rlpEncoder;
        RlpEncoder it = rlpEncoder = new RlpEncoder(this.rlpEnvelopedSize(null, true), true);
        boolean bl = false;
        this.rlpEncodeEnveloped(it, null, true);
        byte[] rlp = rlpEncoder.toByteArray();
        return Hashing.keccak256((byte[])rlp);
    }

    default public void rlpEncode(@NotNull RlpEncoder rlp) {
        this.rlpEncodeEnveloped(rlp, io.ethers.core.types.transaction.TransactionUnsigned$Companion.EMPTY_SIGNATURE, true);
    }

    default public int rlpSize() {
        return this.rlpEnvelopedSize(io.ethers.core.types.transaction.TransactionUnsigned$Companion.EMPTY_SIGNATURE, true);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\f\u0010\u000e\u001a\u00020\u000f*\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/ethers/core/types/transaction/TransactionUnsigned$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "<init>", "()V", "EMPTY_SIGNATURE", "Lio/ethers/core/types/Signature;", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "data", "", "chainId", "", "dropEmptyRSV", "", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nTransactionUnsigned.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionUnsigned.kt\nio/ethers/core/types/transaction/TransactionUnsigned$Companion\n+ 2 RlpDecoder.kt\nio/ethers/rlp/RlpDecoder\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n102#2,6:111\n109#2,3:118\n102#2,10:121\n102#2,10:131\n102#2,10:141\n1#3:117\n*S KotlinDebug\n*F\n+ 1 TransactionUnsigned.kt\nio/ethers/core/types/transaction/TransactionUnsigned$Companion\n*L\n77#1:111,6\n77#1:118,3\n85#1:121,10\n90#1:131,10\n95#1:141,10\n*E\n"})
    public static final class Companion
    implements RlpDecodable<TransactionUnsigned> {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Signature EMPTY_SIGNATURE;

        private Companion() {
        }

        @Nullable
        public TransactionUnsigned rlpDecode(@NotNull RlpDecoder rlp) {
            return this.rlpDecode(rlp, -1L);
        }

        @Nullable
        public final TransactionUnsigned rlpDecode(@NotNull byte[] data, long chainId) {
            return this.rlpDecode(new RlpDecoder(data), chainId);
        }

        @Nullable
        public final TransactionUnsigned rlpDecode(@NotNull RlpDecoder rlp, long chainId) {
            TransactionUnsigned transactionUnsigned;
            int type = UByte.constructor-impl((byte)rlp.peekByte()) & 0xFF;
            if (type >= 192) {
                TxLegacy txLegacy;
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    txLegacy = null;
                } else {
                    TxLegacy txLegacy2;
                    RlpDecoder $this$rlpDecode_u24lambda_u241 = this_$iv;
                    boolean bl = false;
                    TxLegacy it = txLegacy2 = TxLegacy.Companion.rlpDecode(rlp, chainId);
                    boolean bl2 = false;
                    $$INSTANCE.dropEmptyRSV($this$rlpDecode_u24lambda_u241);
                    TxLegacy r$iv = txLegacy2;
                    this_$iv.finishList(listEndPosition$iv);
                    txLegacy = r$iv;
                }
                return txLegacy;
            }
            TxType txType = TxType.Companion.fromType(type);
            if (Intrinsics.areEqual((Object)txType, (Object)TxType.Legacy.INSTANCE)) {
                throw new IllegalStateException("Should not happen");
            }
            if (Intrinsics.areEqual((Object)txType, (Object)TxType.AccessList.INSTANCE)) {
                TxAccessList txAccessList;
                rlp.readByte();
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    txAccessList = null;
                } else {
                    TxAccessList txAccessList2;
                    RlpDecoder $this$rlpDecode_u24lambda_u243 = this_$iv;
                    boolean bl = false;
                    TxAccessList it = txAccessList2 = TxAccessList.Companion.rlpDecode(rlp);
                    boolean bl3 = false;
                    $$INSTANCE.dropEmptyRSV($this$rlpDecode_u24lambda_u243);
                    TxAccessList r$iv = txAccessList2;
                    this_$iv.finishList(listEndPosition$iv);
                    txAccessList = r$iv;
                }
                transactionUnsigned = txAccessList;
            } else if (Intrinsics.areEqual((Object)txType, (Object)TxType.DynamicFee.INSTANCE)) {
                TxDynamicFee txDynamicFee;
                rlp.readByte();
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    txDynamicFee = null;
                } else {
                    TxDynamicFee txDynamicFee2;
                    RlpDecoder $this$rlpDecode_u24lambda_u245 = this_$iv;
                    boolean bl = false;
                    TxDynamicFee it = txDynamicFee2 = TxDynamicFee.Companion.rlpDecode(rlp);
                    boolean bl4 = false;
                    $$INSTANCE.dropEmptyRSV($this$rlpDecode_u24lambda_u245);
                    TxDynamicFee r$iv = txDynamicFee2;
                    this_$iv.finishList(listEndPosition$iv);
                    txDynamicFee = r$iv;
                }
                transactionUnsigned = txDynamicFee;
            } else if (Intrinsics.areEqual((Object)txType, (Object)TxType.Blob.INSTANCE)) {
                TxBlob txBlob;
                rlp.readByte();
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    txBlob = null;
                } else {
                    TxBlob txBlob2;
                    RlpDecoder $this$rlpDecode_u24lambda_u247 = this_$iv;
                    boolean bl = false;
                    TxBlob it = txBlob2 = TxBlob.Companion.rlpDecode(rlp);
                    boolean bl5 = false;
                    $$INSTANCE.dropEmptyRSV($this$rlpDecode_u24lambda_u247);
                    TxBlob r$iv = txBlob2;
                    this_$iv.finishList(listEndPosition$iv);
                    txBlob = r$iv;
                }
                transactionUnsigned = txBlob;
            } else if (txType instanceof TxType.Unsupported) {
                transactionUnsigned = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return transactionUnsigned;
        }

        private final void dropEmptyRSV(RlpDecoder $this$dropEmptyRSV) {
            $this$dropEmptyRSV.decodeLong();
            $this$dropEmptyRSV.decodeLong();
            $this$dropEmptyRSV.decodeLong();
        }

        static {
            $$INSTANCE = new Companion();
            EMPTY_SIGNATURE = new Signature(BigInteger.ZERO, BigInteger.ZERO, 0L);
        }
    }
}

