/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types.transaction;

import io.ethers.core.types.AccessList;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Signature;
import io.ethers.core.types.transaction.ChainId;
import io.ethers.core.types.transaction.Transaction;
import io.ethers.core.types.transaction.TransactionRecovered;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.core.types.transaction.TxAccessList;
import io.ethers.core.types.transaction.TxBlob;
import io.ethers.core.types.transaction.TxDynamicFee;
import io.ethers.core.types.transaction.TxLegacy;
import io.ethers.core.types.transaction.TxType;
import io.ethers.crypto.Hashing;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 V2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001VB1\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010!\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0015H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0015H\u0016J\u0011\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0096\u0001J\u0011\u0010/\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0096\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u0004\u0018\u00010-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u0002098VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u001a\u0010<\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u000101X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b=\u00104R\u0012\u0010>\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b?\u0010;R\u0014\u0010@\u001a\u0004\u0018\u00010AX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0012\u0010D\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bE\u0010;R\u0012\u0010F\u001a\u00020-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bG\u00107R\u0012\u0010H\u001a\u00020-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bI\u00107R\u0012\u0010J\u001a\u00020-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bK\u00107R\u0012\u0010L\u001a\u000209X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bM\u0010;R\u0014\u0010N\u001a\u0004\u0018\u00010\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u001bR\u0012\u0010P\u001a\u00020QX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0012\u0010T\u001a\u00020-X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bU\u00107\u00a8\u0006W"}, d2={"Lio/ethers/core/types/transaction/TransactionSigned;", "Lio/ethers/core/types/transaction/TransactionRecovered;", "Lio/ethers/core/types/transaction/Transaction;", "Lio/ethers/rlp/RlpEncodable;", "tx", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "signature", "Lio/ethers/core/types/Signature;", "hash", "Lio/ethers/core/types/Hash;", "from", "Lio/ethers/core/types/Address;", "<init>", "(Lio/ethers/core/types/transaction/TransactionUnsigned;Lio/ethers/core/types/Signature;Lio/ethers/core/types/Hash;Lio/ethers/core/types/Address;)V", "getTx", "()Lio/ethers/core/types/transaction/TransactionUnsigned;", "getSignature", "()Lio/ethers/core/types/Signature;", "_hash", "_from", "_isValidSignature", "", "toCallRequest", "Lio/ethers/core/types/CallRequest;", "getHash", "()Lio/ethers/core/types/Hash;", "getFrom", "()Lio/ethers/core/types/Address;", "fromOrNull", "getFromOrNull", "isSignatureValid", "", "()Z", "equals", "other", "", "hashCode", "toString", "", "rlpEncode", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "rlpSize", "getEffectiveGasPrice", "Ljava/math/BigInteger;", "baseFee", "getEffectiveGasTip", "accessList", "", "Lio/ethers/core/types/AccessList$Item;", "getAccessList", "()Ljava/util/List;", "blobFeeCap", "getBlobFeeCap", "()Ljava/math/BigInteger;", "blobGas", "", "getBlobGas", "()J", "blobVersionedHashes", "getBlobVersionedHashes", "chainId", "getChainId", "data", "Lio/ethers/core/types/Bytes;", "getData", "()Lio/ethers/core/types/Bytes;", "gas", "getGas", "gasFeeCap", "getGasFeeCap", "gasPrice", "getGasPrice", "gasTipCap", "getGasTipCap", "nonce", "getNonce", "to", "getTo", "type", "Lio/ethers/core/types/transaction/TxType;", "getType", "()Lio/ethers/core/types/transaction/TxType;", "value", "getValue", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nTransactionSigned.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionSigned.kt\nio/ethers/core/types/transaction/TransactionSigned\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
public final class TransactionSigned
implements TransactionRecovered,
Transaction,
RlpEncodable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TransactionUnsigned tx;
    @NotNull
    private final Signature signature;
    @Nullable
    private Hash _hash;
    @Nullable
    private Address _from;
    private int _isValidSignature;

    @JvmOverloads
    public TransactionSigned(@NotNull TransactionUnsigned tx, @NotNull Signature signature, @Nullable Hash hash, @Nullable Address from) {
        this.tx = tx;
        this.signature = signature;
        this._hash = hash;
        this._from = from;
        this._isValidSignature = -1;
    }

    public /* synthetic */ TransactionSigned(TransactionUnsigned transactionUnsigned, Signature signature, Hash hash, Address address, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            hash = null;
        }
        if ((n & 8) != 0) {
            address = null;
        }
        this(transactionUnsigned, signature, hash, address);
    }

    @NotNull
    public final TransactionUnsigned getTx() {
        return this.tx;
    }

    @NotNull
    public final Signature getSignature() {
        return this.signature;
    }

    @Override
    @NotNull
    public CallRequest toCallRequest() {
        return TransactionRecovered.super.toCallRequest();
    }

    @Override
    @NotNull
    public Hash getHash() {
        if (this._hash == null) {
            RlpEncoder rlpEncoder;
            RlpEncoder it = rlpEncoder = new RlpEncoder(this.tx.rlpEnvelopedSize(this.signature, true), true);
            boolean bl = false;
            this.tx.rlpEncodeEnveloped(it, this.signature, true);
            byte[] rlp = rlpEncoder.toByteArray();
            this._hash = new Hash(Hashing.keccak256((byte[])rlp));
        }
        Hash hash = this._hash;
        Intrinsics.checkNotNull((Object)hash);
        return hash;
    }

    @Override
    @NotNull
    public Address getFrom() {
        if (this._from == null && !this.isSignatureValid()) {
            throw new IllegalStateException("Unable to recover sender, invalid signature");
        }
        Address address = this._from;
        Intrinsics.checkNotNull((Object)address);
        return address;
    }

    @Nullable
    public final Address getFromOrNull() {
        if (this._from == null && !this.isSignatureValid()) {
            return null;
        }
        return this._from;
    }

    public final boolean isSignatureValid() {
        if (this._isValidSignature == -1) {
            Address from = this.signature.recoverFromHash(this.tx.signatureHash());
            this._isValidSignature = from != null ? 1 : 0;
            this._from = from;
        }
        return this._isValidSignature == 1;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.transaction.TransactionSigned");
        TransactionSigned cfr_ignored_0 = (TransactionSigned)other;
        if (!Intrinsics.areEqual((Object)this.tx, (Object)((TransactionSigned)other).tx)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signature, (Object)((TransactionSigned)other).signature);
    }

    public int hashCode() {
        int result = this.tx.hashCode();
        result = 31 * result + this.signature.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "TransactionSigned(tx=" + this.tx + ", signature=" + this.signature + ")";
    }

    public void rlpEncode(@NotNull RlpEncoder rlp) {
        this.tx.rlpEncodeEnveloped(rlp, this.signature, false);
    }

    public int rlpSize() {
        return this.tx.rlpEnvelopedSize(this.signature, false);
    }

    @Override
    @Nullable
    public Address getTo() {
        return this.tx.getTo();
    }

    @Override
    @NotNull
    public BigInteger getValue() {
        return this.tx.getValue();
    }

    @Override
    public long getNonce() {
        return this.tx.getNonce();
    }

    @Override
    public long getGas() {
        return this.tx.getGas();
    }

    @Override
    @NotNull
    public BigInteger getGasPrice() {
        return this.tx.getGasPrice();
    }

    @Override
    @NotNull
    public BigInteger getGasTipCap() {
        return this.tx.getGasTipCap();
    }

    @Override
    @NotNull
    public BigInteger getGasFeeCap() {
        return this.tx.getGasFeeCap();
    }

    @Override
    @Nullable
    public Bytes getData() {
        return this.tx.getData();
    }

    @Override
    public long getChainId() {
        return this.tx.getChainId();
    }

    @Override
    @NotNull
    public List<AccessList.Item> getAccessList() {
        return this.tx.getAccessList();
    }

    @Override
    @NotNull
    public TxType getType() {
        return this.tx.getType();
    }

    @Override
    @Nullable
    public BigInteger getBlobFeeCap() {
        return this.tx.getBlobFeeCap();
    }

    @Override
    @Nullable
    public List<Hash> getBlobVersionedHashes() {
        return this.tx.getBlobVersionedHashes();
    }

    @Override
    public long getBlobGas() {
        return this.tx.getBlobGas();
    }

    @Override
    @NotNull
    public BigInteger getEffectiveGasTip(@NotNull BigInteger baseFee) {
        return this.tx.getEffectiveGasTip(baseFee);
    }

    @Override
    @NotNull
    public BigInteger getEffectiveGasPrice(@NotNull BigInteger baseFee) {
        return this.tx.getEffectiveGasPrice(baseFee);
    }

    @JvmOverloads
    public TransactionSigned(@NotNull TransactionUnsigned tx, @NotNull Signature signature, @Nullable Hash hash) {
        this(tx, signature, hash, null, 8, null);
    }

    @JvmOverloads
    public TransactionSigned(@NotNull TransactionUnsigned tx, @NotNull Signature signature) {
        this(tx, signature, null, null, 12, null);
    }

    @JvmStatic
    @Nullable
    public static TransactionSigned rlpDecode(@NotNull byte[] data) {
        return Companion.rlpDecode(data);
    }

    @JvmStatic
    @Nullable
    public static TransactionSigned rlpDecode(@NotNull RlpDecoder rlp) {
        return Companion.rlpDecode(rlp);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/transaction/TransactionSigned$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/transaction/TransactionSigned;", "<init>", "()V", "rlpDecode", "data", "", "rlp", "Lio/ethers/rlp/RlpDecoder;", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nTransactionSigned.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionSigned.kt\nio/ethers/core/types/transaction/TransactionSigned$Companion\n+ 2 RlpDecoder.kt\nio/ethers/rlp/RlpDecoder\n*L\n1#1,214:1\n102#2,10:215\n102#2,10:225\n102#2,10:235\n102#2,6:245\n102#2,10:251\n109#2,3:261\n*S KotlinDebug\n*F\n+ 1 TransactionSigned.kt\nio/ethers/core/types/transaction/TransactionSigned$Companion\n*L\n133#1:215,10\n165#1:225,10\n175#1:235,10\n185#1:245,6\n191#1:251,10\n185#1:261,3\n*E\n"})
    public static final class Companion
    implements RlpDecodable<TransactionSigned> {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public TransactionSigned rlpDecode(@NotNull byte[] data) {
            return (TransactionSigned)super.rlpDecode(data);
        }

        @JvmStatic
        @Nullable
        public TransactionSigned rlpDecode(@NotNull RlpDecoder rlp) {
            TransactionSigned transactionSigned;
            int type = UByte.constructor-impl((byte)rlp.peekByte()) & 0xFF;
            if (type >= 192) {
                TransactionSigned transactionSigned2;
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    transactionSigned2 = null;
                } else {
                    RlpDecoder $this$rlpDecode_u24lambda_u240 = this_$iv;
                    boolean bl = false;
                    long nonce = rlp.decodeLong();
                    BigInteger bigInteger = rlp.decodeBigInteger();
                    if (bigInteger == null) {
                        bigInteger = BigInteger.ZERO;
                    }
                    BigInteger gasPrice = bigInteger;
                    long gas = rlp.decodeLong();
                    Address to = (Address)rlp.decode((RlpDecodable)Address.Companion);
                    BigInteger bigInteger2 = rlp.decodeBigInteger();
                    if (bigInteger2 == null) {
                        bigInteger2 = BigInteger.ZERO;
                    }
                    BigInteger value = bigInteger2;
                    Bytes data = (Bytes)rlp.decode((RlpDecodable)Bytes.Companion);
                    Signature signature = (Signature)rlp.decode((RlpDecodable)Signature.Companion);
                    if (signature == null) {
                        return null;
                    }
                    Signature signature2 = signature;
                    long chainId = ChainId.fromSignature(signature2);
                    TxLegacy tx = new TxLegacy(to, value, nonce, gas, gasPrice, data, chainId);
                    TransactionSigned r$iv = new TransactionSigned(tx, signature2, null, null, 12, null);
                    this_$iv.finishList(listEndPosition$iv);
                    transactionSigned2 = r$iv;
                }
                return transactionSigned2;
            }
            TxType txType = TxType.Companion.fromType(type);
            if (Intrinsics.areEqual((Object)txType, (Object)TxType.Legacy.INSTANCE)) {
                throw new IllegalStateException("Should not happen");
            }
            if (Intrinsics.areEqual((Object)txType, (Object)TxType.AccessList.INSTANCE)) {
                rlp.readByte();
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    transactionSigned = null;
                } else {
                    RlpDecoder $this$rlpDecode_u24lambda_u241 = this_$iv;
                    boolean bl = false;
                    TxAccessList tx = TxAccessList.Companion.rlpDecode(rlp);
                    Signature signature = (Signature)rlp.decode((RlpDecodable)Signature.Companion);
                    if (signature == null) {
                        return null;
                    }
                    Signature signature3 = signature;
                    TransactionSigned r$iv = new TransactionSigned(tx, signature3, null, null, 12, null);
                    this_$iv.finishList(listEndPosition$iv);
                    transactionSigned = r$iv;
                }
            } else if (Intrinsics.areEqual((Object)txType, (Object)TxType.DynamicFee.INSTANCE)) {
                rlp.readByte();
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    transactionSigned = null;
                } else {
                    RlpDecoder $this$rlpDecode_u24lambda_u242 = this_$iv;
                    boolean bl = false;
                    TxDynamicFee tx = TxDynamicFee.Companion.rlpDecode(rlp);
                    Signature signature = (Signature)rlp.decode((RlpDecodable)Signature.Companion);
                    if (signature == null) {
                        return null;
                    }
                    Signature signature4 = signature;
                    TransactionSigned r$iv = new TransactionSigned(tx, signature4, null, null, 12, null);
                    this_$iv.finishList(listEndPosition$iv);
                    transactionSigned = r$iv;
                }
            } else if (Intrinsics.areEqual((Object)txType, (Object)TxType.Blob.INSTANCE)) {
                rlp.readByte();
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    transactionSigned = null;
                } else {
                    TransactionSigned transactionSigned3;
                    RlpDecoder $this$rlpDecode_u24lambda_u244 = this_$iv;
                    boolean bl = false;
                    boolean isNetworkEncoding = rlp.isNextElementList();
                    if (isNetworkEncoding) {
                        TxBlob tx = null;
                        Signature signature = null;
                        RlpDecoder this_$iv2 = rlp;
                        boolean $i$f$decodeList2 = false;
                        int listEndPosition$iv2 = this_$iv2.startList();
                        if (this_$iv2.getPosition() != listEndPosition$iv2) {
                            RlpDecoder $this$rlpDecode_u24lambda_u244_u24lambda_u243 = this_$iv2;
                            boolean bl2 = false;
                            TxBlob txBlob = TxBlob.Companion.rlpDecode(rlp);
                            if (txBlob == null) {
                                return null;
                            }
                            tx = txBlob;
                            Signature signature5 = (Signature)rlp.decode((RlpDecodable)Signature.Companion);
                            if (signature5 == null) {
                                return null;
                            }
                            signature = signature5;
                            Unit r$iv = Unit.INSTANCE;
                            this_$iv2.finishList(listEndPosition$iv2);
                        }
                        TxBlob.Sidecar sidecar = (TxBlob.Sidecar)rlp.decode((RlpDecodable)TxBlob.Sidecar.Companion);
                        if (sidecar == null) {
                            return null;
                        }
                        TxBlob.Sidecar sidecar2 = sidecar;
                        TxBlob txBlob = tx;
                        if (txBlob == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"tx");
                            txBlob = null;
                        }
                        TransactionUnsigned transactionUnsigned = TxBlob.copy$default(txBlob, null, null, 0L, 0L, null, null, null, 0L, null, null, null, sidecar2, 2047, null);
                        Signature signature6 = signature;
                        if (signature6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"signature");
                            signature6 = null;
                        }
                        transactionSigned3 = new TransactionSigned(transactionUnsigned, signature6, null, null, 12, null);
                    } else {
                        TxBlob txBlob = TxBlob.Companion.rlpDecode(rlp);
                        if (txBlob == null) {
                            return null;
                        }
                        TxBlob tx = txBlob;
                        Signature signature = (Signature)rlp.decode((RlpDecodable)Signature.Companion);
                        if (signature == null) {
                            return null;
                        }
                        Signature signature7 = signature;
                        transactionSigned3 = new TransactionSigned(tx, signature7, null, null, 12, null);
                    }
                    TransactionSigned r$iv = transactionSigned3;
                    this_$iv.finishList(listEndPosition$iv);
                    transactionSigned = r$iv;
                }
            } else if (txType instanceof TxType.Unsupported) {
                transactionSigned = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return transactionSigned;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

