/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bloom;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Log;
import io.ethers.core.types.TransactionReceipt;
import io.ethers.core.types.transaction.TxType;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/TxReceiptDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lio/ethers/core/types/TransactionReceipt;", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nTransactionReceipt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionReceipt.kt\nio/ethers/core/types/TxReceiptDeserializer\n+ 2 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n1#1,124:1\n33#2,4:125\n75#2,4:129\n75#2,4:133\n38#2:137\n*S KotlinDebug\n*F\n+ 1 TransactionReceipt.kt\nio/ethers/core/types/TxReceiptDeserializer\n*L\n78#1:125,4\n85#1:129,4\n88#1:133,4\n78#1:137\n*E\n"})
final class TxReceiptDeserializer
extends JsonDeserializer<TransactionReceipt> {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public TransactionReceipt deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Map map;
        Address address;
        Hash hash;
        if (p.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Expected start object, got: " + p.getCurrentToken());
        }
        Hash blockHash = null;
        long blockNumber = 0L;
        blockNumber = -1L;
        Hash transactionHash = null;
        int transactionIndex = 0;
        transactionIndex = -1;
        Address from = null;
        Ref.ObjectRef to = new Ref.ObjectRef();
        long gasUsed = 0L;
        gasUsed = -1L;
        long cumulativeGasUsed = 0L;
        cumulativeGasUsed = -1L;
        Ref.ObjectRef contractAddress = new Ref.ObjectRef();
        List<Log> logs = null;
        logs = CollectionsKt.emptyList();
        Bloom logsBloom = null;
        int type = 0;
        type = -1;
        BigInteger effectiveGasPrice = null;
        long status = 0L;
        status = -1L;
        Bytes root = null;
        HashMap otherFields = null;
        JsonParser $this$forEachObjectField$iv = p;
        boolean $i$f$forEachObjectField = false;
        while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$forEachObjectField$iv)) {
            String field$iv = $this$forEachObjectField$iv.currentName();
            $this$forEachObjectField$iv.nextToken();
            String field = field$iv;
            boolean bl = false;
            switch (field) {
                case "blockHash": {
                    blockHash = JsonParserExtensionsKt.readHash(p);
                    break;
                }
                case "blockNumber": {
                    blockNumber = JsonParserExtensionsKt.readHexLong(p);
                    break;
                }
                case "transactionHash": {
                    transactionHash = JsonParserExtensionsKt.readHash(p);
                    break;
                }
                case "transactionIndex": {
                    transactionIndex = JsonParserExtensionsKt.readHexInt(p);
                    break;
                }
                case "from": {
                    from = JsonParserExtensionsKt.readAddress(p);
                    break;
                }
                case "to": {
                    JsonParser $this$deserialize_u24lambda_u242_u24lambda_u240;
                    Ref.ObjectRef objectRef;
                    Address address2;
                    Ref.ObjectRef objectRef2 = to;
                    JsonParser $this$readOrNull$iv = p;
                    boolean $i$f$readOrNull = false;
                    if ($this$readOrNull$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                        address2 = null;
                    } else {
                        JsonParser jsonParser = $this$readOrNull$iv;
                        objectRef = objectRef2;
                        boolean bl2 = false;
                        address2 = JsonParserExtensionsKt.readAddress($this$deserialize_u24lambda_u242_u24lambda_u240);
                        objectRef2 = objectRef;
                    }
                    objectRef2.element = address2;
                    break;
                }
                case "gasUsed": {
                    gasUsed = JsonParserExtensionsKt.readHexLong(p);
                    break;
                }
                case "cumulativeGasUsed": {
                    cumulativeGasUsed = JsonParserExtensionsKt.readHexLong(p);
                    break;
                }
                case "contractAddress": {
                    Address address3;
                    JsonParser $this$deserialize_u24lambda_u242_u24lambda_u240;
                    Ref.ObjectRef objectRef;
                    Ref.ObjectRef objectRef3 = contractAddress;
                    JsonParser $this$readOrNull$iv = p;
                    boolean $i$f$readOrNull = false;
                    if ($this$readOrNull$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
                        address3 = null;
                    } else {
                        void $this$deserialize_u24lambda_u242_u24lambda_u241;
                        $this$deserialize_u24lambda_u242_u24lambda_u240 = $this$readOrNull$iv;
                        objectRef = objectRef3;
                        boolean bl3 = false;
                        address3 = JsonParserExtensionsKt.readAddress((JsonParser)$this$deserialize_u24lambda_u242_u24lambda_u241);
                        objectRef3 = objectRef;
                    }
                    objectRef3.element = address3;
                    break;
                }
                case "logs": {
                    logs = JsonParserExtensionsKt.readListOf(p, Log.class);
                    break;
                }
                case "logsBloom": {
                    logsBloom = JsonParserExtensionsKt.readBloom(p);
                    break;
                }
                case "type": {
                    type = JsonParserExtensionsKt.readHexInt(p);
                    break;
                }
                case "effectiveGasPrice": {
                    effectiveGasPrice = JsonParserExtensionsKt.readHexBigInteger(p);
                    break;
                }
                case "status": {
                    status = JsonParserExtensionsKt.readHexLong(p);
                    break;
                }
                case "root": {
                    root = JsonParserExtensionsKt.readBytes(p);
                    break;
                }
                default: {
                    if (otherFields == null) {
                        otherFields = new HashMap();
                    }
                    ((Map)otherFields).put(p.currentName(), p.readValueAsTree());
                }
            }
        }
        Hash hash2 = blockHash;
        if (hash2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"blockHash");
            hash2 = null;
        }
        if ((hash = transactionHash) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactionHash");
            hash = null;
        }
        if ((address = from) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"from");
            address = null;
        }
        Address address4 = (Address)to.element;
        Address address5 = (Address)contractAddress.element;
        Bloom bloom = logsBloom;
        if (bloom == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logsBloom");
            bloom = null;
        }
        TxType txType = TxType.Companion.fromType(type);
        BigInteger bigInteger = effectiveGasPrice;
        if (bigInteger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"effectiveGasPrice");
            bigInteger = null;
        }
        if ((map = (Map)otherFields) == null) {
            map = MapsKt.emptyMap();
        }
        return new TransactionReceipt(hash2, blockNumber, hash, transactionIndex, address, address4, gasUsed, cumulativeGasUsed, address5, logs, bloom, txType, bigInteger, status, root, map);
    }
}

