/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockSelector;
import io.ethers.core.types.Hash;
import io.ethers.core.types.LogFilter;
import io.ethers.core.types.LogFilterKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lio/ethers/core/types/LogFilterSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lio/ethers/core/types/LogFilter;", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "ethers-core"})
final class LogFilterSerializer
extends JsonSerializer<LogFilter> {
    public void serialize(@NotNull LogFilter value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
        int lastValidIndex;
        Hash[][] topics;
        gen.writeStartObject();
        BlockSelector blocks = value.getBlocks();
        if (blocks instanceof BlockSelector.Hash) {
            gen.writeStringField("blockHash", ((BlockSelector.Hash)blocks).getFrom().getId());
        } else if (blocks instanceof BlockSelector.Range) {
            gen.writeStringField("fromBlock", ((BlockSelector.Range)blocks).getFrom().getId());
            gen.writeStringField("toBlock", ((BlockSelector.Range)blocks).getTo().getId());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Address[] address = value.getAddresses();
        if (address != null) {
            gen.writeArrayFieldStart("address");
            int n = address.length;
            for (int i = 0; i < n; ++i) {
                gen.writeString(address[i].toString());
            }
            gen.writeEndArray();
        }
        if ((topics = value.getTopics()) != null && (lastValidIndex = LogFilterKt.access$getIndexOfLastNonNullTopic(topics)) != -1) {
            gen.writeArrayFieldStart("topics");
            int i = 0;
            if (i <= lastValidIndex) {
                while (true) {
                    Hash[] hashes = topics[i];
                    if (hashes == null) {
                        gen.writeNull();
                    } else if (hashes.length == 1) {
                        gen.writeString(hashes[0].toString());
                    } else {
                        gen.writeStartArray();
                        int n = hashes.length;
                        for (int j = 0; j < n; ++j) {
                            gen.writeString(hashes[j].toString());
                        }
                        gen.writeEndArray();
                    }
                    if (i == lastValidIndex) break;
                    ++i;
                }
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }
}

