/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.ethers.core.types.AccountOverrideSerializer;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonSerialize(using=AccountOverrideSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u001c\u0010\u001b\u001a\u00020\u00002\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019J\u001c\u0010 \u001a\u00020\u00002\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u0000J\b\u0010&\u001a\u00020'H\u0016J\u0013\u0010(\u001a\u00020)2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R@\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR@\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001f\u00a8\u0006-"}, d2={"Lio/ethers/core/types/AccountOverride;", "", "<init>", "()V", "other", "(Lio/ethers/core/types/AccountOverride;)V", "nonce", "", "getNonce", "()J", "setNonce", "(J)V", "code", "Lio/ethers/core/types/Bytes;", "getCode", "()Lio/ethers/core/types/Bytes;", "setCode", "(Lio/ethers/core/types/Bytes;)V", "balance", "Ljava/math/BigInteger;", "getBalance", "()Ljava/math/BigInteger;", "setBalance", "(Ljava/math/BigInteger;)V", "value", "", "Lio/ethers/core/types/Hash;", "state", "getState", "()Ljava/util/Map;", "setState", "(Ljava/util/Map;)V", "stateDiff", "getStateDiff", "setStateDiff", "mergeChanges", "applyChanges", "", "toString", "", "equals", "", "hashCode", "", "Companion", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nAccountOverride.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountOverride.kt\nio/ethers/core/types/AccountOverride\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
public final class AccountOverride {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long nonce = -1L;
    @Nullable
    private Bytes code;
    @Nullable
    private BigInteger balance;
    @Nullable
    private Map<Hash, Hash> state;
    @Nullable
    private Map<Hash, Hash> stateDiff;

    public AccountOverride() {
    }

    public AccountOverride(@NotNull AccountOverride other) {
        this();
        this.applyChanges(other);
    }

    public final long getNonce() {
        return this.nonce;
    }

    public final /* synthetic */ void setNonce(long l) {
        this.nonce = l;
    }

    @Nullable
    public final Bytes getCode() {
        return this.code;
    }

    public final /* synthetic */ void setCode(Bytes bytes) {
        this.code = bytes;
    }

    @Nullable
    public final BigInteger getBalance() {
        return this.balance;
    }

    public final /* synthetic */ void setBalance(BigInteger bigInteger) {
        this.balance = bigInteger;
    }

    @Nullable
    public final Map<Hash, Hash> getState() {
        return this.state;
    }

    public final /* synthetic */ void setState(Map value) {
        if (!(value == null || this.stateDiff == null)) {
            boolean bl = false;
            String string = "state and stateDiff cannot be set at the same time";
            throw new IllegalArgumentException(string.toString());
        }
        this.state = value;
    }

    @Nullable
    public final Map<Hash, Hash> getStateDiff() {
        return this.stateDiff;
    }

    public final /* synthetic */ void setStateDiff(Map value) {
        if (!(value == null || this.state == null)) {
            boolean bl = false;
            String string = "state and stateDiff cannot be set at the same time";
            throw new IllegalArgumentException(string.toString());
        }
        this.stateDiff = value;
    }

    @NotNull
    public final AccountOverride nonce(long nonce) {
        this.nonce = nonce;
        return this;
    }

    @NotNull
    public final AccountOverride code(@Nullable Bytes code) {
        this.code = code;
        return this;
    }

    @NotNull
    public final AccountOverride balance(@Nullable BigInteger balance) {
        this.balance = balance;
        return this;
    }

    @NotNull
    public final AccountOverride state(@Nullable Map<Hash, Hash> state) {
        this.setState(state);
        return this;
    }

    @NotNull
    public final AccountOverride stateDiff(@Nullable Map<Hash, Hash> stateDiff) {
        this.setStateDiff(stateDiff);
        return this;
    }

    @NotNull
    public final AccountOverride mergeChanges(@NotNull AccountOverride other) {
        AccountOverride ret = new AccountOverride();
        ret.applyChanges(this);
        ret.applyChanges(other);
        return ret;
    }

    public final void applyChanges(@NotNull AccountOverride other) {
        if (other.nonce != -1L) {
            this.nonce = other.nonce;
        }
        if (other.code != null) {
            this.code = other.code;
        }
        if (other.balance != null) {
            this.balance = other.balance;
        }
        if (other.state != null) {
            this.setStateDiff(null);
            this.setState(other.state);
        }
        if (other.stateDiff != null) {
            Map<Object, Object> curr;
            boolean applyingOnFreshState = this.state != null;
            Map<Object, Object> map = curr = applyingOnFreshState ? this.state : this.stateDiff;
            if (curr == null) {
                Map<Hash, Hash> map2 = other.stateDiff;
                Intrinsics.checkNotNull(map2);
                curr = new HashMap(map2.size());
            }
            if (curr instanceof HashMap) {
                HashMap hashMap = (HashMap)curr;
                Map<Hash, Hash> map3 = other.stateDiff;
                Intrinsics.checkNotNull(map3);
                hashMap.putAll(map3);
            } else {
                HashMap<Hash, Hash> hashMap;
                HashMap<Hash, Hash> $this$applyChanges_u24lambda_u242 = hashMap = new HashMap<Hash, Hash>(curr);
                boolean bl = false;
                Map<Hash, Hash> map4 = other.stateDiff;
                Intrinsics.checkNotNull(map4);
                $this$applyChanges_u24lambda_u242.putAll(map4);
                curr = hashMap;
            }
            if (applyingOnFreshState) {
                this.setState(curr);
            } else {
                this.setStateDiff(curr);
            }
        }
    }

    @NotNull
    public String toString() {
        return "AccountOverride(nonce=" + this.nonce + ", code=" + this.code + ", balance=" + this.balance + ", state=" + this.state + ", stateDiff=" + this.stateDiff + ")";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.ethers.core.types.AccountOverride");
        AccountOverride cfr_ignored_0 = (AccountOverride)other;
        if (this.nonce != ((AccountOverride)other).nonce) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.code, (Object)((AccountOverride)other).code)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.balance, (Object)((AccountOverride)other).balance)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.state, ((AccountOverride)other).state)) {
            return false;
        }
        return Intrinsics.areEqual(this.stateDiff, ((AccountOverride)other).stateDiff);
    }

    public int hashCode() {
        int result = Long.hashCode(this.nonce);
        Bytes bytes = this.code;
        result = 31 * result + (bytes != null ? bytes.hashCode() : 0);
        BigInteger bigInteger = this.balance;
        result = 31 * result + (bigInteger != null ? bigInteger.hashCode() : 0);
        Map<Hash, Hash> map = this.state;
        result = 31 * result + (map != null ? ((Object)map).hashCode() : 0);
        Map<Hash, Hash> map2 = this.stateDiff;
        result = 31 * result + (map2 != null ? ((Object)map2).hashCode() : 0);
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\b\tH\u0086\n\u00a8\u0006\n"}, d2={"Lio/ethers/core/types/AccountOverride$Companion;", "", "<init>", "()V", "invoke", "Lio/ethers/core/types/AccountOverride;", "builder", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ethers-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AccountOverride invoke(@NotNull Function1<? super AccountOverride, Unit> builder) {
            boolean $i$f$invoke = false;
            AccountOverride accountOverride = new AccountOverride();
            builder.invoke((Object)accountOverride);
            return accountOverride;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

