/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core.types;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.ethers.core.types.AccessListItemDeserializer;
import io.ethers.core.types.AccessListItemSerializer;
import io.ethers.core.types.Address;
import io.ethers.core.types.Hash;
import io.ethers.rlp.RlpDecodable;
import io.ethers.rlp.RlpDecoder;
import io.ethers.rlp.RlpEncodable;
import io.ethers.rlp.RlpEncoder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lio/ethers/core/types/AccessList;", "", "<init>", "()V", "Item", "ethers-core"})
public final class AccessList {
    @NotNull
    public static final AccessList INSTANCE = new AccessList();

    private AccessList() {
    }

    @JsonSerialize(using=AccessListItemSerializer.class)
    @JsonDeserialize(using=AccessListItemDeserializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lio/ethers/core/types/AccessList$Item;", "Lio/ethers/rlp/RlpEncodable;", "address", "Lio/ethers/core/types/Address;", "storageKeys", "", "Lio/ethers/core/types/Hash;", "<init>", "(Lio/ethers/core/types/Address;Ljava/util/List;)V", "getAddress", "()Lio/ethers/core/types/Address;", "getStorageKeys", "()Ljava/util/List;", "rlpEncode", "", "rlp", "Lio/ethers/rlp/RlpEncoder;", "rlpSize", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "ethers-core"})
    @SourceDebugExtension(value={"SMAP\nAccessList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessList.kt\nio/ethers/core/types/AccessList$Item\n+ 2 RlpEncoder.kt\nio/ethers/rlp/RlpEncoder\n*L\n1#1,122:1\n71#2,5:123\n*S KotlinDebug\n*F\n+ 1 AccessList.kt\nio/ethers/core/types/AccessList$Item\n*L\n34#1:123,5\n*E\n"})
    public static final class Item
    implements RlpEncodable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Address address;
        @NotNull
        private final List<Hash> storageKeys;

        public Item(@NotNull Address address, @NotNull List<Hash> storageKeys) {
            this.address = address;
            this.storageKeys = storageKeys;
        }

        @NotNull
        public final Address getAddress() {
            return this.address;
        }

        @NotNull
        public final List<Hash> getStorageKeys() {
            return this.storageKeys;
        }

        public void rlpEncode(@NotNull RlpEncoder rlp) {
            int listBodySize = RlpEncoder.Companion.sizeOf((RlpEncodable)this.address) + RlpEncoder.Companion.sizeOfList(this.storageKeys);
            RlpEncoder this_$iv = rlp;
            boolean $i$f$encodeList = false;
            int bufferStartPosition$iv = this_$iv.startList(listBodySize);
            RlpEncoder $this$rlpEncode_u24lambda_u240 = this_$iv;
            boolean bl = false;
            $this$rlpEncode_u24lambda_u240.encode((RlpEncodable)this.address);
            $this$rlpEncode_u24lambda_u240.encodeList(this.storageKeys);
            this_$iv.finishList(bufferStartPosition$iv, listBodySize);
        }

        public int rlpSize() {
            RlpEncoder.Companion $this$rlpSize_u24lambda_u241 = RlpEncoder.Companion;
            boolean bl = false;
            return $this$rlpSize_u24lambda_u241.sizeOfList($this$rlpSize_u24lambda_u241.sizeOf((RlpEncodable)this.address) + $this$rlpSize_u24lambda_u241.sizeOfList(this.storageKeys));
        }

        @NotNull
        public final Address component1() {
            return this.address;
        }

        @NotNull
        public final List<Hash> component2() {
            return this.storageKeys;
        }

        @NotNull
        public final Item copy(@NotNull Address address, @NotNull List<Hash> storageKeys) {
            return new Item(address, storageKeys);
        }

        public static /* synthetic */ Item copy$default(Item item, Address address, List list, int n, Object object) {
            if ((n & 1) != 0) {
                address = item.address;
            }
            if ((n & 2) != 0) {
                list = item.storageKeys;
            }
            return item.copy(address, list);
        }

        @NotNull
        public String toString() {
            return "Item(address=" + this.address + ", storageKeys=" + this.storageKeys + ")";
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = result * 31 + ((Object)this.storageKeys).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Item item = (Item)other;
            if (!Intrinsics.areEqual((Object)this.address, (Object)item.address)) {
                return false;
            }
            return Intrinsics.areEqual(this.storageKeys, item.storageKeys);
        }

        @JvmStatic
        @Nullable
        public static Item rlpDecode(@NotNull RlpDecoder rlp) {
            return Companion.rlpDecode(rlp);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0017\u00a8\u0006\b"}, d2={"Lio/ethers/core/types/AccessList$Item$Companion;", "Lio/ethers/rlp/RlpDecodable;", "Lio/ethers/core/types/AccessList$Item;", "<init>", "()V", "rlpDecode", "rlp", "Lio/ethers/rlp/RlpDecoder;", "ethers-core"})
        @SourceDebugExtension(value={"SMAP\nAccessList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessList.kt\nio/ethers/core/types/AccessList$Item$Companion\n+ 2 RlpDecoder.kt\nio/ethers/rlp/RlpDecoder\n*L\n1#1,122:1\n102#2,10:123\n*S KotlinDebug\n*F\n+ 1 AccessList.kt\nio/ethers/core/types/AccessList$Item$Companion\n*L\n47#1:123,10\n*E\n"})
        public static final class Companion
        implements RlpDecodable<Item> {
            private Companion() {
            }

            @JvmStatic
            @Nullable
            public Item rlpDecode(@NotNull RlpDecoder rlp) {
                Item item;
                RlpDecoder this_$iv = rlp;
                boolean $i$f$decodeList = false;
                int listEndPosition$iv = this_$iv.startList();
                if (this_$iv.getPosition() == listEndPosition$iv) {
                    item = null;
                } else {
                    RlpDecoder $this$rlpDecode_u24lambda_u240 = this_$iv;
                    boolean bl = false;
                    Address address = (Address)rlp.decode((RlpDecodable)Address.Companion);
                    if (address == null) {
                        return null;
                    }
                    Address address2 = address;
                    List storageKeys = rlp.decodeAsList((RlpDecodable)Hash.Companion);
                    Item r$iv = new Item(address2, storageKeys);
                    this_$iv.finishList(listEndPosition$iv);
                    item = r$iv;
                }
                return item;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

