/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.ethers.core.FastHex;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bloom;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a0\u0010\u0004\u001a\u00020\u0005*\u00020\u00022!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00050\u0007H\u0086\b\u001a\u001b\u0010\f\u001a\u00020\u0005*\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0086\b\u001a\u0012\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\b\u001a\u001b\u0010\u0010\u001a\u00020\u0005*\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0086\b\u001a3\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u0013*\u00020\u00022\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00130\u0007\u00a2\u0006\u0002\b\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u0016\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u001a*\u00020\u0002\u001a\f\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0002\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020\u0002\u001a\n\u0010 \u001a\u00020!*\u00020\u0002\u001a\n\u0010\"\u001a\u00020#*\u00020\u0002\u001a\n\u0010$\u001a\u00020#*\u00020\u0002\u001a\f\u0010%\u001a\u00020#*\u00020&H\u0002\u001a\n\u0010'\u001a\u00020(*\u00020\u0002\u001a\f\u0010)\u001a\u00020(*\u00020&H\u0002\u001a\u0010\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0+*\u00020\u0002\u001a,\u0010,\u001a\u0010\u0012\f\u0012\n .*\u0004\u0018\u0001H-H-0+\"\u0004\b\u0000\u0010-*\u00020\u00022\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-00\u001a2\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00130+\"\u0004\b\u0000\u0010\u0013*\u00020\u00022\u0017\u00101\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00130\u0007\u00a2\u0006\u0002\b\u0015H\u0086\b\u001aG\u00102\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H503\"\u0004\b\u0000\u00104\"\u0004\b\u0001\u00105*\u00020\u00022\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H40\u00072\f\u00107\u001a\b\u0012\u0004\u0012\u0002H500H\u0086\b\u001aR\u00102\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H503\"\u0004\b\u0000\u00104\"\u0004\b\u0001\u00105*\u00020\u00022\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u0002H40\u00072\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H50\u0007\u00a2\u0006\u0002\b\u0015H\u0086\b\u001a(\u00109\u001a\b\u0012\u0004\u0012\u0002H\u00130:\"\b\b\u0000\u0010\u0013*\u00020;*\u00020\u00022\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001300\u001a3\u00109\u001a\b\u0012\u0004\u0012\u0002H\u00130:\"\b\b\u0000\u0010\u0013*\u00020;*\u00020\u00022\u0017\u0010<\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00130\u0007\u00a2\u0006\u0002\b\u0015\u001a\n\u0010>\u001a\u00020&*\u00020\u0002\u001a\n\u0010?\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010@\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010B\u001a\u00020\u0005*\u00020\u0002\"\u000e\u0010=\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010A\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"isNextTokenObjectEnd", "", "Lcom/fasterxml/jackson/core/JsonParser;", "isNextTokenArrayEnd", "forEachObjectField", "", "parseObjectValue", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "fieldName", "forEachArrayElement", "parseArrayValue", "Lkotlin/Function0;", "isField", "ifNotNull", "block", "readOrNull", "R", "parseValue", "Lkotlin/ExtensionFunctionType;", "(Lcom/fasterxml/jackson/core/JsonParser;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readAddress", "Lio/ethers/core/types/Address;", "readBytes", "Lio/ethers/core/types/Bytes;", "readBytesEmptyAsNull", "readBloom", "Lio/ethers/core/types/Bloom;", "readHash", "Lio/ethers/core/types/Hash;", "readHexBigInteger", "Ljava/math/BigInteger;", "readAnyLong", "", "readHexLong", "toLong", "", "readHexInt", "", "toInt", "readListOfHashes", "", "readListOf", "T", "kotlin.jvm.PlatformType", "clazz", "Ljava/lang/Class;", "decoder", "readMapOf", "", "K", "V", "keyParser", "valueClass", "valueParser", "readOptionalValue", "Ljava/util/Optional;", "", "action", "EMPTY_BYTES", "readHexByteArray", "isHexValue", "initForReading", "STRICT_MODE", "handleUnknownField", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nJsonParserExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n194#1,14:362\n194#1,14:376\n1#2:390\n*S KotlinDebug\n*F\n+ 1 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n183#1:362,14\n188#1:376,14\n*E\n"})
public final class JsonParserExtensionsKt {
    @NotNull
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final boolean STRICT_MODE = Intrinsics.areEqual((Object)System.getenv("ETHERS_JSON_STRICT_MODE"), (Object)"true");

    public static final boolean isNextTokenObjectEnd(@NotNull JsonParser $this$isNextTokenObjectEnd) {
        JsonToken token = $this$isNextTokenObjectEnd.nextToken();
        return token == null || token == JsonToken.END_OBJECT;
    }

    public static final boolean isNextTokenArrayEnd(@NotNull JsonParser $this$isNextTokenArrayEnd) {
        JsonToken token = $this$isNextTokenArrayEnd.nextToken();
        return token == null || token == JsonToken.END_ARRAY;
    }

    public static final void forEachObjectField(@NotNull JsonParser $this$forEachObjectField, @NotNull Function1<? super String, Unit> parseObjectValue) {
        boolean $i$f$forEachObjectField = false;
        while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$forEachObjectField)) {
            String field = $this$forEachObjectField.currentName();
            $this$forEachObjectField.nextToken();
            parseObjectValue.invoke((Object)field);
        }
    }

    public static final void forEachArrayElement(@NotNull JsonParser $this$forEachArrayElement, @NotNull Function0<Unit> parseArrayValue) {
        boolean $i$f$forEachArrayElement = false;
        while (!JsonParserExtensionsKt.isNextTokenArrayEnd($this$forEachArrayElement)) {
            parseArrayValue.invoke();
        }
    }

    public static final boolean isField(@NotNull JsonParser $this$isField, @NotNull String name) {
        if (!Intrinsics.areEqual((Object)$this$isField.currentName(), (Object)name)) {
            return false;
        }
        $this$isField.nextToken();
        return true;
    }

    public static final void ifNotNull(@NotNull JsonParser $this$ifNotNull, @NotNull Function0<Unit> block) {
        boolean $i$f$ifNotNull = false;
        if ($this$ifNotNull.getCurrentToken() == JsonToken.VALUE_NULL) {
            return;
        }
        block.invoke();
    }

    @Nullable
    public static final <R> R readOrNull(@NotNull JsonParser $this$readOrNull, @NotNull Function1<? super JsonParser, ? extends R> parseValue) {
        boolean $i$f$readOrNull = false;
        if ($this$readOrNull.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        return (R)parseValue.invoke((Object)$this$readOrNull);
    }

    @NotNull
    public static final Address readAddress(@NotNull JsonParser $this$readAddress) {
        byte[] arr = JsonParserExtensionsKt.readHexByteArray($this$readAddress);
        if (arr.length == 0) {
            return Address.ZERO;
        }
        return new Address(arr);
    }

    @NotNull
    public static final Bytes readBytes(@NotNull JsonParser $this$readBytes) {
        byte[] arr = JsonParserExtensionsKt.readHexByteArray($this$readBytes);
        if (arr.length == 0) {
            return Bytes.EMPTY;
        }
        return new Bytes(arr);
    }

    @Nullable
    public static final Bytes readBytesEmptyAsNull(@NotNull JsonParser $this$readBytesEmptyAsNull) {
        byte[] bytes = JsonParserExtensionsKt.readHexByteArray($this$readBytesEmptyAsNull);
        if (bytes.length == 0) {
            return null;
        }
        return new Bytes(bytes);
    }

    @NotNull
    public static final Bloom readBloom(@NotNull JsonParser $this$readBloom) {
        return new Bloom(JsonParserExtensionsKt.readHexByteArray($this$readBloom));
    }

    @NotNull
    public static final Hash readHash(@NotNull JsonParser $this$readHash) {
        return new Hash(JsonParserExtensionsKt.readHexByteArray($this$readHash));
    }

    @NotNull
    public static final BigInteger readHexBigInteger(@NotNull JsonParser $this$readHexBigInteger) {
        byte[] decoded = JsonParserExtensionsKt.readHexByteArray($this$readHexBigInteger);
        if (decoded.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(1, decoded);
    }

    public static final long readAnyLong(@NotNull JsonParser $this$readAnyLong) {
        if (JsonParserExtensionsKt.isHexValue($this$readAnyLong)) {
            return JsonParserExtensionsKt.readHexLong($this$readAnyLong);
        }
        return $this$readAnyLong.getValueAsLong();
    }

    public static final long readHexLong(@NotNull JsonParser $this$readHexLong) {
        return JsonParserExtensionsKt.toLong(JsonParserExtensionsKt.readHexByteArray($this$readHexLong));
    }

    private static final long toLong(byte[] $this$toLong) {
        if ($this$toLong.length == 0) {
            return 0L;
        }
        long value = 0L;
        for (byte b : $this$toLong) {
            value = (value << 8) + (long)(b & 0xFF);
        }
        return value;
    }

    public static final int readHexInt(@NotNull JsonParser $this$readHexInt) {
        return JsonParserExtensionsKt.toInt(JsonParserExtensionsKt.readHexByteArray($this$readHexInt));
    }

    private static final int toInt(byte[] $this$toInt) {
        if ($this$toInt.length == 0) {
            return 0;
        }
        int value = 0;
        for (byte b : $this$toInt) {
            value = (value << 8) + (b & 0xFF);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Hash> readListOfHashes(@NotNull JsonParser $this$readListOfHashes) {
        List list;
        JsonParser $this$readListOf$iv = $this$readListOfHashes;
        boolean $i$f$readListOf = false;
        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
            list = CollectionsKt.emptyList();
        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
            list = CollectionsKt.emptyList();
        } else {
            ArrayList<Hash> ret$iv = new ArrayList<Hash>();
            do {
                void $this$readListOfHashes_u24lambda_u240;
                JsonParser jsonParser = $this$readListOf$iv;
                ArrayList<Hash> arrayList = ret$iv;
                boolean bl = false;
                arrayList.add(JsonParserExtensionsKt.readHash((JsonParser)$this$readListOfHashes_u24lambda_u240));
            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
            list = ret$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> readListOf(@NotNull JsonParser $this$readListOf, @NotNull Class<T> clazz) {
        List list;
        JsonParser $this$readListOf$iv = $this$readListOf;
        boolean $i$f$readListOf = false;
        if ($this$readListOf$iv.getCurrentToken() == JsonToken.VALUE_NULL) {
            list = CollectionsKt.emptyList();
        } else if ($this$readListOf$iv.nextToken() == JsonToken.END_ARRAY) {
            list = CollectionsKt.emptyList();
        } else {
            ArrayList<Object> ret$iv = new ArrayList<Object>();
            do {
                void $this$readListOf_u24lambda_u241;
                JsonParser jsonParser = $this$readListOf$iv;
                ArrayList<Object> arrayList = ret$iv;
                boolean bl = false;
                arrayList.add($this$readListOf_u24lambda_u241.readValueAs(clazz));
            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
            list = ret$iv;
        }
        return list;
    }

    @NotNull
    public static final <R> List<R> readListOf(@NotNull JsonParser $this$readListOf, @NotNull Function1<? super JsonParser, ? extends R> decoder) {
        boolean $i$f$readListOf = false;
        if ($this$readListOf.getCurrentToken() == JsonToken.VALUE_NULL) {
            return CollectionsKt.emptyList();
        }
        if ($this$readListOf.nextToken() == JsonToken.END_ARRAY) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        do {
            ret.add(decoder.invoke((Object)$this$readListOf));
        } while ($this$readListOf.nextToken() != JsonToken.END_ARRAY);
        return ret;
    }

    @NotNull
    public static final <K, V> Map<K, V> readMapOf(@NotNull JsonParser $this$readMapOf, @NotNull Function1<? super String, ? extends K> keyParser, @NotNull Class<V> valueClass) {
        boolean $i$f$readMapOf = false;
        if ($this$readMapOf.getCurrentToken() == JsonToken.VALUE_NULL) {
            return MapsKt.emptyMap();
        }
        if ($this$readMapOf.nextToken() == JsonToken.END_OBJECT) {
            return MapsKt.emptyMap();
        }
        HashMap ret = new HashMap();
        do {
            Map map = ret;
            Object object = keyParser.invoke((Object)$this$readMapOf.currentName());
            JsonToken $this$readMapOf_u24lambda_u242 = $this$readMapOf.nextToken();
            boolean bl = false;
            Object object2 = $this$readMapOf.readValueAs(valueClass);
            map.put(object, object2);
        } while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$readMapOf));
        return ret;
    }

    @NotNull
    public static final <K, V> Map<K, V> readMapOf(@NotNull JsonParser $this$readMapOf, @NotNull Function1<? super String, ? extends K> keyParser, @NotNull Function1<? super JsonParser, ? extends V> valueParser) {
        boolean $i$f$readMapOf = false;
        if ($this$readMapOf.getCurrentToken() == JsonToken.VALUE_NULL) {
            return MapsKt.emptyMap();
        }
        if ($this$readMapOf.nextToken() == JsonToken.END_OBJECT) {
            return MapsKt.emptyMap();
        }
        HashMap ret = new HashMap();
        do {
            Map map = ret;
            Object object = keyParser.invoke((Object)$this$readMapOf.currentName());
            JsonToken $this$readMapOf_u24lambda_u243 = $this$readMapOf.nextToken();
            boolean bl = false;
            Object object2 = valueParser.invoke((Object)$this$readMapOf);
            map.put(object, object2);
        } while (!JsonParserExtensionsKt.isNextTokenObjectEnd($this$readMapOf));
        return ret;
    }

    @NotNull
    public static final <R> Optional<R> readOptionalValue(@NotNull JsonParser $this$readOptionalValue, @NotNull Class<R> clazz) {
        Optional<Object> optional;
        if ($this$readOptionalValue.currentToken() == JsonToken.VALUE_NULL) {
            $this$readOptionalValue.nextToken();
            optional = Optional.empty();
        } else {
            optional = Optional.of($this$readOptionalValue.readValueAs(clazz));
        }
        return optional;
    }

    @NotNull
    public static final <R> Optional<R> readOptionalValue(@NotNull JsonParser $this$readOptionalValue, @NotNull Function1<? super JsonParser, ? extends R> action) {
        Optional<Object> optional;
        if ($this$readOptionalValue.currentToken() == JsonToken.VALUE_NULL) {
            $this$readOptionalValue.nextToken();
            optional = Optional.empty();
        } else {
            optional = Optional.of(action.invoke((Object)$this$readOptionalValue));
        }
        return optional;
    }

    @NotNull
    public static final byte[] readHexByteArray(@NotNull JsonParser $this$readHexByteArray) {
        if (!$this$readHexByteArray.hasTextCharacters()) {
            String text = $this$readHexByteArray.getText();
            if (((CharSequence)text).length() == 0) {
                return EMPTY_BYTES;
            }
            if (text.length() == 2 && (Intrinsics.areEqual((Object)text, (Object)"0x") || Intrinsics.areEqual((Object)text, (Object)"0X"))) {
                return EMPTY_BYTES;
            }
            return FastHex.decode(text);
        }
        int len = $this$readHexByteArray.getTextLength();
        if (len == 0) {
            return EMPTY_BYTES;
        }
        char[] chars = $this$readHexByteArray.getTextCharacters();
        int offset = $this$readHexByteArray.getTextOffset();
        if (len == 2 && chars[offset] == '0' && (chars[offset + 1] == 'x' || chars[offset + 1] == 'X')) {
            return EMPTY_BYTES;
        }
        return FastHex.decode(chars, offset, len);
    }

    public static final boolean isHexValue(@NotNull JsonParser $this$isHexValue) {
        if (!$this$isHexValue.hasTextCharacters()) {
            String text = $this$isHexValue.getText();
            return text.length() >= 2 && text.charAt(0) == '0' && (text.charAt(1) == 'x' || text.charAt(1) == 'X');
        }
        int len = $this$isHexValue.getTextLength();
        if (len == 0) {
            return false;
        }
        char[] chars = $this$isHexValue.getTextCharacters();
        int offset = $this$isHexValue.getTextOffset();
        return len >= 2 && chars[offset] == '0' && (chars[offset + 1] == 'x' || chars[offset + 1] == 'X');
    }

    @NotNull
    public static final JsonParser initForReading(@NotNull JsonParser $this$initForReading) {
        JsonToken t = $this$initForReading.getCurrentToken();
        if (t == null && (t = $this$initForReading.nextToken()) == null) {
            throw MismatchedInputException.from((JsonParser)$this$initForReading, null, (String)"No content to map due to end-of-input");
        }
        return $this$initForReading;
    }

    public static final void handleUnknownField(@NotNull JsonParser $this$handleUnknownField) {
        if (STRICT_MODE) {
            throw new IllegalArgumentException("Unknown field " + $this$handleUnknownField.currentName());
        }
        $this$handleUnknownField.skipChildren();
    }
}

