/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import io.ethers.core.FastHex;
import io.ethers.core.JsonParserExtensionsKt;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/ethers/core/Jackson;", "", "<init>", "()V", "MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "createAndInitParser", "Lcom/fasterxml/jackson/core/JsonParser;", "content", "", "stream", "Ljava/io/InputStream;", "ByteArrayHexSerializer", "ByteArrayHexDeserializer", "ethers-core"})
public final class Jackson {
    @NotNull
    public static final Jackson INSTANCE = new Jackson();
    @JvmField
    @NotNull
    public static final JsonMapper MAPPER;

    private Jackson() {
    }

    @NotNull
    public final JsonParser createAndInitParser(@NotNull JsonMapper $this$createAndInitParser, @NotNull String content) {
        return JsonParserExtensionsKt.initForReading($this$createAndInitParser.createParser(content));
    }

    @NotNull
    public final JsonParser createAndInitParser(@NotNull JsonMapper $this$createAndInitParser, @NotNull InputStream stream) {
        return JsonParserExtensionsKt.initForReading($this$createAndInitParser.createParser(stream));
    }

    static {
        MapperFeature[] mapperFeatureArray = new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS};
        MAPPER = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(mapperFeatureArray)).addModule((Module)new KotlinModule.Builder().withReflectionCacheSize(512).build())).addModule((Module)new SimpleModule().addSerializer(byte[].class, (JsonSerializer)new ByteArrayHexSerializer()).addDeserializer(byte[].class, (JsonDeserializer)new ByteArrayHexDeserializer()))).build();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/ethers/core/Jackson$ByteArrayHexDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "", "<init>", "()V", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "ethers-core"})
    private static final class ByteArrayHexDeserializer
    extends StdDeserializer<byte[]> {
        public ByteArrayHexDeserializer() {
            super(byte[].class);
        }

        @NotNull
        public byte[] deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
            return JsonParserExtensionsKt.readHexByteArray(p);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lio/ethers/core/Jackson$ByteArrayHexSerializer;", "Lcom/fasterxml/jackson/databind/ser/std/StdSerializer;", "", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "ethers-core"})
    private static final class ByteArrayHexSerializer
    extends StdSerializer<byte[]> {
        public ByteArrayHexSerializer() {
            super(byte[].class);
        }

        public void serialize(@NotNull byte[] value, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) {
            gen.writeString(FastHex.encodeWithPrefix(value));
        }
    }
}

