/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.core;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0014H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000bH\u0007J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J\u001a\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0007J4\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00052!\u0010\u001e\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u00050\u001fH\u0082\bJ(\u0010#\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0007J$\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000b2\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0005H\u0007J$\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020(2\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\u0005H\u0007J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0007J%\u0010*\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00052\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001fH\u0082\bJ\u0018\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001bH\u0002J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/ethers/core/FastHex;", "", "<init>", "()V", "CHARS_PER_BYTE", "", "BITS_PER_CHAR", "BYTE_0", "", "BYTE_X", "EMPTY_BYTES", "", "ENCODE_TABLE", "", "DECODE_TABLE_UPPER", "DECODE_TABLE_LOWER", "encodeWithPrefix", "", "value", "", "Ljava/math/BigInteger;", "buffer", "offset", "len", "encodeWithoutPrefix", "encodeAsBytes", "withPrefix", "", "encodeNumberWithPrefix", "bitSize", "getNextByte", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "bits", "encodeToAsciiBytes", "decode", "hex", "", "length", "", "isValidHex", "decodeHexByte", "charCodeAtOffset", "getNibble", "c", "", "upper", "isValidHexChar", "isDivisibleBy2", "num", "ethers-core"})
@SourceDebugExtension(value={"SMAP\nFastHex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastHex.kt\nio/ethers/core/FastHex\n*L\n1#1,351:1\n124#1,31:352\n124#1,31:383\n124#1,31:414\n317#1:445\n317#1:446\n317#1:447\n*S KotlinDebug\n*F\n+ 1 FastHex.kt\nio/ethers/core/FastHex\n*L\n55#1:352,31\n64#1:383,31\n75#1:414,31\n215#1:445\n252#1:446\n289#1:447\n*E\n"})
public final class FastHex {
    @NotNull
    public static final FastHex INSTANCE;
    private static final int CHARS_PER_BYTE = 2;
    private static final int BITS_PER_CHAR = 4;
    private static final byte BYTE_0 = 48;
    private static final byte BYTE_X = 120;
    @NotNull
    private static final byte[] EMPTY_BYTES;
    @NotNull
    private static final int[] ENCODE_TABLE;
    @NotNull
    private static final byte[] DECODE_TABLE_UPPER;
    @NotNull
    private static final byte[] DECODE_TABLE_LOWER;

    private FastHex() {
    }

    @JvmStatic
    @NotNull
    public static final String encodeWithPrefix(int value) {
        if (value == 0) {
            return "0x0";
        }
        FastHex fastHex = INSTANCE;
        int bitSize$iv = 32;
        boolean $i$f$encodeNumberWithPrefix = false;
        int idx$iv = 2;
        byte[] bytes$iv = null;
        for (int bits$iv = bitSize$iv - 8; bits$iv >= 0; bits$iv -= 8) {
            int it = bits$iv;
            boolean bl = false;
            int byte$iv = value >> it & 0xFF;
            if (bytes$iv == null && byte$iv <= 0) continue;
            int nibbles$iv = ENCODE_TABLE[byte$iv];
            byte upper$iv = (byte)(nibbles$iv >>> 8);
            byte lower$iv = (byte)(nibbles$iv & 0xFF);
            if (bytes$iv == null) {
                boolean upperIsZero$iv = upper$iv == 48;
                int size$iv = (bits$iv / 8 + 1) * 2 + 2 - (upperIsZero$iv ? 1 : 0);
                bytes$iv = new byte[size$iv];
                bytes$iv[0] = 48;
                bytes$iv[1] = 120;
                if (!upperIsZero$iv) {
                    bytes$iv[idx$iv++] = upper$iv;
                }
                bytes$iv[idx$iv++] = lower$iv;
                continue;
            }
            bytes$iv[idx$iv++] = upper$iv;
            bytes$iv[idx$iv++] = lower$iv;
        }
        Intrinsics.checkNotNull(bytes$iv);
        return new String(bytes$iv, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String encodeWithPrefix(long value) {
        if (value == 0L) {
            return "0x0";
        }
        FastHex fastHex = INSTANCE;
        int bitSize$iv = 64;
        boolean $i$f$encodeNumberWithPrefix = false;
        int idx$iv = 2;
        byte[] bytes$iv = null;
        for (int bits$iv = bitSize$iv - 8; bits$iv >= 0; bits$iv -= 8) {
            int it = bits$iv;
            boolean bl = false;
            int byte$iv = (int)(value >> it & 0xFFL);
            if (bytes$iv == null && byte$iv <= 0) continue;
            int nibbles$iv = ENCODE_TABLE[byte$iv];
            byte upper$iv = (byte)(nibbles$iv >>> 8);
            byte lower$iv = (byte)(nibbles$iv & 0xFF);
            if (bytes$iv == null) {
                boolean upperIsZero$iv = upper$iv == 48;
                int size$iv = (bits$iv / 8 + 1) * 2 + 2 - (upperIsZero$iv ? 1 : 0);
                bytes$iv = new byte[size$iv];
                bytes$iv[0] = 48;
                bytes$iv[1] = 120;
                if (!upperIsZero$iv) {
                    bytes$iv[idx$iv++] = upper$iv;
                }
                bytes$iv[idx$iv++] = lower$iv;
                continue;
            }
            bytes$iv[idx$iv++] = upper$iv;
            bytes$iv[idx$iv++] = lower$iv;
        }
        Intrinsics.checkNotNull(bytes$iv);
        return new String(bytes$iv, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String encodeWithPrefix(@NotNull BigInteger value) {
        if (Intrinsics.areEqual((Object)value, (Object)BigInteger.ZERO)) {
            return "0x0";
        }
        int byteIdx = 0;
        byte[] arr = value.toByteArray();
        FastHex fastHex = INSTANCE;
        int bitSize$iv = arr.length * 8;
        boolean $i$f$encodeNumberWithPrefix = false;
        int idx$iv = 2;
        byte[] bytes$iv = null;
        for (int bits$iv = bitSize$iv - 8; bits$iv >= 0; bits$iv -= 8) {
            int it = bits$iv;
            boolean bl = false;
            int n = byteIdx;
            byteIdx = n + 1;
            int byte$iv = arr[n] & 0xFF;
            if (bytes$iv == null && byte$iv <= 0) continue;
            int nibbles$iv = ENCODE_TABLE[byte$iv];
            byte upper$iv = (byte)(nibbles$iv >>> 8);
            byte lower$iv = (byte)(nibbles$iv & 0xFF);
            if (bytes$iv == null) {
                boolean upperIsZero$iv = upper$iv == 48;
                int size$iv = (bits$iv / 8 + 1) * 2 + 2 - (upperIsZero$iv ? 1 : 0);
                bytes$iv = new byte[size$iv];
                bytes$iv[0] = 48;
                bytes$iv[1] = 120;
                if (!upperIsZero$iv) {
                    bytes$iv[idx$iv++] = upper$iv;
                }
                bytes$iv[idx$iv++] = lower$iv;
                continue;
            }
            bytes$iv[idx$iv++] = upper$iv;
            bytes$iv[idx$iv++] = lower$iv;
        }
        Intrinsics.checkNotNull(bytes$iv);
        return new String(bytes$iv, Charsets.UTF_8);
    }

    @JvmStatic
    @NotNull
    public static final String encodeWithPrefix(@NotNull byte[] buffer) {
        return FastHex.encodeWithPrefix(buffer, 0, buffer.length);
    }

    @JvmStatic
    @NotNull
    public static final String encodeWithPrefix(@NotNull byte[] buffer, int offset, int len) {
        return new String(INSTANCE.encodeToAsciiBytes(buffer, offset, len, true), Charsets.US_ASCII);
    }

    @JvmStatic
    @NotNull
    public static final String encodeWithoutPrefix(@NotNull byte[] buffer) {
        return FastHex.encodeWithoutPrefix(buffer, 0, buffer.length);
    }

    @JvmStatic
    @NotNull
    public static final String encodeWithoutPrefix(@NotNull byte[] buffer, int offset, int len) {
        return new String(INSTANCE.encodeToAsciiBytes(buffer, offset, len, false), Charsets.US_ASCII);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final byte[] encodeAsBytes(@NotNull byte[] buffer, boolean withPrefix) {
        return INSTANCE.encodeToAsciiBytes(buffer, 0, buffer.length, withPrefix);
    }

    public static /* synthetic */ byte[] encodeAsBytes$default(byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FastHex.encodeAsBytes(byArray, bl);
    }

    private final String encodeNumberWithPrefix(int bitSize, Function1<? super Integer, Integer> getNextByte) {
        boolean $i$f$encodeNumberWithPrefix = false;
        int idx = 2;
        byte[] bytes = null;
        for (int bits = bitSize - 8; bits >= 0; bits -= 8) {
            int n = ((Number)getNextByte.invoke((Object)bits)).intValue();
            if (bytes == null && n <= 0) continue;
            int nibbles = ENCODE_TABLE[n];
            byte upper = (byte)(nibbles >>> 8);
            byte lower = (byte)(nibbles & 0xFF);
            if (bytes == null) {
                boolean upperIsZero = upper == 48;
                int size = (bits / 8 + 1) * 2 + 2 - (upperIsZero ? 1 : 0);
                bytes = new byte[size];
                bytes[0] = 48;
                bytes[1] = 120;
                if (!upperIsZero) {
                    bytes[idx++] = upper;
                }
                bytes[idx++] = lower;
                continue;
            }
            bytes[idx++] = upper;
            bytes[idx++] = lower;
        }
        Intrinsics.checkNotNull(bytes);
        return new String(bytes, Charsets.UTF_8);
    }

    private final byte[] encodeToAsciiBytes(byte[] buffer, int offset, int len, boolean withPrefix) {
        byte[] bytes;
        byte[] byArray;
        int currOffset = offset;
        int end = currOffset + len;
        int i = 0;
        if (withPrefix) {
            byte[] byArray2;
            i += 2;
            byte[] it = byArray2 = new byte[len * 2 + 2];
            boolean bl = false;
            it[0] = 48;
            it[1] = 120;
            byArray = byArray2;
        } else {
            byArray = bytes = new byte[len * 2];
        }
        while (currOffset < end) {
            int hexPair = ENCODE_TABLE[buffer[currOffset] & 0xFF];
            bytes[i] = (byte)(hexPair >>> 8);
            bytes[i + 1] = (byte)hexPair;
            ++currOffset;
            i += 2;
        }
        return bytes;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decode(@NotNull CharSequence hex) {
        int destIndex = 0;
        int currOffset = 0;
        if (hex.length() >= 2 && hex.charAt(0) == '0' && (hex.charAt(1) == 'x' || hex.charAt(1) == 'X')) {
            currOffset = 2;
        }
        if (hex.length() == currOffset) {
            return EMPTY_BYTES;
        }
        byte[] dest = null;
        if (!INSTANCE.isDivisibleBy2(hex.length())) {
            dest = new byte[(hex.length() + 1 - currOffset) / 2];
            dest[destIndex++] = DECODE_TABLE_LOWER[hex.charAt(currOffset++)];
        } else {
            dest = new byte[(hex.length() - currOffset) / 2];
        }
        while (destIndex < dest.length) {
            int index;
            int n = destIndex++;
            FastHex this_$iv = INSTANCE;
            boolean $i$f$decodeHexByte = false;
            int n2 = currOffset;
            byte[] byArray = DECODE_TABLE_UPPER;
            int n3 = n;
            byte[] byArray2 = dest;
            boolean bl = false;
            char c = hex.charAt(index);
            index = currOffset + 1;
            byte[] byArray3 = DECODE_TABLE_LOWER;
            byte by = byArray[c];
            bl = false;
            char c2 = hex.charAt(index);
            byArray2[n3] = (byte)(by | byArray3[c2]);
            currOffset += 2;
        }
        return dest;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decode(@NotNull byte[] hex, int offset, int length) {
        int destIndex = 0;
        int currOffset = offset;
        int currLength = length;
        if (currLength >= 2 && hex[currOffset] == 48 && hex[currOffset + 1] == 120) {
            currOffset += 2;
            currLength -= 2;
        }
        if (currLength == 0) {
            return EMPTY_BYTES;
        }
        byte[] dest = null;
        if (!INSTANCE.isDivisibleBy2(currLength)) {
            dest = new byte[(currLength + 1) / 2];
            dest[destIndex++] = DECODE_TABLE_LOWER[hex[currOffset++]];
        } else {
            dest = new byte[currLength / 2];
        }
        while (destIndex < dest.length) {
            int index;
            int n = destIndex++;
            FastHex this_$iv = INSTANCE;
            boolean $i$f$decodeHexByte = false;
            int n2 = currOffset;
            byte[] byArray = DECODE_TABLE_UPPER;
            int n3 = n;
            byte[] byArray2 = dest;
            boolean bl = false;
            byte by = hex[index];
            index = currOffset + 1;
            byte[] byArray3 = DECODE_TABLE_LOWER;
            byte by2 = byArray[by];
            bl = false;
            byte by3 = hex[index];
            byArray2[n3] = (byte)(by2 | byArray3[by3]);
            currOffset += 2;
        }
        return dest;
    }

    public static /* synthetic */ byte[] decode$default(byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length - n;
        }
        return FastHex.decode(byArray, n, n2);
    }

    @JvmStatic
    @NotNull
    public static final byte[] decode(@NotNull char[] hex, int offset, int length) {
        int destIndex = 0;
        int currOffset = offset;
        int currLength = length;
        if (currLength >= 2 && hex[currOffset] == '0' && (hex[currOffset + 1] == 'x' || hex[currOffset + 1] == 'X')) {
            currOffset += 2;
            currLength -= 2;
        }
        if (currLength == 0) {
            return EMPTY_BYTES;
        }
        byte[] dest = null;
        if (!INSTANCE.isDivisibleBy2(currLength)) {
            dest = new byte[(currLength + 1) / 2];
            dest[destIndex++] = DECODE_TABLE_LOWER[hex[currOffset++]];
        } else {
            dest = new byte[currLength / 2];
        }
        while (destIndex < dest.length) {
            int index;
            int n = destIndex++;
            FastHex this_$iv = INSTANCE;
            boolean $i$f$decodeHexByte = false;
            int n2 = currOffset;
            byte[] byArray = DECODE_TABLE_UPPER;
            int n3 = n;
            byte[] byArray2 = dest;
            boolean bl = false;
            char c = hex[index];
            index = currOffset + 1;
            byte[] byArray3 = DECODE_TABLE_LOWER;
            byte by = byArray[c];
            bl = false;
            char c2 = hex[index];
            byArray2[n3] = (byte)(by | byArray3[c2]);
            currOffset += 2;
        }
        return dest;
    }

    public static /* synthetic */ byte[] decode$default(char[] cArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = cArray.length - n;
        }
        return FastHex.decode(cArray, n, n2);
    }

    @JvmStatic
    public static final boolean isValidHex(@NotNull CharSequence hex) {
        int startIndex = 0;
        if (hex.length() >= 2 && hex.charAt(0) == '0' && (hex.charAt(1) == 'x' || hex.charAt(1) == 'X')) {
            startIndex = 2;
        }
        int n = hex.length();
        for (int i = startIndex; i < n; ++i) {
            if (INSTANCE.isValidHexChar(hex.charAt(i))) continue;
            return false;
        }
        return hex.length() > 0;
    }

    private final byte decodeHexByte(int offset, Function1<? super Integer, Integer> charCodeAtOffset) {
        boolean $i$f$decodeHexByte = false;
        return (byte)(DECODE_TABLE_UPPER[((Number)charCodeAtOffset.invoke((Object)offset)).intValue()] | DECODE_TABLE_LOWER[((Number)charCodeAtOffset.invoke((Object)(offset + 1))).intValue()]);
    }

    private final byte getNibble(char c, boolean upper) {
        int nibble;
        block2: {
            int n;
            char c2;
            block1: {
                c2 = c;
                boolean bl = '0' <= c2 ? c2 < ':' : false;
                if (!bl) break block1;
                n = c - 48;
                break block2;
            }
            n = ('A' <= c2 ? c2 < 'G' : false) ? c - 55 : (nibble = ('a' <= c2 ? c2 < 'g' : false) ? c - 87 : -1);
        }
        if (nibble == -1) {
            return -1;
        }
        return upper ? (byte)(nibble << 4) : (byte)nibble;
    }

    private final boolean isValidHexChar(char c) {
        boolean bl;
        block1: {
            char c2;
            block0: {
                c2 = c;
                boolean bl2 = '0' <= c2 ? c2 < ':' : false;
                if (!bl2) break block0;
                bl = true;
                break block1;
            }
            bl = ('A' <= c2 ? c2 < 'G' : false) ? true : ('a' <= c2 ? c2 < 'g' : false);
        }
        return bl;
    }

    private final boolean isDivisibleBy2(int num) {
        return (num & 1) == 0;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final byte[] encodeAsBytes(@NotNull byte[] buffer) {
        return FastHex.encodeAsBytes$default(buffer, false, 2, null);
    }

    static {
        int i;
        int n;
        INSTANCE = new FastHex();
        EMPTY_BYTES = new byte[0];
        int n2 = 0;
        Object[] objectArray = new int[256];
        while (n2 < 256) {
            n = n2++;
            objectArray[n] = -1;
        }
        ENCODE_TABLE = objectArray;
        n2 = 0;
        objectArray = new byte[256];
        while (n2 < 256) {
            n = n2++;
            objectArray[n] = -1;
        }
        DECODE_TABLE_UPPER = (byte[])objectArray;
        n2 = 0;
        objectArray = new byte[256];
        while (n2 < 256) {
            n = n2++;
            objectArray[n] = -1;
        }
        DECODE_TABLE_LOWER = (byte[])objectArray;
        objectArray = new char[16];
        objectArray[0] = 48;
        objectArray[1] = 49;
        objectArray[2] = 50;
        objectArray[3] = 51;
        objectArray[4] = 52;
        objectArray[5] = 53;
        objectArray[6] = 54;
        objectArray[7] = 55;
        objectArray[8] = 56;
        objectArray[9] = 57;
        objectArray[10] = 97;
        objectArray[11] = 98;
        objectArray[12] = 99;
        objectArray[13] = 100;
        objectArray[14] = 101;
        objectArray[15] = 102;
        Object[] chars = objectArray;
        n = ENCODE_TABLE.length;
        for (i = 0; i < n; ++i) {
            int upper = chars[(i & 0xF0) >>> 4];
            int lower = chars[i & 0xF];
            FastHex.ENCODE_TABLE[i] = upper << 8 | lower;
        }
        n = DECODE_TABLE_UPPER.length;
        for (i = 0; i < n; ++i) {
            FastHex.DECODE_TABLE_UPPER[i] = INSTANCE.getNibble((char)i, true);
            FastHex.DECODE_TABLE_LOWER[i] = INSTANCE.getNibble((char)i, false);
        }
    }
}

