/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.AbiCodec;
import io.ethers.abi.AbiType;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.Hash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0002)*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u0005\u00a2\u0006\u0002\u0010\u001cJ\u0019\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u001e\u00a2\u0006\u0002\u0010\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\bH\u00c6\u0003J-\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010$\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000fR\u001b\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u001b\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lio/ethers/abi/AbiEvent;", "", "name", "", "tokens", "", "Lio/ethers/abi/AbiEvent$Token;", "isAnonymous", "", "<init>", "(Ljava/lang/String;Ljava/util/List;Z)V", "getName", "()Ljava/lang/String;", "getTokens", "()Ljava/util/List;", "()Z", "indexed", "Lio/ethers/abi/AbiType;", "getIndexed", "data", "getData", "topicId", "Lio/ethers/core/types/Hash;", "getTopicId", "()Lio/ethers/core/types/Hash;", "decodeTopics", "", "topics", "(Ljava/util/List;)[Ljava/lang/Object;", "decodeData", "Lio/ethers/core/types/Bytes;", "(Lio/ethers/core/types/Bytes;)[Ljava/lang/Object;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "Token", "Companion", "ethers-abi"})
@SourceDebugExtension(value={"SMAP\nAbiEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiEvent.kt\nio/ethers/abi/AbiEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n774#2:271\n865#2,2:272\n1563#2:274\n1634#2,3:275\n774#2:278\n865#2,2:279\n1563#2:281\n1634#2,3:282\n1563#2:285\n1634#2,3:286\n*S KotlinDebug\n*F\n+ 1 AbiEvent.kt\nio/ethers/abi/AbiEvent\n*L\n87#1:271\n87#1:272,2\n87#1:274\n87#1:275,3\n88#1:278\n88#1:279,2\n88#1:281\n88#1:282,3\n90#1:285\n90#1:286,3\n*E\n"})
public final class AbiEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Token> tokens;
    private final boolean isAnonymous;
    @NotNull
    private final List<AbiType<?>> indexed;
    @NotNull
    private final List<AbiType<?>> data;
    @NotNull
    private final Hash topicId;
    @JvmField
    @NotNull
    public static final AbiType.FixedBytes NON_VALUE_INDEXED_TYPE = new AbiType.FixedBytes(32);

    public AbiEvent(@NotNull String name, @NotNull List<Token> tokens, boolean isAnonymous) {
        Collection<AbiType<?>> collection;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Token it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        this.name = name;
        this.tokens = tokens;
        this.isAnonymous = isAnonymous;
        Iterable iterable = this.tokens;
        AbiEvent abiEvent = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Token)element$iv$iv;
            boolean bl = false;
            if (!it.getIndexed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Token)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getType());
        }
        abiEvent.indexed = (List)destination$iv$iv;
        $this$map$iv = this.tokens;
        abiEvent = this;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Token)element$iv$iv;
            boolean bl = false;
            if (!(!it.getIndexed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Token)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getType());
        }
        abiEvent.data = (List)destination$iv$iv;
        $this$map$iv = this.tokens;
        String string = this.name;
        AbiType.Companion companion = AbiType.Companion;
        abiEvent = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Token)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        collection = (List)destination$iv$iv;
        byte[] byArray = companion.computeSignatureHash(string, (List<? extends AbiType<?>>)collection);
        abiEvent.topicId = new Hash(byArray);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final List<Token> getTokens() {
        return this.tokens;
    }

    public final boolean isAnonymous() {
        return this.isAnonymous;
    }

    @NotNull
    public final List<AbiType<?>> getIndexed() {
        return this.indexed;
    }

    @NotNull
    public final List<AbiType<?>> getData() {
        return this.data;
    }

    @NotNull
    public final Hash getTopicId() {
        return this.topicId;
    }

    @NotNull
    public final Object[] decodeTopics(@NotNull List<Hash> topics) {
        int offsetTopic0 = this.isAnonymous ? 0 : 1;
        Object[] ret = new Object[this.indexed.size()];
        int n = ((Collection)this.indexed).size();
        for (int i = 0; i < n; ++i) {
            ret[i] = AbiCodec.decode(this.indexed.get(i), topics.get(i + offsetTopic0).asByteArray());
        }
        return ret;
    }

    @NotNull
    public final Object[] decodeData(@NotNull Bytes data) {
        return AbiCodec.decode(this.data, data.asByteArray());
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final List<Token> component2() {
        return this.tokens;
    }

    public final boolean component3() {
        return this.isAnonymous;
    }

    @NotNull
    public final AbiEvent copy(@NotNull String name, @NotNull List<Token> tokens, boolean isAnonymous) {
        return new AbiEvent(name, tokens, isAnonymous);
    }

    public static /* synthetic */ AbiEvent copy$default(AbiEvent abiEvent, String string, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = abiEvent.name;
        }
        if ((n & 2) != 0) {
            list = abiEvent.tokens;
        }
        if ((n & 4) != 0) {
            bl = abiEvent.isAnonymous;
        }
        return abiEvent.copy(string, list, bl);
    }

    @NotNull
    public String toString() {
        return "AbiEvent(name=" + this.name + ", tokens=" + this.tokens + ", isAnonymous=" + this.isAnonymous + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + ((Object)this.tokens).hashCode();
        result = result * 31 + Boolean.hashCode(this.isAnonymous);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbiEvent)) {
            return false;
        }
        AbiEvent abiEvent = (AbiEvent)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)abiEvent.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tokens, abiEvent.tokens)) {
            return false;
        }
        return this.isAnonymous == abiEvent.isAnonymous;
    }

    @JvmStatic
    @NotNull
    public static final AbiType<?> getTopicAbiType(@NotNull AbiType<?> type) {
        return Companion.getTopicAbiType(type);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/ethers/abi/AbiEvent$Companion;", "", "<init>", "()V", "NON_VALUE_INDEXED_TYPE", "Lio/ethers/abi/AbiType$FixedBytes;", "getTopicAbiType", "Lio/ethers/abi/AbiType;", "type", "ethers-abi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AbiType<?> getTopicAbiType(@NotNull AbiType<?> type) {
            return type.isDynamic() || type instanceof AbiType.FixedArray || type instanceof AbiType.Tuple ? (AbiType<?>)NON_VALUE_INDEXED_TYPE : type;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/ethers/abi/AbiEvent$Token;", "", "type", "Lio/ethers/abi/AbiType;", "indexed", "", "<init>", "(Lio/ethers/abi/AbiType;Z)V", "getType", "()Lio/ethers/abi/AbiType;", "getIndexed", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "ethers-abi"})
    public static final class Token {
        @NotNull
        private final AbiType<?> type;
        private final boolean indexed;

        public Token(@NotNull AbiType<?> type, boolean indexed) {
            this.type = type;
            this.indexed = indexed;
        }

        @NotNull
        public final AbiType<?> getType() {
            return this.type;
        }

        public final boolean getIndexed() {
            return this.indexed;
        }

        @NotNull
        public final AbiType<?> component1() {
            return this.type;
        }

        public final boolean component2() {
            return this.indexed;
        }

        @NotNull
        public final Token copy(@NotNull AbiType<?> type, boolean indexed) {
            return new Token(type, indexed);
        }

        public static /* synthetic */ Token copy$default(Token token, AbiType abiType, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                abiType = token.type;
            }
            if ((n & 2) != 0) {
                bl = token.indexed;
            }
            return token.copy(abiType, bl);
        }

        @NotNull
        public String toString() {
            return "Token(type=" + this.type + ", indexed=" + this.indexed + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Boolean.hashCode(this.indexed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual(this.type, token.type)) {
                return false;
            }
            return this.indexed == token.indexed;
        }
    }
}

