/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.test.names;

import io.kotest.common.Platform;
import io.kotest.common.Platform_jvmKt;
import io.kotest.common.reflection.AnnotationSearchParameter;
import io.kotest.common.reflection.IncludingAnnotations;
import io.kotest.common.reflection.reflectionjvm;
import io.kotest.core.annotation.DisplayName;
import io.kotest.core.names.TestNameCase;
import io.kotest.core.test.TestCase;
import io.kotest.engine.config.ProjectConfigResolver;
import io.kotest.engine.config.TestConfigResolver;
import io.kotest.engine.names.DisplayNameFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\t\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\f\u0010\u0011\u001a\u00020\n*\u00020\nH\u0002J\f\u0010\u0012\u001a\u00020\n*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/kotest/engine/test/names/DefaultDisplayNameFormatter;", "Lio/kotest/engine/names/DisplayNameFormatter;", "projectConfigResolver", "Lio/kotest/engine/config/ProjectConfigResolver;", "testConfigResolver", "Lio/kotest/engine/config/TestConfigResolver;", "<init>", "(Lio/kotest/engine/config/ProjectConfigResolver;Lio/kotest/engine/config/TestConfigResolver;)V", "()V", "format", "", "testCase", "Lio/kotest/core/test/TestCase;", "kclass", "Lkotlin/reflect/KClass;", "appendTagsInDisplayName", "displayName", "capital", "uncapitalize", "kotest-framework-engine"})
@SourceDebugExtension(value={"SMAP\nDefaultDisplayNameFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDisplayNameFormatter.kt\nio/kotest/engine/test/names/DefaultDisplayNameFormatter\n+ 2 reflection.kt\nio/kotest/common/reflection/ReflectionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n70#2,4:97\n808#3,11:101\n1#4:112\n*S KotlinDebug\n*F\n+ 1 DefaultDisplayNameFormatter.kt\nio/kotest/engine/test/names/DefaultDisplayNameFormatter\n*L\n77#1:97,4\n77#1:101,11\n*E\n"})
public final class DefaultDisplayNameFormatter
implements DisplayNameFormatter {
    @NotNull
    private final ProjectConfigResolver projectConfigResolver;
    @NotNull
    private final TestConfigResolver testConfigResolver;

    public DefaultDisplayNameFormatter(@NotNull ProjectConfigResolver projectConfigResolver, @NotNull TestConfigResolver testConfigResolver) {
        Intrinsics.checkNotNullParameter((Object)projectConfigResolver, (String)"projectConfigResolver");
        Intrinsics.checkNotNullParameter((Object)testConfigResolver, (String)"testConfigResolver");
        this.projectConfigResolver = projectConfigResolver;
        this.testConfigResolver = testConfigResolver;
    }

    public DefaultDisplayNameFormatter() {
        this(new ProjectConfigResolver(), new TestConfigResolver());
    }

    @Override
    @NotNull
    public String format(@NotNull TestCase testCase) {
        String displayName;
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        boolean bl = this.projectConfigResolver.includeTestScopeAffixes(testCase);
        if (bl) {
            string3 = testCase.getName().getPrefix();
            if (string3 == null) {
                string3 = "";
            }
        } else if (!bl) {
            string3 = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String prefix = string3;
        boolean bl2 = this.projectConfigResolver.includeTestScopeAffixes(testCase);
        if (bl2) {
            string2 = testCase.getName().getSuffix();
            if (string2 == null) {
                string2 = "";
            }
        } else if (!bl2) {
            string2 = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String suffix = string2;
        if (StringsKt.isBlank((CharSequence)prefix)) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.projectConfigResolver.testNameCase().ordinal()]) {
                case 1: {
                    string = this.capital(testCase.getName().getName()) + suffix;
                    break;
                }
                case 2: {
                    string = this.uncapitalize(testCase.getName().getName()) + suffix;
                    break;
                }
                case 3: {
                    String string4 = testCase.getName().getName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    string = string4 + suffix;
                    break;
                }
                default: {
                    string = testCase.getName().getName() + suffix;
                    break;
                }
            }
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.projectConfigResolver.testNameCase().ordinal()]) {
                case 1: {
                    string = this.capital(prefix) + this.uncapitalize(testCase.getName().getName()) + suffix;
                    break;
                }
                case 2: {
                    string = this.uncapitalize(prefix) + this.uncapitalize(testCase.getName().getName()) + suffix;
                    break;
                }
                case 3: {
                    String string5 = prefix.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    String string6 = testCase.getName().getName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                    string = string5 + string6 + suffix;
                    break;
                }
                default: {
                    string = displayName = prefix + testCase.getName().getName() + suffix;
                }
            }
        }
        if (this.projectConfigResolver.testNameAppendTags()) {
            return this.appendTagsInDisplayName(testCase, displayName);
        }
        String name = displayName;
        TestCase parent = testCase.getParent();
        return parent == null ? name : (this.projectConfigResolver.displayFullTestPath() ? this.format(parent) + " " + name : name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String format(@NotNull KClass<?> kclass) {
        Object object;
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        if (WhenMappings.$EnumSwitchMapping$1[Platform_jvmKt.getPlatform().ordinal()] == 1) {
            void $this$filterIsInstanceTo$iv$iv$iv;
            KClass<?> $this$annotation_u24default$iv = kclass;
            IncludingAnnotations[] includingAnnotationsArray = new IncludingAnnotations[]{IncludingAnnotations.INSTANCE};
            Object[] parameters$iv = (AnnotationSearchParameter[])includingAnnotationsArray;
            boolean $i$f$annotation = false;
            Iterable $this$filterIsInstance$iv$iv = reflectionjvm.getReflection().annotations($this$annotation_u24default$iv, ArraysKt.toSet((Object[])parameters$iv));
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof DisplayName)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            object = (DisplayName)CollectionsKt.firstOrNull((List)((List)destination$iv$iv$iv));
            if ((object == null || (object = object.name()) == null) && (object = kclass.getSimpleName()) == null) {
                object = "<unknown>";
            }
        } else {
            object = kclass.getSimpleName();
            if (object == null) {
                object = "<unknown>";
            }
        }
        return object;
    }

    private final String appendTagsInDisplayName(TestCase testCase, String displayName) {
        String tagNames = CollectionsKt.joinToString$default((Iterable)this.testConfigResolver.tags(testCase), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        return StringsKt.isBlank((CharSequence)tagNames) ? displayName : displayName + "[tags = " + tagNames + "]";
    }

    /*
     * WARNING - void declaration
     */
    private final String capital(String $this$capital) {
        String string;
        String string2 = $this$capital;
        if (((CharSequence)string2).length() > 0) {
            void it2;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)(Character.isLowerCase((char)it2) ? CharsKt.titlecase((char)it2) : String.valueOf((char)it2)));
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = string2;
        }
        return string;
    }

    private final String uncapitalize(String $this$uncapitalize) {
        char c = Character.toLowerCase($this$uncapitalize.charAt(0));
        String string = StringsKt.substring((String)$this$uncapitalize, (IntRange)RangesKt.until((int)1, (int)$this$uncapitalize.length()));
        return c + string;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TestNameCase.values().length];
            try {
                nArray[TestNameCase.Sentence.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestNameCase.InitialLowercase.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestNameCase.Lowercase.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Platform.values().length];
            try {
                nArray[Platform.JVM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

