/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.engine.tags;

import io.kotest.engine.tags.Lexer;
import io.kotest.engine.tags.Token;
import io.kotest.engine.tags.TokenType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/kotest/engine/tags/Parser;", "", "tokens", "", "Lio/kotest/engine/tags/Token;", "<init>", "(Ljava/util/List;)V", "cursor", "", "isEof", "", "skip", "", "type", "Lio/kotest/engine/tags/TokenType;", "consume", "peek", "skipIf", "Companion", "kotest-framework-engine"})
public final class Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Token> tokens;
    private int cursor;

    public Parser(@NotNull List<Token> tokens) {
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        this.tokens = tokens;
    }

    private final boolean isEof() {
        return this.cursor == this.tokens.size();
    }

    public final void skip() {
        this.consume();
    }

    public final void skip(@NotNull TokenType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.consume(type);
    }

    @NotNull
    public final Token consume() {
        Token token = this.tokens.get(this.cursor);
        int n = this.cursor;
        this.cursor = n + 1;
        return token;
    }

    @NotNull
    public final Token consume(@NotNull TokenType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Token next = this.consume();
        if (next.getType() != type) {
            throw new IllegalStateException(("Expected " + type + " but was " + next).toString());
        }
        return next;
    }

    @Nullable
    public final Token peek() {
        return this.isEof() ? null : this.tokens.get(this.cursor);
    }

    public final boolean skipIf(@NotNull TokenType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Token token = this.peek();
        if ((token != null ? token.getType() : null) == type) {
            this.skip();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/kotest/engine/tags/Parser$Companion;", "", "<init>", "()V", "from", "Lio/kotest/engine/tags/Parser;", "input", "", "kotest-framework-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Parser from(@NotNull String input2) {
            Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
            return new Parser(new Lexer(input2).lex());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

