/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.kjson.resource.ResourceLoader;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u0019*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0019B'\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000b\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lio/kjson/resource/Resource;", "T", "", "resourcePath", "Ljava/nio/file/Path;", "resourceURL", "Ljava/net/URL;", "resourceLoader", "Lio/kjson/resource/ResourceLoader;", "(Ljava/nio/file/Path;Ljava/net/URL;Lio/kjson/resource/ResourceLoader;)V", "getResourcePath$resource_loader", "()Ljava/nio/file/Path;", "getResourceURL", "()Ljava/net/URL;", "equals", "", "other", "hashCode", "", "load", "()Ljava/lang/Object;", "resolve", "relativeURL", "", "toString", "Companion", "resource-loader"})
@SourceDebugExtension(value={"SMAP\nResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resource.kt\nio/kjson/resource/Resource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class Resource<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path resourcePath;
    @NotNull
    private final URL resourceURL;
    @NotNull
    private final ResourceLoader<T> resourceLoader;
    @NotNull
    private static final String currentPath;

    public Resource(@Nullable Path resourcePath, @NotNull URL resourceURL, @NotNull ResourceLoader<T> resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        Intrinsics.checkNotNullParameter(resourceLoader, (String)"resourceLoader");
        this.resourcePath = resourcePath;
        this.resourceURL = resourceURL;
        this.resourceLoader = resourceLoader;
    }

    @Nullable
    public final Path getResourcePath$resource_loader() {
        return this.resourcePath;
    }

    @NotNull
    public final URL getResourceURL() {
        return this.resourceURL;
    }

    public final T load() {
        return this.resourceLoader.load(this);
    }

    @NotNull
    public final Resource<T> resolve(@NotNull String relativeURL) {
        Intrinsics.checkNotNullParameter((Object)relativeURL, (String)"relativeURL");
        String extendedURL = this.resourceLoader.addExtension(relativeURL);
        if (new URI(extendedURL).getScheme() == null && this.resourcePath != null) {
            Path path;
            if (Files.isDirectory(this.resourcePath, new LinkOption[0])) {
                Path path2 = this.resourcePath.resolve(extendedURL);
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resourcePath.resolve(extendedURL)");
            } else {
                Path path3 = this.resourcePath.resolveSibling(extendedURL);
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resourcePath.resolveSibling(extendedURL)");
            }
            Path resolved = path;
            return this.resourceLoader.resource(resolved);
        }
        URL resolvedURL = this.resourceURL.toURI().resolve(extendedURL).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedURL, (String)"resolvedURL");
        return this.resourceLoader.resource(resolvedURL);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof Resource && this.resourceLoader == ((Resource)other).resourceLoader && Intrinsics.areEqual((Object)this.resourceURL.toString(), (Object)((Resource)other).resourceURL.toString());
    }

    public int hashCode() {
        return this.resourceLoader.hashCode() ^ this.resourceURL.toString().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        String string;
        if (!Intrinsics.areEqual((Object)this.resourceURL.getProtocol(), (Object)"file")) {
            String string2 = this.resourceURL.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resourceURL.toString()");
        } else {
            void var2_3;
            void var3_1;
            String it = this.resourceURL.getPath();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String path = StringsKt.startsWith$default((String)it, (String)"///", (boolean)false, (int)2, null) ? StringsKt.drop((String)it, (int)2) : var3_1;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            void var1_4 = StringsKt.startsWith$default((String)path, (String)currentPath, (boolean)false, (int)2, null) ? StringsKt.drop((String)path, (int)currentPath.length()) : var2_3;
            Intrinsics.checkNotNullExpressionValue((Object)var1_4, (String)"{\n        val path = res\u2026se\n            path\n    }");
            string = var1_4;
        }
        return string;
    }

    static {
        String it = new File(".").getAbsolutePath();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String string = StringsKt.endsWith$default((String)it, (String)"/.", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)it, (int)1) : (StringsKt.endsWith$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null) ? it : it + '/');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(\".\").absolutePath.l\u2026\"\n            }\n        }");
        currentPath = string;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/kjson/resource/Resource$Companion;", "", "()V", "currentPath", "", "getCurrentPath", "()Ljava/lang/String;", "classPathURL", "Ljava/net/URL;", "name", "resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getCurrentPath() {
            return currentPath;
        }

        @Nullable
        public final URL classPathURL(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Resource.class.getResource(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

