/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.kjson.resource.Loader;
import io.kjson.resource.ResourceDescriptor;
import io.kjson.resource.ResourceLoader;
import io.kjson.resource.ResourceLoaderException;
import io.kjson.resource.ResourceNotFoundException;
import io.kjson.resource.ResourceRecursionException;
import io.kjson.util.Cache;
import io.kjson.util.HTTPHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 $*\u0004\b\u0000\u0010\u0001*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00002\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001$B\u0019\b\u0004\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001f\u0010\u0018\u001a\u00028\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\r\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u001bH&\u00a2\u0006\u0002\u0010\u001fJ\u0015\u0010 \u001a\u00028\u00012\u0006\u0010!\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u00028\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\u0019R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006%"}, d2={"Lio/kjson/resource/ResourceLoader;", "T", "R", "Lio/kjson/resource/Loader;", "resourcePath", "Ljava/nio/file/Path;", "resourceURL", "Ljava/net/URL;", "(Ljava/nio/file/Path;Ljava/net/URL;)V", "defaultContentType", "", "getDefaultContentType", "()Ljava/lang/String;", "defaultExtension", "getDefaultExtension", "parent", "resourceCache", "Lio/kjson/util/Cache;", "getResourceURL", "()Ljava/net/URL;", "checkHTTP", "", "conn", "Ljava/net/HttpURLConnection;", "checkRecursion", "(Ljava/nio/file/Path;Ljava/net/URL;)Lio/kjson/resource/ResourceLoader;", "createResourceDescriptor", "Lio/kjson/resource/ResourceDescriptor;", "load", "()Ljava/lang/Object;", "rd", "(Lio/kjson/resource/ResourceDescriptor;)Ljava/lang/Object;", "resolve", "name", "(Ljava/lang/String;)Lio/kjson/resource/ResourceLoader;", "resolvedLoader", "Companion", "resource-loader"})
public abstract class ResourceLoader<T, R extends ResourceLoader<T, R>>
implements Loader<T, R> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path resourcePath;
    @NotNull
    private final URL resourceURL;
    @Nullable
    private ResourceLoader<T, R> parent;
    @NotNull
    private final Cache<URL, T> resourceCache;
    @Nullable
    private final String defaultExtension;
    @Nullable
    private final String defaultContentType;
    @NotNull
    private static final File currentDirectory = new File(".");
    private static final char separator = File.separatorChar;
    private static final FileSystem defaultFileSystem = FileSystems.getDefault();
    @NotNull
    private static final Cache<String, FileSystem> fileSystemCache = new Cache(Companion.fileSystemCache.1.INSTANCE);

    protected ResourceLoader(@Nullable Path resourcePath, @NotNull URL resourceURL) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        this.resourcePath = resourcePath;
        this.resourceURL = resourceURL;
        this.resourceCache = new Cache((Function1)new Function1<URL, T>(this){
            final /* synthetic */ ResourceLoader<T, R> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final T invoke(@NotNull URL it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.load(ResourceLoader.access$createResourceDescriptor(this.this$0));
            }
        });
    }

    @Override
    @NotNull
    public URL getResourceURL() {
        return this.resourceURL;
    }

    @Nullable
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Nullable
    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public abstract T load(@NotNull ResourceDescriptor var1);

    @NotNull
    public abstract R resolvedLoader(@Nullable Path var1, @NotNull URL var2);

    @Override
    public T load() {
        return this.resourceCache.get(this.getResourceURL());
    }

    private final ResourceDescriptor createResourceDescriptor() {
        Instant instant;
        Path path = this.resourcePath;
        if (path != null) {
            Path path2 = path;
            boolean bl2 = false;
            if (!Files.exists(path2, new LinkOption[0]) || Files.isDirectory(path2, new LinkOption[0])) {
                throw new ResourceNotFoundException(this.getResourceURL());
            }
            InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(path)");
            return new ResourceDescriptor(inputStream, this.getResourceURL(), null, Files.size(path2), Files.getLastModifiedTime(path2, new LinkOption[0]).toInstant(), null, 36, null);
        }
        URLConnection conn = this.getResourceURL().openConnection();
        boolean bl = false;
        Long bl2 = conn.getContentLengthLong();
        long it = ((Number)bl2).longValue();
        boolean bl3 = false;
        Long contentLength = it >= 0L ? bl2 : null;
        Long l = conn.getLastModified();
        long it2 = ((Number)l).longValue();
        boolean bl4 = false;
        Long l2 = it2 != 0L ? l : null;
        if (l2 != null) {
            it2 = ((Number)l2).longValue();
            boolean bl5 = false;
            instant = Instant.ofEpochMilli(it2);
        } else {
            instant = null;
        }
        Instant lastModified = instant;
        String charsetName = null;
        String mimeType = null;
        if (conn instanceof HttpURLConnection) {
            HTTPHeader contentTypeHeader;
            Object object;
            HTTPHeader hTTPHeader;
            String string;
            if (!this.checkHTTP((HttpURLConnection)conn)) {
                throw new ResourceLoaderException("Connection vetoed - " + this.getResourceURL());
            }
            if (((HttpURLConnection)conn).getResponseCode() == 404) {
                throw new ResourceNotFoundException(this.getResourceURL());
            }
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                throw new IOException("Error status - " + ((HttpURLConnection)conn).getResponseCode() + " - " + this.getResourceURL());
            }
            String string2 = string = ((HttpURLConnection)conn).getContentType();
            if (string2 != null) {
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contentType");
                String it3 = string;
                boolean bl6 = false;
                hTTPHeader = HTTPHeader.Companion.create(it3);
            } else {
                hTTPHeader = null;
            }
            charsetName = (object = (contentTypeHeader = hTTPHeader)) != null && (object = HTTPHeader.element$default((HTTPHeader)object, 0, 1, null)) != null ? HTTPHeader.Element.parameter$default((HTTPHeader.Element)object, "charset", 0, 2, null) : null;
            HTTPHeader hTTPHeader2 = contentTypeHeader;
            mimeType = hTTPHeader2 != null ? hTTPHeader2.firstElementText() : null;
        } else {
            charsetName = null;
            mimeType = conn.getContentType();
        }
        InputStream inputStream = conn.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"conn.getInputStream()");
        return new ResourceDescriptor(inputStream, this.getResourceURL(), charsetName, contentLength, lastModified, mimeType);
    }

    public boolean checkHTTP(@NotNull HttpURLConnection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        return true;
    }

    @Override
    @NotNull
    public R resolve(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String extendedName = Companion.addExtension(name, this.getDefaultExtension());
        if (new URI(extendedName).getScheme() == null && this.resourcePath != null) {
            Path resolved = Files.isDirectory(this.resourcePath, new LinkOption[0]) ? this.resourcePath.resolve(extendedName) : this.resourcePath.resolveSibling(extendedName);
            URL uRL = resolved.toUri().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"resolved.toUri().toURL()");
            return this.checkRecursion(resolved, uRL);
        }
        URL resolvedURL = this.getResourceURL().toURI().resolve(extendedName).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedURL, (String)"resolvedURL");
        return this.checkRecursion(Companion.derivePath(resolvedURL), resolvedURL);
    }

    private final R checkRecursion(Path resourcePath, URL resourceURL) {
        R r;
        ResourceLoader<T, R> parentRef = this.parent;
        while (parentRef != null) {
            if (Intrinsics.areEqual((Object)resourceURL, (Object)parentRef.getResourceURL())) {
                throw new ResourceRecursionException(resourceURL);
            }
            parentRef = parentRef.parent;
        }
        R it = r = this.resolvedLoader(resourcePath, resourceURL);
        boolean bl = false;
        ((ResourceLoader)it).parent = this;
        return r;
    }

    @Override
    public T load(@NotNull String name) {
        return Loader.DefaultImpls.load(this, name);
    }

    public static final /* synthetic */ ResourceDescriptor access$createResourceDescriptor(ResourceLoader $this) {
        return $this.createResourceDescriptor();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/kjson/resource/ResourceLoader$Companion;", "", "()V", "currentDirectory", "Ljava/io/File;", "getCurrentDirectory", "()Ljava/io/File;", "defaultFileSystem", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "fileSystemCache", "Lio/kjson/util/Cache;", "", "separator", "", "addExtension", "s", "defaultExtension", "classPathURL", "Ljava/net/URL;", "name", "derivePath", "Ljava/nio/file/Path;", "url", "resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getCurrentDirectory() {
            return currentDirectory;
        }

        @Nullable
        public final URL classPathURL(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return ResourceLoader.class.getResource(name);
        }

        @NotNull
        public final String addExtension(@NotNull String s, @Nullable String defaultExtension) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return defaultExtension != null && StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)(StringsKt.lastIndexOf$default((CharSequence)s, (char)separator, (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null) < 0 ? s + '.' + defaultExtension : s;
        }

        @Nullable
        public final Path derivePath(@NotNull URL url) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URI uri = url.toURI();
            String string = uri.getScheme();
            if (Intrinsics.areEqual((Object)string, (Object)"jar")) {
                String schemeSpecific = uri.getSchemeSpecificPart();
                Cache cache = fileSystemCache;
                Intrinsics.checkNotNullExpressionValue((Object)schemeSpecific, (String)"schemeSpecific");
                FileSystem fs = (FileSystem)cache.get(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)schemeSpecific, (char)':', null, (int)2, null), (char)'!', null, (int)2, null));
                path = fs.getPath(StringsKt.substringAfter$default((String)schemeSpecific, (char)'!', null, (int)2, null), new String[0]);
            } else {
                path = Intrinsics.areEqual((Object)string, (Object)"file") ? defaultFileSystem.getPath(uri.getPath(), new String[0]) : null;
            }
            return path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

