/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.yaml.parser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.text.TextMatcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015J\b\u0010\u0018\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/kjson/yaml/parser/Line;", "Lnet/pwall/text/TextMatcher;", "lineNumber", "", "line", "", "(ILjava/lang/String;)V", "getLineNumber", "()I", "atEnd", "", "isComment", "isSpace", "ch", "", "matchColon", "matchDash", "matchSpace", "matchSpaces", "matchWithWhitespace", "skipBackSpaces", "", "skipSpaces", "skipToSpace", "toString", "kjson-yaml"})
public final class Line
extends TextMatcher {
    private final int lineNumber;

    public Line(int lineNumber, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        super(line);
        this.lineNumber = lineNumber;
        this.skip(Line::_init_$lambda$0);
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    private final boolean matchWithWhitespace(char ch) {
        if (!this.match(ch)) {
            return false;
        }
        if (this.isAtEnd()) {
            return true;
        }
        int charIndex = this.getStart();
        if (this.matchSpaces()) {
            this.setStart(charIndex);
            return true;
        }
        this.setIndex(charIndex);
        return false;
    }

    public final boolean matchColon() {
        return this.matchWithWhitespace(':');
    }

    public final boolean matchDash() {
        return this.matchWithWhitespace('-');
    }

    public final boolean isComment() {
        if (!this.match('#')) {
            return false;
        }
        this.setIndex(this.getStart());
        return this.getStart() == 0 || this.isSpace(this.getChar(this.getStart() - 1));
    }

    public final boolean matchSpace() {
        return this.match(' ') || this.match('\t');
    }

    public final boolean matchSpaces() {
        return this.matchSeq(arg_0 -> Line.matchSpaces$lambda$1(this, arg_0));
    }

    public final void skipSpaces() {
        this.skip(arg_0 -> Line.skipSpaces$lambda$2(this, arg_0));
    }

    public final void skipToSpace() {
        this.skip(arg_0 -> Line.skipToSpace$lambda$3(this, arg_0));
    }

    public final boolean atEnd() {
        return this.isAtEnd() || this.isComment();
    }

    public final void skipBackSpaces() {
        while (this.getIndex() > 0 && this.isSpace(this.getChar(this.getIndex() - 1))) {
            int n = this.getIndex();
            this.setIndex(n + -1);
        }
    }

    private final boolean isSpace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    @NotNull
    public String toString() {
        return "" + this.lineNumber + ':' + (this.getIndex() + 1);
    }

    private static final boolean _init_$lambda$0(char it) {
        return it == ' ';
    }

    private static final boolean matchSpaces$lambda$1(Line this$0, char it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.isSpace(it);
    }

    private static final boolean skipSpaces$lambda$2(Line this$0, char it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.isSpace(it);
    }

    private static final boolean skipToSpace$lambda$3(Line this$0, char it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return !this$0.isSpace(it);
    }
}

