/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.yaml.parser;

import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.pointer.JSONPointer;
import io.kjson.yaml.YAMLDocument;
import io.kjson.yaml.parser.Line;
import io.kjson.yaml.parser.Parser;
import io.kjson.yaml.parser.YAMLParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.pwall.log.Logger;
import net.pwall.log.LoggerUtilKt;
import net.pwall.pipeline.codec.DynamicReader;
import net.pwall.text.MapResult;
import net.pwall.text.StringMapper;
import net.pwall.text.TextMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0016\u0018\u0000 #2\u00020\u0001:\u0015\u001e\u001f !\"#$%&'()*+,-./012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u00063"}, d2={"Lio/kjson/yaml/parser/Parser;", "", "()V", "createYAMLDocument", "Lio/kjson/yaml/YAMLDocument;", "rootNode", "Lio/kjson/JSONValue;", "context", "Lio/kjson/yaml/parser/Parser$Context;", "parse", "file", "Ljava/io/File;", "charset", "Ljava/nio/charset/Charset;", "inputStream", "Ljava/io/InputStream;", "reader", "Ljava/io/Reader;", "parseStream", "", "processSeparator", "", "line", "Lio/kjson/yaml/parser/Line;", "outerBlock", "Lio/kjson/yaml/parser/Parser$Block;", "processTAGDirective", "processYAMLDirective", "Lkotlin/Pair;", "", "AliasChild", "Block", "BlockScalar", "Child", "ChildBlock", "Companion", "Context", "DoubleQuotedScalar", "ErrorBlock", "FlowMapping", "FlowNode", "FlowScalar", "FlowSequence", "FoldedBlockScalar", "InitialBlock", "LiteralBlockScalar", "MappingBlock", "PlainScalar", "SequenceBlock", "SingleQuotedScalar", "State", "kjson-yaml"})
public final class Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log = LoggerUtilKt.getLogger();
    @NotNull
    private static final Set<String> floatNamedConstants;

    @NotNull
    public final YAMLDocument parse(@NotNull File file, @Nullable Charset charset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.parse(new FileInputStream(file), charset);
    }

    public static /* synthetic */ YAMLDocument parse$default(Parser parser, File file, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = null;
        }
        return parser.parse(file, charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YAMLDocument parse(@NotNull InputStream inputStream, @Nullable Charset charset) {
        DynamicReader dynamicReader;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        DynamicReader dynamicReader2 = dynamicReader = new DynamicReader(inputStream);
        Parser parser = this;
        boolean bl = false;
        Charset charset2 = charset;
        if (charset2 != null) {
            void $this$parse_u24lambda_u2d1;
            Charset it = charset2;
            boolean bl2 = false;
            $this$parse_u24lambda_u2d1.switchTo(it);
        }
        return parser.parse((Reader)dynamicReader);
    }

    public static /* synthetic */ YAMLDocument parse$default(Parser parser, InputStream inputStream, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = null;
        }
        return parser.parse(inputStream, charset);
    }

    @NotNull
    public final YAMLDocument parse(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Ref.ObjectRef state = new Ref.ObjectRef();
        state.element = State.INITIAL;
        Context context = new Context(null, null, null, null, null, null, null, 127, null);
        InitialBlock outerBlock = new InitialBlock(context, 0);
        Ref.IntRef lineNumber = new Ref.IntRef();
        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(lineNumber, (Ref.ObjectRef<State>)state, context, this, outerBlock){
            final /* synthetic */ Ref.IntRef $lineNumber;
            final /* synthetic */ Ref.ObjectRef<State> $state;
            final /* synthetic */ Context $context;
            final /* synthetic */ Parser this$0;
            final /* synthetic */ InitialBlock $outerBlock;
            {
                this.$lineNumber = $lineNumber;
                this.$state = $state;
                this.$context = $context;
                this.this$0 = $receiver;
                this.$outerBlock = $outerBlock;
                super(1);
            }

            public final void invoke(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ++this.$lineNumber.element;
                Line line = new Line(this.$lineNumber.element, text);
                switch (parse.WhenMappings.$EnumSwitchMapping$0[((State)((Object)this.$state.element)).ordinal()]) {
                    case 1: {
                        if (StringsKt.startsWith$default((String)text, (String)"%YAML", (boolean)false, (int)2, null)) {
                            this.$context.setVersion((Pair<Integer, Integer>)Parser.access$processYAMLDirective(this.this$0, line));
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"%TAG", (boolean)false, (int)2, null)) {
                            Parser.access$processTAGDirective(this.this$0, this.$context, line);
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((CharSequence)text, (char)'%', (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$warn(Parser.Companion, Intrinsics.stringPlus((String)"Unrecognised directive ignored - ", (Object)text));
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$state.element = State.MAIN;
                            Parser.access$processSeparator(this.this$0, line, this.$outerBlock);
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (line.atEnd()) break;
                        this.$state.element = State.MAIN;
                        this.$outerBlock.processLine(line);
                        break;
                    }
                    case 2: {
                        if (StringsKt.startsWith$default((String)text, (String)"%YAML", (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Duplicate or misplaced %YAML directive", line);
                            throw new KotlinNothingValueException();
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"%TAG", (boolean)false, (int)2, null)) {
                            Parser.access$processTAGDirective(this.this$0, this.$context, line);
                            break;
                        }
                        if (StringsKt.startsWith$default((CharSequence)text, (char)'%', (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$warn(Parser.Companion, Intrinsics.stringPlus((String)"Unrecognised directive ignored - ", (Object)text));
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$state.element = State.MAIN;
                            Parser.access$processSeparator(this.this$0, line, this.$outerBlock);
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (line.atEnd()) break;
                        io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Illegal data following directive(s)", line);
                        throw new KotlinNothingValueException();
                    }
                    case 3: {
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Multiple documents not allowed", line);
                            throw new KotlinNothingValueException();
                        }
                        if (line.atEnd()) {
                            this.$outerBlock.processBlankLine(line);
                            break;
                        }
                        this.$outerBlock.processLine(line);
                        break;
                    }
                    case 4: {
                        if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0)) break;
                        io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Non-blank lines after end of document", line);
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }));
        JSONValue rootNode = outerBlock.conclude(new Line(lineNumber.element, ""));
        return this.createYAMLDocument(rootNode, context);
    }

    @NotNull
    public final List<YAMLDocument> parseStream(@NotNull File file, @Nullable Charset charset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.parseStream(new FileInputStream(file), charset);
    }

    public static /* synthetic */ List parseStream$default(Parser parser, File file, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = null;
        }
        return parser.parseStream(file, charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<YAMLDocument> parseStream(@NotNull InputStream inputStream, @Nullable Charset charset) {
        DynamicReader dynamicReader;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        DynamicReader dynamicReader2 = dynamicReader = new DynamicReader(inputStream);
        Parser parser = this;
        boolean bl = false;
        Charset charset2 = charset;
        if (charset2 != null) {
            void $this$parseStream_u24lambda_u2d3;
            Charset it = charset2;
            boolean bl2 = false;
            $this$parseStream_u24lambda_u2d3.switchTo(it);
        }
        return parser.parseStream((Reader)dynamicReader);
    }

    public static /* synthetic */ List parseStream$default(Parser parser, InputStream inputStream, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = null;
        }
        return parser.parseStream(inputStream, charset);
    }

    @NotNull
    public final List<YAMLDocument> parseStream(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Ref.ObjectRef state = new Ref.ObjectRef();
        state.element = State.INITIAL;
        Ref.ObjectRef context = new Ref.ObjectRef();
        context.element = new Context(null, null, null, null, null, null, null, 127, null);
        Ref.ObjectRef outerBlock = new Ref.ObjectRef();
        outerBlock.element = new InitialBlock((Context)context.element, 0);
        Ref.IntRef lineNumber = new Ref.IntRef();
        List result = new ArrayList();
        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(lineNumber, (Ref.ObjectRef<State>)state, (Ref.ObjectRef<Context>)context, this, (Ref.ObjectRef<InitialBlock>)outerBlock, (List<YAMLDocument>)result){
            final /* synthetic */ Ref.IntRef $lineNumber;
            final /* synthetic */ Ref.ObjectRef<State> $state;
            final /* synthetic */ Ref.ObjectRef<Context> $context;
            final /* synthetic */ Parser this$0;
            final /* synthetic */ Ref.ObjectRef<InitialBlock> $outerBlock;
            final /* synthetic */ List<YAMLDocument> $result;
            {
                this.$lineNumber = $lineNumber;
                this.$state = $state;
                this.$context = $context;
                this.this$0 = $receiver;
                this.$outerBlock = $outerBlock;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ++this.$lineNumber.element;
                Line line = new Line(this.$lineNumber.element, text);
                switch (parseStream.WhenMappings.$EnumSwitchMapping$0[((State)((Object)this.$state.element)).ordinal()]) {
                    case 1: {
                        if (StringsKt.startsWith$default((String)text, (String)"%YAML", (boolean)false, (int)2, null)) {
                            ((Context)this.$context.element).setVersion((Pair<Integer, Integer>)Parser.access$processYAMLDirective(this.this$0, line));
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"%TAG", (boolean)false, (int)2, null)) {
                            Parser.access$processTAGDirective(this.this$0, (Context)this.$context.element, line);
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((CharSequence)text, (char)'%', (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$warn(Parser.Companion, Intrinsics.stringPlus((String)"Unrecognised directive ignored - ", (Object)text));
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$state.element = State.MAIN;
                            Parser.access$processSeparator(this.this$0, line, (Block)this.$outerBlock.element);
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$result.add(new YAMLDocument(null, null, 2, null));
                            break;
                        }
                        if (line.atEnd()) break;
                        this.$state.element = State.MAIN;
                        ((InitialBlock)this.$outerBlock.element).processLine(line);
                        break;
                    }
                    case 2: {
                        if (StringsKt.startsWith$default((String)text, (String)"%YAML", (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Duplicate or misplaced %YAML directive", line);
                            throw new KotlinNothingValueException();
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"%TAG", (boolean)false, (int)2, null)) {
                            Parser.access$processTAGDirective(this.this$0, (Context)this.$context.element, line);
                            break;
                        }
                        if (StringsKt.startsWith$default((CharSequence)text, (char)'%', (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$warn(Parser.Companion, Intrinsics.stringPlus((String)"Unrecognised directive ignored - ", (Object)text));
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$state.element = State.MAIN;
                            Parser.access$processSeparator(this.this$0, line, (Block)this.$outerBlock.element);
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$result.add(Parser.access$createYAMLDocument(this.this$0, null, (Context)this.$context.element));
                            this.$state.element = State.INITIAL;
                            break;
                        }
                        if (line.atEnd()) break;
                        io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Illegal data following directive(s)", line);
                        throw new KotlinNothingValueException();
                    }
                    case 3: {
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$result.add(Parser.access$createYAMLDocument(this.this$0, ((InitialBlock)this.$outerBlock.element).conclude(line), (Context)this.$context.element));
                            this.$context.element = new Context(null, null, null, null, null, null, null, 127, null);
                            this.$outerBlock.element = new InitialBlock((Context)this.$context.element, 0);
                            this.$state.element = State.INITIAL;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$result.add(Parser.access$createYAMLDocument(this.this$0, ((InitialBlock)this.$outerBlock.element).conclude(line), (Context)this.$context.element));
                            this.$context.element = new Context(null, null, null, null, null, null, null, 127, null);
                            this.$outerBlock.element = new InitialBlock((Context)this.$context.element, 0);
                            this.$state.element = State.MAIN;
                            Parser.access$processSeparator(this.this$0, line, (Block)this.$outerBlock.element);
                            break;
                        }
                        if (line.atEnd()) {
                            ((InitialBlock)this.$outerBlock.element).processBlankLine(line);
                            break;
                        }
                        ((InitialBlock)this.$outerBlock.element).processLine(line);
                        break;
                    }
                    case 4: {
                        if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0)) break;
                        io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Non-blank lines after end of document", line);
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }));
        if (state.element != State.INITIAL || result.isEmpty()) {
            result.add(this.createYAMLDocument(((InitialBlock)outerBlock.element).conclude(new Line(lineNumber.element, "")), (Context)context.element));
        }
        return result;
    }

    private final void processSeparator(Line line, Block outerBlock) {
        line.skipFixed(3);
        line.skipSpaces();
        if (!line.atEnd()) {
            outerBlock.processLine(line);
        }
    }

    private final YAMLDocument createYAMLDocument(JSONValue rootNode, Context context) {
        log.debug(() -> Parser.createYAMLDocument$lambda-4(rootNode));
        Pair<Integer, Integer> pair = context.getVersion();
        if (pair != null) {
            Pair<Integer, Integer> it = pair;
            boolean bl = false;
            return new YAMLDocument(rootNode, context.getTagMap(), ((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        }
        return new YAMLDocument(rootNode, context.getTagMap());
    }

    private final Pair<Integer, Integer> processYAMLDirective(Line line) {
        line.skipFixed(5);
        if (!line.matchSpaces()) {
            Parser.Companion.fatal("Illegal %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        if (!line.matchDec()) {
            Parser.Companion.fatal("Illegal version number on %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        int majorVersion = line.getResultInt();
        if (!line.match('.') || !line.matchDec()) {
            Parser.Companion.fatal("Illegal version number on %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        int minorVersion = line.getResultInt();
        if (majorVersion != 1) {
            Parser.Companion.fatal("%YAML version must be 1.x", line);
            throw new KotlinNothingValueException();
        }
        line.skipSpaces();
        if (!line.atEnd()) {
            Parser.Companion.fatal("Illegal data on %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        if (!(1 <= minorVersion ? minorVersion < 3 : false)) {
            Parser.Companion.warn("Unexpected YAML version - " + majorVersion + '.' + minorVersion);
        }
        return TuplesKt.to((Object)majorVersion, (Object)minorVersion);
    }

    private final void processTAGDirective(Context context, Line line) {
        TextMatcher tm;
        String handle;
        String string;
        line.skipFixed(4);
        if (!line.matchSpaces()) {
            Parser.Companion.fatal("Illegal %TAG directive", line);
            throw new KotlinNothingValueException();
        }
        if (!line.match('!')) {
            Parser.Companion.fatal("Illegal tag handle on %TAG directive", line);
            throw new KotlinNothingValueException();
        }
        int handleStart = line.getStart();
        if (line.matchSpace()) {
            line.revert();
            string = "!";
        } else if (line.match('!')) {
            string = "!!";
        } else {
            if (!line.matchSeq(Parser::processTAGDirective$lambda-6) || !line.match('!')) {
                Parser.Companion.fatal("Illegal tag handle on %TAG directive", line);
                throw new KotlinNothingValueException();
            }
            string = handle = line.getString(handleStart, line.getIndex());
        }
        if (context.getTagHandles().containsKey(handle)) {
            Parser.Companion.fatal("Duplicate tag handle", line);
            throw new KotlinNothingValueException();
        }
        if (!line.matchSpaces()) {
            Parser.Companion.fatal("Illegal %TAG directive", line);
            throw new KotlinNothingValueException();
        }
        line.skipToSpace();
        String prefix = line.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"prefix");
        if (!(StringsKt.startsWith$default((CharSequence)prefix, (char)'!', (boolean)false, (int)2, null) || Parser.Companion.matchURI(tm = new TextMatcher(prefix)) && tm.isAtEnd())) {
            Parser.Companion.fatal("Illegal prefix on %TAG directive", line);
            throw new KotlinNothingValueException();
        }
        line.skipSpaces();
        if (!line.atEnd()) {
            Parser.Companion.fatal("Illegal data on %TAG directive", line);
            throw new KotlinNothingValueException();
        }
        Map<String, String> map = context.getTagHandles();
        Intrinsics.checkNotNullExpressionValue((Object)handle, (String)"handle");
        map.put(handle, prefix);
    }

    private static final Object createYAMLDocument$lambda-4(JSONValue $rootNode) {
        String type = $rootNode == null ? "null" : Reflection.getOrCreateKotlinClass($rootNode.getClass()).getSimpleName();
        return Intrinsics.stringPlus((String)"Parse complete; result is ", (Object)type);
    }

    private static final boolean processTAGDirective$lambda-6(char it) {
        return Parser.Companion.isTagHandleChar(it);
    }

    public static final /* synthetic */ Pair access$processYAMLDirective(Parser $this, Line line) {
        return $this.processYAMLDirective(line);
    }

    public static final /* synthetic */ void access$processTAGDirective(Parser $this, Context context, Line line) {
        $this.processTAGDirective(context, line);
    }

    public static final /* synthetic */ void access$processSeparator(Parser $this, Line line, Block outerBlock) {
        $this.processSeparator(line, outerBlock);
    }

    public static final /* synthetic */ YAMLDocument access$createYAMLDocument(Parser $this, JSONValue rootNode, Context context) {
        return $this.createYAMLDocument(rootNode, context);
    }

    static {
        Object[] objectArray = new String[]{".nan", ".NaN", ".NAN", ".inf", ".Inf", ".INF", "+.inf", "+.Inf", "+.INF", "-.inf", "-.Inf", "-.INF"};
        floatNamedConstants = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/kjson/yaml/parser/Parser$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "DIRECTIVE", "MAIN", "ENDED", "kjson-yaml"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIAL = new State();
        public static final /* enum */ State DIRECTIVE = new State();
        public static final /* enum */ State MAIN = new State();
        public static final /* enum */ State ENDED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.INITIAL, State.DIRECTIVE, State.MAIN, State.ENDED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0007J\u0010\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\"\u001a\u00020\u0007J\u0010\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R(\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lio/kjson/yaml/parser/Parser$Context;", "", "version", "Lkotlin/Pair;", "", "tagHandles", "", "", "anchorMap", "Lio/kjson/JSONValue;", "tagMap", "Lio/kjson/pointer/JSONPointer;", "pointer", "anchor", "tag", "(Lkotlin/Pair;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lio/kjson/pointer/JSONPointer;Ljava/lang/String;Ljava/lang/String;)V", "getAnchor", "()Ljava/lang/String;", "setAnchor", "(Ljava/lang/String;)V", "getAnchorMap", "()Ljava/util/Map;", "getTag", "setTag", "getTagHandles", "getTagMap", "getVersion", "()Lkotlin/Pair;", "setVersion", "(Lkotlin/Pair;)V", "child", "index", "name", "getTagHandle", "shortcut", "saveNodeProperties", "", "node", "kjson-yaml"})
    public static final class Context {
        @Nullable
        private Pair<Integer, Integer> version;
        @NotNull
        private final Map<String, String> tagHandles;
        @NotNull
        private final Map<String, JSONValue> anchorMap;
        @NotNull
        private final Map<JSONPointer, String> tagMap;
        @NotNull
        private final JSONPointer pointer;
        @Nullable
        private String anchor;
        @Nullable
        private String tag;

        public Context(@Nullable Pair<Integer, Integer> version, @NotNull Map<String, String> tagHandles, @NotNull Map<String, JSONValue> anchorMap, @NotNull Map<JSONPointer, String> tagMap, @NotNull JSONPointer pointer, @Nullable String anchor, @Nullable String tag) {
            Intrinsics.checkNotNullParameter(tagHandles, (String)"tagHandles");
            Intrinsics.checkNotNullParameter(anchorMap, (String)"anchorMap");
            Intrinsics.checkNotNullParameter(tagMap, (String)"tagMap");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            this.version = version;
            this.tagHandles = tagHandles;
            this.anchorMap = anchorMap;
            this.tagMap = tagMap;
            this.pointer = pointer;
            this.anchor = anchor;
            this.tag = tag;
        }

        public /* synthetic */ Context(Pair pair, Map map, Map map2, Map map3, JSONPointer jSONPointer, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                pair = null;
            }
            if ((n & 2) != 0) {
                map = new LinkedHashMap();
            }
            if ((n & 4) != 0) {
                map2 = new LinkedHashMap();
            }
            if ((n & 8) != 0) {
                map3 = new LinkedHashMap();
            }
            if ((n & 0x10) != 0) {
                jSONPointer = JSONPointer.Companion.getRoot();
            }
            if ((n & 0x20) != 0) {
                string = null;
            }
            if ((n & 0x40) != 0) {
                string2 = null;
            }
            this((Pair<Integer, Integer>)pair, map, map2, map3, jSONPointer, string, string2);
        }

        @Nullable
        public final Pair<Integer, Integer> getVersion() {
            return this.version;
        }

        public final void setVersion(@Nullable Pair<Integer, Integer> pair) {
            this.version = pair;
        }

        @NotNull
        public final Map<String, String> getTagHandles() {
            return this.tagHandles;
        }

        @NotNull
        public final Map<String, JSONValue> getAnchorMap() {
            return this.anchorMap;
        }

        @NotNull
        public final Map<JSONPointer, String> getTagMap() {
            return this.tagMap;
        }

        @Nullable
        public final String getAnchor() {
            return this.anchor;
        }

        public final void setAnchor(@Nullable String string) {
            this.anchor = string;
        }

        @Nullable
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@Nullable String string) {
            this.tag = string;
        }

        @Nullable
        public final String getTagHandle(@NotNull String shortcut) {
            String string;
            Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
            String string2 = this.tagHandles.get(shortcut);
            return string2 == null ? (Intrinsics.areEqual((Object)(string = shortcut), (Object)"!") ? "!" : (Intrinsics.areEqual((Object)string, (Object)"!!") ? "tag:yaml.org,2002:" : null)) : string2;
        }

        public final void saveNodeProperties(@Nullable JSONValue node) {
            String it;
            String string = this.anchor;
            if (string != null) {
                it = string;
                boolean bl = false;
                if (node != null) {
                    this.getAnchorMap().put(it, node);
                }
            }
            String string2 = this.tag;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                Map<JSONPointer, String> map = this.getTagMap();
                JSONPointer jSONPointer = this.pointer;
                map.put(jSONPointer, it);
            }
        }

        @NotNull
        public final Context child(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Context(this.version, this.tagHandles, this.anchorMap, this.tagMap, this.pointer.child(name), null, null, 96, null);
        }

        @NotNull
        public final Context child(int index) {
            return new Context(this.version, this.tagHandles, this.anchorMap, this.tagMap, this.pointer.child(index), null, null, 96, null);
        }

        public Context() {
            this(null, null, null, null, null, null, null, 127, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lio/kjson/yaml/parser/Parser$Block;", "", "context", "Lio/kjson/yaml/parser/Parser$Context;", "indent", "", "(Lio/kjson/yaml/parser/Parser$Context;I)V", "getContext", "()Lio/kjson/yaml/parser/Parser$Context;", "getIndent", "()I", "conclude", "Lio/kjson/JSONValue;", "line", "Lio/kjson/yaml/parser/Line;", "processBlankLine", "", "processLine", "kjson-yaml"})
    public static abstract class Block {
        @NotNull
        private final Context context;
        private final int indent;

        public Block(@NotNull Context context, int indent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.indent = indent;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        public final int getIndent() {
            return this.indent;
        }

        public abstract void processLine(@NotNull Line var1);

        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
        }

        @Nullable
        public abstract JSONValue conclude(@NotNull Line var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lio/kjson/yaml/parser/Parser$ErrorBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "()V", "conclude", "", "line", "Lio/kjson/yaml/parser/Line;", "processLine", "kjson-yaml"})
    public static final class ErrorBlock
    extends Block {
        @NotNull
        public static final ErrorBlock INSTANCE = new ErrorBlock();

        private ErrorBlock() {
            super(new Context(null, null, null, null, null, null, null, 127, null), 0);
        }

        @NotNull
        public Void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            Companion.fatal("Should not happen", line);
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            Companion.fatal("Should not happen", line);
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/kjson/yaml/parser/Parser$InitialBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "context", "Lio/kjson/yaml/parser/Parser$Context;", "indent", "", "(Lio/kjson/yaml/parser/Parser$Context;I)V", "child", "node", "Lio/kjson/JSONValue;", "state", "Lio/kjson/yaml/parser/Parser$InitialBlock$State;", "conclude", "line", "Lio/kjson/yaml/parser/Line;", "processBlankLine", "", "processFirstLine", "processLine", "State", "kjson-yaml"})
    public static final class InitialBlock
    extends Block {
        @NotNull
        private State state;
        @Nullable
        private JSONValue node;
        @NotNull
        private Block child;

        public InitialBlock(@NotNull Context context, int indent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, indent);
            this.state = State.INITIAL;
            this.child = ErrorBlock.INSTANCE;
        }

        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processFirstLine(line);
                    break;
                }
                case 2: {
                    this.child.processLine(line);
                    break;
                }
                case 3: {
                    Companion.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        private final void processFirstLine(Line line) {
            Child child;
            Object it;
            int initialIndex = line.getIndex();
            Companion.processNodeProperties(line, this.getContext());
            if (line.atEnd()) {
                return;
            }
            if (line.match('*')) {
                it = Companion.getAnchorName(line);
                boolean bl = false;
                JSONValue jSONValue = this.getContext().getAnchorMap().get(it);
                if (jSONValue == null) {
                    Companion.fatal("Can't locate alias \"" + (String)it + '\"', line);
                    throw new KotlinNothingValueException();
                }
                child = new AliasChild(jSONValue);
            } else {
                Child child2;
                if (line.matchDash()) {
                    this.child = new SequenceBlock(this.getContext(), initialIndex);
                    if (!line.atEnd()) {
                        this.child.processLine(line);
                    }
                    this.state = State.CHILD;
                    return;
                }
                if (line.match('\"')) {
                    child = io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null);
                } else if (line.match('\'')) {
                    child = io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null);
                } else if (line.match('[')) {
                    child2 = new FlowSequence(this.getContext(), false);
                    it = child2;
                    boolean bl = false;
                    ((FlowSequence)it).continuation(line);
                    child = child2;
                } else if (line.match('{')) {
                    child2 = new FlowMapping(this.getContext(), false);
                    it = child2;
                    boolean bl = false;
                    ((FlowMapping)it).continuation(line);
                    child = child2;
                } else {
                    BlockScalar.Chomping chomping;
                    if (line.match('?')) {
                        line.skipSpaces();
                        this.child = new MappingBlock(this.getContext(), initialIndex);
                        if (!line.atEnd()) {
                            this.child.processLine(line);
                        }
                        this.state = State.CHILD;
                        return;
                    }
                    if (line.match(':')) {
                        Companion.fatal("Can't handle standalone mapping values", line);
                        throw new KotlinNothingValueException();
                    }
                    if (line.match('|')) {
                        chomping = Companion.determineChomping(line);
                        line.skipSpaces();
                        if (!line.atEnd()) {
                            Companion.fatal("Illegal literal block header", line);
                            throw new KotlinNothingValueException();
                        }
                        child = new LiteralBlockScalar(this.getIndent(), chomping);
                    } else if (line.match('>')) {
                        chomping = Companion.determineChomping(line);
                        line.skipSpaces();
                        if (!line.atEnd()) {
                            Companion.fatal("Illegal folded block header", line);
                            throw new KotlinNothingValueException();
                        }
                        child = new FoldedBlockScalar(this.getIndent(), chomping);
                    } else {
                        child = io.kjson.yaml.parser.Parser$Companion.processPlainScalar$default(Companion, line, null, this.getContext(), 1, null);
                    }
                }
            }
            Child scalar = child;
            line.skipSpaces();
            if (line.matchColon()) {
                if (line.atEnd()) {
                    this.child = new MappingBlock(this.getContext(), initialIndex, ((Object)scalar.getText()).toString());
                    this.state = State.CHILD;
                } else {
                    this.child = new MappingBlock(this.getContext(), initialIndex, ((Object)scalar.getText()).toString(), line);
                    this.state = State.CHILD;
                }
            } else if (scalar.getTerminated()) {
                this.node = scalar.getYAMLNode();
                this.state = State.CLOSED;
            } else {
                this.child = new ChildBlock(this.getContext(), initialIndex, scalar);
                this.state = State.CHILD;
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.processBlankLine(line);
                }
            }
        }

        @Override
        @Nullable
        public JSONValue conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.node = this.child.conclude(line);
                }
            }
            this.state = State.CLOSED;
            this.getContext().saveNodeProperties(this.node);
            return this.node;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/yaml/parser/Parser$InitialBlock$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CHILD", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CHILD, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.INITIAL.ordinal()] = 1;
                nArray[State.CHILD.ordinal()] = 2;
                nArray[State.CLOSED.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001aB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/kjson/yaml/parser/Parser$MappingBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "context", "Lio/kjson/yaml/parser/Parser$Context;", "indent", "", "key", "", "(Lio/kjson/yaml/parser/Parser$Context;ILjava/lang/String;)V", "line", "Lio/kjson/yaml/parser/Line;", "(Lio/kjson/yaml/parser/Parser$Context;ILjava/lang/String;Lio/kjson/yaml/parser/Line;)V", "(Lio/kjson/yaml/parser/Parser$Context;I)V", "child", "properties", "Lio/kjson/JSONObject$Builder;", "state", "Lio/kjson/yaml/parser/Parser$MappingBlock$State;", "conclude", "Lio/kjson/JSONObject;", "processBlankLine", "", "processColon", "processLine", "processQM", "saveKey", "State", "kjson-yaml"})
    public static final class MappingBlock
    extends Block {
        @NotNull
        private State state;
        @NotNull
        private Block child;
        @NotNull
        private final JSONObject.Builder properties;
        @NotNull
        private String key;

        public MappingBlock(@NotNull Context context, int indent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, indent);
            this.state = State.QM_CHILD;
            this.child = new InitialBlock(context, indent + 1);
            this.properties = new JSONObject.Builder(0, null, 3, null);
            this.key = "";
        }

        public MappingBlock(@NotNull Context context, int indent, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this(context, indent);
            this.key = key;
            this.child = new InitialBlock(context.child(key), indent + 1);
            this.state = State.CHILD;
        }

        public MappingBlock(@NotNull Context context, int indent, @NotNull String key, @NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            this(context, indent);
            this.key = key;
            this.child = new InitialBlock(context.child(key), indent + 1);
            this.child.processLine(line);
            this.state = State.CHILD;
        }

        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            int effectiveIndent = line.getIndex();
            if (line.matchDash()) {
                effectiveIndent = line.getIndex();
                line.revert();
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processQM(line);
                    break;
                }
                case 2: {
                    if (line.getIndex() >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    this.saveKey(line);
                    this.state = State.COLON;
                    this.processColon(line);
                    break;
                }
                case 3: {
                    this.processColon(line);
                    break;
                }
                case 4: {
                    if (effectiveIndent >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    this.properties.add(this.key, this.child.conclude(line));
                    this.state = State.KEY;
                    this.processQM(line);
                    break;
                }
                case 5: {
                    Companion.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void saveKey(Line line) {
            String string;
            MappingBlock mappingBlock = this;
            JSONValue jSONValue = this.child.conclude(line);
            if (jSONValue == null) {
                string = "null";
            } else {
                void it;
                JSONValue jSONValue2 = jSONValue;
                MappingBlock mappingBlock2 = mappingBlock;
                boolean bl = false;
                String string2 = it instanceof JSONString ? ((JSONString)it).getValue() : it.toString();
                mappingBlock = mappingBlock2;
                string = string2;
                if (string2 == null) {
                    string = mappingBlock.key = "null";
                }
            }
            if (this.properties.containsKey(this.key)) {
                Companion.fatal(Intrinsics.stringPlus((String)"Duplicate key in mapping - ", (Object)this.key), line);
                throw new KotlinNothingValueException();
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: 
                case 4: {
                    this.child.processBlankLine(line);
                }
            }
        }

        private final void processQM(Line line) {
            if (line.match('?')) {
                line.skipSpaces();
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getContext(), this.getIndent() + 1);
                } else {
                    this.child = new InitialBlock(this.getContext(), line.getIndex());
                    this.child.processLine(line);
                }
                this.state = State.QM_CHILD;
            } else {
                if (line.atEnd()) {
                    return;
                }
                FlowScalar scalar = line.match('\"') ? (FlowScalar)io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null) : (line.match('\'') ? (FlowScalar)io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null) : (FlowScalar)io.kjson.yaml.parser.Parser$Companion.processPlainScalar$default(Companion, line, null, this.getContext(), 1, null));
                line.skipSpaces();
                if (line.matchColon()) {
                    this.key = scalar.getText();
                    if (this.properties.containsKey(this.key)) {
                        Companion.fatal(Intrinsics.stringPlus((String)"Duplicate key in mapping - ", (Object)this.key), line);
                        throw new KotlinNothingValueException();
                    }
                    line.skipSpaces();
                    if (line.atEnd()) {
                        this.child = new InitialBlock(this.getContext().child(this.key), this.getIndent() + 1);
                        this.state = State.CHILD;
                    } else {
                        this.child = new InitialBlock(this.getContext().child(this.key), this.getIndent() + 1);
                        this.child.processLine(line);
                        this.state = State.CHILD;
                    }
                } else {
                    Companion.fatal("Illegal key in mapping", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        private final void processColon(Line line) {
            if (line.match(':')) {
                line.skipSpaces();
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getContext().child(this.key), this.getIndent() + 1);
                } else {
                    this.child = new InitialBlock(this.getContext().child(this.key), line.getIndex());
                    this.child.processLine(line);
                }
                this.state = State.CHILD;
            } else if (line.match('?')) {
                this.saveKey(line);
                this.properties.add(this.key, null);
                line.revert();
                this.processQM(line);
            } else {
                Companion.fatal("Unexpected content in block mapping", line);
                throw new KotlinNothingValueException();
            }
        }

        @NotNull
        public JSONObject conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    this.saveKey(line);
                    this.properties.add(this.key, null);
                    break;
                }
                case 4: {
                    this.properties.add(this.key, this.child.conclude(line));
                }
            }
            this.state = State.CLOSED;
            return this.properties.build();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/kjson/yaml/parser/Parser$MappingBlock$State;", "", "(Ljava/lang/String;I)V", "KEY", "CHILD", "QM_CHILD", "COLON", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State KEY = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State QM_CHILD = new State();
            public static final /* enum */ State COLON = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.KEY, State.CHILD, State.QM_CHILD, State.COLON, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.KEY.ordinal()] = 1;
                nArray[State.QM_CHILD.ordinal()] = 2;
                nArray[State.COLON.ordinal()] = 3;
                nArray[State.CHILD.ordinal()] = 4;
                nArray[State.CLOSED.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/kjson/yaml/parser/Parser$SequenceBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "context", "Lio/kjson/yaml/parser/Parser$Context;", "indent", "", "(Lio/kjson/yaml/parser/Parser$Context;I)V", "child", "items", "Lio/kjson/JSONArray$Builder;", "state", "Lio/kjson/yaml/parser/Parser$SequenceBlock$State;", "conclude", "Lio/kjson/JSONArray;", "line", "Lio/kjson/yaml/parser/Line;", "processBlankLine", "", "processDash", "processLine", "State", "kjson-yaml"})
    public static final class SequenceBlock
    extends Block {
        @NotNull
        private State state;
        @NotNull
        private final JSONArray.Builder items;
        @NotNull
        private Block child;

        public SequenceBlock(@NotNull Context context, int indent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, indent);
            this.state = State.CHILD;
            this.items = new JSONArray.Builder(0, null, 3, null);
            this.child = new InitialBlock(context.child(0), indent + 2);
        }

        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processDash(line);
                    break;
                }
                case 2: {
                    if (line.getIndex() >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    this.items.add(this.child.conclude(line));
                    this.state = State.DASH;
                    this.processDash(line);
                    break;
                }
                case 3: {
                    Companion.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.processBlankLine(line);
                }
            }
        }

        private final void processDash(Line line) {
            if (line.matchDash()) {
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getContext().child(this.items.getSize()), this.getIndent() + 2);
                } else {
                    this.child = new InitialBlock(this.getContext().child(this.items.getSize()), line.getIndex());
                    this.child.processLine(line);
                }
            } else {
                Companion.fatal("Unexpected content in block sequence", line);
                throw new KotlinNothingValueException();
            }
            this.state = State.CHILD;
        }

        @NotNull
        public JSONArray conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.items.add(this.child.conclude(line));
                }
            }
            this.state = State.CLOSED;
            return this.items.build();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/yaml/parser/Parser$SequenceBlock$State;", "", "(Ljava/lang/String;I)V", "DASH", "CHILD", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State DASH = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.DASH, State.CHILD, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.DASH.ordinal()] = 1;
                nArray[State.CHILD.ordinal()] = 2;
                nArray[State.CLOSED.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/kjson/yaml/parser/Parser$ChildBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "context", "Lio/kjson/yaml/parser/Parser$Context;", "indent", "", "scalar", "Lio/kjson/yaml/parser/Parser$Child;", "(Lio/kjson/yaml/parser/Parser$Context;ILio/kjson/yaml/parser/Parser$Child;)V", "(Lio/kjson/yaml/parser/Parser$Context;I)V", "child", "node", "Lio/kjson/JSONValue;", "state", "Lio/kjson/yaml/parser/Parser$ChildBlock$State;", "conclude", "line", "Lio/kjson/yaml/parser/Line;", "processBlankLine", "", "processLine", "State", "kjson-yaml"})
    public static final class ChildBlock
    extends Block {
        @NotNull
        private State state;
        @NotNull
        private Child child;
        @Nullable
        private JSONValue node;

        public ChildBlock(@NotNull Context context, int indent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context, indent);
            this.state = State.INITIAL;
            this.child = new PlainScalar("", context);
        }

        public ChildBlock(@NotNull Context context, int indent, @NotNull Child scalar) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
            this(context, indent);
            this.child = scalar;
            this.state = State.CONTINUATION;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void processLine(@NotNull Line line) {
            Child child;
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            ChildBlock childBlock = this;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    Companion.processNodeProperties(line, this.getContext());
                    if (line.isAtEnd()) {
                        return;
                    }
                    if (line.match('#')) {
                        return;
                    }
                    if (line.match('*')) {
                        void it;
                        String string = Companion.getAnchorName(line);
                        ChildBlock childBlock2 = childBlock;
                        boolean bl = false;
                        JSONValue jSONValue = this.getContext().getAnchorMap().get(it);
                        if (jSONValue == null) {
                            Companion.fatal("Can't locate alias \"" + (String)it + '\"', line);
                            throw new KotlinNothingValueException();
                        }
                        childBlock = childBlock2;
                        child = new AliasChild(jSONValue);
                        break;
                    }
                    if (line.match('\"')) {
                        child = io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null);
                        break;
                    }
                    if (line.match('\'')) {
                        child = io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null);
                        break;
                    }
                    if (line.match('|')) {
                        BlockScalar.Chomping chomping = Companion.determineChomping(line);
                        line.skipSpaces();
                        if (!line.atEnd()) {
                            Companion.fatal("Illegal literal block header", line);
                            throw new KotlinNothingValueException();
                        }
                        child = new LiteralBlockScalar(this.getIndent(), chomping);
                        break;
                    }
                    if (line.match('>')) {
                        BlockScalar.Chomping chomping = Companion.determineChomping(line);
                        line.skipSpaces();
                        if (!line.atEnd()) {
                            Companion.fatal("Illegal folded block header", line);
                            throw new KotlinNothingValueException();
                        }
                        child = new FoldedBlockScalar(this.getIndent(), chomping);
                        break;
                    }
                    if (line.match('[')) {
                        FlowSequence flowSequence;
                        FlowSequence it = flowSequence = new FlowSequence(this.getContext(), false);
                        ChildBlock childBlock3 = childBlock;
                        boolean bl = false;
                        it.continuation(line);
                        childBlock = childBlock3;
                        child = flowSequence;
                        break;
                    }
                    if (line.match('{')) {
                        FlowMapping flowMapping;
                        FlowMapping it = flowMapping = new FlowMapping(this.getContext(), false);
                        ChildBlock childBlock4 = childBlock;
                        boolean bl = false;
                        it.continuation(line);
                        childBlock = childBlock4;
                        child = flowMapping;
                        break;
                    }
                    if (line.match('?')) {
                        Companion.fatal("Can't handle standalone mapping keys", line);
                        throw new KotlinNothingValueException();
                    }
                    if (line.match(':')) {
                        Companion.fatal("Can't handle standalone mapping values", line);
                        throw new KotlinNothingValueException();
                    }
                    child = io.kjson.yaml.parser.Parser$Companion.processPlainScalar$default(Companion, line, null, this.getContext(), 1, null);
                    break;
                }
                case 2: {
                    child = this.child.continuation(line);
                    break;
                }
                case 3: {
                    Companion.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            childBlock.child = child;
            line.skipSpaces();
            if (line.atEnd()) {
                if (this.child.getTerminated()) {
                    this.node = this.child.getYAMLNode();
                    this.state = State.CLOSED;
                } else {
                    this.state = State.CONTINUATION;
                }
            } else {
                Companion.fatal("Illegal data following scalar", line);
                throw new KotlinNothingValueException();
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.continuation(line);
                }
            }
        }

        @Override
        @Nullable
        public JSONValue conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.child.getComplete()) {
                        this.node = this.child.getYAMLNode();
                        break;
                    }
                    Companion.fatal("Incomplete scalar", line);
                    throw new KotlinNothingValueException();
                }
            }
            this.state = State.CLOSED;
            this.getContext().saveNodeProperties(this.node);
            return this.node;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/yaml/parser/Parser$ChildBlock$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CONTINUATION", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CONTINUATION, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.INITIAL.ordinal()] = 1;
                nArray[State.CONTINUATION.ordinal()] = 2;
                nArray[State.CLOSED.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H&R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\u0004R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lio/kjson/yaml/parser/Parser$Child;", "", "terminated", "", "(Z)V", "complete", "getComplete", "()Z", "getTerminated", "setTerminated", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONValue;", "kjson-yaml"})
    public static abstract class Child {
        private boolean terminated;

        public Child(boolean terminated) {
            this.terminated = terminated;
        }

        public final boolean getTerminated() {
            return this.terminated;
        }

        public final void setTerminated(boolean bl) {
            this.terminated = bl;
        }

        public boolean getComplete() {
            return this.terminated;
        }

        @NotNull
        public abstract CharSequence getText();

        @Nullable
        public abstract JSONValue getYAMLNode();

        @NotNull
        public abstract Child continuation(@NotNull Line var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/kjson/yaml/parser/Parser$AliasChild;", "Lio/kjson/yaml/parser/Parser$Child;", "node", "Lio/kjson/JSONValue;", "(Lio/kjson/JSONValue;)V", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "kjson-yaml"})
    public static final class AliasChild
    extends Child {
        @NotNull
        private final JSONValue node;

        public AliasChild(@NotNull JSONValue node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super(true);
            this.node = node;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return this.getYAMLNode().toString();
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            Companion.fatal("Illegal data after alias", line);
            throw new KotlinNothingValueException();
        }

        @Override
        @NotNull
        public JSONValue getYAMLNode() {
            return this.node;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lio/kjson/yaml/parser/Parser$FlowSequence;", "Lio/kjson/yaml/parser/Parser$Child;", "context", "Lio/kjson/yaml/parser/Parser$Context;", "terminated", "", "(Lio/kjson/yaml/parser/Parser$Context;Z)V", "child", "items", "Lio/kjson/JSONArray$Builder;", "key", "", "seqContext", "state", "Lio/kjson/yaml/parser/Parser$FlowSequence$State;", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONArray;", "processLine", "", "State", "kjson-yaml"})
    public static final class FlowSequence
    extends Child {
        @NotNull
        private final Context context;
        @NotNull
        private State state;
        @NotNull
        private Context seqContext;
        @NotNull
        private Child child;
        @Nullable
        private String key;
        @NotNull
        private final JSONArray.Builder items;

        public FlowSequence(@NotNull Context context, boolean terminated) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(terminated);
            this.context = context;
            this.state = State.ITEM;
            this.seqContext = this.context.child(0);
            this.child = new FlowNode("", this.seqContext);
            this.items = new JSONArray.Builder(0, null, 3, null);
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return this.getYAMLNode().toString();
        }

        private final void processLine(Line line) {
            while (!line.atEnd()) {
                JSONValue item;
                Pair[] pairArray;
                Object it;
                if (this.state != State.COMMA) {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                        case 1: {
                            FlowSequence flowSequence;
                            Child child;
                            Child child2;
                            line.skipSpaces();
                            Companion.processNodeProperties(line, this.seqContext);
                            FlowSequence flowSequence2 = this;
                            if (line.match('\"')) {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null);
                            } else if (line.match('\'')) {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null);
                            } else if (line.match('[')) {
                                FlowSequence flowSequence3 = child = new FlowSequence(this.seqContext, false);
                                flowSequence = flowSequence2;
                                boolean bl = false;
                                ((FlowSequence)it).continuation(line);
                                flowSequence2 = flowSequence;
                                child2 = child;
                            } else if (line.match('{')) {
                                child = new FlowMapping(this.seqContext, false);
                                it = child;
                                flowSequence = flowSequence2;
                                boolean bl = false;
                                ((FlowMapping)it).continuation(line);
                                flowSequence2 = flowSequence;
                                child2 = child;
                            } else if (line.match('*')) {
                                it = Companion.getAnchorName(line);
                                flowSequence = flowSequence2;
                                boolean bl = false;
                                JSONValue jSONValue = this.seqContext.getAnchorMap().get(it);
                                if (jSONValue == null) {
                                    Companion.fatal("Can't locate alias \"" + (String)it + '\"', line);
                                    throw new KotlinNothingValueException();
                                }
                                flowSequence2 = flowSequence;
                                child2 = new AliasChild(jSONValue);
                            } else {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processFlowNode$default(Companion, line, null, this.seqContext, 1, null);
                            }
                            flowSequence2.child = child2;
                            break;
                        }
                        case 2: {
                            this.child = this.child.continuation(line);
                        }
                    }
                    line.skipSpaces();
                    if (line.atEnd()) {
                        this.state = this.child.getTerminated() ? State.COMMA : State.CONTINUATION;
                        break;
                    }
                }
                if (line.match(']')) {
                    JSONObject jSONObject;
                    String string = this.key;
                    if (string == null) {
                        jSONObject = null;
                    } else {
                        String it2 = string;
                        boolean bl = false;
                        pairArray = new Pair[]{TuplesKt.to((Object)it2, (Object)this.child.getYAMLNode())};
                        jSONObject = JSONObject.Companion.of(pairArray);
                    }
                    JSONValue jSONValue = item = jSONObject == null ? this.child.getYAMLNode() : (JSONValue)jSONObject;
                    if (jSONValue != null) {
                        it = jSONValue;
                        boolean bl = false;
                        this.items.add((JSONValue)it);
                    }
                    this.seqContext.saveNodeProperties(item);
                    this.setTerminated(true);
                    this.state = State.CLOSED;
                    break;
                }
                if (line.matchColon()) {
                    this.key = String.valueOf(this.child.getYAMLNode());
                    this.state = State.ITEM;
                    continue;
                }
                if (line.match(',')) {
                    JSONObject jSONObject;
                    if (this.key == null) {
                        jSONObject = null;
                    } else {
                        String it3;
                        boolean bl = false;
                        pairArray = new Pair[]{TuplesKt.to((Object)it3, (Object)this.child.getYAMLNode())};
                        jSONObject = JSONObject.Companion.of(pairArray);
                    }
                    item = jSONObject == null ? this.child.getYAMLNode() : (JSONValue)jSONObject;
                    this.items.add(item);
                    this.seqContext.saveNodeProperties(item);
                    this.key = null;
                    this.seqContext = this.context.child(this.items.getSize());
                    this.state = State.ITEM;
                    continue;
                }
                Companion.fatal("Unexpected character in flow sequence", line);
                throw new KotlinNothingValueException();
            }
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            if (this.state != State.CLOSED) {
                this.processLine(line);
            }
            return this;
        }

        @NotNull
        public JSONArray getYAMLNode() {
            return this.items.build();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/kjson/yaml/parser/Parser$FlowSequence$State;", "", "(Ljava/lang/String;I)V", "ITEM", "CONTINUATION", "COMMA", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State ITEM = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State COMMA = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.ITEM, State.CONTINUATION, State.COMMA, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.ITEM.ordinal()] = 1;
                nArray[State.CONTINUATION.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lio/kjson/yaml/parser/Parser$FlowMapping;", "Lio/kjson/yaml/parser/Parser$Child;", "context", "Lio/kjson/yaml/parser/Parser$Context;", "terminated", "", "(Lio/kjson/yaml/parser/Parser$Context;Z)V", "child", "key", "", "mapContext", "properties", "Lio/kjson/JSONObject$Builder;", "state", "Lio/kjson/yaml/parser/Parser$FlowMapping$State;", "text", "", "getText", "()Ljava/lang/CharSequence;", "addProperty", "", "value", "Lio/kjson/JSONValue;", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONObject;", "processLine", "State", "kjson-yaml"})
    public static final class FlowMapping
    extends Child {
        @NotNull
        private final Context context;
        @NotNull
        private State state;
        @NotNull
        private Context mapContext;
        @NotNull
        private Child child;
        @Nullable
        private String key;
        @NotNull
        private final JSONObject.Builder properties;

        public FlowMapping(@NotNull Context context, boolean terminated) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(terminated);
            this.context = context;
            this.state = State.ITEM;
            this.mapContext = this.context.child("");
            this.child = new FlowNode("", this.mapContext);
            this.properties = new JSONObject.Builder(0, null, 3, null);
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return this.getYAMLNode().toString();
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            if (this.state != State.CLOSED) {
                this.processLine(line);
            }
            return this;
        }

        @NotNull
        public JSONObject getYAMLNode() {
            return this.properties.build();
        }

        private final void processLine(Line line) {
            while (!line.atEnd()) {
                Object it;
                if (this.state != State.COMMA) {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                        case 1: {
                            FlowMapping flowMapping;
                            Child child;
                            line.skipSpaces();
                            Companion.processNodeProperties(line, this.mapContext);
                            FlowMapping flowMapping2 = this;
                            if (line.match('\"')) {
                                child = io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null);
                            } else if (line.match('\'')) {
                                child = io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null);
                            } else if (line.match('[')) {
                                FlowSequence flowSequence;
                                FlowSequence flowSequence2 = flowSequence = new FlowSequence(this.mapContext, false);
                                flowMapping = flowMapping2;
                                boolean bl = false;
                                ((FlowSequence)it).continuation(line);
                                flowMapping2 = flowMapping;
                                child = flowSequence;
                            } else if (line.match('{')) {
                                FlowMapping flowMapping3 = new FlowMapping(this.mapContext, false);
                                it = flowMapping3;
                                flowMapping = flowMapping2;
                                boolean bl = false;
                                ((FlowMapping)it).continuation(line);
                                flowMapping2 = flowMapping;
                                child = flowMapping3;
                            } else if (line.match('*')) {
                                it = Companion.getAnchorName(line);
                                flowMapping = flowMapping2;
                                boolean bl = false;
                                JSONValue jSONValue = this.mapContext.getAnchorMap().get(it);
                                if (jSONValue == null) {
                                    Companion.fatal("Can't locate alias \"" + (String)it + '\"', line);
                                    throw new KotlinNothingValueException();
                                }
                                flowMapping2 = flowMapping;
                                child = new AliasChild(jSONValue);
                            } else {
                                child = io.kjson.yaml.parser.Parser$Companion.processFlowNode$default(Companion, line, null, this.mapContext, 1, null);
                            }
                            flowMapping2.child = child;
                            break;
                        }
                        case 2: {
                            this.child = this.child.continuation(line);
                        }
                    }
                    line.skipSpaces();
                    if (line.atEnd()) {
                        this.state = this.child.getTerminated() ? State.COMMA : State.CONTINUATION;
                        break;
                    }
                }
                if (line.match('}')) {
                    Unit unit;
                    Unit unit2;
                    String string = this.key;
                    if (string == null) {
                        unit2 = null;
                    } else {
                        it = string;
                        boolean bl = false;
                        this.addProperty((String)it, this.child.getYAMLNode());
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit == null) {
                        FlowMapping $this$processLine_u24lambda_u2d4 = this;
                        boolean bl = false;
                        if ($this$processLine_u24lambda_u2d4.child.getYAMLNode() != null) {
                            Companion.fatal("Unexpected end of flow mapping", line);
                            throw new KotlinNothingValueException();
                        }
                    }
                    this.setTerminated(true);
                    this.state = State.CLOSED;
                    break;
                }
                if (line.matchColon() || this.child instanceof DoubleQuotedScalar && line.match(':')) {
                    String it2 = String.valueOf(this.child.getYAMLNode());
                    boolean bl = false;
                    this.key = it2;
                    this.mapContext = this.context.child(it2);
                    this.state = State.ITEM;
                    continue;
                }
                if (line.match(',')) {
                    Unit unit;
                    if (this.key == null) {
                        unit = null;
                    } else {
                        boolean bl = false;
                        this.addProperty((String)it, this.child.getYAMLNode());
                        unit = Unit.INSTANCE;
                    }
                    if (unit == null) {
                        Companion.fatal("Key missing in flow mapping", line);
                        throw new KotlinNothingValueException();
                    }
                    this.key = null;
                    this.mapContext = this.context.child("");
                    this.state = State.ITEM;
                    continue;
                }
                Companion.fatal("Unexpected character in flow mapping", line);
                throw new KotlinNothingValueException();
            }
        }

        private final void addProperty(String key, JSONValue value) {
            this.properties.add(key, value);
            this.mapContext.saveNodeProperties(value);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/kjson/yaml/parser/Parser$FlowMapping$State;", "", "(Ljava/lang/String;I)V", "ITEM", "CONTINUATION", "COMMA", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State ITEM = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State COMMA = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.ITEM, State.CONTINUATION, State.COMMA, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.ITEM.ordinal()] = 1;
                nArray[State.CONTINUATION.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$FlowScalar;", "Lio/kjson/yaml/parser/Parser$Child;", "text", "", "terminated", "", "(Ljava/lang/String;Z)V", "getText", "()Ljava/lang/String;", "getYAMLNode", "Lio/kjson/JSONValue;", "kjson-yaml"})
    public static abstract class FlowScalar
    extends Child {
        @NotNull
        private final String text;

        public FlowScalar(@NotNull String text, boolean terminated) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(terminated);
            this.text = text;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @Nullable
        public JSONValue getYAMLNode() {
            return (JSONValue)new JSONString(this.getText());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\b*\u00020\u0003H\u0002J\f\u0010\u0017\u001a\u00020\b*\u00020\u0003H\u0002R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lio/kjson/yaml/parser/Parser$PlainScalar;", "Lio/kjson/yaml/parser/Parser$FlowScalar;", "text", "", "context", "Lio/kjson/yaml/parser/Parser$Context;", "(Ljava/lang/String;Lio/kjson/yaml/parser/Parser$Context;)V", "complete", "", "getComplete", "()Z", "getContext", "()Lio/kjson/yaml/parser/Parser$Context;", "continuation", "Lio/kjson/yaml/parser/Parser$Child;", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONValue;", "intOrLong", "value", "", "matchesDecimal", "matchesInteger", "kjson-yaml"})
    public static class PlainScalar
    extends FlowScalar {
        @NotNull
        private final Context context;

        public PlainScalar(@NotNull String text, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(text, false);
            this.context = context;
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @Override
        public boolean getComplete() {
            return true;
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return Companion.processPlainScalar(line, Intrinsics.stringPlus((String)this.getText(), (Object)" "), this.context);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public JSONValue getYAMLNode() {
            block27: {
                block26: {
                    v0 = this.context.getTag();
                    if (v0 != null) {
                        it = v0;
                        $i$a$-let-Parser$PlainScalar$getYAMLNode$1 = false;
                        if (Intrinsics.areEqual((Object)it, (Object)"tag:yaml.org,2002:str")) {
                            return (JSONValue)new JSONString(this.getText());
                        }
                        if (Intrinsics.areEqual(it, (Object)"tag:yaml.org,2002:float") && this.matchesInteger(this.getText())) {
                            return (JSONValue)new JSONDecimal(this.getText());
                        }
                        if (Intrinsics.areEqual(it, (Object)"tag:yaml.org,2002:int") && !this.matchesInteger(this.getText()) && this.matchesDecimal(this.getText()) && new JSONDecimal(this.getText()).isIntegral()) {
                            return this.intOrLong(new BigDecimal(this.getText()).longValue());
                        }
                    }
                    v1 = this.context.getVersion();
                    if (v1 != null) {
                        it = v1;
                        $i$a$-let-Parser$PlainScalar$getYAMLNode$2 = false;
                        if (((Number)it.getSecond()).intValue() < 2) {
                            if (Intrinsics.areEqual((Object)this.getText(), (Object)"yes") || Intrinsics.areEqual((Object)this.getText(), (Object)"Yes") || Intrinsics.areEqual((Object)this.getText(), (Object)"YES") || Intrinsics.areEqual((Object)this.getText(), (Object)"on") || Intrinsics.areEqual((Object)this.getText(), (Object)"On") || Intrinsics.areEqual((Object)this.getText(), (Object)"ON")) {
                                return (JSONValue)JSONBoolean.TRUE;
                            }
                            if (Intrinsics.areEqual((Object)this.getText(), (Object)"no") || Intrinsics.areEqual((Object)this.getText(), (Object)"No") || Intrinsics.areEqual((Object)this.getText(), (Object)"NO") || Intrinsics.areEqual((Object)this.getText(), (Object)"off") || Intrinsics.areEqual((Object)this.getText(), (Object)"Off") || Intrinsics.areEqual((Object)this.getText(), (Object)"OFF")) {
                                return (JSONValue)JSONBoolean.FALSE;
                            }
                            if (this.getText().length() > 1 && StringsKt.startsWith$default((CharSequence)this.getText(), (char)'0', (boolean)false, (int)2, null)) {
                                block24: {
                                    $this$all$iv = StringsKt.drop((String)this.getText(), (int)1);
                                    $i$f$all = false;
                                    var7_7 = $this$all$iv;
                                    var8_10 = 0;
                                    while (var8_10 < var7_7.length()) {
                                        element$iv = var7_7.charAt(var8_10);
                                        ++var8_10;
                                        d = element$iv;
                                        $i$a$-all-Parser$PlainScalar$getYAMLNode$2$1 = false;
                                        if ('0' <= d ? d < '8' : false) continue;
                                        v2 = false;
                                        break block24;
                                    }
                                    v2 = true;
                                }
                                if (v2) {
                                    return this.intOrLong(Long.parseLong(this.getText(), CharsKt.checkRadix((int)8)));
                                }
                            }
                        }
                    }
                    if (((CharSequence)this.getText()).length() == 0 || Intrinsics.areEqual((Object)this.getText(), (Object)"null") || Intrinsics.areEqual((Object)this.getText(), (Object)"Null") || Intrinsics.areEqual((Object)this.getText(), (Object)"NULL") || Intrinsics.areEqual((Object)this.getText(), (Object)"~")) {
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)this.getText(), (Object)"true") || Intrinsics.areEqual((Object)this.getText(), (Object)"True") || Intrinsics.areEqual((Object)this.getText(), (Object)"TRUE")) {
                        return (JSONValue)JSONBoolean.TRUE;
                    }
                    if (Intrinsics.areEqual((Object)this.getText(), (Object)"false") || Intrinsics.areEqual((Object)this.getText(), (Object)"False") || Intrinsics.areEqual((Object)this.getText(), (Object)"FALSE")) {
                        return (JSONValue)JSONBoolean.FALSE;
                    }
                    if (this.getText().length() <= 2) break block27;
                    if (StringsKt.startsWith$default((String)this.getText(), (String)"0o", (boolean)false, (int)2, null)) {
                        block25: {
                            $this$all$iv = StringsKt.drop((String)this.getText(), (int)2);
                            $i$f$all = false;
                            var3_1 = $this$all$iv;
                            var4_2 = 0;
                            while (var4_2 < var3_1.length()) {
                                element$iv = var3_1.charAt(var4_2);
                                ++var4_2;
                                it = element$iv;
                                $i$a$-all-Parser$PlainScalar$getYAMLNode$3 = false;
                                if ('0' <= it ? it < '8' : false) continue;
                                v3 = false;
                                break block25;
                            }
                            v3 = true;
                        }
                        if (v3) {
                            return this.intOrLong(Long.parseLong(StringsKt.drop((String)this.getText(), (int)2), CharsKt.checkRadix((int)8)));
                        }
                    }
                    if (!StringsKt.startsWith$default((String)this.getText(), (String)"0x", (boolean)false, (int)2, null)) break block27;
                    $this$all$iv = StringsKt.drop((String)this.getText(), (int)2);
                    $i$f$all = false;
                    var3_1 = $this$all$iv;
                    var4_2 = 0;
                    while (var4_2 < var3_1.length()) {
                        element$iv = var3_1.charAt(var4_2);
                        ++var4_2;
                        it = element$iv;
                        $i$a$-all-Parser$PlainScalar$getYAMLNode$4 = false;
                        if ('0' <= it ? it < ':' : false) ** GOTO lbl-1000
                        if ('A' <= it ? it < 'G' : false) ** GOTO lbl-1000
                        v4 = 'a' <= it ? it < 'g' : false;
                        if (v4) lbl-1000:
                        // 3 sources

                        {
                            v5 = true;
                        } else {
                            v5 = false;
                        }
                        if (v5) continue;
                        v6 = false;
                        break block26;
                    }
                    v6 = true;
                }
                if (v6) {
                    return this.intOrLong(Long.parseLong(StringsKt.drop((String)this.getText(), (int)2), CharsKt.checkRadix((int)16)));
                }
            }
            if (this.matchesInteger(this.getText())) {
                return this.intOrLong(Long.parseLong(this.getText()));
            }
            if (this.matchesDecimal(this.getText())) {
                return (JSONValue)new JSONDecimal(this.getText());
            }
            if (this.context.getTag() == null && Parser.Companion.getFloatNamedConstants().contains(this.getText())) {
                this.context.setTag("tag:yaml.org,2002:float");
            }
            return (JSONValue)new JSONString(this.getText());
        }

        private final JSONValue intOrLong(long value) {
            return (Integer.MIN_VALUE <= value ? value <= Integer.MAX_VALUE : false) ? (JSONValue)new JSONInt((int)value) : (JSONValue)new JSONLong(value);
        }

        private final boolean matchesInteger(String $this$matchesInteger) {
            TextMatcher it = new TextMatcher($this$matchesInteger);
            boolean bl = false;
            if (!it.match('+')) {
                it.match('-');
            }
            return it.matchDec() && it.isAtEnd();
        }

        private final boolean matchesDecimal(String $this$matchesDecimal) {
            TextMatcher pt = new TextMatcher($this$matchesDecimal);
            if (!pt.match('+')) {
                pt.match('-');
            }
            if (pt.match('.')) {
                if (!pt.matchDec()) {
                    return false;
                }
            } else {
                if (!pt.matchDec()) {
                    return false;
                }
                if (pt.match('.')) {
                    pt.matchDec();
                }
            }
            if (pt.match('e') || pt.match('E')) {
                if (!pt.match('+')) {
                    pt.match('-');
                }
                if (!pt.matchDec()) {
                    return false;
                }
            }
            return pt.isAtEnd();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$FlowNode;", "Lio/kjson/yaml/parser/Parser$PlainScalar;", "text", "", "context", "Lio/kjson/yaml/parser/Parser$Context;", "(Ljava/lang/String;Lio/kjson/yaml/parser/Parser$Context;)V", "continuation", "Lio/kjson/yaml/parser/Parser$Child;", "line", "Lio/kjson/yaml/parser/Line;", "kjson-yaml"})
    public static final class FlowNode
    extends PlainScalar {
        public FlowNode(@NotNull String text, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(text, context);
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return Companion.processFlowNode(line, Intrinsics.stringPlus((String)this.getText(), (Object)" "), this.getContext());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$DoubleQuotedScalar;", "Lio/kjson/yaml/parser/Parser$FlowScalar;", "text", "", "terminated", "", "escapedNewline", "(Ljava/lang/String;ZZ)V", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "kjson-yaml"})
    public static final class DoubleQuotedScalar
    extends FlowScalar {
        private final boolean escapedNewline;

        public DoubleQuotedScalar(@NotNull String text, boolean terminated, boolean escapedNewline) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, terminated);
            this.escapedNewline = escapedNewline;
        }

        public /* synthetic */ DoubleQuotedScalar(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(string, bl, bl2);
        }

        @Override
        @NotNull
        public DoubleQuotedScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return Companion.processDoubleQuotedScalar(line, this.escapedNewline || StringsKt.endsWith$default((CharSequence)this.getText(), (char)' ', (boolean)false, (int)2, null) ? this.getText() : Intrinsics.stringPlus((String)this.getText(), (Object)" "));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/kjson/yaml/parser/Parser$SingleQuotedScalar;", "Lio/kjson/yaml/parser/Parser$FlowScalar;", "text", "", "terminated", "", "(Ljava/lang/String;Z)V", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "kjson-yaml"})
    public static final class SingleQuotedScalar
    extends FlowScalar {
        public SingleQuotedScalar(@NotNull String text, boolean terminated) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, terminated);
        }

        @Override
        @NotNull
        public SingleQuotedScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return Companion.processSingleQuotedScalar(line, StringsKt.endsWith$default((CharSequence)this.getText(), (char)' ', (boolean)false, (int)2, null) ? this.getText() : Intrinsics.stringPlus((String)this.getText(), (Object)" "));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u0013*\u00060\u000ej\u0002`\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/kjson/yaml/parser/Parser$BlockScalar;", "Lio/kjson/yaml/parser/Parser$Child;", "indent", "", "chomping", "Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "(ILio/kjson/yaml/parser/Parser$BlockScalar$Chomping;)V", "complete", "", "getComplete", "()Z", "state", "Lio/kjson/yaml/parser/Parser$BlockScalar$State;", "text", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getText", "()Ljava/lang/StringBuilder;", "appendText", "", "string", "", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONString;", "strip", "Chomping", "State", "kjson-yaml"})
    public static abstract class BlockScalar
    extends Child {
        private int indent;
        @NotNull
        private final Chomping chomping;
        @NotNull
        private State state;
        @NotNull
        private final StringBuilder text;

        public BlockScalar(int indent, @NotNull Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(false);
            this.indent = indent;
            this.chomping = chomping;
            this.state = State.INITIAL;
            this.text = new StringBuilder();
        }

        @Override
        @NotNull
        public StringBuilder getText() {
            return this.text;
        }

        @Override
        public boolean getComplete() {
            return true;
        }

        public abstract void appendText(@NotNull String var1);

        @Override
        @NotNull
        public BlockScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    if (line.getIndex() > this.indent) {
                        this.indent = line.getIndex();
                    }
                    if (line.isAtEnd()) break;
                    this.state = State.CONTINUATION;
                    line.skipToEnd();
                    String string = line.getResult();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.result");
                    this.appendText(string);
                    break;
                }
                case 2: {
                    if (line.isAtEnd()) {
                        if (line.getIndex() > this.indent) {
                            line.setStart(this.indent);
                            String string = line.getResult();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.result");
                            this.appendText(string);
                            break;
                        }
                        this.appendText("");
                        break;
                    }
                    if (line.getIndex() < this.indent) {
                        if (line.isComment()) break;
                        Companion.fatal("Bad indentation in block scalar", line);
                        throw new KotlinNothingValueException();
                    }
                    if (line.getIndex() > this.indent) {
                        line.setIndex(this.indent);
                    }
                    line.skipToEnd();
                    String string = line.getResult();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.result");
                    this.appendText(string);
                }
            }
            return this;
        }

        @NotNull
        public JSONString getYAMLNode() {
            StringBuilder sb = new StringBuilder(this.getText());
            switch (WhenMappings.$EnumSwitchMapping$1[this.chomping.ordinal()]) {
                case 1: {
                    this.strip(sb);
                    break;
                }
                case 2: {
                    this.strip(sb);
                    sb.append("\n");
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new JSONString(string);
        }

        private final void strip(StringBuilder $this$strip) {
            while (StringsKt.endsWith$default((CharSequence)$this$strip, (char)'\n', (boolean)false, (int)2, null)) {
                $this$strip.setLength($this$strip.length() - 1);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "", "(Ljava/lang/String;I)V", "STRIP", "KEEP", "CLIP", "kjson-yaml"})
        public static final class Chomping
        extends Enum<Chomping> {
            public static final /* enum */ Chomping STRIP = new Chomping();
            public static final /* enum */ Chomping KEEP = new Chomping();
            public static final /* enum */ Chomping CLIP = new Chomping();
            private static final /* synthetic */ Chomping[] $VALUES;

            public static Chomping[] values() {
                return (Chomping[])$VALUES.clone();
            }

            public static Chomping valueOf(String value) {
                return Enum.valueOf(Chomping.class, value);
            }

            static {
                $VALUES = chompingArray = new Chomping[]{Chomping.STRIP, Chomping.KEEP, Chomping.CLIP};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/kjson/yaml/parser/Parser$BlockScalar$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CONTINUATION", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CONTINUATION = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CONTINUATION};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.INITIAL.ordinal()] = 1;
                nArray[State.CONTINUATION.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Chomping.values().length];
                nArray[Chomping.STRIP.ordinal()] = 1;
                nArray[Chomping.CLIP.ordinal()] = 2;
                nArray[Chomping.KEEP.ordinal()] = 3;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$LiteralBlockScalar;", "Lio/kjson/yaml/parser/Parser$BlockScalar;", "indent", "", "chomping", "Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "(ILio/kjson/yaml/parser/Parser$BlockScalar$Chomping;)V", "appendText", "", "string", "", "kjson-yaml"})
    public static final class LiteralBlockScalar
    extends BlockScalar {
        public LiteralBlockScalar(int indent, @NotNull BlockScalar.Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(indent, chomping);
        }

        @Override
        public void appendText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.getText().append(string);
            this.getText().append('\n');
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$FoldedBlockScalar;", "Lio/kjson/yaml/parser/Parser$BlockScalar;", "indent", "", "chomping", "Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "(ILio/kjson/yaml/parser/Parser$BlockScalar$Chomping;)V", "appendText", "", "string", "", "kjson-yaml"})
    public static final class FoldedBlockScalar
    extends BlockScalar {
        public FoldedBlockScalar(int indent, @NotNull BlockScalar.Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(indent, chomping);
        }

        @Override
        public void appendText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (!(((CharSequence)string).length() == 0) && !StringsKt.startsWith$default((CharSequence)string, (char)' ', (boolean)false, (int)2, null) && !StringsKt.startsWith$default((CharSequence)string, (char)'\b', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)this.getText(), (char)'\n', (boolean)false, (int)2, null)) {
                this.getText().setLength(this.getText().length() - 1);
                if (StringsKt.endsWith$default((CharSequence)this.getText(), (char)'\n', (boolean)false, (int)2, null)) {
                    this.getText().append('\n');
                } else {
                    while (StringsKt.endsWith$default((CharSequence)this.getText(), (char)' ', (boolean)false, (int)2, null)) {
                        this.getText().setLength(this.getText().length() - 1);
                    }
                    this.getText().append(' ');
                }
            }
            this.getText().append(string);
            this.getText().append('\n');
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0014\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0010H\u0002J\n\u0010\u0017\u001a\u00020\u0005*\u00020\u0010J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0019*\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u0012*\u00020\u00102\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0002J\u0014\u0010!\u001a\u00020\"*\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u0005J\u001c\u0010$\u001a\u00020%*\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'J\u0012\u0010(\u001a\u00020\u0012*\u00020\u00102\u0006\u0010&\u001a\u00020'J\u001c\u0010)\u001a\u00020**\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'J\u0014\u0010+\u001a\u00020,*\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006-"}, d2={"Lio/kjson/yaml/parser/Parser$Companion;", "", "()V", "floatNamedConstants", "", "", "getFloatNamedConstants", "()Ljava/util/Set;", "log", "Lnet/pwall/log/Logger;", "getLog", "()Lnet/pwall/log/Logger;", "fatal", "", "text", "line", "Lio/kjson/yaml/parser/Line;", "warn", "", "message", "decodePercentEncoding", "determineChomping", "Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "getAnchorName", "isTagHandleChar", "", "", "matchURI", "Lnet/pwall/text/TextMatcher;", "processBackslash", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "processDoubleQuotedScalar", "Lio/kjson/yaml/parser/Parser$DoubleQuotedScalar;", "initial", "processFlowNode", "Lio/kjson/yaml/parser/Parser$FlowNode;", "context", "Lio/kjson/yaml/parser/Parser$Context;", "processNodeProperties", "processPlainScalar", "Lio/kjson/yaml/parser/Parser$PlainScalar;", "processSingleQuotedScalar", "Lio/kjson/yaml/parser/Parser$SingleQuotedScalar;", "kjson-yaml"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final Set<String> getFloatNamedConstants() {
            return floatNamedConstants;
        }

        private final void warn(String message) {
            this.getLog().warn(() -> Companion.warn$lambda-0(message));
        }

        private final Void fatal(String text, Line line) {
            YAMLParseException exception = new YAMLParseException(text, line);
            this.getLog().error(() -> Companion.fatal$lambda-1(exception));
            throw exception;
        }

        @NotNull
        public final PlainScalar processPlainScalar(@NotNull Line $this$processPlainScalar, @NotNull String initial, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processPlainScalar), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            StringBuilder sb = new StringBuilder(initial);
            while (!$this$processPlainScalar.isAtEnd()) {
                if ($this$processPlainScalar.matchColon()) {
                    $this$processPlainScalar.revert();
                    $this$processPlainScalar.skipBackSpaces();
                    break;
                }
                if ($this$processPlainScalar.isComment()) {
                    $this$processPlainScalar.skipBackSpaces();
                    break;
                }
                sb.append($this$processPlainScalar.nextChar());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new PlainScalar(((Object)StringsKt.trim((CharSequence)string)).toString(), context);
        }

        public static /* synthetic */ PlainScalar processPlainScalar$default(Companion companion, Line line, String string, Context context, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.processPlainScalar(line, string, context);
        }

        @NotNull
        public final FlowNode processFlowNode(@NotNull Line $this$processFlowNode, @NotNull String initial, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processFlowNode), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            StringBuilder sb = new StringBuilder(initial);
            while (!$this$processFlowNode.isAtEnd()) {
                if ($this$processFlowNode.matchAny("[]{},")) {
                    $this$processFlowNode.revert();
                    Object object = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
                    Object it = object = new FlowNode(((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString(), context);
                    boolean bl = false;
                    ((Child)it).setTerminated(true);
                    return object;
                }
                if ($this$processFlowNode.matchColon()) {
                    $this$processFlowNode.revert();
                    $this$processFlowNode.skipBackSpaces();
                    break;
                }
                if ($this$processFlowNode.isComment()) {
                    $this$processFlowNode.skipBackSpaces();
                    break;
                }
                sb.append($this$processFlowNode.nextChar());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new FlowNode(((Object)StringsKt.trim((CharSequence)string)).toString(), context);
        }

        public static /* synthetic */ FlowNode processFlowNode$default(Companion companion, Line line, String string, Context context, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.processFlowNode(line, string, context);
        }

        @NotNull
        public final SingleQuotedScalar processSingleQuotedScalar(@NotNull Line $this$processSingleQuotedScalar, @NotNull String initial) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processSingleQuotedScalar), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            StringBuilder sb = new StringBuilder(initial);
            while (!$this$processSingleQuotedScalar.isAtEnd()) {
                if ($this$processSingleQuotedScalar.match('\'')) {
                    if ($this$processSingleQuotedScalar.match('\'')) {
                        sb.append('\'');
                        continue;
                    }
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                    return new SingleQuotedScalar(string, true);
                }
                sb.append($this$processSingleQuotedScalar.nextChar());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new SingleQuotedScalar(string, false);
        }

        public static /* synthetic */ SingleQuotedScalar processSingleQuotedScalar$default(Companion companion, Line line, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.processSingleQuotedScalar(line, string);
        }

        @NotNull
        public final DoubleQuotedScalar processDoubleQuotedScalar(@NotNull Line $this$processDoubleQuotedScalar, @NotNull String initial) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processDoubleQuotedScalar), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            StringBuilder sb = new StringBuilder(initial);
            while (!$this$processDoubleQuotedScalar.isAtEnd()) {
                if ($this$processDoubleQuotedScalar.match('\"')) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                    return new DoubleQuotedScalar(string, true, false, 4, null);
                }
                if ($this$processDoubleQuotedScalar.match('\\')) {
                    if ($this$processDoubleQuotedScalar.isAtEnd()) {
                        String string = sb.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                        return new DoubleQuotedScalar(string, false, true);
                    }
                    this.processBackslash($this$processDoubleQuotedScalar, sb);
                    continue;
                }
                sb.append($this$processDoubleQuotedScalar.nextChar());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new DoubleQuotedScalar(string, false, false, 4, null);
        }

        public static /* synthetic */ DoubleQuotedScalar processDoubleQuotedScalar$default(Companion companion, Line line, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.processDoubleQuotedScalar(line, string);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void processBackslash(Line $this$processBackslash, StringBuilder sb) {
            if ($this$processBackslash.match('0')) {
                sb.append('\u0000');
                return;
            }
            if ($this$processBackslash.match('a')) {
                sb.append('\u0007');
                return;
            }
            if ($this$processBackslash.match('b')) {
                sb.append('\b');
                return;
            }
            if ($this$processBackslash.match('t')) {
                sb.append('\t');
                return;
            }
            if ($this$processBackslash.match('\t')) {
                sb.append('\t');
                return;
            }
            if ($this$processBackslash.match('n')) {
                sb.append('\n');
                return;
            }
            if ($this$processBackslash.match('v')) {
                sb.append('\u000b');
                return;
            }
            if ($this$processBackslash.match('f')) {
                sb.append('\f');
                return;
            }
            if ($this$processBackslash.match('r')) {
                sb.append('\r');
                return;
            }
            if ($this$processBackslash.match('e')) {
                sb.append('\u001b');
                return;
            }
            if ($this$processBackslash.match(' ')) {
                sb.append(' ');
                return;
            }
            if ($this$processBackslash.match('\"')) {
                sb.append('\"');
                return;
            }
            if ($this$processBackslash.match('/')) {
                sb.append('/');
                return;
            }
            if ($this$processBackslash.match('\\')) {
                sb.append('\\');
                return;
            }
            if ($this$processBackslash.match('N')) {
                sb.append('\u0085');
                return;
            }
            if ($this$processBackslash.match('_')) {
                sb.append('\u00a0');
                return;
            }
            if ($this$processBackslash.match('L')) {
                sb.append('\u2028');
                return;
            }
            if ($this$processBackslash.match('P')) {
                sb.append('\u2029');
                return;
            }
            if ($this$processBackslash.match('x')) {
                if (!$this$processBackslash.matchHex(2, 2)) {
                    this.fatal("Illegal hex value in double quoted scalar", $this$processBackslash);
                    throw new KotlinNothingValueException();
                }
                sb.append((char)$this$processBackslash.getResultHexInt());
                return;
            }
            if ($this$processBackslash.match('u')) {
                if (!$this$processBackslash.matchHex(4, 4)) {
                    this.fatal("Illegal unicode value in double quoted scalar", $this$processBackslash);
                    throw new KotlinNothingValueException();
                }
                sb.append((char)$this$processBackslash.getResultHexInt());
                return;
            }
            if (!$this$processBackslash.match('U')) {
                this.fatal("Illegal escape sequence in double quoted scalar", $this$processBackslash);
                throw new KotlinNothingValueException();
            }
            if (!$this$processBackslash.matchHex(8, 8)) {
                this.fatal("Illegal unicode value in double quoted scalar", $this$processBackslash);
                throw new KotlinNothingValueException();
            }
            int codePoint = $this$processBackslash.getResultHexInt();
            if (Character.isSupplementaryCodePoint(codePoint)) {
                sb.append(Character.highSurrogate(codePoint));
                sb.append(Character.lowSurrogate(codePoint));
                return;
            }
            if (Character.isBmpCodePoint(codePoint)) {
                sb.append((char)codePoint);
                return;
            }
            this.fatal("Illegal 32-bit unicode value in double quoted scalar", $this$processBackslash);
            throw new KotlinNothingValueException();
        }

        public final void processNodeProperties(@NotNull Line $this$processNodeProperties, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processNodeProperties), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            while (true) {
                if ($this$processNodeProperties.match('&')) {
                    if (context.getAnchor() != null) {
                        this.fatal("Duplicate anchor", $this$processNodeProperties);
                        throw new KotlinNothingValueException();
                    }
                    context.setAnchor(this.getAnchorName($this$processNodeProperties));
                    continue;
                }
                if (!$this$processNodeProperties.match('!')) break;
                if (context.getTag() != null) {
                    this.fatal("Duplicate tag", $this$processNodeProperties);
                    throw new KotlinNothingValueException();
                }
                if ($this$processNodeProperties.match('<')) {
                    int startTag = $this$processNodeProperties.getIndex();
                    $this$processNodeProperties.match('!');
                    if (!this.matchURI($this$processNodeProperties)) {
                        this.fatal("Illegal verbatim local tag", $this$processNodeProperties);
                        throw new KotlinNothingValueException();
                    }
                    int endTag = $this$processNodeProperties.getIndex();
                    if (!$this$processNodeProperties.match('>')) {
                        this.fatal("Illegal verbatim local tag", $this$processNodeProperties);
                        throw new KotlinNothingValueException();
                    }
                    context.setTag($this$processNodeProperties.getString(startTag, endTag));
                } else {
                    String prefix;
                    String handle;
                    String string;
                    if ($this$processNodeProperties.match('!')) {
                        string = "!!";
                    } else if ($this$processNodeProperties.matchSeq(Companion::processNodeProperties$lambda-3) && $this$processNodeProperties.matchContinue(1, 1, Companion::processNodeProperties$lambda-4)) {
                        String endTag = $this$processNodeProperties.getString($this$processNodeProperties.getStart() - 1, $this$processNodeProperties.getIndex());
                        Intrinsics.checkNotNullExpressionValue((Object)endTag, (String)"{\n                      \u2026                        }");
                        string = endTag;
                    } else {
                        string = handle = "!";
                    }
                    if (context.getTagHandle(handle) == null) {
                        this.fatal("Tag handle " + handle + " not declared", $this$processNodeProperties);
                        throw new KotlinNothingValueException();
                    }
                    $this$processNodeProperties.skip(Companion::processNodeProperties$lambda-5);
                    String suffix = $this$processNodeProperties.getResult();
                    Intrinsics.checkNotNullExpressionValue((Object)suffix, (String)"suffix");
                    context.setTag(Intrinsics.stringPlus((String)prefix, (Object)this.decodePercentEncoding(suffix, $this$processNodeProperties)));
                }
                $this$processNodeProperties.skipSpaces();
            }
        }

        private final String decodePercentEncoding(String $this$decodePercentEncoding, Line line) {
            return StringMapper.INSTANCE.mapSubstrings($this$decodePercentEncoding, (Function1)new Function1<Integer, MapResult>($this$decodePercentEncoding, line){
                final /* synthetic */ String $this_decodePercentEncoding;
                final /* synthetic */ Line $line;
                {
                    this.$this_decodePercentEncoding = $receiver;
                    this.$line = $line;
                    super(1);
                }

                @Nullable
                public final MapResult invoke(int it) {
                    return this.$this_decodePercentEncoding.charAt(it) == '%' ? StringMapper.INSTANCE.buildResult(this.$this_decodePercentEncoding, it, 3, "Incomplete percent sequence", (Function0)new Function0<Integer>(this.$this_decodePercentEncoding, it, this.$line){
                        final /* synthetic */ String $this_decodePercentEncoding;
                        final /* synthetic */ int $it;
                        final /* synthetic */ Line $line;
                        {
                            this.$this_decodePercentEncoding = $receiver;
                            this.$it = $it;
                            this.$line = $line;
                            super(0);
                        }

                        @NotNull
                        public final Integer invoke() {
                            int n;
                            try {
                                n = StringMapper.INSTANCE.fromHexDigit(this.$this_decodePercentEncoding.charAt(this.$it + 1)) << 4 | StringMapper.INSTANCE.fromHexDigit(this.$this_decodePercentEncoding.charAt(this.$it + 2));
                            }
                            catch (NumberFormatException _) {
                                io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Illegal percent sequence", this.$line);
                                throw new KotlinNothingValueException();
                            }
                            return n;
                        }
                    }) : null;
                }
            });
        }

        @NotNull
        public final String getAnchorName(@NotNull Line $this$getAnchorName) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)$this$getAnchorName), (String)"<this>");
            if (!$this$getAnchorName.matchSeq(Companion::getAnchorName$lambda-6)) {
                this.fatal("Anchor name missing", $this$getAnchorName);
                throw new KotlinNothingValueException();
            }
            String it = string = $this$getAnchorName.getResult();
            boolean bl = false;
            $this$getAnchorName.skipSpaces();
            String string2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.also { skipSpaces() }");
            return string2;
        }

        private final BlockScalar.Chomping determineChomping(Line $this$determineChomping) {
            return $this$determineChomping.match('-') ? BlockScalar.Chomping.STRIP : ($this$determineChomping.match('+') ? BlockScalar.Chomping.KEEP : BlockScalar.Chomping.CLIP);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isTagHandleChar(char $this$isTagHandleChar) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            if ('A' <= $this$isTagHandleChar) {
                if ($this$isTagHandleChar < '[') {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) return true;
            if ('a' <= $this$isTagHandleChar) {
                if ($this$isTagHandleChar < '{') {
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) return true;
            if ('0' <= $this$isTagHandleChar) {
                if ($this$isTagHandleChar < ':') {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            if ($this$isTagHandleChar != '-') return false;
            return true;
        }

        private final boolean matchURI(TextMatcher $this$matchURI) {
            int uriStart;
            block3: {
                uriStart = $this$matchURI.getIndex();
                while (true) {
                    if ($this$matchURI.matchSeq(Companion::matchURI$lambda-8)) {
                        continue;
                    }
                    if (!$this$matchURI.match('%') || !$this$matchURI.matchContinue(TextMatcher::isHexDigit)) break block3;
                    if (!$this$matchURI.matchHex(2, 2)) break;
                }
                int n = $this$matchURI.getIndex();
                $this$matchURI.setIndex(n + -1);
            }
            if ($this$matchURI.getIndex() > uriStart) {
                $this$matchURI.setStart(uriStart);
                return true;
            }
            return false;
        }

        private static final Object warn$lambda-0(String $message) {
            Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
            return Intrinsics.stringPlus((String)"YAML Warning: ", (Object)$message);
        }

        private static final Object fatal$lambda-1(YAMLParseException $exception) {
            Intrinsics.checkNotNullParameter((Object)((Object)$exception), (String)"$exception");
            return $exception.getMessage();
        }

        private static final boolean processNodeProperties$lambda-3(char it) {
            return Companion.isTagHandleChar(it);
        }

        private static final boolean processNodeProperties$lambda-4(char it) {
            return it == '!';
        }

        private static final boolean processNodeProperties$lambda-5(char it) {
            return !StringsKt.contains$default((CharSequence)" \t[]{},!", (char)it, (boolean)false, (int)2, null);
        }

        private static final boolean getAnchorName$lambda-6(char it) {
            return !StringsKt.contains$default((CharSequence)" \t[]{},", (char)it, (boolean)false, (int)2, null);
        }

        private static final boolean matchURI$lambda-8(char it) {
            return Companion.isTagHandleChar(it) || StringsKt.contains$default((CharSequence)"#;/?:@&=+$,_.~*'()[]", (char)it, (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

