/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.yaml.parser;

import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.pointer.JSONPointer;
import io.kjson.yaml.YAMLDocument;
import io.kjson.yaml.parser.Line;
import io.kjson.yaml.parser.Parser;
import io.kjson.yaml.parser.YAMLParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.pwall.log.Logger;
import net.pwall.log.LoggerDelegate;
import net.pwall.pipeline.codec.DynamicReader;
import net.pwall.text.TextMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u00162\u00020\u0001:\u0013\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006%"}, d2={"Lio/kjson/yaml/parser/Parser;", "", "()V", "parse", "Lio/kjson/yaml/YAMLDocument;", "file", "Ljava/io/File;", "charset", "Ljava/nio/charset/Charset;", "inputStream", "Ljava/io/InputStream;", "reader", "Ljava/io/Reader;", "processYAMLDirective", "Lkotlin/Pair;", "", "line", "Lio/kjson/yaml/parser/Line;", "Block", "BlockScalar", "Child", "ChildBlock", "Companion", "DoubleQuotedScalar", "ErrorBlock", "FlowMapping", "FlowNode", "FlowScalar", "FlowSequence", "FoldedBlockScalar", "InitialBlock", "LiteralBlockScalar", "MappingBlock", "PlainScalar", "SequenceBlock", "SingleQuotedScalar", "State", "kjson-yaml"})
public final class Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LoggerDelegate<Companion> log$delegate = new LoggerDelegate(null, 1, null);

    @NotNull
    public final YAMLDocument parse(@NotNull File file, @Nullable Charset charset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.parse(new FileInputStream(file), charset);
    }

    public static /* synthetic */ YAMLDocument parse$default(Parser parser, File file, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = null;
        }
        return parser.parse(file, charset);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final YAMLDocument parse(@NotNull InputStream inputStream, @Nullable Charset charset) {
        DynamicReader dynamicReader;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        DynamicReader dynamicReader2 = dynamicReader = new DynamicReader(inputStream);
        Parser parser = this;
        boolean bl = false;
        Charset charset2 = charset;
        if (charset2 != null) {
            void $this$parse_u24lambda_u2d1;
            Charset it = charset2;
            boolean bl2 = false;
            $this$parse_u24lambda_u2d1.switchTo(it);
        }
        return parser.parse((Reader)dynamicReader);
    }

    public static /* synthetic */ YAMLDocument parse$default(Parser parser, InputStream inputStream, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = null;
        }
        return parser.parse(inputStream, charset);
    }

    @NotNull
    public final YAMLDocument parse(@NotNull Reader reader) {
        YAMLDocument yAMLDocument;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Ref.ObjectRef state = new Ref.ObjectRef();
        state.element = State.INITIAL;
        Ref.ObjectRef version = new Ref.ObjectRef();
        InitialBlock outerBlock = new InitialBlock(0);
        Ref.IntRef lineNumber = new Ref.IntRef();
        TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(lineNumber, (Ref.ObjectRef<State>)state, (Ref.ObjectRef<Pair<Integer, Integer>>)version, this, outerBlock){
            final /* synthetic */ Ref.IntRef $lineNumber;
            final /* synthetic */ Ref.ObjectRef<State> $state;
            final /* synthetic */ Ref.ObjectRef<Pair<Integer, Integer>> $version;
            final /* synthetic */ Parser this$0;
            final /* synthetic */ InitialBlock $outerBlock;
            {
                this.$lineNumber = $lineNumber;
                this.$state = $state;
                this.$version = $version;
                this.this$0 = $receiver;
                this.$outerBlock = $outerBlock;
                super(1);
            }

            public final void invoke(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                ++this.$lineNumber.element;
                Line line = new Line(this.$lineNumber.element, text);
                switch (parse.WhenMappings.$EnumSwitchMapping$0[((State)((Object)this.$state.element)).ordinal()]) {
                    case 1: {
                        if (StringsKt.startsWith$default((String)text, (String)"%YAML", (boolean)false, (int)2, null)) {
                            this.$version.element = Parser.access$processYAMLDirective(this.this$0, line);
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((CharSequence)text, (char)'%', (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$warn(Parser.Companion, Intrinsics.stringPlus((String)"Unrecognised directive ignored - ", (Object)text));
                            this.$state.element = State.DIRECTIVE;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$state.element = State.MAIN;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (line.atEnd()) break;
                        this.$state.element = State.MAIN;
                        this.$outerBlock.processLine(line);
                        break;
                    }
                    case 2: {
                        if (StringsKt.startsWith$default((String)text, (String)"%YAML", (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Duplicate or misplaced %YAML directive", line);
                            throw new KotlinNothingValueException();
                        }
                        if (StringsKt.startsWith$default((CharSequence)text, (char)'%', (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$warn(Parser.Companion, Intrinsics.stringPlus((String)"Unrecognised directive ignored - ", (Object)text));
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            this.$state.element = State.MAIN;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (line.atEnd()) break;
                        io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Illegal data following directive(s)", line);
                        throw new KotlinNothingValueException();
                    }
                    case 3: {
                        if (StringsKt.startsWith$default((String)text, (String)"...", (boolean)false, (int)2, null)) {
                            this.$state.element = State.ENDED;
                            break;
                        }
                        if (StringsKt.startsWith$default((String)text, (String)"---", (boolean)false, (int)2, null)) {
                            io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Multiple documents not allowed", line);
                            throw new KotlinNothingValueException();
                        }
                        if (line.atEnd()) {
                            this.$outerBlock.processBlankLine(line);
                            break;
                        }
                        this.$outerBlock.processLine(line);
                        break;
                    }
                    case 4: {
                        if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() > 0)) break;
                        io.kjson.yaml.parser.Parser$Companion.access$fatal(Parser.Companion, "Non-blank lines after end of document", line);
                        throw new KotlinNothingValueException();
                    }
                }
            }
        }));
        JSONValue rootNode = outerBlock.conclude(new Line(lineNumber.element, ""));
        Companion.getLog().debug(() -> Parser.parse$lambda-2(rootNode));
        Pair pair = (Pair)version.element;
        if (pair == null) {
            yAMLDocument = null;
        } else {
            Pair it = pair;
            boolean bl = false;
            yAMLDocument = new YAMLDocument(rootNode, (Map<JSONPointer, String>)MapsKt.emptyMap(), ((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        }
        YAMLDocument yAMLDocument2 = yAMLDocument;
        if (yAMLDocument == null) {
            yAMLDocument2 = new YAMLDocument(rootNode, null, 2, null);
        }
        return yAMLDocument2;
    }

    private final Pair<Integer, Integer> processYAMLDirective(Line line) {
        line.skipFixed(5);
        if (!line.matchSpaces() || !line.matchDec()) {
            Parser.Companion.fatal("Illegal %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        int majorVersion = line.getResultInt();
        if (!line.match('.') || !line.matchDec()) {
            Parser.Companion.fatal("Illegal version number on %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        int minorVersion = line.getResultInt();
        if (majorVersion != 1) {
            Parser.Companion.fatal("%YAML version must be 1.x", line);
            throw new KotlinNothingValueException();
        }
        line.skipSpaces();
        if (!line.atEnd()) {
            Parser.Companion.fatal("Illegal data on %YAML directive", line);
            throw new KotlinNothingValueException();
        }
        if (!(1 <= minorVersion ? minorVersion < 3 : false)) {
            Parser.Companion.warn("Unexpected YAML version - " + majorVersion + '.' + minorVersion);
        }
        return TuplesKt.to((Object)majorVersion, (Object)minorVersion);
    }

    private static final Object parse$lambda-2(JSONValue $rootNode) {
        String type = $rootNode == null ? "null" : Reflection.getOrCreateKotlinClass($rootNode.getClass()).getSimpleName();
        return Intrinsics.stringPlus((String)"Parse complete; result is ", (Object)type);
    }

    public static final /* synthetic */ Pair access$processYAMLDirective(Parser $this, Line line) {
        return $this.processYAMLDirective(line);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/kjson/yaml/parser/Parser$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "DIRECTIVE", "MAIN", "ENDED", "kjson-yaml"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIAL = new State();
        public static final /* enum */ State DIRECTIVE = new State();
        public static final /* enum */ State MAIN = new State();
        public static final /* enum */ State ENDED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.INITIAL, State.DIRECTIVE, State.MAIN, State.ENDED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/kjson/yaml/parser/Parser$Block;", "", "indent", "", "(I)V", "getIndent", "()I", "conclude", "Lio/kjson/JSONValue;", "line", "Lio/kjson/yaml/parser/Line;", "processBlankLine", "", "processLine", "kjson-yaml"})
    public static abstract class Block {
        private final int indent;

        public Block(int indent) {
            this.indent = indent;
        }

        public final int getIndent() {
            return this.indent;
        }

        public abstract void processLine(@NotNull Line var1);

        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
        }

        @Nullable
        public abstract JSONValue conclude(@NotNull Line var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lio/kjson/yaml/parser/Parser$ErrorBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "()V", "conclude", "", "line", "Lio/kjson/yaml/parser/Line;", "processLine", "kjson-yaml"})
    public static final class ErrorBlock
    extends Block {
        @NotNull
        public static final ErrorBlock INSTANCE = new ErrorBlock();

        private ErrorBlock() {
            super(0);
        }

        @NotNull
        public Void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            Companion.fatal("Should not happen", line);
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            Companion.fatal("Should not happen", line);
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/kjson/yaml/parser/Parser$InitialBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "indent", "", "(I)V", "child", "node", "Lio/kjson/JSONValue;", "state", "Lio/kjson/yaml/parser/Parser$InitialBlock$State;", "conclude", "line", "Lio/kjson/yaml/parser/Line;", "processBlankLine", "", "processFirstLine", "processLine", "State", "kjson-yaml"})
    public static final class InitialBlock
    extends Block {
        @NotNull
        private State state = State.INITIAL;
        @Nullable
        private JSONValue node;
        @NotNull
        private Block child = ErrorBlock.INSTANCE;

        public InitialBlock(int indent) {
            super(indent);
        }

        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processFirstLine(line);
                    break;
                }
                case 2: {
                    this.child.processLine(line);
                    break;
                }
                case 3: {
                    Companion.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        private final void processFirstLine(Line line) {
            FlowSequence it;
            Child child;
            Child child2;
            int initialIndex = line.getIndex();
            if (line.atEnd()) {
                return;
            }
            if (line.matchDash()) {
                this.child = new SequenceBlock(initialIndex);
                if (!line.atEnd()) {
                    this.child.processLine(line);
                }
                this.state = State.CHILD;
                return;
            }
            if (line.match('\"')) {
                child2 = io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null);
            } else if (line.match('\'')) {
                child2 = io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null);
            } else if (line.match('[')) {
                it = child = new FlowSequence(false);
                boolean bl = false;
                it.continuation(line);
                child2 = child;
            } else if (line.match('{')) {
                it = child = new FlowMapping(false);
                boolean bl = false;
                ((FlowMapping)((Object)it)).continuation(line);
                child2 = child;
            } else {
                if (line.match('?')) {
                    line.skipSpaces();
                    this.child = new MappingBlock(initialIndex);
                    if (!line.atEnd()) {
                        this.child.processLine(line);
                    }
                    this.state = State.CHILD;
                    return;
                }
                if (line.match(':')) {
                    Companion.fatal("Can't handle standalone mapping values", line);
                    throw new KotlinNothingValueException();
                }
                child2 = io.kjson.yaml.parser.Parser$Companion.processPlainScalar$default(Companion, line, null, 1, null);
            }
            Child scalar = child2;
            line.skipSpaces();
            if (line.matchColon()) {
                if (line.atEnd()) {
                    this.child = new MappingBlock(initialIndex, ((Object)scalar.getText()).toString());
                    this.state = State.CHILD;
                } else {
                    this.child = new MappingBlock(initialIndex, ((Object)scalar.getText()).toString(), line);
                    this.state = State.CHILD;
                }
            } else if (scalar.getTerminated()) {
                this.node = scalar.getYAMLNode();
                this.state = State.CLOSED;
            } else {
                this.child = new ChildBlock(initialIndex, scalar);
                this.state = State.CHILD;
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.processBlankLine(line);
                }
            }
        }

        @Override
        @Nullable
        public JSONValue conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.node = this.child.conclude(line);
                }
            }
            this.state = State.CLOSED;
            return this.node;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/yaml/parser/Parser$InitialBlock$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CHILD", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CHILD, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.INITIAL.ordinal()] = 1;
                nArray[State.CHILD.ordinal()] = 2;
                nArray[State.CLOSED.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/kjson/yaml/parser/Parser$MappingBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "indent", "", "key", "", "(ILjava/lang/String;)V", "line", "Lio/kjson/yaml/parser/Line;", "(ILjava/lang/String;Lio/kjson/yaml/parser/Line;)V", "(I)V", "child", "properties", "Lio/kjson/JSONObject$Builder;", "state", "Lio/kjson/yaml/parser/Parser$MappingBlock$State;", "conclude", "Lio/kjson/JSONObject;", "processBlankLine", "", "processColon", "processLine", "processQM", "State", "kjson-yaml"})
    public static final class MappingBlock
    extends Block {
        @NotNull
        private State state;
        @NotNull
        private Block child;
        @NotNull
        private final JSONObject.Builder properties;
        @NotNull
        private String key;

        public MappingBlock(int indent) {
            super(indent);
            this.state = State.QM_CHILD;
            this.child = new InitialBlock(indent + 1);
            this.properties = new JSONObject.Builder(0, null, 3, null);
            this.key = "";
        }

        public MappingBlock(int indent, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this(indent);
            this.key = key;
            this.child = new InitialBlock(indent + 1);
            this.state = State.CHILD;
        }

        public MappingBlock(int indent, @NotNull String key, @NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            this(indent);
            this.key = key;
            this.child = new ChildBlock(indent + 1);
            this.child.processLine(line);
            this.state = State.CHILD;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            int effectiveIndent = line.getIndex();
            if (line.matchDash()) {
                effectiveIndent = line.getIndex();
                line.revert();
            }
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processQM(line);
                    break;
                }
                case 2: {
                    String string;
                    if (line.getIndex() >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    MappingBlock mappingBlock = this;
                    JSONValue jSONValue = this.child.conclude(line);
                    if (jSONValue == null) {
                        string = "null";
                    } else {
                        void it;
                        JSONValue jSONValue2 = jSONValue;
                        MappingBlock mappingBlock2 = mappingBlock;
                        boolean bl = false;
                        String string2 = it instanceof JSONString ? ((JSONString)it).getValue() : it.toString();
                        mappingBlock = mappingBlock2;
                        string = string2;
                        if (string2 == null) {
                            string = mappingBlock.key = "null";
                        }
                    }
                    if (this.properties.containsKey(this.key)) {
                        Companion.fatal(Intrinsics.stringPlus((String)"Duplicate key in mapping - ", (Object)this.key), line);
                        throw new KotlinNothingValueException();
                    }
                    this.state = State.COLON;
                    this.processColon(line);
                    break;
                }
                case 3: {
                    this.processColon(line);
                    break;
                }
                case 4: {
                    if (effectiveIndent >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    this.properties.add(this.key, this.child.conclude(line));
                    this.state = State.KEY;
                    this.processQM(line);
                    break;
                }
                case 5: {
                    Companion.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: 
                case 4: {
                    this.child.processBlankLine(line);
                }
            }
        }

        private final void processQM(Line line) {
            if (line.match('?')) {
                line.skipSpaces();
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getIndent() + 1);
                } else {
                    this.child = new InitialBlock(line.getIndex());
                    this.child.processLine(line);
                }
                this.state = State.QM_CHILD;
            } else {
                if (line.atEnd()) {
                    return;
                }
                FlowScalar scalar = line.match('\"') ? (FlowScalar)io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null) : (line.match('\'') ? (FlowScalar)io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null) : (FlowScalar)io.kjson.yaml.parser.Parser$Companion.processPlainScalar$default(Companion, line, null, 1, null));
                line.skipSpaces();
                if (line.matchColon()) {
                    this.key = scalar.getText();
                    if (this.properties.containsKey(this.key)) {
                        Companion.fatal(Intrinsics.stringPlus((String)"Duplicate key in mapping - ", (Object)this.key), line);
                        throw new KotlinNothingValueException();
                    }
                    line.skipSpaces();
                    if (line.atEnd()) {
                        this.child = new InitialBlock(this.getIndent() + 1);
                        this.state = State.CHILD;
                    } else {
                        this.child = new ChildBlock(this.getIndent() + 1);
                        this.child.processLine(line);
                        this.state = State.CHILD;
                    }
                } else {
                    Companion.fatal("Illegal key in mapping", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        private final void processColon(Line line) {
            if (line.match(':')) {
                line.skipSpaces();
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getIndent() + 1);
                } else {
                    this.child = new InitialBlock(line.getIndex());
                    this.child.processLine(line);
                }
            } else {
                Companion.fatal("Unexpected content in block mapping", line);
                throw new KotlinNothingValueException();
            }
            this.state = State.CHILD;
        }

        @NotNull
        public JSONObject conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    Companion.fatal("Block mapping value missing", line);
                    throw new KotlinNothingValueException();
                }
                case 4: {
                    this.properties.add(this.key, this.child.conclude(line));
                }
            }
            this.state = State.CLOSED;
            return this.properties.build();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/kjson/yaml/parser/Parser$MappingBlock$State;", "", "(Ljava/lang/String;I)V", "KEY", "CHILD", "QM_CHILD", "COLON", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State KEY = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State QM_CHILD = new State();
            public static final /* enum */ State COLON = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.KEY, State.CHILD, State.QM_CHILD, State.COLON, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.KEY.ordinal()] = 1;
                nArray[State.QM_CHILD.ordinal()] = 2;
                nArray[State.COLON.ordinal()] = 3;
                nArray[State.CHILD.ordinal()] = 4;
                nArray[State.CLOSED.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/kjson/yaml/parser/Parser$SequenceBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "indent", "", "(I)V", "child", "items", "Lio/kjson/JSONArray$Builder;", "state", "Lio/kjson/yaml/parser/Parser$SequenceBlock$State;", "conclude", "Lio/kjson/JSONArray;", "line", "Lio/kjson/yaml/parser/Line;", "processBlankLine", "", "processDash", "processLine", "State", "kjson-yaml"})
    public static final class SequenceBlock
    extends Block {
        @NotNull
        private State state = State.CHILD;
        @NotNull
        private final JSONArray.Builder items = new JSONArray.Builder(0, null, 3, null);
        @NotNull
        private Block child;

        public SequenceBlock(int indent) {
            super(indent);
            this.child = new InitialBlock(indent + 2);
        }

        @Override
        public void processLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    this.processDash(line);
                    break;
                }
                case 2: {
                    if (line.getIndex() >= this.child.getIndent()) {
                        this.child.processLine(line);
                        break;
                    }
                    this.items.add(this.child.conclude(line));
                    this.state = State.DASH;
                    this.processDash(line);
                    break;
                }
                case 3: {
                    Companion.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.processBlankLine(line);
                }
            }
        }

        private final void processDash(Line line) {
            if (line.matchDash()) {
                if (line.atEnd()) {
                    this.child = new InitialBlock(this.getIndent() + 2);
                } else {
                    this.child = new InitialBlock(line.getIndex());
                    this.child.processLine(line);
                }
            } else {
                Companion.fatal("Unexpected content in block sequence", line);
                throw new KotlinNothingValueException();
            }
            this.state = State.CHILD;
        }

        @NotNull
        public JSONArray conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.items.add(this.child.conclude(line));
                }
            }
            this.state = State.CLOSED;
            return this.items.build();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/yaml/parser/Parser$SequenceBlock$State;", "", "(Ljava/lang/String;I)V", "DASH", "CHILD", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State DASH = new State();
            public static final /* enum */ State CHILD = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.DASH, State.CHILD, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.DASH.ordinal()] = 1;
                nArray[State.CHILD.ordinal()] = 2;
                nArray[State.CLOSED.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u000fH\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/kjson/yaml/parser/Parser$ChildBlock;", "Lio/kjson/yaml/parser/Parser$Block;", "indent", "", "scalar", "Lio/kjson/yaml/parser/Parser$Child;", "(ILio/kjson/yaml/parser/Parser$Child;)V", "(I)V", "child", "node", "Lio/kjson/JSONValue;", "state", "Lio/kjson/yaml/parser/Parser$ChildBlock$State;", "conclude", "line", "Lio/kjson/yaml/parser/Line;", "processBlankLine", "", "processLine", "determineChomping", "Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "State", "kjson-yaml"})
    public static final class ChildBlock
    extends Block {
        @NotNull
        private State state;
        @NotNull
        private Child child;
        @Nullable
        private JSONValue node;

        public ChildBlock(int indent) {
            super(indent);
            this.state = State.INITIAL;
            this.child = new PlainScalar("");
        }

        public ChildBlock(int indent, @NotNull Child scalar) {
            Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
            this(indent);
            this.child = scalar;
            this.state = State.CONTINUATION;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void processLine(@NotNull Line line) {
            Child child;
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            ChildBlock childBlock = this;
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    if (line.isAtEnd()) {
                        return;
                    }
                    if (line.match('#')) {
                        return;
                    }
                    if (line.match('\"')) {
                        child = io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null);
                        break;
                    }
                    if (line.match('\'')) {
                        child = io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null);
                        break;
                    }
                    if (line.match('|')) {
                        BlockScalar.Chomping chomping = this.determineChomping(line);
                        line.skipSpaces();
                        if (!line.atEnd()) {
                            Companion.fatal("Illegal literal block header", line);
                            throw new KotlinNothingValueException();
                        }
                        child = new LiteralBlockScalar(this.getIndent(), chomping);
                        break;
                    }
                    if (line.match('>')) {
                        BlockScalar.Chomping chomping = this.determineChomping(line);
                        line.skipSpaces();
                        if (!line.atEnd()) {
                            Companion.fatal("Illegal folded block header", line);
                            throw new KotlinNothingValueException();
                        }
                        child = new FoldedBlockScalar(this.getIndent(), chomping);
                        break;
                    }
                    if (line.match('[')) {
                        void it;
                        FlowSequence flowSequence;
                        FlowSequence flowSequence2 = flowSequence = new FlowSequence(false);
                        ChildBlock childBlock2 = childBlock;
                        boolean bl = false;
                        it.continuation(line);
                        childBlock = childBlock2;
                        child = flowSequence;
                        break;
                    }
                    if (line.match('{')) {
                        FlowMapping flowMapping;
                        FlowMapping it = flowMapping = new FlowMapping(false);
                        ChildBlock childBlock3 = childBlock;
                        boolean bl = false;
                        it.continuation(line);
                        childBlock = childBlock3;
                        child = flowMapping;
                        break;
                    }
                    if (line.match('?')) {
                        Companion.fatal("Can't handle standalone mapping keys", line);
                        throw new KotlinNothingValueException();
                    }
                    if (line.match(':')) {
                        Companion.fatal("Can't handle standalone mapping values", line);
                        throw new KotlinNothingValueException();
                    }
                    child = io.kjson.yaml.parser.Parser$Companion.processPlainScalar$default(Companion, line, null, 1, null);
                    break;
                }
                case 2: {
                    child = this.child.continuation(line);
                    break;
                }
                case 3: {
                    Companion.fatal("Unexpected state in YAML processing", line);
                    throw new KotlinNothingValueException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            childBlock.child = child;
            line.skipSpaces();
            if (line.atEnd()) {
                if (this.child.getTerminated()) {
                    this.node = this.child.getYAMLNode();
                    this.state = State.CLOSED;
                } else {
                    this.state = State.CONTINUATION;
                }
            } else {
                Companion.fatal("Illegal data following scalar", line);
                throw new KotlinNothingValueException();
            }
        }

        @Override
        public void processBlankLine(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.child.continuation(line);
                }
            }
        }

        @Override
        @Nullable
        public JSONValue conclude(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.child.getComplete()) {
                        this.node = this.child.getYAMLNode();
                        break;
                    }
                    Companion.fatal("Incomplete scalar", line);
                    throw new KotlinNothingValueException();
                }
            }
            this.state = State.CLOSED;
            return this.node;
        }

        private final BlockScalar.Chomping determineChomping(Line $this$determineChomping) {
            return $this$determineChomping.match('-') ? BlockScalar.Chomping.STRIP : ($this$determineChomping.match('+') ? BlockScalar.Chomping.KEEP : BlockScalar.Chomping.CLIP);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/yaml/parser/Parser$ChildBlock$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CONTINUATION", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CONTINUATION, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.INITIAL.ordinal()] = 1;
                nArray[State.CONTINUATION.ordinal()] = 2;
                nArray[State.CLOSED.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H&J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H&R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\u0004R\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lio/kjson/yaml/parser/Parser$Child;", "", "terminated", "", "(Z)V", "complete", "getComplete", "()Z", "getTerminated", "setTerminated", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONValue;", "kjson-yaml"})
    public static abstract class Child {
        private boolean terminated;

        public Child(boolean terminated) {
            this.terminated = terminated;
        }

        public final boolean getTerminated() {
            return this.terminated;
        }

        public final void setTerminated(boolean bl) {
            this.terminated = bl;
        }

        public boolean getComplete() {
            return this.terminated;
        }

        @NotNull
        public abstract CharSequence getText();

        @Nullable
        public abstract JSONValue getYAMLNode();

        @NotNull
        public abstract Child continuation(@NotNull Line var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lio/kjson/yaml/parser/Parser$FlowSequence;", "Lio/kjson/yaml/parser/Parser$Child;", "terminated", "", "(Z)V", "child", "items", "Lio/kjson/JSONArray$Builder;", "key", "", "state", "Lio/kjson/yaml/parser/Parser$FlowSequence$State;", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONArray;", "processLine", "", "State", "kjson-yaml"})
    public static final class FlowSequence
    extends Child {
        @NotNull
        private State state = State.ITEM;
        @NotNull
        private Child child = new FlowNode("");
        @Nullable
        private String key;
        @NotNull
        private final JSONArray.Builder items = new JSONArray.Builder(0, null, 3, null);

        public FlowSequence(boolean terminated) {
            super(terminated);
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return this.getYAMLNode().toString();
        }

        private final void processLine(Line line) {
            while (!line.atEnd()) {
                Pair[] pairArray;
                Object it;
                Object object;
                if (this.state != State.COMMA) {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                        case 1: {
                            Child child;
                            Child child2;
                            FlowSequence flowSequence = this;
                            if (line.match('\"')) {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null);
                            } else if (line.match('\'')) {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null);
                            } else if (line.match('[')) {
                                FlowSequence flowSequence2 = child = new FlowSequence(false);
                                object = flowSequence;
                                boolean bl = false;
                                ((FlowSequence)it).continuation(line);
                                flowSequence = object;
                                child2 = child;
                            } else if (line.match('{')) {
                                child = new FlowMapping(false);
                                it = child;
                                object = flowSequence;
                                boolean bl = false;
                                ((FlowMapping)it).continuation(line);
                                flowSequence = object;
                                child2 = child;
                            } else {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processFlowNode$default(Companion, line, null, 1, null);
                            }
                            flowSequence.child = child2;
                            break;
                        }
                        case 2: {
                            this.child = this.child.continuation(line);
                        }
                    }
                    line.skipSpaces();
                    if (line.atEnd()) {
                        this.state = this.child.getTerminated() ? State.COMMA : State.CONTINUATION;
                        break;
                    }
                }
                if (line.match(']')) {
                    Unit unit;
                    Unit unit2;
                    String string = this.key;
                    if (string == null) {
                        unit2 = null;
                    } else {
                        it = string;
                        boolean bl = false;
                        pairArray = new Pair[]{TuplesKt.to((Object)it, (Object)this.child.getYAMLNode())};
                        this.items.add((JSONValue)JSONObject.Companion.of(pairArray));
                        unit2 = unit = Unit.INSTANCE;
                    }
                    if (unit == null) {
                        JSONValue jSONValue = this.child.getYAMLNode();
                        if (jSONValue != null) {
                            it = jSONValue;
                            boolean bl = false;
                            this.items.add((JSONValue)it);
                        }
                    }
                    this.setTerminated(true);
                    this.state = State.CLOSED;
                    break;
                }
                if (line.matchColon()) {
                    this.key = String.valueOf(this.child.getYAMLNode());
                    this.state = State.ITEM;
                    continue;
                }
                if (line.match(',')) {
                    JSONObject jSONObject;
                    JSONArray.Builder builder = this.items;
                    if (this.key == null) {
                        jSONObject = null;
                    } else {
                        object = builder;
                        boolean bl = false;
                        pairArray = new Pair[]{TuplesKt.to((Object)it, (Object)this.child.getYAMLNode())};
                        jSONObject = JSONObject.Companion.of(pairArray);
                        builder = object;
                    }
                    builder.add(jSONObject == null ? this.child.getYAMLNode() : (JSONValue)jSONObject);
                    this.key = null;
                    this.state = State.ITEM;
                    continue;
                }
                Companion.fatal("Unexpected character in flow sequence", line);
                throw new KotlinNothingValueException();
            }
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            if (this.state != State.CLOSED) {
                this.processLine(line);
            }
            return this;
        }

        @NotNull
        public JSONArray getYAMLNode() {
            return this.items.build();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/kjson/yaml/parser/Parser$FlowSequence$State;", "", "(Ljava/lang/String;I)V", "ITEM", "CONTINUATION", "COMMA", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State ITEM = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State COMMA = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.ITEM, State.CONTINUATION, State.COMMA, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.ITEM.ordinal()] = 1;
                nArray[State.CONTINUATION.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lio/kjson/yaml/parser/Parser$FlowMapping;", "Lio/kjson/yaml/parser/Parser$Child;", "terminated", "", "(Z)V", "child", "key", "", "properties", "Lio/kjson/JSONObject$Builder;", "state", "Lio/kjson/yaml/parser/Parser$FlowMapping$State;", "text", "", "getText", "()Ljava/lang/CharSequence;", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONObject;", "processLine", "", "State", "kjson-yaml"})
    public static final class FlowMapping
    extends Child {
        @NotNull
        private State state = State.ITEM;
        @NotNull
        private Child child = new FlowNode("");
        @Nullable
        private String key;
        @NotNull
        private final JSONObject.Builder properties = new JSONObject.Builder(0, null, 3, null);

        public FlowMapping(boolean terminated) {
            super(terminated);
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return this.getYAMLNode().toString();
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            if (this.state != State.CLOSED) {
                this.processLine(line);
            }
            return this;
        }

        @NotNull
        public JSONObject getYAMLNode() {
            return this.properties.build();
        }

        private final void processLine(Line line) {
            while (!line.atEnd()) {
                if (this.state != State.COMMA) {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                        case 1: {
                            Child it;
                            FlowMapping flowMapping;
                            Child child;
                            Child child2;
                            FlowMapping flowMapping2 = this;
                            if (line.match('\"')) {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processDoubleQuotedScalar$default(Companion, line, null, 1, null);
                            } else if (line.match('\'')) {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processSingleQuotedScalar$default(Companion, line, null, 1, null);
                            } else if (line.match('[')) {
                                child = new FlowSequence(false);
                                FlowSequence flowSequence = child;
                                flowMapping = flowMapping2;
                                boolean bl = false;
                                ((FlowSequence)it).continuation(line);
                                flowMapping2 = flowMapping;
                                child2 = child;
                            } else if (line.match('{')) {
                                it = child = new FlowMapping(false);
                                flowMapping = flowMapping2;
                                boolean bl = false;
                                ((FlowMapping)it).continuation(line);
                                flowMapping2 = flowMapping;
                                child2 = child;
                            } else {
                                child2 = io.kjson.yaml.parser.Parser$Companion.processFlowNode$default(Companion, line, null, 1, null);
                            }
                            flowMapping2.child = child2;
                            break;
                        }
                        case 2: {
                            this.child = this.child.continuation(line);
                        }
                    }
                    line.skipSpaces();
                    if (line.atEnd()) {
                        this.state = this.child.getTerminated() ? State.COMMA : State.CONTINUATION;
                        break;
                    }
                }
                if (line.match('}')) {
                    if (this.key == null) {
                        if (this.child.getYAMLNode() != null) {
                            Companion.fatal("Unexpected end of flow mapping", line);
                            throw new KotlinNothingValueException();
                        }
                    } else {
                        this.properties.add(String.valueOf(this.key), this.child.getYAMLNode());
                    }
                    this.setTerminated(true);
                    this.state = State.CLOSED;
                    break;
                }
                if (line.matchColon() || this.child instanceof DoubleQuotedScalar && line.match(':')) {
                    this.key = String.valueOf(this.child.getYAMLNode());
                    this.state = State.ITEM;
                    continue;
                }
                if (line.match(',')) {
                    if (this.key == null) {
                        Companion.fatal("Key missing in flow mapping", line);
                        throw new KotlinNothingValueException();
                    }
                    this.properties.add(String.valueOf(this.key), this.child.getYAMLNode());
                    this.key = null;
                    this.state = State.ITEM;
                    continue;
                }
                Companion.fatal("Unexpected character in flow mapping", line);
                throw new KotlinNothingValueException();
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/kjson/yaml/parser/Parser$FlowMapping$State;", "", "(Ljava/lang/String;I)V", "ITEM", "CONTINUATION", "COMMA", "CLOSED", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State ITEM = new State();
            public static final /* enum */ State CONTINUATION = new State();
            public static final /* enum */ State COMMA = new State();
            public static final /* enum */ State CLOSED = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.ITEM, State.CONTINUATION, State.COMMA, State.CLOSED};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.ITEM.ordinal()] = 1;
                nArray[State.CONTINUATION.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$FlowScalar;", "Lio/kjson/yaml/parser/Parser$Child;", "text", "", "terminated", "", "(Ljava/lang/String;Z)V", "getText", "()Ljava/lang/String;", "getYAMLNode", "Lio/kjson/JSONValue;", "kjson-yaml"})
    public static abstract class FlowScalar
    extends Child {
        @NotNull
        private final String text;

        public FlowScalar(@NotNull String text, boolean terminated) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(terminated);
            this.text = text;
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        @Nullable
        public JSONValue getYAMLNode() {
            return (JSONValue)new JSONString(this.getText());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0003H\u0002J\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0003H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/kjson/yaml/parser/Parser$PlainScalar;", "Lio/kjson/yaml/parser/Parser$FlowScalar;", "text", "", "(Ljava/lang/String;)V", "complete", "", "getComplete", "()Z", "continuation", "Lio/kjson/yaml/parser/Parser$Child;", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONValue;", "intOrLong", "value", "", "matchesDecimal", "matchesInteger", "kjson-yaml"})
    public static class PlainScalar
    extends FlowScalar {
        public PlainScalar(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, false);
        }

        @Override
        public boolean getComplete() {
            return true;
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return Companion.processPlainScalar(line, Intrinsics.stringPlus((String)this.getText(), (Object)" "));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public JSONValue getYAMLNode() {
            block14: {
                block13: {
                    if (((CharSequence)this.getText()).length() == 0 || Intrinsics.areEqual((Object)this.getText(), (Object)"null") || Intrinsics.areEqual((Object)this.getText(), (Object)"Null") || Intrinsics.areEqual((Object)this.getText(), (Object)"NULL") || Intrinsics.areEqual((Object)this.getText(), (Object)"~")) {
                        return null;
                    }
                    if (Intrinsics.areEqual((Object)this.getText(), (Object)"true") || Intrinsics.areEqual((Object)this.getText(), (Object)"True") || Intrinsics.areEqual((Object)this.getText(), (Object)"TRUE")) {
                        return (JSONValue)JSONBoolean.TRUE;
                    }
                    if (Intrinsics.areEqual((Object)this.getText(), (Object)"false") || Intrinsics.areEqual((Object)this.getText(), (Object)"False") || Intrinsics.areEqual((Object)this.getText(), (Object)"FALSE")) {
                        return (JSONValue)JSONBoolean.FALSE;
                    }
                    if (StringsKt.startsWith$default((String)this.getText(), (String)"0o", (boolean)false, (int)2, null) && this.getText().length() > 2) {
                        block12: {
                            $this$all$iv = StringsKt.drop((String)this.getText(), (int)2);
                            $i$f$all = false;
                            var3_3 = $this$all$iv;
                            var4_4 = 0;
                            while (var4_4 < var3_3.length()) {
                                element$iv = var3_3.charAt(var4_4);
                                ++var4_4;
                                it = element$iv;
                                $i$a$-all-Parser$PlainScalar$getYAMLNode$1 = false;
                                if ('0' <= it ? it < '8' : false) continue;
                                v0 = false;
                                break block12;
                            }
                            v0 = true;
                        }
                        if (v0) {
                            return this.intOrLong(Long.parseLong(StringsKt.drop((String)this.getText(), (int)2), CharsKt.checkRadix((int)8)));
                        }
                    }
                    if (!StringsKt.startsWith$default((String)this.getText(), (String)"0x", (boolean)false, (int)2, null) || this.getText().length() <= 2) break block14;
                    $this$all$iv = StringsKt.drop((String)this.getText(), (int)2);
                    $i$f$all = false;
                    var3_3 = $this$all$iv;
                    var4_4 = 0;
                    while (var4_4 < var3_3.length()) {
                        element$iv = var3_3.charAt(var4_4);
                        ++var4_4;
                        it = element$iv;
                        $i$a$-all-Parser$PlainScalar$getYAMLNode$2 = false;
                        if ('0' <= it ? it < ':' : false) ** GOTO lbl-1000
                        if ('A' <= it ? it < 'G' : false) ** GOTO lbl-1000
                        v1 = 'a' <= it ? it < 'g' : false;
                        if (v1) lbl-1000:
                        // 3 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        if (v2) continue;
                        v3 = false;
                        break block13;
                    }
                    v3 = true;
                }
                if (v3) {
                    return this.intOrLong(Long.parseLong(StringsKt.drop((String)this.getText(), (int)2), CharsKt.checkRadix((int)16)));
                }
            }
            if (this.matchesInteger(this.getText())) {
                return this.intOrLong(Long.parseLong(this.getText()));
            }
            if (this.matchesDecimal(this.getText())) {
                return (JSONValue)new JSONDecimal(this.getText());
            }
            return (JSONValue)new JSONString(this.getText());
        }

        private final JSONValue intOrLong(long value) {
            return (Integer.MIN_VALUE <= value ? value <= Integer.MAX_VALUE : false) ? (JSONValue)new JSONInt((int)value) : (JSONValue)new JSONLong(value);
        }

        private final boolean matchesInteger(String $this$matchesInteger) {
            TextMatcher it = new TextMatcher($this$matchesInteger);
            boolean bl = false;
            if (!it.match('+')) {
                it.match('-');
            }
            return it.matchDec() && it.isAtEnd();
        }

        private final boolean matchesDecimal(String $this$matchesDecimal) {
            TextMatcher pt = new TextMatcher($this$matchesDecimal);
            if (!pt.match('+')) {
                pt.match('-');
            }
            if (pt.match('.')) {
                if (!pt.matchDec()) {
                    return false;
                }
            } else {
                if (!pt.matchDec()) {
                    return false;
                }
                if (pt.match('.')) {
                    pt.matchDec();
                }
            }
            if (pt.match('e') || pt.match('E')) {
                if (!pt.match('+')) {
                    pt.match('-');
                }
                if (!pt.matchDec()) {
                    return false;
                }
            }
            return pt.isAtEnd();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lio/kjson/yaml/parser/Parser$FlowNode;", "Lio/kjson/yaml/parser/Parser$PlainScalar;", "text", "", "(Ljava/lang/String;)V", "continuation", "Lio/kjson/yaml/parser/Parser$Child;", "line", "Lio/kjson/yaml/parser/Line;", "kjson-yaml"})
    public static final class FlowNode
    extends PlainScalar {
        public FlowNode(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text);
        }

        @Override
        @NotNull
        public Child continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return Companion.processFlowNode(line, Intrinsics.stringPlus((String)this.getText(), (Object)" "));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$DoubleQuotedScalar;", "Lio/kjson/yaml/parser/Parser$FlowScalar;", "text", "", "terminated", "", "escapedNewline", "(Ljava/lang/String;ZZ)V", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "kjson-yaml"})
    public static final class DoubleQuotedScalar
    extends FlowScalar {
        private final boolean escapedNewline;

        public DoubleQuotedScalar(@NotNull String text, boolean terminated, boolean escapedNewline) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, terminated);
            this.escapedNewline = escapedNewline;
        }

        public /* synthetic */ DoubleQuotedScalar(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(string, bl, bl2);
        }

        @Override
        @NotNull
        public DoubleQuotedScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return Companion.processDoubleQuotedScalar(line, this.escapedNewline || StringsKt.endsWith$default((CharSequence)this.getText(), (char)' ', (boolean)false, (int)2, null) ? this.getText() : Intrinsics.stringPlus((String)this.getText(), (Object)" "));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lio/kjson/yaml/parser/Parser$SingleQuotedScalar;", "Lio/kjson/yaml/parser/Parser$FlowScalar;", "text", "", "terminated", "", "(Ljava/lang/String;Z)V", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "kjson-yaml"})
    public static final class SingleQuotedScalar
    extends FlowScalar {
        public SingleQuotedScalar(@NotNull String text, boolean terminated) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super(text, terminated);
        }

        @Override
        @NotNull
        public SingleQuotedScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            return Companion.processSingleQuotedScalar(line, StringsKt.endsWith$default((CharSequence)this.getText(), (char)' ', (boolean)false, (int)2, null) ? this.getText() : Intrinsics.stringPlus((String)this.getText(), (Object)" "));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u0013*\u00060\u000ej\u0002`\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/kjson/yaml/parser/Parser$BlockScalar;", "Lio/kjson/yaml/parser/Parser$Child;", "indent", "", "chomping", "Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "(ILio/kjson/yaml/parser/Parser$BlockScalar$Chomping;)V", "complete", "", "getComplete", "()Z", "state", "Lio/kjson/yaml/parser/Parser$BlockScalar$State;", "text", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getText", "()Ljava/lang/StringBuilder;", "appendText", "", "string", "", "continuation", "line", "Lio/kjson/yaml/parser/Line;", "getYAMLNode", "Lio/kjson/JSONString;", "strip", "Chomping", "State", "kjson-yaml"})
    public static abstract class BlockScalar
    extends Child {
        private int indent;
        @NotNull
        private final Chomping chomping;
        @NotNull
        private State state;
        @NotNull
        private final StringBuilder text;

        public BlockScalar(int indent, @NotNull Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(false);
            this.indent = indent;
            this.chomping = chomping;
            this.state = State.INITIAL;
            this.text = new StringBuilder();
        }

        @Override
        @NotNull
        public StringBuilder getText() {
            return this.text;
        }

        @Override
        public boolean getComplete() {
            return true;
        }

        public abstract void appendText(@NotNull String var1);

        @Override
        @NotNull
        public BlockScalar continuation(@NotNull Line line) {
            Intrinsics.checkNotNullParameter((Object)((Object)line), (String)"line");
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    if (line.getIndex() > this.indent) {
                        this.indent = line.getIndex();
                    }
                    if (line.isAtEnd()) break;
                    this.state = State.CONTINUATION;
                    line.skipToEnd();
                    String string = line.getResult();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.result");
                    this.appendText(string);
                    break;
                }
                case 2: {
                    if (line.isAtEnd()) {
                        if (line.getIndex() > this.indent) {
                            line.setStart(this.indent);
                            String string = line.getResult();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.result");
                            this.appendText(string);
                            break;
                        }
                        this.appendText("");
                        break;
                    }
                    if (line.getIndex() < this.indent) {
                        if (line.isComment()) break;
                        Companion.fatal("Bad indentation in block scalar", line);
                        throw new KotlinNothingValueException();
                    }
                    if (line.getIndex() > this.indent) {
                        line.setIndex(this.indent);
                    }
                    line.skipToEnd();
                    String string = line.getResult();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line.result");
                    this.appendText(string);
                }
            }
            return this;
        }

        @NotNull
        public JSONString getYAMLNode() {
            StringBuilder sb = new StringBuilder(this.getText());
            switch (WhenMappings.$EnumSwitchMapping$1[this.chomping.ordinal()]) {
                case 1: {
                    this.strip(sb);
                    break;
                }
                case 2: {
                    this.strip(sb);
                    sb.append("\n");
                }
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new JSONString(string);
        }

        private final void strip(StringBuilder $this$strip) {
            while (StringsKt.endsWith$default((CharSequence)$this$strip, (char)'\n', (boolean)false, (int)2, null)) {
                $this$strip.setLength($this$strip.length() - 1);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "", "(Ljava/lang/String;I)V", "STRIP", "KEEP", "CLIP", "kjson-yaml"})
        public static final class Chomping
        extends Enum<Chomping> {
            public static final /* enum */ Chomping STRIP = new Chomping();
            public static final /* enum */ Chomping KEEP = new Chomping();
            public static final /* enum */ Chomping CLIP = new Chomping();
            private static final /* synthetic */ Chomping[] $VALUES;

            public static Chomping[] values() {
                return (Chomping[])$VALUES.clone();
            }

            public static Chomping valueOf(String value) {
                return Enum.valueOf(Chomping.class, value);
            }

            static {
                $VALUES = chompingArray = new Chomping[]{Chomping.STRIP, Chomping.KEEP, Chomping.CLIP};
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/kjson/yaml/parser/Parser$BlockScalar$State;", "", "(Ljava/lang/String;I)V", "INITIAL", "CONTINUATION", "kjson-yaml"})
        public static final class State
        extends Enum<State> {
            public static final /* enum */ State INITIAL = new State();
            public static final /* enum */ State CONTINUATION = new State();
            private static final /* synthetic */ State[] $VALUES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            static {
                $VALUES = stateArray = new State[]{State.INITIAL, State.CONTINUATION};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[State.values().length];
                nArray[State.INITIAL.ordinal()] = 1;
                nArray[State.CONTINUATION.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Chomping.values().length];
                nArray[Chomping.STRIP.ordinal()] = 1;
                nArray[Chomping.CLIP.ordinal()] = 2;
                nArray[Chomping.KEEP.ordinal()] = 3;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$LiteralBlockScalar;", "Lio/kjson/yaml/parser/Parser$BlockScalar;", "indent", "", "chomping", "Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "(ILio/kjson/yaml/parser/Parser$BlockScalar$Chomping;)V", "appendText", "", "string", "", "kjson-yaml"})
    public static final class LiteralBlockScalar
    extends BlockScalar {
        public LiteralBlockScalar(int indent, @NotNull BlockScalar.Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(indent, chomping);
        }

        @Override
        public void appendText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.getText().append(string);
            this.getText().append('\n');
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lio/kjson/yaml/parser/Parser$FoldedBlockScalar;", "Lio/kjson/yaml/parser/Parser$BlockScalar;", "indent", "", "chomping", "Lio/kjson/yaml/parser/Parser$BlockScalar$Chomping;", "(ILio/kjson/yaml/parser/Parser$BlockScalar$Chomping;)V", "appendText", "", "string", "", "kjson-yaml"})
    public static final class FoldedBlockScalar
    extends BlockScalar {
        public FoldedBlockScalar(int indent, @NotNull BlockScalar.Chomping chomping) {
            Intrinsics.checkNotNullParameter((Object)((Object)chomping), (String)"chomping");
            super(indent, chomping);
        }

        @Override
        public void appendText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (StringsKt.endsWith$default((CharSequence)this.getText(), (char)'\n', (boolean)false, (int)2, null)) {
                this.getText().setLength(this.getText().length() - 1);
                while (StringsKt.endsWith$default((CharSequence)this.getText(), (char)' ', (boolean)false, (int)2, null)) {
                    this.getText().setLength(this.getText().length() - 1);
                }
                this.getText().append(' ');
            }
            this.getText().append(string);
            this.getText().append('\n');
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u0010*\u00020\u000e2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\fJ\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\fJ\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\fJ\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\fR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lio/kjson/yaml/parser/Parser$Companion;", "", "()V", "log", "Lnet/pwall/log/Logger;", "getLog", "()Lnet/pwall/log/Logger;", "log$delegate", "Lnet/pwall/log/LoggerDelegate;", "fatal", "", "text", "", "line", "Lio/kjson/yaml/parser/Line;", "warn", "", "message", "processBackslash", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "processDoubleQuotedScalar", "Lio/kjson/yaml/parser/Parser$DoubleQuotedScalar;", "initial", "processFlowNode", "Lio/kjson/yaml/parser/Parser$FlowNode;", "processPlainScalar", "Lio/kjson/yaml/parser/Parser$PlainScalar;", "processSingleQuotedScalar", "Lio/kjson/yaml/parser/Parser$SingleQuotedScalar;", "kjson-yaml"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private final void warn(String message) {
            this.getLog().warn(() -> Companion.warn$lambda-0(message));
        }

        private final Void fatal(String text, Line line) {
            YAMLParseException exception = new YAMLParseException(text, line);
            this.getLog().error(() -> Companion.fatal$lambda-1(exception));
            throw exception;
        }

        @NotNull
        public final PlainScalar processPlainScalar(@NotNull Line $this$processPlainScalar, @NotNull String initial) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processPlainScalar), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            StringBuilder sb = new StringBuilder(initial);
            while (!$this$processPlainScalar.isAtEnd()) {
                if ($this$processPlainScalar.matchColon()) {
                    $this$processPlainScalar.revert();
                    $this$processPlainScalar.skipBackSpaces();
                    break;
                }
                if ($this$processPlainScalar.isComment()) {
                    $this$processPlainScalar.skipBackSpaces();
                    break;
                }
                sb.append($this$processPlainScalar.nextChar());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new PlainScalar(((Object)StringsKt.trim((CharSequence)string)).toString());
        }

        public static /* synthetic */ PlainScalar processPlainScalar$default(Companion companion, Line line, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.processPlainScalar(line, string);
        }

        @NotNull
        public final FlowNode processFlowNode(@NotNull Line $this$processFlowNode, @NotNull String initial) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processFlowNode), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            StringBuilder sb = new StringBuilder(initial);
            while (!$this$processFlowNode.isAtEnd()) {
                if ($this$processFlowNode.matchAny("[]{},")) {
                    $this$processFlowNode.revert();
                    Object object = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
                    Object it = object = new FlowNode(((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString());
                    boolean bl = false;
                    ((Child)it).setTerminated(true);
                    return object;
                }
                if ($this$processFlowNode.matchColon()) {
                    $this$processFlowNode.revert();
                    $this$processFlowNode.skipBackSpaces();
                    break;
                }
                if ($this$processFlowNode.isComment()) {
                    $this$processFlowNode.skipBackSpaces();
                    break;
                }
                sb.append($this$processFlowNode.nextChar());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new FlowNode(((Object)StringsKt.trim((CharSequence)string)).toString());
        }

        public static /* synthetic */ FlowNode processFlowNode$default(Companion companion, Line line, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.processFlowNode(line, string);
        }

        @NotNull
        public final SingleQuotedScalar processSingleQuotedScalar(@NotNull Line $this$processSingleQuotedScalar, @NotNull String initial) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processSingleQuotedScalar), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            StringBuilder sb = new StringBuilder(initial);
            while (!$this$processSingleQuotedScalar.isAtEnd()) {
                if ($this$processSingleQuotedScalar.match('\'')) {
                    if ($this$processSingleQuotedScalar.match('\'')) {
                        sb.append('\'');
                        continue;
                    }
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                    return new SingleQuotedScalar(string, true);
                }
                sb.append($this$processSingleQuotedScalar.nextChar());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new SingleQuotedScalar(string, false);
        }

        public static /* synthetic */ SingleQuotedScalar processSingleQuotedScalar$default(Companion companion, Line line, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.processSingleQuotedScalar(line, string);
        }

        @NotNull
        public final DoubleQuotedScalar processDoubleQuotedScalar(@NotNull Line $this$processDoubleQuotedScalar, @NotNull String initial) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$processDoubleQuotedScalar), (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            StringBuilder sb = new StringBuilder(initial);
            while (!$this$processDoubleQuotedScalar.isAtEnd()) {
                if ($this$processDoubleQuotedScalar.match('\"')) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                    return new DoubleQuotedScalar(string, true, false, 4, null);
                }
                if ($this$processDoubleQuotedScalar.match('\\')) {
                    if ($this$processDoubleQuotedScalar.isAtEnd()) {
                        String string = sb.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                        return new DoubleQuotedScalar(string, false, true);
                    }
                    this.processBackslash($this$processDoubleQuotedScalar, sb);
                    continue;
                }
                sb.append($this$processDoubleQuotedScalar.nextChar());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return new DoubleQuotedScalar(string, false, false, 4, null);
        }

        public static /* synthetic */ DoubleQuotedScalar processDoubleQuotedScalar$default(Companion companion, Line line, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.processDoubleQuotedScalar(line, string);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void processBackslash(Line $this$processBackslash, StringBuilder sb) {
            if ($this$processBackslash.match('0')) {
                sb.append('\u0000');
                return;
            }
            if ($this$processBackslash.match('a')) {
                sb.append('\u0007');
                return;
            }
            if ($this$processBackslash.match('b')) {
                sb.append('\b');
                return;
            }
            if ($this$processBackslash.match('t')) {
                sb.append('\t');
                return;
            }
            if ($this$processBackslash.match('\t')) {
                sb.append('\t');
                return;
            }
            if ($this$processBackslash.match('n')) {
                sb.append('\n');
                return;
            }
            if ($this$processBackslash.match('v')) {
                sb.append('\u000b');
                return;
            }
            if ($this$processBackslash.match('f')) {
                sb.append('\f');
                return;
            }
            if ($this$processBackslash.match('r')) {
                sb.append('\r');
                return;
            }
            if ($this$processBackslash.match('e')) {
                sb.append('\u001b');
                return;
            }
            if ($this$processBackslash.match(' ')) {
                sb.append(' ');
                return;
            }
            if ($this$processBackslash.match('\"')) {
                sb.append('\"');
                return;
            }
            if ($this$processBackslash.match('/')) {
                sb.append('/');
                return;
            }
            if ($this$processBackslash.match('\\')) {
                sb.append('\\');
                return;
            }
            if ($this$processBackslash.match('N')) {
                sb.append('\u0085');
                return;
            }
            if ($this$processBackslash.match('_')) {
                sb.append('\u00a0');
                return;
            }
            if ($this$processBackslash.match('L')) {
                sb.append('\u2028');
                return;
            }
            if ($this$processBackslash.match('P')) {
                sb.append('\u2029');
                return;
            }
            if ($this$processBackslash.match('x')) {
                if (!$this$processBackslash.matchHex(2, 2)) {
                    this.fatal("Illegal hex value in double quoted scalar", $this$processBackslash);
                    throw new KotlinNothingValueException();
                }
                sb.append((char)$this$processBackslash.getResultHexInt());
                return;
            }
            if ($this$processBackslash.match('u')) {
                if (!$this$processBackslash.matchHex(4, 4)) {
                    this.fatal("Illegal unicode value in double quoted scalar", $this$processBackslash);
                    throw new KotlinNothingValueException();
                }
                sb.append((char)$this$processBackslash.getResultHexInt());
                return;
            }
            if (!$this$processBackslash.match('U')) {
                this.fatal("Illegal escape sequence in double quoted scalar", $this$processBackslash);
                throw new KotlinNothingValueException();
            }
            if (!$this$processBackslash.matchHex(8, 8)) {
                this.fatal("Illegal unicode value in double quoted scalar", $this$processBackslash);
                throw new KotlinNothingValueException();
            }
            int codePoint = $this$processBackslash.getResultHexInt();
            if (Character.isSupplementaryCodePoint(codePoint)) {
                sb.append(Character.highSurrogate(codePoint));
                sb.append(Character.lowSurrogate(codePoint));
                return;
            }
            if (Character.isBmpCodePoint(codePoint)) {
                sb.append((char)codePoint);
                return;
            }
            this.fatal("Illegal 32-bit unicode value in double quoted scalar", $this$processBackslash);
            throw new KotlinNothingValueException();
        }

        private static final Object warn$lambda-0(String $message) {
            Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
            return Intrinsics.stringPlus((String)"YAML Warning: ", (Object)$message);
        }

        private static final Object fatal$lambda-1(YAMLParseException $exception) {
            Intrinsics.checkNotNullParameter((Object)((Object)$exception), (String)"$exception");
            return $exception.getMessage();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lnet/pwall/log/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

